/*
 * Decompiled with CFR 0.152.
 */
package com.afmobi.tudcsdk;

import android.content.Context;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import com.afmobi.tudcsdk.TudcsdkException;
import com.afmobi.tudcsdk.constant.BuildApkConfig;
import com.afmobi.tudcsdk.internal.MidCoreWrapper;
import com.afmobi.tudcsdk.utils.ValidateUtil;
import com.transsion.core.CoreUtil;
import com.transsion.core.log.LogUtils;

public final class Tudcsdk {
    private static Boolean sdkInitialized = false;
    private static Context applicationConext;
    private static int callbackRequestCodeOffset;
    private static String mUserApp_Id;
    private static String mUserApp_Key;
    private static String mUserApp_Secret;
    private static String mGoogleServerClientId;
    private static String mFaceBookAppId;
    private static String mTwitterKey;
    private static String mTwitterSecret;
    private static InitializeCallback mInitializeCallback;
    private static boolean toShareTgtByAuthorize;
    private static boolean allowToLoginByShareTgt;
    private static String mChannelId;
    private static int appFrontCount;
    public static int RUN_ENVIRONMENT_TEST;
    public static int RUN_ENVIRONMENT_PROD;
    public static int RUN_ENVIRONMENT_PRE_PROD;
    public static int RUN_ENVIRONMENT_MUTIDATA;

    public static synchronized void sdkInitialize(Context context, InitializeCallback initializeCallback) {
        CoreUtil.init((Context)context);
        mInitializeCallback = initializeCallback;
        applicationConext = context;
        sdkInitialized = true;
        ValidateUtil.notNull(applicationConext, "applicationContext");
        Tudcsdk.loadDefaultsFromMetadata(applicationConext);
        MidCoreWrapper.initMidCore(applicationConext);
    }

    public static void loadDefaultsFromMetadata(Context object) {
        block19: {
            Object object2;
            if (object == null) {
                return;
            }
            try {
                object = object.getPackageManager().getApplicationInfo(object.getPackageName(), 128);
                if (object == null || object.metaData == null) break block19;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                return;
            }
            if (TextUtils.isEmpty((CharSequence)mUserApp_Id)) {
                object2 = object.metaData.get("com.afmobi.tudc.APPID");
                if (object2 instanceof String) {
                    mUserApp_Id = (String)object2;
                } else if (object2 instanceof Integer) {
                    throw new TudcsdkException("App Ids cannot be directly placed in the manifest.They must be placed in the string resource file.");
                }
            }
            if (TextUtils.isEmpty((CharSequence)mUserApp_Key)) {
                object2 = object.metaData.get("com.afmobi.tudc.APPKEY");
                if (object2 instanceof String) {
                    mUserApp_Key = (String)object2;
                } else if (object2 instanceof Integer) {
                    throw new TudcsdkException("App Ids cannot be directly placed in the manifest.They must be placed in the string resource file.");
                }
            }
            if (TextUtils.isEmpty((CharSequence)mUserApp_Secret)) {
                object2 = object.metaData.get("com.afmobi.tudc.APPSECRET");
                if (object2 instanceof String) {
                    mUserApp_Secret = (String)object2;
                } else if (object2 instanceof Integer) {
                    throw new TudcsdkException("App Ids cannot be directly placed in the manifest.They must be placed in the string resource file.");
                }
            }
            if (TextUtils.isEmpty((CharSequence)mGoogleServerClientId) && (object2 = object.metaData.get("com.google.server.clientId")) instanceof String) {
                mGoogleServerClientId = (String)object2;
            }
            if (TextUtils.isEmpty((CharSequence)mFaceBookAppId) && (object2 = object.metaData.get("com.facebook.sdk.ApplicationId")) instanceof String) {
                mFaceBookAppId = (String)object2;
            }
            if (TextUtils.isEmpty((CharSequence)mTwitterKey) && (object2 = object.metaData.get("com.twitter.sdk.twitterKey")) instanceof String) {
                mTwitterKey = (String)object2;
            }
            if (TextUtils.isEmpty((CharSequence)mTwitterSecret) && (object = object.metaData.get("com.twitter.sdk.twitterSecret")) instanceof String) {
                mTwitterSecret = (String)object;
            }
            return;
        }
    }

    public static synchronized boolean isInitialized() {
        if (!sdkInitialized.booleanValue()) {
            LogUtils.e((Object)"sdkInitialized is false");
        }
        return sdkInitialized;
    }

    public static synchronized void setDebugModel(boolean bl) {
        BuildApkConfig.setDebugMode(bl);
    }

    public static synchronized void setToShareTgtByAuthorize(boolean bl) {
        toShareTgtByAuthorize = bl;
    }

    public static synchronized void setChannelId(String string2) {
        mChannelId = string2;
    }

    public static String getChannelId() {
        return mChannelId;
    }

    public static synchronized void setIsReleaseSignature(boolean bl) {
        BuildApkConfig.setIsReleaseSignature(bl);
    }

    public static boolean isReleaseSignature() {
        return BuildApkConfig.isReleaseSignature();
    }

    public static synchronized boolean getToShareTgtByAuthorizeState() {
        return toShareTgtByAuthorize;
    }

    public static synchronized void setAllowToLoginBySharedTgt(boolean bl) {
        allowToLoginByShareTgt = bl;
    }

    public static boolean getAllowToLoginBySharedTgtStatus() {
        return allowToLoginByShareTgt;
    }

    public static int getCallbackRequestCodeOffset() {
        return callbackRequestCodeOffset;
    }

    public static Context getApplicationContext() {
        Context context = applicationConext;
        if (context == null) {
            context = CoreUtil.getContext();
        }
        return context;
    }

    public static String getUserApp_Id() {
        if (TextUtils.isEmpty((CharSequence)mUserApp_Id)) {
            Tudcsdk.loadDefaultsFromMetadata(CoreUtil.getContext());
        }
        return mUserApp_Id;
    }

    public static String getUserApp_Key() {
        if (TextUtils.isEmpty((CharSequence)mUserApp_Key)) {
            Tudcsdk.loadDefaultsFromMetadata(CoreUtil.getContext());
        }
        return mUserApp_Key;
    }

    public static String getmUserApp_Secret() {
        if (TextUtils.isEmpty((CharSequence)mUserApp_Secret)) {
            Tudcsdk.loadDefaultsFromMetadata(CoreUtil.getContext());
        }
        return mUserApp_Secret;
    }

    public static String getGoogleServerClientId() {
        return mGoogleServerClientId;
    }

    public static String getFaceBookAppId() {
        return mFaceBookAppId;
    }

    public static String getTwitterKey() {
        return mTwitterKey;
    }

    public static String getTwitterSecret() {
        return mTwitterSecret;
    }

    public static InitializeCallback getInitializeCallback() {
        return mInitializeCallback;
    }

    static {
        callbackRequestCodeOffset = 44976;
        mUserApp_Id = "";
        mUserApp_Key = "";
        mUserApp_Secret = "";
        mGoogleServerClientId = "";
        mFaceBookAppId = "";
        mTwitterKey = "";
        mTwitterSecret = "";
        toShareTgtByAuthorize = false;
        allowToLoginByShareTgt = true;
        mChannelId = "";
        appFrontCount = 0;
        RUN_ENVIRONMENT_TEST = 0;
        RUN_ENVIRONMENT_PROD = 2;
        RUN_ENVIRONMENT_PRE_PROD = 3;
        RUN_ENVIRONMENT_MUTIDATA = 4;
    }

    public static interface InitializeCallback {
        public void onInitialized();

        public void onPermissionError(String[] var1);
    }
}

