/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun;

import android.content.Context;
import android.os.IBinder;
import android.os.RemoteException;
import com.transsion.kolun.IKolunCore;
import com.transsion.kolun.content.KolunEventListener;
import com.transsion.kolun.content.Persona;
import com.transsion.kolun.content.UserContext;
import com.transsion.kolun.util.AndroidHiddenApi;
import com.transsion.kolun.util.KolunLog;

public class Kolun {
    private static final String TAG = "Kolun";
    public static final String KOLUN_LIVING = "KolunLiving";
    private final Context mContext;
    private IKolunCore mCore;

    public Kolun(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context is NonNull");
        }
        this.mContext = context.getApplicationContext();
    }

    public static boolean isSystemServiceExists() {
        IBinder service = AndroidHiddenApi.ServiceManagerProxy.getService("kolun");
        return service != null;
    }

    public Persona getPersona() {
        Persona persona = Persona.getInstance();
        persona.loadFromBytes(this.getLabels(1));
        return persona;
    }

    public UserContext getUserContext() {
        UserContext userContext = UserContext.getInstance();
        userContext.loadFromBytes(this.getLabels(0));
        return userContext;
    }

    public byte[] getLabels(int type) {
        try {
            return this.getKolunCore().getLabels(this.getOpPackageName(), type);
        }
        catch (RemoteException | NullPointerException e2) {
            KolunLog.w(TAG, "service is not ready or feature not supported " + e2);
            return null;
        }
    }

    public void listenKolunEvent(KolunEventListener listener, int events) {
        try {
            this.getKolunCore().listen(this.getOpPackageName(), listener.callback, events);
        }
        catch (RemoteException | NullPointerException e2) {
            KolunLog.w(TAG, "service is not ready or feature not supported " + e2);
        }
    }

    public IBinder getModule(String name) {
        try {
            return this.getKolunCore().getModule(this.getOpPackageName(), name);
        }
        catch (RemoteException | NullPointerException e2) {
            KolunLog.w(TAG, "service is not ready or feature not supported " + e2);
            return null;
        }
    }

    public IBinder getAnalysis(String name) {
        try {
            return this.getKolunCore().getAnalysis(this.getOpPackageName(), name);
        }
        catch (RemoteException | NullPointerException e2) {
            KolunLog.w(TAG, "service is not ready or feature not supported " + e2);
            return null;
        }
    }

    public IBinder getVersionController() {
        try {
            return this.getKolunCore().getVersionController(this.getOpPackageName());
        }
        catch (RemoteException | NullPointerException e2) {
            KolunLog.w(TAG, "service is not ready or feature not supported " + e2);
            return null;
        }
    }

    public IBinder getBinder(String ... params) {
        try {
            return this.getKolunCore().getBinder(this.getOpPackageName(), params);
        }
        catch (RemoteException | NullPointerException e2) {
            KolunLog.w(TAG, "service is not ready or feature not supported " + e2);
            return null;
        }
    }

    public void registerBinder(String name, IBinder iBinder) {
        try {
            this.getKolunCore().registerBinder(this.getOpPackageName(), iBinder, name);
        }
        catch (RemoteException | NullPointerException e2) {
            KolunLog.w(TAG, "service is not ready or feature not supported " + e2);
        }
    }

    protected IKolunCore getKolunCore() {
        if (this.mCore == null) {
            IBinder binder = AndroidHiddenApi.ServiceManagerProxy.getService("kolun");
            if (binder == null) {
                return null;
            }
            this.mCore = IKolunCore.Stub.asInterface(binder);
        }
        return this.mCore;
    }

    protected String getOpPackageName() {
        return this.mContext.getPackageName();
    }

    protected Context getContext() {
        return this.mContext;
    }
}

