/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.bridge;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.net.Uri;
import android.os.Handler;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.SparseArray;
import com.transsion.kolun.util.KolunLog;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public class AndroidSystemBridge {
    private static final String TAG = "AndroidSystemBridge";
    public static final String ACTION_SETTING_CHANGE = "setting_change";
    private static final Object sLock = new Object();
    private static volatile AndroidSystemBridge sAndroidSystemBridge;
    private final SparseArray<Backend> mBackends = new SparseArray();

    private AndroidSystemBridge() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AndroidSystemBridge getInstance() {
        AndroidSystemBridge instance = sAndroidSystemBridge;
        if (instance == null) {
            Object object = sLock;
            synchronized (object) {
                instance = sAndroidSystemBridge;
                if (instance == null) {
                    sAndroidSystemBridge = instance = new AndroidSystemBridge();
                }
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSession(Context context, Handler handler, AndroidSystemEventListener listener) {
        Object object = sLock;
        synchronized (object) {
            int session = AndroidSystemBridge.sAndroidSystemBridge.mBackends.size();
            AndroidSystemBridge.sAndroidSystemBridge.mBackends.put(session, (Object)new Backend(context, handler, listener));
            return session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listenBroadcast(int session, IntentFilter filter) {
        SparseArray<Backend> sparseArray = this.mBackends;
        synchronized (sparseArray) {
            final Backend backend = (Backend)this.mBackends.get(session);
            if (backend == null) {
                throw new RuntimeException("must invoke getSession");
            }
            if (backend.broadcastReceiver != null) {
                throw new RuntimeException("must invoke listenBroadcast once");
            }
            backend.broadcastReceiver = new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    if (backend.listener != null) {
                        backend.listener.onAndroidSystemEvent(new AndroidSystemEvent(intent));
                    }
                }
            };
            Context context = (Context)backend.weakContext.get();
            if (context != null) {
                context.registerReceiver(backend.broadcastReceiver, filter, null, backend.handler);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelListenBroadcast(int session) {
        SparseArray<Backend> sparseArray = this.mBackends;
        synchronized (sparseArray) {
            Context context;
            Backend backend = (Backend)this.mBackends.get(session);
            if (backend == null) {
                throw new RuntimeException("must invoke getSession");
            }
            if (backend.broadcastReceiver != null && (context = (Context)backend.weakContext.get()) != null) {
                try {
                    context.unregisterReceiver(backend.broadcastReceiver);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void listenSetting(int session, int type, String name, String def) {
        SparseArray<Backend> sparseArray = this.mBackends;
        synchronized (sparseArray) {
            Backend backend = (Backend)this.mBackends.get(session);
            if (backend == null) {
                throw new RuntimeException("must invoke getSession");
            }
            backend.settingObserver.listen(type, name, def);
        }
    }

    public void listenSetting(int session, int type, String name) {
        this.listenSetting(session, type, name, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelListenSetting(int session, int type, String name) {
        SparseArray<Backend> sparseArray = this.mBackends;
        synchronized (sparseArray) {
            Backend backend = (Backend)this.mBackends.get(session);
            if (backend == null) {
                throw new RuntimeException("must invoke getSession");
            }
            backend.settingObserver.unListen(type, name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(int session) {
        SparseArray<Backend> sparseArray = this.mBackends;
        synchronized (sparseArray) {
            Context context;
            Backend backend = (Backend)this.mBackends.get(session);
            if (backend == null) {
                KolunLog.w(TAG, "session is not exist : " + session);
                return;
            }
            if (backend.broadcastReceiver != null && (context = (Context)backend.weakContext.get()) != null) {
                try {
                    context.unregisterReceiver(backend.broadcastReceiver);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            backend.settingObserver.unListen();
        }
    }

    public static class AndroidSystemEvent {
        public final Intent mIntent;

        AndroidSystemEvent(Intent intent) {
            this.mIntent = intent;
        }

        public Intent getIntent() {
            return this.mIntent;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("AndroidSystemEvent {");
            if (this.mIntent != null) {
                sb.append(this.mIntent);
            }
            sb.append(" }");
            return sb.toString();
        }
    }

    public static class SettingInfo {
        public static final int SETTING_GLOBAL = 0;
        public static final int SETTING_SECURE = 1;
        public static final int SETTING_SYSTEM = 2;
        final int type;
        final String name;
        final String defaultValue;
        final Uri uri;
        boolean registered;

        SettingInfo(int type, String name, String defaultValue) {
            this.type = type;
            this.name = name;
            this.defaultValue = defaultValue;
            this.uri = this.getUri(type, name);
            this.registered = false;
        }

        boolean equals(int type, String name) {
            return type == this.type && TextUtils.equals((CharSequence)name, (CharSequence)this.name);
        }

        boolean equals(SettingInfo o2) {
            return o2 != null && o2.uri == this.uri;
        }

        private Uri getUri(int type, String name) {
            if (name == null) {
                return null;
            }
            switch (type) {
                case 0: {
                    return Settings.Global.getUriFor((String)name);
                }
                case 1: {
                    return Settings.Secure.getUriFor((String)name);
                }
                case 2: {
                    return Settings.System.getUriFor((String)name);
                }
            }
            return null;
        }
    }

    private static class SettingObserver
    extends ContentObserver {
        private final Backend backend;
        private final HashMap<Uri, SettingInfo> mSettingInfoMap = new HashMap();

        public SettingObserver(Backend backend, Handler handler) {
            super(handler);
            this.backend = backend;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void listen(int type, String name, String defaultValue) {
            SettingObserver settingObserver = this;
            synchronized (settingObserver) {
                Context context;
                SettingInfo info = this.searchLocked(type, name);
                if (info == null) {
                    info = new SettingInfo(type, name, defaultValue);
                    this.mSettingInfoMap.put(info.uri, info);
                }
                if (!info.registered && (context = (Context)this.backend.weakContext.get()) != null) {
                    info.registered = true;
                    context.getContentResolver().registerContentObserver(info.uri, false, (ContentObserver)this);
                    this.onChange(true, info.uri);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unListen(int type, String name) {
            SettingObserver settingObserver = this;
            synchronized (settingObserver) {
                SettingInfo info = this.searchLocked(type, name);
                if (info != null && info.registered) {
                    info.registered = false;
                }
            }
        }

        public void unListen() {
            Context context = (Context)this.backend.weakContext.get();
            if (context != null) {
                context.getContentResolver().unregisterContentObserver((ContentObserver)this);
            }
        }

        private SettingInfo searchLocked(int type, String name) {
            for (SettingInfo info : this.mSettingInfoMap.values()) {
                if (info == null || !info.equals(type, name)) continue;
                return info;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onChange(boolean selfChange, Uri uri) {
            SettingInfo info = null;
            SettingObserver settingObserver = this;
            synchronized (settingObserver) {
                info = this.mSettingInfoMap.get(uri);
            }
            if (info != null && info.registered && this.backend.listener != null) {
                String value = this.getSettingValue(info);
                Intent intent = new Intent(AndroidSystemBridge.ACTION_SETTING_CHANGE);
                intent.putExtra("type", info.type);
                intent.putExtra("name", info.name);
                intent.putExtra("value", value);
                this.backend.listener.onAndroidSystemEvent(new AndroidSystemEvent(intent));
            }
        }

        private String getSettingValue(SettingInfo info) {
            if (info.name == null) {
                return info.defaultValue;
            }
            Context context = (Context)this.backend.weakContext.get();
            if (context == null) {
                return info.defaultValue;
            }
            ContentResolver resolver = context.getContentResolver();
            String value = null;
            switch (info.type) {
                case 0: {
                    value = Settings.Global.getString((ContentResolver)resolver, (String)info.name);
                    break;
                }
                case 1: {
                    value = Settings.Secure.getString((ContentResolver)resolver, (String)info.name);
                    break;
                }
                case 2: {
                    value = Settings.System.getString((ContentResolver)resolver, (String)info.name);
                    break;
                }
            }
            return value != null ? value : info.defaultValue;
        }
    }

    private static class Backend {
        private final WeakReference<Context> weakContext;
        private final Handler handler;
        private final AndroidSystemEventListener listener;
        private final SettingObserver settingObserver;
        private BroadcastReceiver broadcastReceiver;

        public Backend(Context context, Handler handler, AndroidSystemEventListener listener) {
            this.weakContext = new WeakReference<Context>(context);
            this.handler = handler;
            this.listener = listener;
            this.settingObserver = new SettingObserver(this, handler);
        }
    }

    public static interface AndroidSystemEventListener {
        public void onAndroidSystemEvent(AndroidSystemEvent var1);
    }
}

