/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.bridge;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.database.ContentObserver;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.Uri;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Messenger;
import android.os.RemoteException;
import com.transsion.kolun.util.KolunLog;
import java.util.ArrayList;
import java.util.List;

public abstract class AppBridge {
    protected static final int TYPE_SERVICE = 0;
    protected static final int TYPE_SERVICE_AIDL = 1;
    protected static final int TYPE_SERVICE_MESSENGER = 2;
    protected static final int TYPE_CONTENT_PROVIDER = 3;
    protected static final int TYPE_HTTP = 4;
    private static final boolean DEBUG = true;
    public final String TAG;
    private final String mPackageName;
    private final Context mContext;
    private final int mType;

    public AppBridge(Context context, String packageName, int type) {
        if (packageName == null || context == null) {
            throw new IllegalArgumentException("context, packageName,  must not null,  [ " + context + " " + packageName + " ]");
        }
        this.TAG = this.getClass().getSimpleName() + "[" + packageName + "]";
        this.mPackageName = packageName;
        this.mContext = context.getApplicationContext();
        this.mType = type;
    }

    public Context getContext() {
        return this.mContext;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public int getBridgeType() {
        return this.mType;
    }

    abstract boolean connect();

    abstract void disconnect();

    private static boolean isAppExistAndEnabled(Context context, String packageName) {
        if (packageName == null || "".equals(packageName)) {
            return false;
        }
        ApplicationInfo applicationInfo = null;
        try {
            if (context.getPackageManager().getPackageInfo(packageName, 0) != null) {
                applicationInfo = context.getPackageManager().getApplicationInfo(packageName, 0);
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        return applicationInfo != null && applicationInfo.enabled;
    }

    public static class HttpBridge
    extends AppBridge {
        protected static final int NETWORK_STATUS_AVAILABLE = 1;
        protected static final int NETWORK_STATUS_ON_LOST = 2;
        protected static final int NETWORK_STATUS_UNAVAILABLE = 3;
        private volatile boolean mIsConnected = false;
        private ConnectivityManager mConnectivityManager;
        private int mNetworkStatus;
        private final ConnectivityManager.NetworkCallback mNetworkCallback = new ConnectivityManager.NetworkCallback(){

            public void onAvailable(Network network) {
                mNetworkStatus = 1;
                this.onAvailable(network);
            }

            public void onLost(Network network) {
                mNetworkStatus = 2;
                this.onLost(network);
            }

            public void onUnavailable() {
                mNetworkStatus = 3;
                this.onUnavailable();
            }
        };

        public HttpBridge(Context context, String packageName) {
            super(context, packageName, 4);
        }

        @SuppressLint(value={"MissingPermission"})
        private void registerNetworkCallback() {
            if (null == this.mNetworkCallback) {
                return;
            }
            this.mConnectivityManager = (ConnectivityManager)this.getContext().getSystemService("connectivity");
            if (null != this.mConnectivityManager) {
                this.mConnectivityManager.registerDefaultNetworkCallback(this.mNetworkCallback);
            }
        }

        @Override
        protected boolean connect() {
            this.registerNetworkCallback();
            this.mIsConnected = true;
            return true;
        }

        @Override
        protected void disconnect() {
            if (null != this.mConnectivityManager) {
                this.mConnectivityManager.unregisterNetworkCallback(this.mNetworkCallback);
                this.mConnectivityManager = null;
            }
            this.mIsConnected = false;
        }

        protected boolean isConnected() {
            return this.mIsConnected;
        }

        protected void onAvailable(Network network) {
        }

        protected void onLost(Network network) {
        }

        protected void onUnavailable() {
        }

        protected int getNetworkStatus() {
            return this.mNetworkStatus;
        }

        public static interface HttpCallback {
            public void onResponse(int var1, String var2);

            public void onFailure(Throwable var1);

            public void networkLost();

            public void networkAvailable();
        }
    }

    public static class ContentProviderBridge
    extends AppBridge {
        private final Uri mUri;
        private ContentResolver mResolver;
        private volatile ContentObserver mContentObserver;
        private volatile boolean mIsConnected = false;

        public ContentProviderBridge(Context context, String packageName, Uri uri) {
            super(context, packageName, 3);
            if (uri == null) {
                throw new IllegalArgumentException("uri must not null,  [ " + context + " " + packageName + " " + null + " ]");
            }
            this.mUri = uri;
        }

        public boolean isConnected() {
            return this.mIsConnected;
        }

        @Override
        public boolean connect() {
            if (AppBridge.isAppExistAndEnabled(this.getContext(), this.getPackageName())) {
                this.mResolver = this.getContext().getContentResolver();
                this.mIsConnected = true;
            }
            return this.mIsConnected;
        }

        @Override
        public void disconnect() {
            if (this.mContentObserver != null) {
                this.mResolver.unregisterContentObserver(this.mContentObserver);
            }
            this.mIsConnected = false;
            this.mResolver = null;
            this.mContentObserver = null;
        }

        protected Uri getUri() {
            return this.mUri;
        }

        protected ContentResolver getResolver() {
            return this.mResolver;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void observerDataChange(final Observer ob, Handler handler) throws IllegalArgumentException, IllegalStateException {
            if (!this.mIsConnected) {
                throw new IllegalStateException("bridge is disconnected");
            }
            if (ob != null && handler == null) {
                throw new IllegalArgumentException("handler is null");
            }
            if (ob != null && this.mContentObserver != null) {
                throw new IllegalStateException("only observer one time");
            }
            ContentProviderBridge contentProviderBridge = this;
            synchronized (contentProviderBridge) {
                if (ob != null) {
                    if (this.mContentObserver == null) {
                        ContentObserver contentObserver;
                        this.mContentObserver = contentObserver = new ContentObserver(handler){

                            public void onChange(boolean selfChange) {
                                ob.onDataChanged();
                            }
                        };
                    }
                    this.mResolver.registerContentObserver(this.mUri, true, this.mContentObserver);
                } else if (this.mContentObserver != null) {
                    this.mResolver.unregisterContentObserver(this.mContentObserver);
                    this.mContentObserver = null;
                }
            }
        }

        public static interface Observer {
            public void onDataChanged();
        }
    }

    public static class AidlBridge
    extends ServiceBridge {
        public AidlBridge(Context context, String packageName, String serviceName) {
            super(context, packageName, serviceName, 1);
        }

        public AidlBridge(Context context, String packageName, Intent intent) {
            super(context, packageName, intent, 1);
        }

        @Override
        protected void onBridgeConnected(IBinder binder) {
        }

        @Override
        protected void onBridgeDisconnected() {
        }
    }

    public static class MessengerBridge
    extends ServiceBridge {
        private final List<Message> mMessageList = new ArrayList<Message>();
        private Messenger mTheOtherSide;
        private MessengerStateCallback mCallback;

        public MessengerBridge(Context context, String packageName, String serviceName, MessengerStateCallback callback) {
            super(context, packageName, serviceName, 2);
            this.mCallback = callback;
        }

        public MessengerBridge(Context context, String packageName, String serviceName, int flag) {
            super(context, packageName, serviceName, 2, flag);
        }

        public MessengerBridge(Context context, String packageName, String serviceName) {
            super(context, packageName, serviceName, 2);
        }

        public MessengerBridge(Context context, String packageName, Intent intent) {
            super(context, packageName, intent, 2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onBridgeConnected(IBinder binder) {
            MessengerBridge messengerBridge = this;
            synchronized (messengerBridge) {
                this.mTheOtherSide = new Messenger(binder);
                int size = this.mMessageList.size();
                for (int i2 = 0; i2 < size; ++i2) {
                    this.sendMessageInner(this.mMessageList.get(i2));
                }
                this.mMessageList.clear();
            }
            if (this.mCallback != null) {
                this.mCallback.onMessengerStateChanged(this.mTheOtherSide, true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onBridgeDisconnected() {
            MessengerBridge messengerBridge = this;
            synchronized (messengerBridge) {
                this.mTheOtherSide = null;
            }
            if (this.mCallback != null) {
                this.mCallback.onMessengerStateChanged(null, false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendMessage(Message message) {
            MessengerBridge messengerBridge = this;
            synchronized (messengerBridge) {
                boolean shouldPending = false;
                if (this.getServiceState() == ServiceBridge.ServiceState.CONNECTED) {
                    shouldPending = !this.sendMessageInner(message);
                } else if (this.getServiceState() == ServiceBridge.ServiceState.BINDING) {
                    KolunLog.w(this.TAG, "Last binding failed!");
                    this.bindService();
                    shouldPending = true;
                } else {
                    this.bindService();
                    if (this.getServiceState() == ServiceBridge.ServiceState.REFUSE) {
                        shouldPending = false;
                        KolunLog.v(this.TAG, "drop message, cause service state is " + (Object)((Object)this.getServiceState()));
                    } else {
                        shouldPending = true;
                    }
                }
                if (shouldPending) {
                    this.queueMessageLocked(message);
                }
            }
        }

        private void queueMessageLocked(Message message) {
            this.mMessageList.add(message);
        }

        private Message dequeueActionLocked() {
            if (this.mMessageList.size() > 0) {
                return this.mMessageList.remove(0);
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean sendMessageInner(Message message) {
            MessengerBridge messengerBridge = this;
            synchronized (messengerBridge) {
                if (this.mTheOtherSide != null) {
                    try {
                        this.mTheOtherSide.send(message);
                        return true;
                    }
                    catch (RemoteException e2) {
                        KolunLog.w(true, this.TAG, "Failed to send message " + (Object)((Object)e2));
                        return false;
                    }
                }
                return false;
            }
        }

        public static interface MessengerStateCallback {
            public void onMessengerStateChanged(Messenger var1, boolean var2);
        }
    }

    public static class ServiceBridge
    extends AppBridge {
        private final Intent mIntent;
        private final ComponentName mComponentName;
        private final Object mLock = new Object();
        private final int mFlag;
        private volatile ServiceState mServiceState = ServiceState.UNKNOWN;
        private final ServiceConnection mConnection = new ServiceConnection(this){
            final /* synthetic */ ServiceBridge this$0;
            {
                this.this$0 = this$0;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                Object object = this.this$0.mLock;
                synchronized (object) {
                    this.this$0.mServiceState = ServiceState.CONNECTED;
                }
                this.this$0.onBridgeConnected(iBinder);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onServiceDisconnected(ComponentName componentName) {
                Object object = this.this$0.mLock;
                synchronized (object) {
                    this.this$0.mServiceState = ServiceState.DISCONNECTED;
                }
                this.this$0.onBridgeDisconnected();
            }
        };

        public ServiceBridge(Context context, String packageName, String serviceName, int type, int flag) {
            super(context, packageName, type);
            if (serviceName == null) {
                throw new IllegalArgumentException("serviceName must not null,  [ " + context + " " + packageName + " " + null + " ]");
            }
            this.mComponentName = new ComponentName(packageName, serviceName);
            this.mIntent = new Intent();
            this.mIntent.setComponent(this.mComponentName);
            this.mFlag = flag;
        }

        public ServiceBridge(Context context, String packageName, String serviceName) {
            super(context, packageName, 0);
            if (serviceName == null) {
                throw new IllegalArgumentException("serviceName must not null,  [ " + context + " " + packageName + " " + null + " ]");
            }
            this.mComponentName = new ComponentName(packageName, serviceName);
            this.mIntent = new Intent();
            this.mIntent.setComponent(this.mComponentName);
            this.mFlag = 1;
        }

        public ServiceBridge(Context context, String packageName, Intent intent) {
            super(context, packageName, 0);
            if (intent == null) {
                throw new IllegalArgumentException(" intent must not null,  [ " + context + " " + packageName + " " + null + "]");
            }
            this.mComponentName = intent.getComponent();
            this.mIntent = intent;
            this.mFlag = 1;
        }

        public ServiceBridge(Context context, String packageName, Intent intent, int type) {
            super(context, packageName, type);
            if (intent == null) {
                throw new IllegalArgumentException(" intent must not null,  [ " + context + " " + packageName + " " + null + "]");
            }
            this.mComponentName = intent.getComponent();
            this.mIntent = intent;
            this.mFlag = 1;
        }

        public ServiceBridge(Context context, String packageName, String serviceName, int type) {
            super(context, packageName, type);
            if (serviceName == null) {
                throw new IllegalArgumentException("ServiceName must not null,  [ " + context + " " + packageName + " " + null + " ]");
            }
            this.mComponentName = new ComponentName(packageName, serviceName);
            this.mIntent = new Intent();
            this.mIntent.setComponent(this.mComponentName);
            this.mFlag = 1;
        }

        protected void onBridgeConnected(IBinder binder) {
        }

        protected void onBridgeDisconnected() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ServiceState getServiceState() {
            Object object = this.mLock;
            synchronized (object) {
                return this.mServiceState;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void bindService() {
            Object object = this.mLock;
            synchronized (object) {
                KolunLog.d(true, this.TAG, "bindServiceLocked : " + this.mIntent + " " + (Object)((Object)this.mServiceState));
                if (this.mServiceState != ServiceState.CONNECTED) {
                    this.mServiceState = this.getContext().bindService(this.mIntent, this.mConnection, this.mFlag) ? ServiceState.BINDING : ServiceState.REFUSE;
                }
            }
        }

        @Override
        public boolean connect() {
            this.bindService();
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void disconnect() {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mServiceState == ServiceState.BINDING || this.mServiceState == ServiceState.CONNECTED) {
                    this.getContext().unbindService(this.mConnection);
                    this.mServiceState = ServiceState.DISCONNECTED;
                }
            }
        }

        protected static enum ServiceState {
            REFUSE,
            BINDING,
            CONNECTED,
            DISCONNECTED,
            UNKNOWN;

        }
    }
}

