/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.content;

import android.os.Handler;
import android.os.Looper;
import com.transsion.kolun.content.IKolunEventListener;
import java.lang.ref.WeakReference;

public class KolunEventListener {
    public static final int LISTEN_NONE = 0;
    public static final int LISTEN_USERCONTEXT = 1;
    public static final int LISTEN_PERSONA = 2;
    public static final int LISTEN_SCENE_STATE = 4;
    private static final String TAG = "EventListener";
    public final IKolunEventListener callback;
    private final Handler mHandler;

    public KolunEventListener() {
        this(Looper.myLooper());
    }

    public KolunEventListener(Looper looper) {
        this.mHandler = new Handler(looper);
        this.callback = new IKolunEventListenerStub(this);
    }

    public void onUserContextChanged() {
    }

    public void onPersonaChanged() {
    }

    public void onSceneStateChanged(int scene, boolean active) {
    }

    private class IKolunEventListenerStub
    extends IKolunEventListener.Stub {
        private final WeakReference<KolunEventListener> mListenerWeakRef;

        public IKolunEventListenerStub(KolunEventListener listener) {
            this.mListenerWeakRef = new WeakReference<KolunEventListener>(listener);
        }

        @Override
        public void onUserContextChanged() {
            this.invoke(() -> KolunEventListener.this.onUserContextChanged());
        }

        @Override
        public void onPersonaChanged() {
            this.invoke(() -> KolunEventListener.this.onPersonaChanged());
        }

        @Override
        public void onSceneStateChanged(int scene, boolean active) {
            this.invoke(() -> KolunEventListener.this.onSceneStateChanged(scene, active));
        }

        private void invoke(Runnable runnable) {
            KolunEventListener listener = (KolunEventListener)this.mListenerWeakRef.get();
            if (listener != null) {
                listener.mHandler.post(runnable);
            }
        }
    }
}

