/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.content;

import android.util.SparseIntArray;
import com.transsion.kolun.content.Labels;

public class UserContext
extends Labels {
    public static final int SCENE_MORNING = 1;
    public static final int SCENE_BEDTIME = 2;
    public static final int SCENE_SLEEPING = 4;
    public static final int SCENE_GAME_MODE = 256;
    public static final int SCENE_VIDEO_MODE = 512;
    public static final int IDLE = 32769;
    public static final String KEY_ACTIVE_SCENES = "active_scenes";
    public static final String KEY_WEATHER_SCENE = "scene_weather";
    public static final String KEY_TIME_SCENE = "scene_time";
    public static final String KEY_LOCATION_SCENE = "scene_location";
    public static final String KEY_SOCIAL_ATTRIBUTES = "social_attributes";
    public static final String KEY_ACTIVITY_SITUATION = "activity_situation";
    private static final SparseIntArray sAllScene = new SparseIntArray();
    private static final Object sLock = new Object();
    private static volatile UserContext sInstance;

    private UserContext() {
        super(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UserContext getInstance() {
        UserContext instance = sInstance;
        if (instance == null) {
            Object object = sLock;
            synchronized (object) {
                instance = sInstance;
                if (instance == null) {
                    sInstance = instance = new UserContext();
                }
            }
        }
        return instance;
    }

    public boolean isGameMode() {
        return 256 == (this.getAllActiveScene() & 0x100);
    }

    public boolean isVideoMode() {
        return 512 == (this.getAllActiveScene() & 0x200);
    }

    public int getAllActiveScene() {
        String activeScenesStr = this.get(KEY_ACTIVE_SCENES);
        int activeScenes = 0;
        if (activeScenesStr != null) {
            try {
                activeScenes = Integer.parseInt(activeScenesStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return activeScenes;
    }
}

