/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.data;

import android.util.Pair;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Base64;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;

public class DataSecurity {
    public static final int ENCRYPT_TYPE_NONE = 0;
    public static final int ENCRYPT_TYPE_BASE64 = 1;
    public static final int ENCRYPT_TYPE_DES = 2;
    public static final int ENCRYPT_TYPE_RSA = 3;
    public static final String SHA256_TYPE = "SHA-256";

    public static byte[] encrypt(byte[] target, int type, String ... args) throws Exception {
        if (target == null) {
            return null;
        }
        switch (type) {
            case 0: {
                return target;
            }
            case 1: {
                return DataSecurity.base64Encrypt(target);
            }
        }
        return target;
    }

    public static byte[] decrypt(byte[] target, int type, String ... args) throws Exception {
        if (target == null) {
            return null;
        }
        switch (type) {
            case 0: {
                return target;
            }
            case 1: {
                return DataSecurity.base64Decrypt(target);
            }
        }
        return target;
    }

    public static String toBase64String(String target) {
        return Base64.getEncoder().encodeToString(target.getBytes());
    }

    public static String fromBase64String(String target) {
        return new String(Base64.getDecoder().decode(target));
    }

    public static String base64Encode(byte[] target) {
        return Base64.getEncoder().encodeToString(target);
    }

    public static byte[] base64Decode(String target) {
        return Base64.getDecoder().decode(target);
    }

    public static byte[] base64Encrypt(byte[] target) {
        return Base64.getEncoder().encode(target);
    }

    public static byte[] base64Decrypt(byte[] target) {
        return Base64.getDecoder().decode(target);
    }

    public static byte[] DESEncrypt(String password, byte[] target) throws Exception {
        return DESHelper.encrypt(password, target);
    }

    public static byte[] DESDecrypt(String password, byte[] target) throws Exception {
        return DESHelper.decrypt(password, target);
    }

    public static Pair<String, String> generateRSAKeyPair() throws Exception {
        return RSAHelper.genKeyPair();
    }

    public static byte[] RASEncrypt(String pubKey, byte[] target) throws Exception {
        return RSAHelper.encrypt(pubKey, target);
    }

    public static byte[] RSADecrypt(String priKey, byte[] target) throws Exception {
        return RSAHelper.decrypt(priKey, target);
    }

    public static String computeHashOfByteArray(byte[] bytes) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(SHA256_TYPE);
        md.update(bytes);
        return DataSecurity.byteArrayToHex(md.digest());
    }

    public static String computeHashOfString(String source) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance(SHA256_TYPE);
        md.update(source.getBytes());
        return DataSecurity.byteArrayToHex(md.digest());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String computeHashOfFile(String fileLocation, String hashType) throws NoSuchAlgorithmException, IOException {
        MessageDigest md = MessageDigest.getInstance(hashType);
        byte[] hash = null;
        try (FileInputStream fis = null;){
            fis = new FileInputStream(fileLocation);
            byte[] buffer = new byte[256];
            int n2 = 0;
            while (n2 != -1) {
                n2 = ((InputStream)fis).read(buffer);
                if (n2 <= 0) continue;
                md.update(buffer, 0, n2);
            }
            hash = md.digest();
        }
        return DataSecurity.byteArrayToHex(hash);
    }

    public static String byteArrayToHex(byte[] byteArray) {
        char[] hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] resultCharArray = new char[byteArray.length * 2];
        int index = 0;
        for (byte b2 : byteArray) {
            resultCharArray[index++] = hexDigits[b2 >>> 4 & 0xF];
            resultCharArray[index++] = hexDigits[b2 & 0xF];
        }
        return new String(resultCharArray).toLowerCase();
    }

    private static final class RSAHelper {
        private static final String ALGORITHM = "RSA";
        private static final String CIPHER_ALGORITHM = "RSA";
        private static final String CHARSET = "utf8";
        private static final int KEY_LEN = 2048;

        private RSAHelper() {
        }

        public static Pair<String, String> genKeyPair() throws Exception {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
            keyPairGen.initialize(2048, new SecureRandom());
            KeyPair keyPair = keyPairGen.generateKeyPair();
            RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
            RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
            String publicKeyString = new String(Base64.getEncoder().encode(publicKey.getEncoded()), CHARSET);
            String privateKeyString = new String(Base64.getEncoder().encode(privateKey.getEncoded()), CHARSET);
            return new Pair((Object)publicKeyString, (Object)privateKeyString);
        }

        public static byte[] encrypt(String publicKey, byte[] data) throws Exception {
            return data;
        }

        public static byte[] decrypt(String privateKey, byte[] data) throws Exception {
            return data;
        }
    }

    private static final class DESHelper {
        private static final String IV_PARAMETER = "12345678";
        private static final String ALGORITHM = "DES";
        private static final String CIPHER_ALGORITHM = "DES/CBC/PKCS5Padding";
        private static final String CHARSET = "utf8";

        private DESHelper() {
        }

        private static Key generateKey(String password) throws NoSuchAlgorithmException, InvalidKeySpecException, UnsupportedEncodingException, InvalidKeyException {
            DESKeySpec dks = new DESKeySpec(password.getBytes(CHARSET));
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(ALGORITHM);
            return keyFactory.generateSecret(dks);
        }

        private static void checkPassword(String password) {
            if (password == null || password.length() < 8) {
                throw new RuntimeException("password length < 8");
            }
        }

        public static byte[] encrypt(String password, byte[] data) throws Exception {
            return data;
        }

        public static byte[] decrypt(String password, byte[] data) throws Exception {
            if (data == null) {
                return null;
            }
            return data;
        }
    }
}

