/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.download;

import com.transsion.kolun.util.KolunLog;
import java.io.File;

public class DownloadTask {
    public static final int DOWNLOAD_POLICY_ONLY_WIFI = 0;
    public static final int DOWNLOAD_POLICY_WIFI_AND_DATA = 1;
    private static final String TAG = "DownloadTask";
    private static boolean DEBUG = true;
    public final String downloadLink;
    public final String fileName;
    public final String location;
    public final long downLoadPolicy;
    public final boolean hideNotification;
    public final String cookieHeader;
    private IStatusListener mListener;
    private String mTitle;
    private String mDescription;
    private long mDownloadId = -1L;
    private int mStatus = 2;
    private long mReasonCode;
    private long mTotalSize = -1L;
    private long mDownloadedSize = -1L;

    private DownloadTask(String downloadLink, String fileName, String location, int downLoadPolicy, boolean hideNotification, String cookie) {
        this.downloadLink = downloadLink;
        this.fileName = fileName;
        this.location = location;
        this.cookieHeader = cookie;
        this.hideNotification = hideNotification;
        this.downLoadPolicy = downLoadPolicy;
    }

    public static DownloadTask build(String downloadLink, String fileName, String location, boolean hideNotification, String cookie) {
        return new DownloadTask(downloadLink, fileName, location, 0, hideNotification, cookie);
    }

    public static DownloadTask build(String downloadLink, String fileName, String location, boolean hideNotification) {
        return new DownloadTask(downloadLink, fileName, location, 0, hideNotification, null);
    }

    public static DownloadTask build(String downloadLink, String fileName, String location) {
        return new DownloadTask(downloadLink, fileName, location, 0, false, null);
    }

    public static DownloadTask build(String downloadLink, String fileName, String location, int downLoadPolicy) {
        return new DownloadTask(downloadLink, fileName, location, downLoadPolicy, false, null);
    }

    public static DownloadTask build(String downloadLink, String fileName, String location, int downLoadPolicy, boolean hideNotification) {
        return new DownloadTask(downloadLink, fileName, location, downLoadPolicy, hideNotification, null);
    }

    public static DownloadTask build(String downloadLink, String fileName, String location, int downLoadPolicy, boolean hideNotification, String cookie) {
        return new DownloadTask(downloadLink, fileName, location, downLoadPolicy, hideNotification, cookie);
    }

    public void listen(IStatusListener listener) {
        this.mListener = listener;
    }

    public void setDownloadTaskId(long id) {
        this.mDownloadId = id;
    }

    public long getDownloadTaskId() {
        return this.mDownloadId;
    }

    public long getTotalSize() {
        return this.mTotalSize;
    }

    public void setTotalSize(long size) {
        this.mTotalSize = size;
    }

    public long getDownloadedSize() {
        return this.mDownloadedSize;
    }

    public double getProcess() {
        return this.mTotalSize <= 0L || this.mDownloadedSize <= 0L ? 0.0 : (double)(this.mDownloadedSize / this.mTotalSize);
    }

    public int getStatus() {
        return this.mStatus;
    }

    public long getReasonCode() {
        return this.mReasonCode;
    }

    public void setTitle(String title) {
        this.mTitle = title;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public String getTitle() {
        return this.mTitle;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void onStatusChanged(int status, long downloadedSize, long reasonCode) {
        this.mReasonCode = reasonCode;
        this.mDownloadedSize = downloadedSize;
        KolunLog.d(DEBUG, TAG, "onStatusChanged => " + status + " " + downloadedSize + "/" + this.mTotalSize + " " + reasonCode);
        if (this.mStatus != status) {
            this.mStatus = status;
            if (this.mListener != null) {
                this.mListener.onStatusChanged(status);
            }
        }
    }

    public File getDownloadedFile() {
        return new File(this.location, this.fileName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DownloadTask {").append(" id=").append(this.mDownloadId);
        sb.append(" location=").append(this.location);
        sb.append(" url=").append(this.downloadLink);
        sb.append(" listener=").append(this.mListener);
        sb.append(" status=").append(this.mStatus);
        sb.append(" reasonCode=").append(this.mReasonCode);
        sb.append(" ").append(this.mDownloadedSize).append("/").append(this.mTotalSize);
        sb.append(" }");
        return sb.toString();
    }

    public static interface DownloadStatus {
        public static final int STATUS_FAILED = -3;
        public static final int STATUS_PAUSED = -2;
        public static final int STATUS_PENDING = -1;
        public static final int STATUS_RUNNING = 0;
        public static final int STATUS_SUCCESSFUL = 1;
        public static final int STATUS_STANDBY = 2;
        public static final int STATUS_CANCEL = 3;
    }

    public static interface IStatusListener {
        public void onStatusChanged(int var1);
    }
}

