/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.download;

import android.app.DownloadManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.net.Uri;
import android.os.Handler;
import com.transsion.kolun.KolunBuild;
import com.transsion.kolun.download.DownloadTask;
import com.transsion.kolun.download.IDownloadListener;
import com.transsion.kolun.download.IDownloader;
import com.transsion.kolun.util.KolunLog;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Set;

public class SystemDownloader
implements IDownloader {
    private static final String TAG = "Downloader";
    private static final boolean DEBUG = KolunBuild.IS_DEBUGGABLE;
    private final long CHECK_INTERVAL_IN_MILLIS = 5000L;
    private static SystemDownloader sInstance = new SystemDownloader();
    private final HashMap<Long, DownloadTask> mDownloadInfoMap = new HashMap();
    private Context mContext;
    private DownloadManager mDownloadManager;
    private Handler mHandler;
    private IDownloadListener mListener;

    public static SystemDownloader getInstance() {
        return sInstance;
    }

    private SystemDownloader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAllDownloadStatus(DownloadManager downloadManager) {
        if (downloadManager == null) {
            return;
        }
        DownloadManager.Query query = new DownloadManager.Query();
        if (this.mHandler != null) {
            this.mHandler.postDelayed(() -> this.checkAllDownloadStatus(this.mDownloadManager), 5000L);
        }
        SystemDownloader systemDownloader = this;
        synchronized (systemDownloader) {
            Set<Long> keys = this.mDownloadInfoMap.keySet();
            if (keys.size() <= 0) {
                return;
            }
            long[] ids = new long[keys.size()];
            int index = 0;
            for (long key : keys) {
                ids[index++] = key;
            }
            query.setFilterById(ids);
        }
        Cursor cursor = downloadManager.query(query);
        if (cursor != null) {
            try {
                if (cursor.moveToFirst()) {
                    do {
                        this.checkDownloadStatusLocked(cursor);
                    } while (cursor.moveToNext());
                }
            }
            finally {
                cursor.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDownloadStatus(DownloadManager downloadManager, long id) {
        if (downloadManager == null) {
            return;
        }
        SystemDownloader systemDownloader = this;
        synchronized (systemDownloader) {
            if (this.mDownloadInfoMap.get(id) == null) {
                return;
            }
            DownloadManager.Query query = new DownloadManager.Query();
            query.setFilterById(new long[]{id});
            Cursor c2 = downloadManager.query(query);
            if (c2 != null) {
                try {
                    if (c2.moveToFirst()) {
                        this.checkDownloadStatusLocked(c2);
                    }
                }
                finally {
                    c2.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkDownloadStatusLocked(Cursor c2) {
        long id = c2.getLong(c2.getColumnIndex("_id"));
        DownloadTask task = this.mDownloadInfoMap.get(id);
        int status = c2.getInt(c2.getColumnIndex("status"));
        String file = c2.getString(c2.getColumnIndex("local_uri"));
        int downloadStatus = 2;
        KolunLog.v(DEBUG, TAG, "checkDownloadStatusUnchecked [" + id + "] = " + status);
        switch (status) {
            case 1: {
                downloadStatus = -1;
                break;
            }
            case 2: {
                downloadStatus = 0;
                break;
            }
            case 8: {
                downloadStatus = 1;
                break;
            }
            case 4: {
                downloadStatus = -2;
                break;
            }
            case 16: {
                downloadStatus = -3;
            }
        }
        if (task == null) {
            KolunLog.d(DEBUG, TAG, "Can't find download info, id = " + id + ", notify non special listener");
            if (this.mListener != null) {
                if (status == 8) {
                    this.mListener.onSuccess(c2.getString(c2.getColumnIndex("uri")), c2.getString(c2.getColumnIndex("description")));
                } else if (status == 16) {
                    this.mListener.onFailed(c2.getString(c2.getColumnIndex("uri")), c2.getString(c2.getColumnIndex("description")));
                }
            }
            return;
        }
        long totalSize = c2.getLong(c2.getColumnIndex("total_size"));
        long downloadedSize = c2.getLong(c2.getColumnIndex("bytes_so_far"));
        long reasonCode = c2.getLong(c2.getColumnIndex("reason"));
        if (status == 8) {
            String localUri = c2.getString(c2.getColumnIndex("local_uri"));
            File dst = task.getDownloadedFile();
            KolunLog.v(TAG, "copy downloaded file form " + localUri);
            KolunLog.v(DEBUG, TAG, "copy downloaded file form " + localUri + " to " + dst);
            Uri uri = Uri.parse((String)localUri);
            try (AssetFileDescriptor source = this.mContext.getContentResolver().openAssetFileDescriptor(uri, "r");){
                try (FileInputStream in = source.createInputStream();
                     FileOutputStream out = new FileOutputStream(dst);){
                    int numRead;
                    byte[] buffer = new byte[16384];
                    while ((numRead = ((InputStream)in).read(buffer)) != -1) {
                        ((OutputStream)out).write(buffer, 0, numRead);
                    }
                }
                catch (IOException e2) {
                    KolunLog.e(TAG, "Failed to copy downloaded file form " + localUri + ", " + e2);
                }
            }
            catch (IOException e3) {
                KolunLog.e(TAG, "Failed to copy downloaded file form " + localUri + ", " + e3);
            }
            finally {
                this.mDownloadInfoMap.remove(id);
            }
        }
        task.setTotalSize(totalSize);
        task.onStatusChanged(downloadStatus, downloadedSize, reasonCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDownloader create(Context context, Handler handler, IDownloadListener listener) {
        SystemDownloader systemDownloader = this;
        synchronized (systemDownloader) {
            if (this.mContext == null) {
                this.mContext = context;
                this.mDownloadManager = (DownloadManager)this.mContext.getSystemService("download");
                this.mHandler = handler;
                this.mListener = listener;
                this.mContext.registerReceiver(new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        long id = intent.getLongExtra("extra_download_id", -1L);
                        if (id != -1L) {
                            SystemDownloader.this.mHandler.post(() -> SystemDownloader.this.checkDownloadStatus(SystemDownloader.this.mDownloadManager, id));
                        }
                    }
                }, new IntentFilter("android.intent.action.DOWNLOAD_COMPLETE"));
                this.mHandler.postDelayed(() -> this.checkAllDownloadStatus(this.mDownloadManager), 5000L);
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void recycle() {
        SystemDownloader systemDownloader = this;
        synchronized (systemDownloader) {
            this.mContext = null;
            this.mHandler = null;
            this.mListener = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startDownload(DownloadTask task) {
        if (task == null) {
            return;
        }
        SystemDownloader systemDownloader = this;
        synchronized (systemDownloader) {
            KolunLog.v(TAG, "startDownload " + task.downloadLink + " " + task.fileName);
            this.checkNotNull(this.mContext, this.mDownloadManager, this.mHandler);
            try {
                boolean inDownloadQueue = false;
                if (task.getDownloadTaskId() != -1L) {
                    DownloadManager.Query query = new DownloadManager.Query();
                    query.setFilterById(new long[]{task.getDownloadTaskId()});
                    Cursor cursor = this.mDownloadManager.query(query);
                    if (cursor != null) {
                        try {
                            int status;
                            if (cursor.moveToFirst() && ((status = cursor.getInt(cursor.getColumnIndex("status"))) == 1 || status == 2 || status == 4 || status == 8)) {
                                inDownloadQueue = true;
                                KolunLog.v(TAG, "startDownload, this download has been add download queue, and status is " + status);
                            }
                        }
                        finally {
                            cursor.close();
                        }
                    }
                }
                if (!inDownloadQueue) {
                    DownloadManager.Request request = new DownloadManager.Request(Uri.parse((String)task.downloadLink));
                    if (task.downLoadPolicy == 0L) {
                        request.setAllowedNetworkTypes(2);
                    } else if (task.downLoadPolicy == 1L) {
                        request.setAllowedNetworkTypes(3);
                    } else {
                        request.setAllowedNetworkTypes(2);
                    }
                    if (task.cookieHeader != null) {
                        request.addRequestHeader("Cookie", task.cookieHeader);
                    }
                    if (task.hideNotification) {
                        request.setNotificationVisibility(2);
                        request.setVisibleInDownloadsUi(false);
                    }
                    if (task.getTitle() != null) {
                        request.setTitle((CharSequence)task.getTitle());
                    }
                    if (task.getDescription() != null) {
                        request.setDescription((CharSequence)task.getDescription());
                    }
                    long id = this.mDownloadManager.enqueue(request);
                    task.setDownloadTaskId(id);
                }
                SystemDownloader systemDownloader2 = this;
                synchronized (systemDownloader2) {
                    this.mDownloadInfoMap.put(task.getDownloadTaskId(), task);
                }
            }
            catch (IllegalArgumentException | IllegalStateException | NullPointerException e2) {
                KolunLog.w(TAG, "Failed to start startDownload " + task + ", " + e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopDownload(DownloadTask task) {
        if (task == null) {
            return;
        }
        SystemDownloader systemDownloader = this;
        synchronized (systemDownloader) {
            this.checkNotNull(this.mDownloadManager);
            this.mDownloadInfoMap.remove(task.getDownloadTaskId());
            this.mDownloadManager.remove(new long[]{task.getDownloadTaskId()});
        }
    }

    private void checkNotNull(Object ... objects) {
        if (objects == null) {
            return;
        }
        for (Object o2 : objects) {
            if (o2 != null) continue;
            KolunLog.w(TAG, "null pointer exception ", new Throwable());
            throw new RuntimeException("invoke create first !!!");
        }
    }
}

