/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.kolunscanner;

import android.bluetooth.le.ScanSettings;
import android.net.wifi.SoftApConfiguration;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import com.transsion.kolun.kolunscanner.IKolunScannerCallback;
import com.transsion.kolun.kolunscanner.parcelablebean.CustomWifiConfiguration;
import java.util.ArrayList;
import java.util.List;

public interface IKolunScanner
extends IInterface {
    public boolean registerScanClient(String var1, IKolunScannerCallback var2) throws RemoteException;

    public boolean unregisterScanClient(String var1, IKolunScannerCallback var2) throws RemoteException;

    public void startToastActivityInSystem(String var1, Bundle var2, String var3, String var4) throws RemoteException;

    public boolean isScanning(String var1) throws RemoteException;

    public void startBleScan(String var1, List var2, ScanSettings var3) throws RemoteException;

    public void stopBleScan(String var1) throws RemoteException;

    public void refreshBleScanState(String var1, boolean var2) throws RemoteException;

    public int isWifiApOpen(String var1) throws RemoteException;

    public CustomWifiConfiguration getCurrentConnectWifiConfiguration(String var1) throws RemoteException;

    public boolean setStaticIpAddressAndConnectWifi(String var1, String var2, String var3, String var4, String var5, String var6) throws RemoteException;

    public boolean connectWifi(String var1, String var2, String var3) throws RemoteException;

    public String readFileUserSystemPermission(String var1, String var2) throws RemoteException;

    public void enableBluetooth(String var1, boolean var2) throws RemoteException;

    public SoftApConfiguration getCurrentDeviceApInfo(String var1) throws RemoteException;

    public boolean is5GBand(String var1) throws RemoteException;

    public boolean startSoftAp(String var1, boolean var2, String var3, String var4) throws RemoteException;

    public boolean stopSoftAp(String var1) throws RemoteException;

    public void forgetWifiByNetworkID(String var1, int var2) throws RemoteException;

    public String getIpAddress(String var1, String var2) throws RemoteException;

    public int getKolunBleScanAssistorVersion(String var1) throws RemoteException;

    public boolean setWifiEnable(String var1, boolean var2) throws RemoteException;

    public boolean isBluetoothConnected(String var1) throws RemoteException;

    public int getPhoneCallState(String var1) throws RemoteException;

    public void setWifiP2pChannels(String var1, int var2, int var3) throws RemoteException;

    public String[] getFactoryMacAddresses(String var1) throws RemoteException;

    public String getP2pMac(String var1) throws RemoteException;

    public String getP2pIp(String var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IKolunScanner {
        private static final String DESCRIPTOR = "com.transsion.kolun.kolunscanner.IKolunScanner";
        static final int TRANSACTION_registerScanClient = 1;
        static final int TRANSACTION_unregisterScanClient = 2;
        static final int TRANSACTION_startToastActivityInSystem = 3;
        static final int TRANSACTION_isScanning = 4;
        static final int TRANSACTION_startBleScan = 5;
        static final int TRANSACTION_stopBleScan = 6;
        static final int TRANSACTION_refreshBleScanState = 7;
        static final int TRANSACTION_isWifiApOpen = 8;
        static final int TRANSACTION_getCurrentConnectWifiConfiguration = 9;
        static final int TRANSACTION_setStaticIpAddressAndConnectWifi = 10;
        static final int TRANSACTION_connectWifi = 11;
        static final int TRANSACTION_readFileUserSystemPermission = 12;
        static final int TRANSACTION_enableBluetooth = 13;
        static final int TRANSACTION_getCurrentDeviceApInfo = 14;
        static final int TRANSACTION_is5GBand = 15;
        static final int TRANSACTION_startSoftAp = 16;
        static final int TRANSACTION_stopSoftAp = 17;
        static final int TRANSACTION_forgetWifiByNetworkID = 18;
        static final int TRANSACTION_getIpAddress = 19;
        static final int TRANSACTION_getKolunBleScanAssistorVersion = 20;
        static final int TRANSACTION_setWifiEnable = 21;
        static final int TRANSACTION_isBluetoothConnected = 22;
        static final int TRANSACTION_getPhoneCallState = 23;
        static final int TRANSACTION_setWifiP2pChannels = 24;
        static final int TRANSACTION_getFactoryMacAddresses = 25;
        static final int TRANSACTION_getP2pMac = 26;
        static final int TRANSACTION_getP2pIp = 27;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IKolunScanner asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IKolunScanner) {
                return (IKolunScanner)iin;
            }
            return new Proxy(obj);
        }

        public IBinder asBinder() {
            return this;
        }

        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
                case 1: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    IKolunScannerCallback _arg1 = IKolunScannerCallback.Stub.asInterface(data.readStrongBinder());
                    boolean _result = this.registerScanClient(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    IKolunScannerCallback _arg1 = IKolunScannerCallback.Stub.asInterface(data.readStrongBinder());
                    boolean _result = this.unregisterScanClient(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    Bundle _arg1 = 0 != data.readInt() ? (Bundle)Bundle.CREATOR.createFromParcel(data) : null;
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    this.startToastActivityInSystem(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _result = this.isScanning(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    ClassLoader cl = this.getClass().getClassLoader();
                    ArrayList _arg1 = data.readArrayList(cl);
                    ScanSettings _arg2 = 0 != data.readInt() ? (ScanSettings)ScanSettings.CREATOR.createFromParcel(data) : null;
                    this.startBleScan(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.stopBleScan(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    this.refreshBleScanState(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _result = this.isWifiApOpen(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    CustomWifiConfiguration _result = this.getCurrentConnectWifiConfiguration(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    String _arg4 = data.readString();
                    String _arg5 = data.readString();
                    boolean _result = this.setStaticIpAddressAndConnectWifi(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    boolean _result = this.connectWifi(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _result = this.readFileUserSystemPermission(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    this.enableBluetooth(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    SoftApConfiguration _result = this.getCurrentDeviceApInfo(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _result = this.is5GBand(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    boolean _result = this.startSoftAp(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _result = this.stopSoftAp(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 18: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    this.forgetWifiByNetworkID(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 19: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    String _result = this.getIpAddress(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 20: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _result = this.getKolunBleScanAssistorVersion(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 21: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    boolean _result = this.setWifiEnable(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 22: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _result = this.isBluetoothConnected(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 23: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _result = this.getPhoneCallState(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 24: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.setWifiP2pChannels(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 25: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String[] _result = this.getFactoryMacAddresses(_arg0);
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    return true;
                }
                case 26: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _result = this.getP2pMac(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 27: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _result = this.getP2pIp(_arg0);
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IKolunScanner impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IKolunScanner getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IKolunScanner {
            private IBinder mRemote;
            public static IKolunScanner sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean registerScanClient(String callingPackage, IKolunScannerCallback client) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeStrongBinder(client != null ? client.asBinder() : null);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().registerScanClient(callingPackage, client);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean unregisterScanClient(String callingPackage, IKolunScannerCallback client) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeStrongBinder(client != null ? client.asBinder() : null);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().unregisterScanClient(callingPackage, client);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startToastActivityInSystem(String callingPackage, Bundle bundle, String pkg, String clazz) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    if (bundle != null) {
                        _data.writeInt(1);
                        bundle.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(pkg);
                    _data.writeString(clazz);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startToastActivityInSystem(callingPackage, bundle, pkg, clazz);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isScanning(String callingPackage) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isScanning(callingPackage);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startBleScan(String callingPackage, List filters, ScanSettings scanSettings) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeList(filters);
                    if (scanSettings != null) {
                        _data.writeInt(1);
                        scanSettings.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startBleScan(callingPackage, filters, scanSettings);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopBleScan(String callingPackage) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().stopBleScan(callingPackage);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void refreshBleScanState(String callingPackage, boolean startScan) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(startScan ? 1 : 0);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().refreshBleScanState(callingPackage, startScan);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int isWifiApOpen(String callingPackage) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n2 = Stub.getDefaultImpl().isWifiApOpen(callingPackage);
                        return n2;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CustomWifiConfiguration getCurrentConnectWifiConfiguration(String callingPackage) throws RemoteException {
                CustomWifiConfiguration _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        CustomWifiConfiguration customWifiConfiguration = Stub.getDefaultImpl().getCurrentConnectWifiConfiguration(callingPackage);
                        return customWifiConfiguration;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (CustomWifiConfiguration)CustomWifiConfiguration.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setStaticIpAddressAndConnectWifi(String callingPackage, String ssid, String pwd, String staticIpAddress, String gateway, String dns) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(ssid);
                    _data.writeString(pwd);
                    _data.writeString(staticIpAddress);
                    _data.writeString(gateway);
                    _data.writeString(dns);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().setStaticIpAddressAndConnectWifi(callingPackage, ssid, pwd, staticIpAddress, gateway, dns);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean connectWifi(String callingPackage, String ssid, String pwd) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(ssid);
                    _data.writeString(pwd);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().connectWifi(callingPackage, ssid, pwd);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String readFileUserSystemPermission(String callingPackage, String systemFilePath) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(systemFilePath);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string = Stub.getDefaultImpl().readFileUserSystemPermission(callingPackage, systemFilePath);
                        return string;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableBluetooth(String callingPackage, boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(enable ? 1 : 0);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().enableBluetooth(callingPackage, enable);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SoftApConfiguration getCurrentDeviceApInfo(String callingPackage) throws RemoteException {
                SoftApConfiguration _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        SoftApConfiguration softApConfiguration = Stub.getDefaultImpl().getCurrentDeviceApInfo(callingPackage);
                        return softApConfiguration;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (SoftApConfiguration)SoftApConfiguration.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean is5GBand(String callingPackage) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().is5GBand(callingPackage);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean startSoftAp(String callingPackage, boolean is5g, String ssid, String preSharedKey) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(is5g ? 1 : 0);
                    _data.writeString(ssid);
                    _data.writeString(preSharedKey);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().startSoftAp(callingPackage, is5g, ssid, preSharedKey);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean stopSoftAp(String callingPackage) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().stopSoftAp(callingPackage);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forgetWifiByNetworkID(String callingPackage, int netId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(netId);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().forgetWifiByNetworkID(callingPackage, netId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getIpAddress(String callingPackage, String type) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(type);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string = Stub.getDefaultImpl().getIpAddress(callingPackage, type);
                        return string;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getKolunBleScanAssistorVersion(String callingPackage) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n2 = Stub.getDefaultImpl().getKolunBleScanAssistorVersion(callingPackage);
                        return n2;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setWifiEnable(String callingPackage, boolean enable) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(enable ? 1 : 0);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().setWifiEnable(callingPackage, enable);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isBluetoothConnected(String callingPackage) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isBluetoothConnected(callingPackage);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getPhoneCallState(String callingPackage) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n2 = Stub.getDefaultImpl().getPhoneCallState(callingPackage);
                        return n2;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setWifiP2pChannels(String callingPackage, int listeningChannel, int operatingChannel) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeInt(listeningChannel);
                    _data.writeInt(operatingChannel);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setWifiP2pChannels(callingPackage, listeningChannel, operatingChannel);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getFactoryMacAddresses(String callingPackage) throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String[] stringArray = Stub.getDefaultImpl().getFactoryMacAddresses(callingPackage);
                        return stringArray;
                    }
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getP2pMac(String callingPackage) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string = Stub.getDefaultImpl().getP2pMac(callingPackage);
                        return string;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getP2pIp(String callingPackage) throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string = Stub.getDefaultImpl().getP2pIp(callingPackage);
                        return string;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IKolunScanner {
        @Override
        public boolean registerScanClient(String callingPackage, IKolunScannerCallback client) throws RemoteException {
            return false;
        }

        @Override
        public boolean unregisterScanClient(String callingPackage, IKolunScannerCallback client) throws RemoteException {
            return false;
        }

        @Override
        public void startToastActivityInSystem(String callingPackage, Bundle bundle, String pkg, String clazz) throws RemoteException {
        }

        @Override
        public boolean isScanning(String callingPackage) throws RemoteException {
            return false;
        }

        @Override
        public void startBleScan(String callingPackage, List filters, ScanSettings scanSettings) throws RemoteException {
        }

        @Override
        public void stopBleScan(String callingPackage) throws RemoteException {
        }

        @Override
        public void refreshBleScanState(String callingPackage, boolean startScan) throws RemoteException {
        }

        @Override
        public int isWifiApOpen(String callingPackage) throws RemoteException {
            return 0;
        }

        @Override
        public CustomWifiConfiguration getCurrentConnectWifiConfiguration(String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public boolean setStaticIpAddressAndConnectWifi(String callingPackage, String ssid, String pwd, String staticIpAddress, String gateway, String dns) throws RemoteException {
            return false;
        }

        @Override
        public boolean connectWifi(String callingPackage, String ssid, String pwd) throws RemoteException {
            return false;
        }

        @Override
        public String readFileUserSystemPermission(String callingPackage, String systemFilePath) throws RemoteException {
            return null;
        }

        @Override
        public void enableBluetooth(String callingPackage, boolean enable) throws RemoteException {
        }

        @Override
        public SoftApConfiguration getCurrentDeviceApInfo(String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public boolean is5GBand(String callingPackage) throws RemoteException {
            return false;
        }

        @Override
        public boolean startSoftAp(String callingPackage, boolean is5g, String ssid, String preSharedKey) throws RemoteException {
            return false;
        }

        @Override
        public boolean stopSoftAp(String callingPackage) throws RemoteException {
            return false;
        }

        @Override
        public void forgetWifiByNetworkID(String callingPackage, int netId) throws RemoteException {
        }

        @Override
        public String getIpAddress(String callingPackage, String type) throws RemoteException {
            return null;
        }

        @Override
        public int getKolunBleScanAssistorVersion(String callingPackage) throws RemoteException {
            return 0;
        }

        @Override
        public boolean setWifiEnable(String callingPackage, boolean enable) throws RemoteException {
            return false;
        }

        @Override
        public boolean isBluetoothConnected(String callingPackage) throws RemoteException {
            return false;
        }

        @Override
        public int getPhoneCallState(String callingPackage) throws RemoteException {
            return 0;
        }

        @Override
        public void setWifiP2pChannels(String callingPackage, int listeningChannel, int operatingChannel) throws RemoteException {
        }

        @Override
        public String[] getFactoryMacAddresses(String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public String getP2pMac(String callingPackage) throws RemoteException {
            return null;
        }

        @Override
        public String getP2pIp(String callingPackage) throws RemoteException {
            return null;
        }

        public IBinder asBinder() {
            return null;
        }
    }
}

