/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.kolunscanner;

import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import android.net.wifi.SoftApConfiguration;
import android.os.Bundle;
import android.os.RemoteException;
import com.transsion.kolun.Kolun;
import com.transsion.kolun.kolunscanner.IKolunScanner;
import com.transsion.kolun.kolunscanner.IKolunScannerCallback;
import com.transsion.kolun.kolunscanner.parcelablebean.CustomWifiConfiguration;
import com.transsion.kolun.util.KolunLog;
import java.lang.ref.WeakReference;
import java.util.List;

public class KolunScannerManager {
    private static volatile KolunScannerManager mInstance;
    private final String TAG = "KolunScannerManager";
    public static final String KEY_TOAST_BUNDLE = "com.transsion.kolun.kolunscanner.key_toast_bundle";
    public static final String KEY_SCAN_RESULT = "com.transsion.kolun.kolunscanner.key_scan_result";
    public static final String MODULE_KOLUN_SCANNER_ASSISTOR = "BleScanAssistor";
    private IKolunScanner mKolunScanner;
    private WeakReference<Context> mContext;

    private KolunScannerManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static KolunScannerManager getInstance() {
        if (mInstance != null) return mInstance;
        Class<KolunScannerManager> clazz = KolunScannerManager.class;
        synchronized (KolunScannerManager.class) {
            if (mInstance != null) return mInstance;
            mInstance = new KolunScannerManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    public boolean isKolunExists() {
        return Kolun.isSystemServiceExists();
    }

    private String getPackageName() {
        String packageName = "";
        if (this.mContext != null && this.mContext.get() != null) {
            packageName = ((Context)this.mContext.get()).getPackageName();
        }
        return packageName;
    }

    public void initKolunScanner(Context context) {
        if (!this.isKolunExists()) {
            KolunLog.w("KolunScannerManager", "Kolun System Service not exists");
            return;
        }
        if (this.mKolunScanner != null) {
            KolunLog.w("KolunScannerManager", "IKolunScanner already init");
            return;
        }
        try {
            Kolun mKolun = new Kolun(context);
            this.mKolunScanner = IKolunScanner.Stub.asInterface(mKolun.getModule(MODULE_KOLUN_SCANNER_ASSISTOR));
            KolunLog.w("KolunScannerManager", "initKolunScanner init IKolunScanner ");
        }
        catch (Exception exception) {
            KolunLog.w("KolunScannerManager", "initKolunScanner,err:" + exception.toString());
        }
    }

    public int getBleAssistorVersion(Context context) {
        if (!this.isKolunExists()) {
            KolunLog.w("KolunScannerManager", "kolun is not exists");
            return -1;
        }
        this.mContext = new WeakReference<Context>(context);
        try {
            if (this.mKolunScanner == null) {
                Kolun mKolun = new Kolun(context);
                this.mKolunScanner = IKolunScanner.Stub.asInterface(mKolun.getModule(MODULE_KOLUN_SCANNER_ASSISTOR));
                KolunLog.w("KolunScannerManager", "getBleAssistorVersion init IKolunScanner ");
            }
            if (this.mKolunScanner == null) {
                return -1;
            }
            return this.mKolunScanner.getKolunBleScanAssistorVersion(this.getPackageName());
        }
        catch (Exception e2) {
            KolunLog.w("KolunScannerManager", "getBleAssistorVersion,err:" + e2.toString());
            return -1;
        }
    }

    public void registerKolunCallback(Context context, boolean register, IKolunScannerCallback kolunScannerCallback) {
        if (this.mKolunScanner == null) {
            KolunLog.w("KolunScannerManager", "mKolunScanner is null");
            return;
        }
        try {
            if (register) {
                this.mContext = new WeakReference<Context>(context);
                this.mKolunScanner.registerScanClient(context.getPackageName(), kolunScannerCallback);
            } else {
                this.mContext.clear();
                this.mKolunScanner.unregisterScanClient(context.getPackageName(), kolunScannerCallback);
            }
        }
        catch (RemoteException e2) {
            KolunLog.w("KolunScannerManager", "registerKolunCallback,err:" + e2.toString());
        }
    }

    public void enableBluetooth(boolean enable) {
        if (this.mKolunScanner == null) {
            KolunLog.w("KolunScannerManager", "mKolunScanner is null");
            return;
        }
        if (this.getPackageName().isEmpty()) {
            KolunLog.w("KolunScannerManager", "mContext is null");
            return;
        }
        try {
            this.mKolunScanner.enableBluetooth(this.getPackageName(), enable);
        }
        catch (RemoteException e2) {
            KolunLog.w("KolunScannerManager", "enableBluetooth,err:" + e2.toString());
        }
    }

    public void startKolunBleScan(List<ScanFilter> filterList, ScanSettings scanSettings) {
        if (this.mKolunScanner == null) {
            KolunLog.w("KolunScannerManager", "mKolunScanner is null");
            return;
        }
        if (this.getPackageName().isEmpty()) {
            KolunLog.w("KolunScannerManager", "mContext is null");
            return;
        }
        try {
            this.mKolunScanner.startBleScan(this.getPackageName(), filterList, scanSettings);
        }
        catch (RemoteException e2) {
            KolunLog.w("KolunScannerManager", "startKolunBleScan,err:" + e2.toString());
        }
    }

    public void stopKolunBleScan(Context context) {
        if (this.mKolunScanner == null) {
            KolunLog.w("KolunScannerManager", "mKolunScanner is null");
            return;
        }
        try {
            this.mKolunScanner.stopBleScan(context.getPackageName());
        }
        catch (RemoteException e2) {
            KolunLog.w("KolunScannerManager", "stopKolunBleScan,err:" + e2.toString());
        }
    }

    public void refreshBleScanState(Context context, boolean startScan) {
        if (this.mKolunScanner == null) {
            KolunLog.w("KolunScannerManager", "mKolunScanner is null");
            return;
        }
        try {
            this.mKolunScanner.refreshBleScanState(context.getPackageName(), startScan);
        }
        catch (RemoteException e2) {
            KolunLog.w("KolunScannerManager", "stopKolunBleScan,err:" + e2.toString());
        }
    }

    public boolean isKolunBleScanning() {
        if (this.mKolunScanner == null) {
            KolunLog.w("KolunScannerManager", "mKolunScanner is null");
            return false;
        }
        if (this.getPackageName().isEmpty()) {
            KolunLog.w("KolunScannerManager", "mContext is null");
            return false;
        }
        try {
            return this.mKolunScanner.isScanning(this.getPackageName());
        }
        catch (RemoteException e2) {
            KolunLog.w("KolunScannerManager", "isKolunBleScanning,err:" + e2.toString());
            return false;
        }
    }

    public String readFileUserSystemPermission(String filePath) {
        if (this.mKolunScanner == null) {
            KolunLog.w("KolunScannerManager", "mKolunScanner is null");
            return "";
        }
        if (this.getPackageName().isEmpty()) {
            KolunLog.w("KolunScannerManager", "mContext is null");
            return "";
        }
        try {
            return this.mKolunScanner.readFileUserSystemPermission(this.getPackageName(), filePath);
        }
        catch (RemoteException e2) {
            KolunLog.w("KolunScannerManager", "readFileUserSystemPermission,err:" + e2.toString());
            return "";
        }
    }

    public boolean setStaticIpAddressAndConnectWifi(String ssid, String pwd, String staticIpAddress, String gateway, String dns) {
        if (this.mKolunScanner == null) {
            KolunLog.w("KolunScannerManager", "mKolunScanner is null");
            return false;
        }
        if (this.getPackageName().isEmpty()) {
            KolunLog.w("KolunScannerManager", "mContext is null");
            return false;
        }
        try {
            return this.mKolunScanner.setStaticIpAddressAndConnectWifi(this.getPackageName(), ssid, pwd, staticIpAddress, gateway, dns);
        }
        catch (RemoteException e2) {
            KolunLog.w("KolunScannerManager", "setStaticIpAddressAndConnectWifi,err:" + e2.toString());
            return false;
        }
    }

    public boolean connectWifi(String ssid, String pwd, String staticIpAddress, String gateway, String dns) {
        if (this.mKolunScanner == null) {
            KolunLog.w("KolunScannerManager", "mKolunScanner is null");
            return false;
        }
        if (this.getPackageName().isEmpty()) {
            KolunLog.w("KolunScannerManager", "mContext is null");
            return false;
        }
        try {
            return this.mKolunScanner.connectWifi(this.getPackageName(), ssid, pwd);
        }
        catch (RemoteException e2) {
            KolunLog.w("KolunScannerManager", "connectWifi,err:" + e2.toString());
            return false;
        }
    }

    public void startToastActivity(Bundle bundle, Context startTargetContext, String clazz) {
        if (this.mKolunScanner == null) {
            KolunLog.w("KolunScannerManager", "mKolunScanner is null");
            return;
        }
        if (this.getPackageName().isEmpty()) {
            KolunLog.w("KolunScannerManager", "mContext is null");
            return;
        }
        try {
            this.mKolunScanner.startToastActivityInSystem(this.getPackageName(), bundle, startTargetContext.getPackageName(), clazz);
        }
        catch (RemoteException e2) {
            KolunLog.w("KolunScannerManager", "startToastActivity,err:" + e2.toString());
        }
    }

    public int isWifiApOpen() {
        if (this.mKolunScanner == null) {
            KolunLog.w("KolunScannerManager", "mKolunScanner is null");
            return -1;
        }
        if (this.getPackageName().isEmpty()) {
            KolunLog.w("KolunScannerManager", "mContext is null");
            return -1;
        }
        try {
            return this.mKolunScanner.isWifiApOpen(this.getPackageName());
        }
        catch (RemoteException e2) {
            KolunLog.w("KolunScannerManager", "isWifiApOpen,err:" + e2.toString());
            return -1;
        }
    }

    public CustomWifiConfiguration getCurrentConnectWifiConfiguration() {
        if (this.mKolunScanner == null) {
            KolunLog.w("KolunScannerManager", "mKolunScanner is null");
            return null;
        }
        if (this.getPackageName().isEmpty()) {
            KolunLog.w("KolunScannerManager", "mContext is null");
            return null;
        }
        try {
            return this.mKolunScanner.getCurrentConnectWifiConfiguration(this.getPackageName());
        }
        catch (RemoteException e2) {
            KolunLog.w("KolunScannerManager", "getCurrentConnectWifiConfiguration,err:" + e2.toString());
            return null;
        }
    }

    public boolean isBleAssistorExist(Context context) {
        if (!this.isKolunExists() || this.mKolunScanner == null) {
            KolunLog.w("KolunScannerManager", "mKolunScanner is null");
            return false;
        }
        Kolun mKolun = new Kolun(context);
        return mKolun.getModule(MODULE_KOLUN_SCANNER_ASSISTOR) != null;
    }

    public SoftApConfiguration getCurrentDeviceApInfo() {
        if (this.mKolunScanner == null) {
            KolunLog.w("KolunScannerManager", "mKolunScanner is null");
            return null;
        }
        if (this.getPackageName().isEmpty()) {
            KolunLog.w("KolunScannerManager", "mContext is null");
            return null;
        }
        try {
            return this.mKolunScanner.getCurrentDeviceApInfo(this.getPackageName());
        }
        catch (RemoteException e2) {
            KolunLog.w("KolunScannerManager", "getCurrentDeviceApInfo,err:" + e2.toString());
            return null;
        }
    }

    public boolean startSoftAp(boolean is5g, String ssid, String preSharedKey) {
        if (this.mKolunScanner == null) {
            KolunLog.w("KolunScannerManager", "mKolunScanner is null");
            return false;
        }
        if (this.getPackageName().isEmpty()) {
            KolunLog.w("KolunScannerManager", "mContext is null");
            return false;
        }
        try {
            return this.mKolunScanner.startSoftAp(this.getPackageName(), is5g, ssid, preSharedKey);
        }
        catch (RemoteException e2) {
            KolunLog.w("KolunScannerManager", "startSoftAp,err:" + e2.toString());
            return false;
        }
    }

    public boolean stopSoftAp() {
        if (this.mKolunScanner == null) {
            KolunLog.w("KolunScannerManager", "mKolunScanner is null");
            return false;
        }
        if (this.getPackageName().isEmpty()) {
            KolunLog.w("KolunScannerManager", "mContext is null");
            return false;
        }
        try {
            return this.mKolunScanner.stopSoftAp(this.getPackageName());
        }
        catch (RemoteException e2) {
            KolunLog.w("KolunScannerManager", "stopSoftAp,err:" + e2.toString());
            return false;
        }
    }

    public String getIpAddress(String type) {
        if (this.mKolunScanner == null) {
            KolunLog.w("KolunScannerManager", "mKolunScanner is null");
            return null;
        }
        if (this.getPackageName().isEmpty()) {
            KolunLog.w("KolunScannerManager", "mContext is null");
            return null;
        }
        try {
            return this.mKolunScanner.getIpAddress(this.getPackageName(), type);
        }
        catch (RemoteException e2) {
            KolunLog.w("KolunScannerManager", "getIpAddress,err:" + e2.toString());
            return null;
        }
    }

    public boolean is5GBand() {
        if (this.mKolunScanner == null) {
            KolunLog.w("KolunScannerManager", "mKolunScanner is null");
            return false;
        }
        if (this.getPackageName().isEmpty()) {
            KolunLog.w("KolunScannerManager", "mContext is null");
            return false;
        }
        try {
            return this.mKolunScanner.is5GBand(this.getPackageName());
        }
        catch (RemoteException e2) {
            KolunLog.w("KolunScannerManager", "is5GBand,err:" + e2.toString());
            return false;
        }
    }

    public void forgetWifiByNetworkID(int netId) {
        if (this.mKolunScanner == null) {
            KolunLog.w("KolunScannerManager", "mKolunScanner is null");
            return;
        }
        if (this.getPackageName().isEmpty()) {
            KolunLog.w("KolunScannerManager", "mContext is null");
            return;
        }
        try {
            this.mKolunScanner.forgetWifiByNetworkID(this.getPackageName(), netId);
        }
        catch (RemoteException e2) {
            KolunLog.w("KolunScannerManager", "forgetWifiByNetworkID,err:" + e2.toString());
        }
    }

    public boolean setWifiEnable(boolean enable) {
        if (this.mKolunScanner == null) {
            KolunLog.w("KolunScannerManager", "mKolunScanner is null");
            return false;
        }
        if (this.getPackageName().isEmpty()) {
            KolunLog.w("KolunScannerManager", "mContext is null");
            return false;
        }
        try {
            return this.mKolunScanner.setWifiEnable(this.getPackageName(), enable);
        }
        catch (RemoteException e2) {
            KolunLog.w("KolunScannerManager", "setWifiEnable,err:" + e2.toString());
            return false;
        }
    }

    public boolean isBluetoothConnected() {
        if (this.mKolunScanner == null) {
            KolunLog.w("KolunScannerManager", "mKolunScanner is null");
            return false;
        }
        if (this.getPackageName().isEmpty()) {
            KolunLog.w("KolunScannerManager", "mContext is null");
            return false;
        }
        try {
            return this.mKolunScanner.isBluetoothConnected(this.getPackageName());
        }
        catch (RemoteException e2) {
            KolunLog.w("KolunScannerManager", "isBluetoothConnected,err:" + e2.toString());
            return false;
        }
    }

    public int getPhoneCallState() {
        if (this.mKolunScanner == null) {
            KolunLog.w("KolunScannerManager", "mKolunScanner is null");
            return -1;
        }
        if (this.getPackageName().isEmpty()) {
            KolunLog.w("KolunScannerManager", "mContext is null");
            return -1;
        }
        try {
            return this.mKolunScanner.getPhoneCallState(this.getPackageName());
        }
        catch (RemoteException e2) {
            KolunLog.w("KolunScannerManager", "getPhoneCallState,err:" + e2.toString());
            return -1;
        }
    }

    public void setWifiP2pChannels(int listeningChannel, int operatingChannel) {
        if (this.mKolunScanner == null) {
            KolunLog.w("KolunScannerManager", "mKolunScanner is null");
            return;
        }
        if (this.getPackageName().isEmpty()) {
            KolunLog.w("KolunScannerManager", "mContext is null");
            return;
        }
        try {
            this.mKolunScanner.setWifiP2pChannels(this.getPackageName(), listeningChannel, operatingChannel);
        }
        catch (RemoteException e2) {
            KolunLog.w("KolunScannerManager", "getPhoneCallState,err:" + e2.toString());
        }
    }

    public String[] getFactoryMacAddresses() {
        if (this.mKolunScanner == null) {
            KolunLog.w("KolunScannerManager", "mKolunScanner is null");
            return null;
        }
        if (this.getPackageName().isEmpty()) {
            KolunLog.w("KolunScannerManager", "mContext is null");
            return null;
        }
        try {
            return this.mKolunScanner.getFactoryMacAddresses(this.getPackageName());
        }
        catch (RemoteException e2) {
            KolunLog.w("KolunScannerManager", "getFactoryMacAddresses,err:" + e2.toString());
            return null;
        }
    }

    public String getP2pMac() {
        if (this.mKolunScanner == null) {
            KolunLog.w("KolunScannerManager", "mKolunScanner is null");
            return null;
        }
        if (this.getPackageName().isEmpty()) {
            KolunLog.w("KolunScannerManager", "mContext is null");
            return null;
        }
        try {
            return this.mKolunScanner.getP2pMac(this.getPackageName());
        }
        catch (RemoteException e2) {
            KolunLog.w("KolunScannerManager", "getP2pMac,err:" + e2.toString());
            return null;
        }
    }

    public String getP2pIp() {
        if (this.mKolunScanner == null) {
            KolunLog.w("KolunScannerManager", "mKolunScanner is null");
            return null;
        }
        if (this.getPackageName().isEmpty()) {
            KolunLog.w("KolunScannerManager", "mContext is null");
            return null;
        }
        try {
            return this.mKolunScanner.getP2pIp(this.getPackageName());
        }
        catch (RemoteException e2) {
            KolunLog.w("KolunScannerManager", "getP2pIp,err:" + e2.toString());
            return null;
        }
    }
}

