/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.util;

import android.os.Handler;
import com.transsion.kolun.util.KolunLog;

public class FutureTask {
    public static final String TAG = "FutureTask";
    private final FutureFunction mFunction;
    private Object[] mParamArray;
    private final Runnable mRunnable;
    private Handler mHandler;

    public FutureTask(FutureFunction function, Object ... param) {
        this.mFunction = function;
        this.mParamArray = param;
        this.mRunnable = () -> {
            try {
                this.mFunction.invoke(this.mParamArray);
            }
            catch (Exception e2) {
                KolunLog.w(TAG, "Exception ", (Throwable)e2);
            }
            finally {
                this.recycle();
            }
        };
    }

    public void run(Handler handler, int delay) {
        this.mHandler = handler != null ? handler : new Handler();
        KolunLog.d(TAG, "Run " + this.mFunction + " in " + this.mHandler + " after " + delay + "ms");
        this.mHandler.postDelayed(this.mRunnable, (long)delay);
    }

    public void vRan(Handler handler, int max) {
        this.vRan(handler, 0, max, 1);
    }

    public void vRan(Handler handler, int min, int max) {
        this.vRan(handler, min, max, 1);
    }

    public void vRan(Handler handler, int min, int max, int step) {
        int delay = 0;
        if (min < 0) {
            min = 0;
        }
        if (max < 0) {
            max = 0;
        }
        if (step < 1) {
            step = 1;
        }
        if (min > max) {
            min = max;
        }
        if (min == max) {
            delay = min;
        } else {
            int stepNum = (max - min) / step;
            int randomStep = (int)(System.currentTimeMillis() % (long)(stepNum + 1));
            delay = min + randomStep * step;
            if (delay > max) {
                delay = max;
            }
        }
        this.run(handler, delay);
    }

    public void cancel() {
        if (this.mHandler != null && this.mHandler.hasCallbacks(this.mRunnable)) {
            KolunLog.d(TAG, "cancel " + this.mFunction + " in " + this.mHandler);
            this.mHandler.removeCallbacks(this.mRunnable);
        }
    }

    private void recycle() {
        this.mParamArray = null;
        this.mHandler = null;
    }

    public static void randomRun(Handler handler, int min, int max, int step, FutureFunction function, Object ... objects) {
        FutureTask futureTask = new FutureTask(function, objects);
        futureTask.vRan(handler, min, max, step);
    }

    public static void randomRun(Handler handler, int min, int max, FutureFunction function, Object ... objects) {
        FutureTask futureTask = new FutureTask(function, objects);
        futureTask.vRan(handler, min, max);
    }

    public static void randomRun(Handler handler, int max, FutureFunction function, Object ... objects) {
        FutureTask futureTask = new FutureTask(function, objects);
        futureTask.vRan(handler, max);
    }

    public static abstract class FiveParameterFunction<T1, T2, T3, T4, T5>
    implements FutureFunction {
        public abstract void apply(T1 var1, T2 var2, T3 var3, T4 var4, T5 var5);

        @Override
        public void invoke(Object ... objects) {
            if (objects == null) {
                this.apply(null, null, null, null, null);
            } else {
                if (objects.length < 4) {
                    throw new IllegalArgumentException("need 5 parameters");
                }
                this.apply(objects[0], objects[1], objects[2], objects[3], objects[4]);
            }
        }
    }

    public static abstract class FourParameterFunction<T1, T2, T3, T4>
    implements FutureFunction {
        public abstract void apply(T1 var1, T2 var2, T3 var3, T4 var4);

        @Override
        public void invoke(Object ... objects) {
            if (objects == null) {
                this.apply(null, null, null, null);
            } else {
                if (objects.length < 4) {
                    throw new IllegalArgumentException("need 4 parameters");
                }
                this.apply(objects[0], objects[1], objects[2], objects[3]);
            }
        }
    }

    public static abstract class ThreeParameterFunction<T1, T2, T3>
    implements FutureFunction {
        public abstract void apply(T1 var1, T2 var2, T3 var3);

        @Override
        public void invoke(Object ... objects) {
            if (objects == null) {
                this.apply(null, null, null);
            } else {
                if (objects.length < 3) {
                    throw new IllegalArgumentException("need 3 parameters");
                }
                this.apply(objects[0], objects[1], objects[2]);
            }
        }
    }

    public static abstract class TwoParameterFunction<T1, T2>
    implements FutureFunction {
        public abstract void apply(T1 var1, T2 var2);

        @Override
        public void invoke(Object ... objects) {
            if (objects == null) {
                this.apply(null, null);
            } else {
                if (objects.length < 2) {
                    throw new IllegalArgumentException("need 2 parameters");
                }
                this.apply(objects[0], objects[1]);
            }
        }
    }

    public static abstract class OneParameterFunction<T>
    implements FutureFunction {
        public abstract void apply(T var1);

        @Override
        public void invoke(Object ... objects) {
            if (objects == null) {
                this.apply(null);
            } else {
                this.apply(objects[0]);
            }
        }
    }

    public static abstract class EmptyParameter0Function
    implements FutureFunction {
        public abstract void apply();

        @Override
        public void invoke(Object ... objects) {
            this.apply();
        }
    }

    public static interface FutureFunction {
        public void invoke(Object ... var1);
    }
}

