/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.util;

import android.util.ArrayMap;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class MasterLuo {

    public static class Weekdays {
        private static final int ALL_DAYS = 127;
        public static final Weekdays ALL = Weekdays.fromBits(127);
        public static final Weekdays NONE = Weekdays.fromBits(0);
        private static final Map<Integer, Integer> sCalendarDayToBit;
        private final int mBits;

        private Weekdays(int bits) {
            this.mBits = 0x7F & bits;
        }

        public static Weekdays fromBits(int bits) {
            return new Weekdays(bits);
        }

        public static Weekdays fromCalendarDays(int ... calendarDays) {
            int bits = 0;
            for (int calendarDay : calendarDays) {
                Integer bit = sCalendarDayToBit.get(calendarDay);
                if (bit == null) continue;
                bits |= bit.intValue();
            }
            return new Weekdays(bits);
        }

        public Weekdays setBit(int calendarDay, boolean on) {
            Integer bit = sCalendarDayToBit.get(calendarDay);
            if (bit == null) {
                return this;
            }
            return new Weekdays(on ? this.mBits | bit : this.mBits & ~bit.intValue());
        }

        public boolean isBitOn(int calendarDay) {
            Integer bit = sCalendarDayToBit.get(calendarDay);
            if (bit == null) {
                throw new IllegalArgumentException(calendarDay + " is not a valid weekday");
            }
            return (this.mBits & bit) > 0;
        }

        public int getBits() {
            return this.mBits;
        }

        public boolean isRepeating() {
            return this.mBits != 0;
        }

        public int getDistanceToPreviousDay(Calendar time) {
            int calendarDay = time.get(7);
            for (int count = 1; count <= 7; ++count) {
                if (--calendarDay < 1) {
                    calendarDay = 7;
                }
                if (!this.isBitOn(calendarDay)) continue;
                return count;
            }
            return -1;
        }

        public int getDistanceToNextDay(Calendar time) {
            int calendarDay = time.get(7);
            for (int count = 0; count < 7; ++count) {
                if (this.isBitOn(calendarDay)) {
                    return count;
                }
                if (++calendarDay <= 7) continue;
                calendarDay = 1;
            }
            return -1;
        }

        public boolean equals(Object o2) {
            if (this == o2) {
                return true;
            }
            if (o2 == null || this.getClass() != o2.getClass()) {
                return false;
            }
            Weekdays weekdays = (Weekdays)o2;
            return this.mBits == weekdays.mBits;
        }

        public int hashCode() {
            return this.mBits;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(19);
            builder.append("[");
            if (this.isBitOn(2)) {
                builder.append(builder.length() > 1 ? " M" : "M");
            }
            if (this.isBitOn(3)) {
                builder.append(builder.length() > 1 ? " T" : "T");
            }
            if (this.isBitOn(4)) {
                builder.append(builder.length() > 1 ? " W" : "W");
            }
            if (this.isBitOn(5)) {
                builder.append(builder.length() > 1 ? " Th" : "Th");
            }
            if (this.isBitOn(6)) {
                builder.append(builder.length() > 1 ? " F" : "F");
            }
            if (this.isBitOn(7)) {
                builder.append(builder.length() > 1 ? " Sa" : "Sa");
            }
            if (this.isBitOn(1)) {
                builder.append(builder.length() > 1 ? " Su" : "Su");
            }
            builder.append("]");
            return builder.toString();
        }

        static {
            ArrayMap map = new ArrayMap(7);
            map.put(2, 1);
            map.put(3, 2);
            map.put(4, 4);
            map.put(5, 8);
            map.put(6, 16);
            map.put(7, 32);
            map.put(1, 64);
            sCalendarDayToBit = Collections.unmodifiableMap(map);
        }

        public static enum Order {
            SAT_TO_FRI(7, 1, 2, 3, 4, 5, 6),
            SUN_TO_SAT(1, 2, 3, 4, 5, 6, 7),
            MON_TO_SUN(2, 3, 4, 5, 6, 7, 1);

            private final List<Integer> mCalendarDays;

            private Order(Integer ... calendarDays) {
                this.mCalendarDays = Arrays.asList(calendarDays);
            }

            public List<Integer> getCalendarDays() {
                return this.mCalendarDays;
            }
        }
    }

    public static final class TimeRange {
        private final long mFirst;
        private final long mLast;

        public TimeRange(String first, String last) {
            if (first == null || last == null) {
                throw new IllegalArgumentException("arguments must not be null");
            }
            this.mFirst = TimeRange.stringToTimeMills(first);
            this.mLast = TimeRange.stringToTimeMills(last);
        }

        public TimeRange(long first, long last) {
            this.mFirst = first;
            this.mLast = last;
        }

        public long[] getRawData() {
            return new long[]{this.mFirst, this.mLast};
        }

        public boolean isContains(long ... args) {
            if (args == null) {
                return true;
            }
            for (long arg : args) {
                if (this.isContains(arg)) continue;
                return false;
            }
            return true;
        }

        public boolean isContains(long t2) {
            if (this.mFirst > this.mLast) {
                return t2 >= this.mFirst || t2 <= this.mLast;
            }
            return t2 <= this.mLast && t2 >= this.mFirst;
        }

        public boolean isContains(String time) {
            long t2 = TimeRange.stringToTimeMills(time);
            return this.isContains(t2);
        }

        public static long stringToTimeMills(String time) {
            if (time == null) {
                return 0L;
            }
            String[] arrays = time.split(":");
            long ret = 0L;
            try {
                int hour = Integer.parseInt(arrays[0]);
                if (hour >= 24) {
                    throw new IllegalArgumentException("hour must in [0, 24) but give " + hour);
                }
                ret += (long)(hour * 3600 * 1000);
                if (arrays.length > 1) {
                    int minute = Integer.parseInt(arrays[1]);
                    if (minute >= 60) {
                        throw new IllegalArgumentException("minute must in [0, 60) but give " + minute);
                    }
                    ret += (long)(minute * 60 * 1000);
                    if (arrays.length > 2) {
                        int seconds = Integer.parseInt(arrays[1]);
                        if (seconds >= 60) {
                            throw new IllegalArgumentException("seconds must in [0, 60) but give " + seconds);
                        }
                        ret += (long)(seconds * 1000);
                    }
                }
            }
            catch (NumberFormatException e2) {
                throw new IllegalArgumentException();
            }
            return ret;
        }

        public static String timeInDayToString(long timeInMiles) {
            int hourInMiles = 3600000;
            int hour = (int)timeInMiles / 3600000;
            int minute = (int)(timeInMiles % 3600000L) / 60000;
            int second = (int)(timeInMiles % 60000L) / 1000;
            return String.format("%02d:%02d:%02d", hour, minute, second);
        }

        public String toString() {
            return "[" + TimeRange.timeInDayToString(this.mFirst) + " ~ " + TimeRange.timeInDayToString(this.mLast) + "]";
        }
    }
}

