/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.util;

import android.text.TextUtils;
import android.util.ArrayMap;
import com.transsion.kolun.data.DataSecurity;
import com.transsion.kolun.util.KolunLog;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

public class Property {
    public static final String CHAR_SET = "utf-8";
    private final ArrayMap<String, String> mProperties = new ArrayMap();
    private final String mName;
    private PropertyChangedListener mListener;

    public Property() {
        this.mName = this.getClass().getSimpleName();
    }

    public Property(String name) {
        this.mName = name;
    }

    public Property(String name, PropertyChangedListener listener) {
        this.mListener = listener;
        this.mName = name;
    }

    public Property(PropertyChangedListener listener) {
        this.mListener = listener;
        this.mName = this.getClass().getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Property(Property o2) {
        this.mName = this.getClass().getSimpleName();
        if (o2 != null) {
            ArrayMap<String, String> arrayMap = this.mProperties;
            synchronized (arrayMap) {
                for (int i2 = 0; i2 < o2.mProperties.size(); ++i2) {
                    this.set((String)o2.mProperties.keyAt(i2), (String)o2.mProperties.valueAt(i2));
                }
                this.mListener = o2.mListener;
            }
        }
    }

    public String getName() {
        if (this.mName == null) {
            return this.getClass().getSimpleName();
        }
        return this.mName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Property o2) {
        if (o2 == null) {
            return;
        }
        ArrayMap<String, String> arrayMap = this.mProperties;
        synchronized (arrayMap) {
            for (int i2 = 0; i2 < o2.mProperties.size(); ++i2) {
                this.set((String)o2.mProperties.keyAt(i2), (String)o2.mProperties.valueAt(i2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        ArrayMap<String, String> arrayMap = this.mProperties;
        synchronized (arrayMap) {
            return this.mProperties.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String prop, String defVal) {
        ArrayMap<String, String> arrayMap = this.mProperties;
        synchronized (arrayMap) {
            String value = (String)this.mProperties.get((Object)prop);
            return value == null ? defVal : value;
        }
    }

    public String get(String prop) {
        return this.get(prop, "");
    }

    public int getInt(String key, int def) {
        String value = this.get(key);
        if (!TextUtils.isEmpty((CharSequence)value)) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    public long getLong(String key, long def) {
        String value = this.get(key);
        if (!TextUtils.isEmpty((CharSequence)value)) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    public float getFloat(String key, float def) {
        String value = this.get(key);
        if (!TextUtils.isEmpty((CharSequence)value)) {
            try {
                return Float.parseFloat(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    public String getString(String key, String def) {
        String value = this.get(key);
        if (!TextUtils.isEmpty((CharSequence)value)) {
            return value;
        }
        return def;
    }

    public boolean getBoolean(String key, boolean def) {
        String value = this.get(key);
        if (!TextUtils.isEmpty((CharSequence)value)) {
            try {
                return Boolean.parseBoolean(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return def;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<String> getAllKeys() {
        ArrayList<String> keyList;
        ArrayMap<String, String> arrayMap = this.mProperties;
        synchronized (arrayMap) {
            keyList = new ArrayList<String>(this.mProperties.keySet());
        }
        return keyList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear() {
        ArrayMap<String, String> arrayMap = this.mProperties;
        synchronized (arrayMap) {
            this.mProperties.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String set(String prop, String value) {
        if (TextUtils.isEmpty((CharSequence)prop)) {
            return "";
        }
        ArrayMap<String, String> arrayMap = this.mProperties;
        synchronized (arrayMap) {
            String oldValue = (String)this.mProperties.put((Object)prop, (Object)value);
            if (this.mListener != null) {
                String rn;
                String ro = oldValue == null ? "" : oldValue;
                String string = rn = value == null ? "" : value;
                if (!ro.equals(rn)) {
                    this.mListener.onChanged(this, prop, rn);
                }
            }
            return oldValue;
        }
    }

    public byte[] covertToBytes() {
        return this.covertToBytes(true);
    }

    public byte[] covertToBytes(boolean encrypt) {
        try {
            String str = this.toJSONObject().toString();
            KolunLog.d(this.getClass().getSimpleName(), "covertToBytes " + str);
            byte[] bytes = this.toJSONObject().toString().getBytes(CHAR_SET);
            if (encrypt) {
                bytes = this.encrypt(bytes);
            }
            return bytes;
        }
        catch (UnsupportedEncodingException e2) {
            return new byte[0];
        }
    }

    public boolean loadFromBytes(byte[] bytes) {
        return this.loadFromBytes(bytes, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadFromBytes(byte[] bytes, boolean decrypt) {
        if (bytes == null) {
            return false;
        }
        try {
            String str;
            ArrayMap<String, String> tmpValues;
            byte[] tmp = bytes;
            if (decrypt) {
                tmp = this.decrypt(bytes);
            }
            if ((tmpValues = this.fromJsonObject(new JSONObject(str = new String(tmp, CHAR_SET)))) == null) {
                return false;
            }
            ArrayMap<String, String> arrayMap = this.mProperties;
            synchronized (arrayMap) {
                this.mProperties.clear();
                this.mProperties.putAll(tmpValues);
                return true;
            }
        }
        catch (UnsupportedEncodingException | RuntimeException | JSONException e2) {
            KolunLog.w(this.getClass().getSimpleName(), "Exception in loadFromBytes " + e2);
            return false;
        }
    }

    protected byte[] encrypt(byte[] bytes) {
        try {
            return DataSecurity.encrypt(bytes, 0, new String[0]);
        }
        catch (Exception e2) {
            KolunLog.e(this.getClass().getSimpleName(), "Failed to encrypt " + e2);
            return bytes;
        }
    }

    protected byte[] decrypt(byte[] bytes) {
        try {
            return DataSecurity.decrypt(bytes, 0, new String[0]);
        }
        catch (Exception e2) {
            KolunLog.e(this.getClass().getSimpleName(), "Failed to decrypt " + e2);
            return bytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JSONObject toJSONObject() {
        ArrayMap<String, String> arrayMap = this.mProperties;
        synchronized (arrayMap) {
            try {
                JSONObject jsonObject = new JSONObject();
                for (int i2 = 0; i2 < this.mProperties.size(); ++i2) {
                    jsonObject.put((String)this.mProperties.keyAt(i2), this.mProperties.valueAt(i2));
                }
                return jsonObject;
            }
            catch (JSONException e2) {
                KolunLog.w(this.getClass().getSimpleName(), "Failed to convert to json" + (Object)((Object)e2));
                return new JSONObject();
            }
        }
    }

    protected ArrayMap<String, String> fromJsonObject(JSONObject jsonObject) throws JSONException {
        if (jsonObject == null) {
            throw new RuntimeException("json object must not null");
        }
        ArrayMap tmpValues = new ArrayMap();
        Iterator it = jsonObject.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = jsonObject.get(key);
            if (value instanceof String) {
                tmpValues.put((Object)key, (Object)((String)value));
                continue;
            }
            throw new RuntimeException("not expect " + value);
        }
        return tmpValues;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mName);
        sb.append(" ");
        sb.append(this.toJSONObject().toString());
        return sb.toString();
    }

    public static interface PropertyChangedListener {
        public void onChanged(Property var1, String var2, String var3);
    }
}

