/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.util;

import android.os.HandlerThread;
import com.transsion.kolun.KolunBuild;
import com.transsion.kolun.util.KolunLog;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class StabilityHelper {
    private static final String TAG = "StabilityHelper";
    private Object sOriginUncaughtExceptionPreHandler = null;
    private static boolean sHasHookUncaughtExceptionPreHandler = false;
    private static List<String> sIgnoreThreadList = new ArrayList<String>();
    private static final Thread.UncaughtExceptionHandler sDefaultExceptionHandler = (t2, e2) -> KolunLog.e(TAG, "catch exception from " + t2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addIgnoreThread(String name) {
        List<String> list = sIgnoreThreadList;
        synchronized (list) {
            if (!sIgnoreThreadList.contains(name)) {
                sIgnoreThreadList.add(name);
                StabilityHelper.hookThreadUncaughtExceptionPreHandler();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeIgnoreThread(String name) {
        List<String> list = sIgnoreThreadList;
        synchronized (list) {
            if (sIgnoreThreadList.contains(name)) {
                sIgnoreThreadList.remove(name);
            }
        }
    }

    private static void hookThreadUncaughtExceptionPreHandler() {
        if (sHasHookUncaughtExceptionPreHandler) {
            return;
        }
        Method getUncaughtExceptionPreHandlerMethod = null;
        try {
            getUncaughtExceptionPreHandlerMethod = Thread.class.getDeclaredMethod("getUncaughtExceptionPreHandler", new Class[0]);
            getUncaughtExceptionPreHandlerMethod.setAccessible(true);
            Object ueh = getUncaughtExceptionPreHandlerMethod.invoke(null, new Object[0]);
            if (ueh != null && !(ueh instanceof UncaughtExceptionPreHandler) && ueh instanceof Thread.UncaughtExceptionHandler) {
                Method setUncaughtExceptionPreHandlerMethod = Thread.class.getDeclaredMethod("setUncaughtExceptionPreHandler", Thread.UncaughtExceptionHandler.class);
                setUncaughtExceptionPreHandlerMethod.setAccessible(true);
                setUncaughtExceptionPreHandlerMethod.invoke(null, new UncaughtExceptionPreHandler((Thread.UncaughtExceptionHandler)ueh));
                sHasHookUncaughtExceptionPreHandler = true;
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e2) {
            KolunLog.w(TAG, "Failed to hookThreadUncaughtExceptionPreHandler", (Throwable)e2);
        }
    }

    public static HandlerThread startNewHandleThread(String name) {
        return StabilityHelper.startNewHandleThread(name, 5, null);
    }

    public static HandlerThread startNewHandleThread(String name, int priority) {
        return StabilityHelper.startNewHandleThread(name, priority, null);
    }

    public static HandlerThread startNewHandleThread(String name, int priority, Thread.UncaughtExceptionHandler handler) {
        HandlerThread thread = new HandlerThread(name, priority);
        StabilityHelper.addIgnoreThread(name);
        if (handler != null) {
            thread.setUncaughtExceptionHandler(handler);
        } else if (!KolunBuild.IS_DEBUGGABLE) {
            thread.setUncaughtExceptionHandler(sDefaultExceptionHandler);
        }
        thread.start();
        return thread;
    }

    private static class UncaughtExceptionPreHandler
    implements Thread.UncaughtExceptionHandler {
        private final Thread.UncaughtExceptionHandler mUncaughtExceptionPreHandler;

        public UncaughtExceptionPreHandler(Thread.UncaughtExceptionHandler ueh) {
            this.mUncaughtExceptionPreHandler = ueh;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            if (thread != null) {
                List list = sIgnoreThreadList;
                synchronized (list) {
                    if (sIgnoreThreadList.contains(thread.getName())) {
                        KolunLog.w(StabilityHelper.TAG, "uncaughtException in " + thread, throwable);
                    }
                }
            }
            try {
                this.mUncaughtExceptionPreHandler.uncaughtException(thread, throwable);
            }
            catch (Error | RuntimeException throwable2) {
                // empty catch block
            }
        }
    }
}

