/*
 * Decompiled with CFR 0.152.
 */
package com.transsion.kolun.util;

import android.os.SystemClock;
import android.util.Pair;
import com.transsion.kolun.util.KolunLog;
import java.util.ArrayDeque;
import java.util.Deque;

public final class TimingTrace {
    private final String mTag;
    private final long mWarnDuration;
    private final Deque<Pair<String, Long>> mStartTimes = new ArrayDeque<Pair<String, Long>>();

    public TimingTrace(String tag) {
        this.mTag = tag;
        this.mWarnDuration = 10L;
    }

    public TimingTrace(String tag, long warnDuration) {
        this.mTag = tag;
        this.mWarnDuration = warnDuration;
    }

    public void traceBegin(String name) {
        this.mStartTimes.push((Pair<String, Long>)Pair.create((Object)name, (Object)SystemClock.elapsedRealtime()));
    }

    public void traceEnd() {
        Pair<String, Long> event = this.mStartTimes.pop();
        this.logDuration((String)event.first, SystemClock.elapsedRealtime() - (Long)event.second);
    }

    public void logDuration(String name, long timeMs) {
        if (timeMs > this.mWarnDuration) {
            KolunLog.w(this.mTag, name + " took to complete: " + timeMs + "ms");
        } else {
            KolunLog.d(this.mTag, name + " took to complete: " + timeMs + "ms");
        }
    }
}

