/*
 * Decompiled with CFR 0.152.
 */
package com.welink.protocol.ble;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.le.AdvertiseCallback;
import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.AdvertiseSettings;
import android.bluetooth.le.BluetoothLeAdvertiser;
import android.os.Build;
import android.os.ParcelUuid;
import com.transsion.kolun.kolunscanner.KolunScannerManager;
import com.welink.protocol.CommonConstant;
import com.welink.protocol.utils.DataTransformUtil;
import com.welink.protocol.utils.LogUtil;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001CB\t\b\u0002\u00a2\u0006\u0004\bB\u0010\u0004J\u000f\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\b\u001a\u00020\u0002\u00a2\u0006\u0004\b\b\u0010\u0004J\u0015\u0010\u000b\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ=\u0010\u0014\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0014\u0010\u0015J\r\u0010\u0016\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0004R\u0016\u0010\u0017\u001a\u00020\u000e8\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0018R\"\u0010\u0019\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u0007\"\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\u00020\u000e8\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u0018R\"\u0010\u001f\u001a\u00020\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u001f\u0010\u0018\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\"\u0010$\u001a\u00020\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b$\u0010\u0018\u001a\u0004\b%\u0010!\"\u0004\b&\u0010#R\"\u0010'\u001a\u00020\u000e8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b'\u0010\u0018\u001a\u0004\b(\u0010!\"\u0004\b)\u0010#R\u0016\u0010*\u001a\u00020\u000e8\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b*\u0010\u0018R\u0018\u0010,\u001a\u0004\u0018\u00010+8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010-R\"\u0010.\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b.\u0010\u001a\u001a\u0004\b/\u0010\u0007\"\u0004\b0\u0010\u001dR\"\u00101\u001a\u00020\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b1\u00102\u001a\u0004\b3\u00104\"\u0004\b5\u0010\fR\u0018\u00107\u001a\u0004\u0018\u0001068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b7\u00108R\u0016\u0010:\u001a\u0002098\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b:\u0010;R$\u0010<\u001a\u0004\u0018\u00010\t8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b<\u00102\u001a\u0004\b=\u00104\"\u0004\b>\u0010\fR\"\u0010?\u001a\u00020\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b?\u0010\u001a\u001a\u0004\b@\u0010\u0007\"\u0004\bA\u0010\u001d\u00a8\u0006D"}, d2={"Lcom/welink/protocol/ble/AdvertiseTool;", "", "", "clearBuf", "()V", "", "isAdvertising", "()Z", "startAdvertisementContinue", "", "deviceName", "setDeviceName", "(Ljava/lang/String;)V", "wholePid", "", "encryptionFlag", "isIncludeDeviceName", "timeout", "advertiseMode", "isConnectable", "startAdvertisement", "(Ljava/lang/String;IZIIZ)V", "stopAdvertising", "LOCAL_NAME_MAX_LENGTH", "I", "mIsAdvertising", "Z", "getMIsAdvertising", "setMIsAdvertising", "(Z)V", "SET_NAME_TIMEOUT", "mEncryptionFlag", "getMEncryptionFlag", "()I", "setMEncryptionFlag", "(I)V", "mTimeout", "getMTimeout", "setMTimeout", "mAdvertiseMode", "getMAdvertiseMode", "setMAdvertiseMode", "WHOLE_PID_LENGTH", "Landroid/bluetooth/le/BluetoothLeAdvertiser;", "mAdvertiser", "Landroid/bluetooth/le/BluetoothLeAdvertiser;", "mIsConnectable", "getMIsConnectable", "setMIsConnectable", "mDeviceName", "Ljava/lang/String;", "getMDeviceName", "()Ljava/lang/String;", "setMDeviceName", "Landroid/bluetooth/le/AdvertiseCallback;", "mAdvertiseCallback", "Landroid/bluetooth/le/AdvertiseCallback;", "Landroid/bluetooth/BluetoothAdapter;", "mBluetoothAdapter", "Landroid/bluetooth/BluetoothAdapter;", "mWholePid", "getMWholePid", "setMWholePid", "mIsIncludeDeviceName", "getMIsIncludeDeviceName", "setMIsIncludeDeviceName", "<init>", "welink_a", "welinkSDK_release"})
public final class AdvertiseTool {
    @NotNull
    public static final AdvertiseTool INSTANCE = new AdvertiseTool();
    private static final int WHOLE_PID_LENGTH = 18;
    private static final int LOCAL_NAME_MAX_LENGTH = 15;
    private static final int SET_NAME_TIMEOUT = 6;
    @NotNull
    private static final BluetoothAdapter mBluetoothAdapter;
    @Nullable
    private static BluetoothLeAdvertiser mAdvertiser;
    @Nullable
    private static AdvertiseCallback mAdvertiseCallback;
    @Nullable
    private static String mWholePid;
    private static int mEncryptionFlag;
    private static boolean mIsIncludeDeviceName;
    private static int mTimeout;
    private static int mAdvertiseMode;
    private static boolean mIsConnectable;
    @NotNull
    private static String mDeviceName;
    private static boolean mIsAdvertising;

    private AdvertiseTool() {
    }

    private final void clearBuf() {
        LogUtil.INSTANCE.i("resetBuf......");
        mWholePid = null;
        mEncryptionFlag = 0;
        mIsIncludeDeviceName = false;
        mTimeout = 0;
        mAdvertiseMode = 0;
        mIsConnectable = false;
        mDeviceName = "";
        mAdvertiser = null;
        mAdvertiseCallback = null;
    }

    static {
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        Intrinsics.checkNotNullExpressionValue((Object)bluetoothAdapter, (String)"getDefaultAdapter()");
        mBluetoothAdapter = bluetoothAdapter;
        mDeviceName = "";
    }

    @Nullable
    public final String getMWholePid() {
        return mWholePid;
    }

    public final void setMWholePid(@Nullable String string) {
        mWholePid = string;
    }

    public final int getMEncryptionFlag() {
        return mEncryptionFlag;
    }

    public final void setMEncryptionFlag(int n2) {
        mEncryptionFlag = n2;
    }

    public final boolean getMIsIncludeDeviceName() {
        return mIsIncludeDeviceName;
    }

    public final void setMIsIncludeDeviceName(boolean bl) {
        mIsIncludeDeviceName = bl;
    }

    public final int getMTimeout() {
        return mTimeout;
    }

    public final void setMTimeout(int n2) {
        mTimeout = n2;
    }

    public final int getMAdvertiseMode() {
        return mAdvertiseMode;
    }

    public final void setMAdvertiseMode(int n2) {
        mAdvertiseMode = n2;
    }

    public final boolean getMIsConnectable() {
        return mIsConnectable;
    }

    public final void setMIsConnectable(boolean bl) {
        mIsConnectable = bl;
    }

    @NotNull
    public final String getMDeviceName() {
        return mDeviceName;
    }

    public final void setMDeviceName(@NotNull String string) {
        String string2 = string;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        mDeviceName = string2;
    }

    public final boolean getMIsAdvertising() {
        return mIsAdvertising;
    }

    public final void setMIsAdvertising(boolean bl) {
        mIsAdvertising = bl;
    }

    public final boolean isAdvertising() {
        return mIsAdvertising;
    }

    public final void startAdvertisementContinue() {
        String string = mWholePid;
        if (string != null) {
            AdvertiseTool advertiseTool = INSTANCE;
            int n2 = advertiseTool.getMEncryptionFlag();
            boolean bl = advertiseTool.getMIsIncludeDeviceName();
            int n3 = advertiseTool.getMTimeout();
            int n4 = advertiseTool.getMAdvertiseMode();
            boolean bl2 = advertiseTool.getMIsConnectable();
            advertiseTool.startAdvertisement(string, n2, bl, n3, n4, bl2);
        }
    }

    public final void setDeviceName(@NotNull String string) {
        String string2 = string;
        Intrinsics.checkNotNullParameter((Object)string2, (String)"deviceName");
        mDeviceName = string2;
    }

    public final void startAdvertisement(@NotNull String object, int n2, boolean bl, int n3, int n4, boolean bl2) {
        String string = object;
        Intrinsics.checkNotNullParameter((Object)string, (String)"wholePid");
        Object object2 = LogUtil.INSTANCE;
        ((LogUtil)object2).i("startAdvertisement......");
        mWholePid = object;
        mEncryptionFlag = n2;
        mIsIncludeDeviceName = bl;
        mTimeout = n3;
        mAdvertiseMode = n4;
        mIsConnectable = bl2;
        String string2 = Build.DEVICE;
        ((LogUtil)object2).i(Intrinsics.stringPlus((String)"localName is ", (Object)string2));
        if (!(string.length() < 18 || bl && string2 != null && string2.length() > 15)) {
            ArrayList<Byte> arrayList;
            ArrayList<Byte> arrayList2;
            int n5;
            string2 = BluetoothAdapter.getDefaultAdapter();
            if (string2 == null) {
                LogUtil.INSTANCE.e("mBluetoothAdapter\u4e3anull\uff0c\u672c\u673a\u53ef\u80fd\u4e0d\u652f\u6301\u84dd\u7259");
                n5 = 0;
            } else {
                long l2 = System.currentTimeMillis();
                int n6 = 0;
                if (!string2.isEnabled()) {
                    LogUtil.INSTANCE.i("\u84dd\u7259\u6ca1\u6253\u5f00\uff0c\u73b0\u5728\u5f00\u542f\u84dd\u7259......");
                    if (CommonConstant.INSTANCE.isKolunLegal()) {
                        KolunScannerManager.getInstance().enableBluetooth(true);
                    } else {
                        string2.enable();
                    }
                }
                while (!string2.isEnabled() && n6 < 6) {
                    n6 = (int)((System.currentTimeMillis() - l2) / (long)1000);
                }
                if (!string2.isEnabled() && n6 >= 6) {
                    LogUtil.INSTANCE.e("\u84dd\u7259\u5f00\u542f\u8d85\u8fc76s\uff0c\u5f00\u542f\u8d85\u65f6\uff0c\u9000\u51fa\uff01");
                    n5 = 0;
                } else {
                    LogUtil.INSTANCE.i("\u84dd\u7259\u5df2\u5f00\u542f\uff01");
                    n5 = 1;
                }
            }
            if (n5 == 0) {
                ((LogUtil)object2).e("startGattServer: \u84dd\u7259\u5f00\u542f\u8d85\u65f6\uff0c\u9000\u51fa\uff01");
                return;
            }
            n5 = (UByte.constructor-impl((byte)((byte)9)) & 0xFF) << 8 | (UByte.constructor-impl((byte)((byte)66)) & 0xFF) << 0;
            DataTransformUtil dataTransformUtil = DataTransformUtil.INSTANCE;
            object = dataTransformUtil.stringToByteArrayInHexInDouble((String)object);
            ArrayList<Byte> arrayList3 = arrayList2 = arrayList;
            arrayList2();
            arrayList2.add((byte)object[1]);
            arrayList2.add((byte)object[3]);
            arrayList2.add((byte)object[7]);
            arrayList3.add((byte)object[8]);
            arrayList3.add((byte)16);
            arrayList.add((byte)n2);
            ((LogUtil)object2).i("manufacturerSpecificData is");
            dataTransformUtil.print(CollectionsKt.toByteArray(arrayList2));
            if (mIsIncludeDeviceName) {
                boolean bl3 = mBluetoothAdapter.setName(mDeviceName);
                long l3 = System.currentTimeMillis();
                n2 = 0;
                ((LogUtil)object2).i("\u8bbe\u7f6eTV \u84dd\u7259\u540d\u79f0\u4e3a\uff1a" + mDeviceName + "\uff0c\u6267\u884c\u8fd4\u56de(\u4e3atrue\u4e0d\u4ee3\u8868\u771f\u6b63\u8bbe\u7f6e\u4e0b\u53bb\u4e86)\uff1a" + bl3);
                while (bl3 && !Intrinsics.areEqual((Object)mBluetoothAdapter.getName(), (Object)mDeviceName) && n2 < 6) {
                    n2 = (int)((System.currentTimeMillis() - l3) / (long)1000);
                    LogUtil.INSTANCE.i(Intrinsics.stringPlus((String)"\u7b49\u5f85\u84dd\u7259\u540d\u79f0\u8bbe\u7f6e\u5b8c\u6210......waitTime is ", (Object)n2));
                }
                object2 = mBluetoothAdapter;
                if (!Intrinsics.areEqual((Object)object2.getName(), (Object)mDeviceName) && n2 >= 6) {
                    LogUtil.INSTANCE.i(Intrinsics.stringPlus((String)"\u8bbe\u7f6e\u84dd\u7259\u540d\u79f0\u8d85\u65f6\uff0cwaitTime is ", (Object)n2));
                } else {
                    LogUtil.INSTANCE.i(Intrinsics.stringPlus((String)"set name successs, TV \u84dd\u7259\u540d\u79f0\u4e3a\uff1a", (Object)object2.getName()));
                }
            }
            if ((object2 = mBluetoothAdapter).getName().length() > 12 && mIsIncludeDeviceName) {
                mIsIncludeDeviceName = false;
                LogUtil.INSTANCE.e("\u84dd\u7259\u540d\u79f0\u957f\u5ea6\u8fc7\u957f\uff0cadvertise data\u653e\u4e0d\u4e0b\uff0c\u73b0\u53bb\u6389\u540d\u79f0\u3002");
            }
            if (object[0] == 6 && object[1] == 13) {
                LogUtil.INSTANCE.e(Intrinsics.stringPlus((String)"RUN PHONE MODE, BT MAC", (Object)object2.getAddress()));
                DataTransformUtil dataTransformUtil2 = DataTransformUtil.INSTANCE;
                String string3 = object2.getAddress();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"mBluetoothAdapter.address");
                byte[] byArray = dataTransformUtil2.macStringToByteArray(string3);
                object = byArray;
                dataTransformUtil2.print(byArray);
                AdvertiseData.Builder builder = new AdvertiseData.Builder().setIncludeTxPowerLevel(false).setIncludeDeviceName(bl).addManufacturerData(n5, CollectionsKt.toByteArray(arrayList2));
                welink_a.welink_a.welink_a.welink_a.welink_c.welink_a.Companion.getClass();
                object = builder.addServiceData(new ParcelUuid(welink_a.welink_a.welink_a.welink_a.welink_c.welink_a.access$getSERVICE_UUID$cp()), (byte[])object).build();
            } else if (object[0] == 6 && object[1] == 10) {
                ParcelUuid parcelUuid;
                ArrayList<Byte> arrayList4;
                LogUtil.INSTANCE.e("RUN PC MODE");
                ArrayList<Byte> arrayList5 = arrayList4;
                arrayList4 = new ArrayList<Byte>();
                String string4 = object2.getAddress();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"mBluetoothAdapter.address");
                byte[] byArray = DataTransformUtil.INSTANCE.macStringToByteArray(string4);
                arrayList5.add(byArray[0]);
                arrayList5.add(byArray[1]);
                arrayList5.add(byArray[2]);
                arrayList5.add(byArray[3]);
                arrayList5.add(byArray[4]);
                arrayList4.add(byArray[5]);
                if (((Object)object).length >= 16) {
                    arrayList5.add((byte)object[9]);
                    arrayList5.add((byte)object[10]);
                    arrayList5.add((byte)object[11]);
                    arrayList5.add((byte)object[12]);
                    arrayList5.add((byte)object[13]);
                    arrayList5.add((byte)object[14]);
                    arrayList5.add((byte)object[15]);
                    if (object[15] == 15) {
                        ArrayList<Byte> arrayList6 = arrayList5;
                        arrayList5.add((byte)object[1]);
                        arrayList5.add((byte)object[3]);
                        arrayList5.add((byte)object[7]);
                        arrayList6.add((byte)object[8]);
                        arrayList6.add((byte)16);
                    }
                }
                AdvertiseData.Builder builder = new AdvertiseData.Builder().setIncludeTxPowerLevel(false).setIncludeDeviceName(bl);
                object = parcelUuid;
                welink_a.welink_a.welink_a.welink_a.welink_c.welink_a.Companion.getClass();
                parcelUuid = new ParcelUuid(welink_a.welink_a.welink_a.welink_a.welink_c.welink_a.access$getSERVICE_UUID$cp());
                object = builder.addServiceData((ParcelUuid)object, CollectionsKt.toByteArray(arrayList5)).build();
            } else {
                AdvertiseData.Builder builder = new AdvertiseData.Builder().setIncludeTxPowerLevel(false).setIncludeDeviceName(bl).addManufacturerData(n5, CollectionsKt.toByteArray(arrayList2));
                welink_a.welink_a.welink_a.welink_a.welink_c.welink_a.Companion.getClass();
                object = builder.addServiceUuid(new ParcelUuid(welink_a.welink_a.welink_a.welink_a.welink_c.welink_a.access$getSERVICE_UUID$cp())).build();
            }
            Object object3 = object2;
            object2 = new AdvertiseSettings.Builder().setAdvertiseMode(n4).setTimeout(n3).setConnectable(mIsConnectable).setTxPowerLevel(3).build();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"Builder()\n            .setAdvertiseMode(advertiseMode)\n            .setTimeout(timeout)\n            .setConnectable(mIsConnectable)\n            .setTxPowerLevel(AdvertiseSettings.ADVERTISE_TX_POWER_HIGH)\n            .build()");
            mAdvertiser = object3.getBluetoothLeAdvertiser();
            LogUtil.INSTANCE.i(Intrinsics.stringPlus((String)"startAdvertisement: with advertiser ", (Object)mAdvertiser));
            if (mAdvertiseCallback == null) {
                welink_a welink_a2;
                welink_a welink_a3 = welink_a2;
                mAdvertiseCallback = new welink_a();
                BluetoothLeAdvertiser bluetoothLeAdvertiser = mAdvertiser;
                if (bluetoothLeAdvertiser != null) {
                    bluetoothLeAdvertiser.startAdvertising((AdvertiseSettings)object2, (AdvertiseData)object, (AdvertiseCallback)welink_a3);
                }
            }
            return;
        }
        ((LogUtil)object2).e("startAdvertisement's param is wrong, wholePid.length:" + ((String)object).length() + " should be 18,localName.length:" + string2.length() + " should <= 15");
    }

    public final void stopAdvertising() {
        AdvertiseCallback advertiseCallback;
        if (!BluetoothAdapter.getDefaultAdapter().isEnabled()) {
            LogUtil.INSTANCE.e("stopBtDiscoverable: \u84dd\u7259\u5df2\u5173\u95ed\uff01");
            mIsAdvertising = false;
            this.clearBuf();
            return;
        }
        LogUtil.INSTANCE.i(Intrinsics.stringPlus((String)"Stopping Advertising with advertiser ", (Object)mAdvertiser));
        BluetoothLeAdvertiser bluetoothLeAdvertiser = mAdvertiser;
        if (bluetoothLeAdvertiser != null && (advertiseCallback = mAdvertiseCallback) != null) {
            if (bluetoothLeAdvertiser != null) {
                bluetoothLeAdvertiser.stopAdvertising(advertiseCallback);
            }
            mAdvertiseCallback = null;
        }
        mIsAdvertising = false;
        this.clearBuf();
    }

    public static final class welink_a
    extends AdvertiseCallback {
        public void onStartFailure(int n2) {
            super.onStartFailure(n2);
            switch (n2) {
                default: {
                    Object object = "unkNown";
                    break;
                }
                case 5: {
                    Object object = "ADVERTISE_Failed_FEATURE_UNSUPPORTED";
                    break;
                }
                case 4: {
                    Object object = "ADVERTISE_Failed_INTERNAL_ERROR";
                    break;
                }
                case 3: {
                    Object object = "ADVERTISE_Failed_ALREADY_STARTED";
                    break;
                }
                case 2: {
                    Object object = "ADVERTISE_Failed_TOO_MANY_ADVERTISERS";
                    break;
                }
                case 1: {
                    Object object = "ADVERTISE_Failed_DATA_TOO_LARGE";
                }
            }
            LogUtil.INSTANCE.e(Intrinsics.stringPlus((String)"Advertising start failed, reason = ", (Object)object));
            INSTANCE.setMIsAdvertising(false);
        }

        public void onStartSuccess(@NotNull AdvertiseSettings advertiseSettings) {
            AdvertiseSettings advertiseSettings2 = advertiseSettings;
            Intrinsics.checkNotNullParameter((Object)advertiseSettings2, (String)"settingsInEffect");
            super.onStartSuccess(advertiseSettings2);
            LogUtil.INSTANCE.i("Advertising start successfully");
            INSTANCE.setMIsAdvertising(true);
        }
    }
}

