/*
 * Decompiled with CFR 0.152.
 */
package com.welink.protocol.ble;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.le.AdvertiseCallback;
import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.AdvertiseSettings;
import android.bluetooth.le.BluetoothLeAdvertiser;
import android.os.Build;
import com.welink.protocol.model.P2pInfo;
import com.welink.protocol.model.PhoneCloneInfo;
import com.welink.protocol.utils.DataTransformUtil;
import com.welink.protocol.utils.LogUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001dB\t\b\u0002\u00a2\u0006\u0004\bc\u0010\u0004J\u000f\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000f\u0010\u0005\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0004J/\u0010\r\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0017\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000f\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0013\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J/\u0010\u0015\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J'\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0017\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u000f\u0010\u001d\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u0004J\u000f\u0010\u001e\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001e\u0010\u0004J\r\u0010\u001f\u001a\u00020\u0002\u00a2\u0006\u0004\b\u001f\u0010\u0004J\r\u0010 \u001a\u00020\u0002\u00a2\u0006\u0004\b \u0010\u0004J\u001d\u0010#\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020!2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b#\u0010$J\u001d\u0010'\u001a\u00020\u00022\u0006\u0010&\u001a\u00020%2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b'\u0010(J\r\u0010)\u001a\u00020\u0002\u00a2\u0006\u0004\b)\u0010\u0004R$\u0010+\u001a\u0004\u0018\u00010*8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b+\u0010,\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u0016\u00102\u001a\u0002018\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b2\u00103R\u0016\u00104\u001a\u00020\u000b8\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b4\u00105R\u0018\u00107\u001a\u0004\u0018\u0001068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b7\u00108R\"\u00109\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b9\u00105\u001a\u0004\b:\u0010;\"\u0004\b<\u0010=R\u0016\u0010>\u001a\u00020\u000b8\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b>\u00105R\u0016\u0010?\u001a\u00020\u00068\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b?\u0010@R\u0016\u0010B\u001a\u00020A8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bB\u0010CR\"\u0010E\u001a\u00020D8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bE\u0010F\u001a\u0004\bG\u0010H\"\u0004\bI\u0010JR(\u0010L\u001a\b\u0012\u0004\u0012\u00020\b0K8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bL\u0010M\u001a\u0004\bN\u0010O\"\u0004\bP\u0010QR\u0018\u0010S\u001a\u0004\u0018\u00010R8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bS\u0010TR\"\u0010U\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bU\u00105\u001a\u0004\bV\u0010;\"\u0004\bW\u0010=R\"\u0010X\u001a\u00020\u000b8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bX\u00105\u001a\u0004\bY\u0010;\"\u0004\bZ\u0010=R\u0016\u0010[\u001a\u00020\u00068\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b[\u0010@R\u0016\u0010]\u001a\u00020\\8\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b]\u0010^R\u0016\u0010_\u001a\u00020\u000b8\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b_\u00105R\u0016\u0010a\u001a\u00020`8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\ba\u0010b\u00a8\u0006e"}, d2={"Lcom/welink/protocol/ble/DataAdvertisTool;", "", "", "clearAdvertiseData", "()V", "shutdownPool", "", "functionCode", "", "advID", "data", "", "timeout", "startAdvertiseData", "(B[B[BI)V", "suffix", "foundEncodeKey", "([B)[B", "key", "dataEncode", "([B[B)[B", "addAdvDataToBuf", "([B[BBI)V", "manufacturerId", "manufacturerSpecificData", "finalStartAdvertise", "(I[BI)V", "addAdvData", "([B)V", "clearAdvData", "stopAdvertising", "stopAdvertiseData", "stopPhoneClonerAdvertise", "Lcom/welink/protocol/model/PhoneCloneInfo;", "phoneCloneInfo", "startPhoneClonerAdvertise", "(Lcom/welink/protocol/model/PhoneCloneInfo;I)V", "Lcom/welink/protocol/model/P2pInfo;", "p2pInfo", "startP2pInfoAdvertise", "(Lcom/welink/protocol/model/P2pInfo;I)V", "startAdvFromRemainAdvData", "Ljava/util/concurrent/ExecutorService;", "mPool", "Ljava/util/concurrent/ExecutorService;", "getMPool", "()Ljava/util/concurrent/ExecutorService;", "setMPool", "(Ljava/util/concurrent/ExecutorService;)V", "Ljava/util/UUID;", "SERVICE_UUID", "Ljava/util/UUID;", "MAC_STRING_LENGTH", "I", "Landroid/bluetooth/le/AdvertiseCallback;", "mAdvertiseCallback", "Landroid/bluetooth/le/AdvertiseCallback;", "mRemainAdvDataIndex", "getMRemainAdvDataIndex", "()I", "setMRemainAdvDataIndex", "(I)V", "DATA_MAX_LENGTH", "GET_P2P_INFO", "B", "Ljava/util/concurrent/atomic/AtomicBoolean;", "mPoolExist", "Ljava/util/concurrent/atomic/AtomicBoolean;", "", "mIsStopAdv", "Z", "getMIsStopAdv", "()Z", "setMIsStopAdv", "(Z)V", "", "mRemainAdvDataMutableList", "Ljava/util/List;", "getMRemainAdvDataMutableList", "()Ljava/util/List;", "setMRemainAdvDataMutableList", "(Ljava/util/List;)V", "Landroid/bluetooth/le/BluetoothLeAdvertiser;", "mAdvertiser", "Landroid/bluetooth/le/BluetoothLeAdvertiser;", "mAdvTotalNum", "getMAdvTotalNum", "setMAdvTotalNum", "mTimeout", "getMTimeout", "setMTimeout", "GET_PHONE_CLONE_INFO", "", "ENCODE_KEY_PREFIX", "Ljava/lang/String;", "ADV_MAX_INDEX", "Landroid/bluetooth/BluetoothAdapter;", "mBluetoothAdapter", "Landroid/bluetooth/BluetoothAdapter;", "<init>", "welink_a", "welinkSDK_release"})
public final class DataAdvertisTool {
    @NotNull
    public static final DataAdvertisTool INSTANCE = new DataAdvertisTool();
    @NotNull
    private static final BluetoothAdapter mBluetoothAdapter;
    @Nullable
    private static BluetoothLeAdvertiser mAdvertiser;
    @Nullable
    private static AdvertiseCallback mAdvertiseCallback;
    @NotNull
    private static final UUID SERVICE_UUID;
    private static final byte GET_PHONE_CLONE_INFO = 10;
    private static final byte GET_P2P_INFO = 8;
    private static final int DATA_MAX_LENGTH = 22;
    private static final int ADV_MAX_INDEX = 15;
    private static final int MAC_STRING_LENGTH = 17;
    @NotNull
    private static final String ENCODE_KEY_PREFIX = "TRANSSION";
    @NotNull
    private static final AtomicBoolean mPoolExist;
    private static int mRemainAdvDataIndex;
    private static int mAdvTotalNum;
    @NotNull
    private static List<byte[]> mRemainAdvDataMutableList;
    @Nullable
    private static ExecutorService mPool;
    private static int mTimeout;
    private static boolean mIsStopAdv;

    private DataAdvertisTool() {
    }

    private final void clearAdvertiseData() {
        DataAdvertisTool dataAdvertisTool = this;
        LogUtil.INSTANCE.i("now clearAdvertiseData......");
        mIsStopAdv = false;
        mAdvertiser = null;
        mAdvertiseCallback = null;
        mAdvTotalNum = 0;
        dataAdvertisTool.clearAdvData();
        mTimeout = 0;
        dataAdvertisTool.shutdownPool();
    }

    private final void shutdownPool() {
        if (mPoolExist.compareAndSet(true, false)) {
            ExecutorService executorService = mPool;
            if (executorService != null) {
                executorService.shutdown();
            }
            mPool = null;
        }
    }

    private final void startAdvertiseData(byte by, byte[] byArray, byte[] byArray2, int n2) {
        DataAdvertisTool dataAdvertisTool = this;
        LogUtil.INSTANCE.i("in startAdvertiseData, adv data is :");
        DataTransformUtil.INSTANCE.print(byArray2);
        mTimeout = n2;
        dataAdvertisTool.addAdvDataToBuf(byArray, byArray2, by, n2);
        dataAdvertisTool.startAdvFromRemainAdvData();
    }

    private final byte[] foundEncodeKey(byte[] byArray) {
        byte[] byArray2 = ENCODE_KEY_PREFIX.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        List list = ArraysKt.toMutableList((byte[])byArray2);
        list.addAll(ArraysKt.toMutableList((byte[])byArray));
        return CollectionsKt.toByteArray((Collection)list);
    }

    private final byte[] dataEncode(byte[] byArray, byte[] byArray2) {
        Object object = new byte[byArray2.length];
        int n2 = 0;
        int n3 = byArray2.length + -1;
        if (n3 >= 0) {
            while (true) {
                int n4 = n2 + 1;
                object[n2] = (byte)(byArray2[n2] ^ byArray[n2 % byArray.length]);
                if (n4 > n3) break;
                n2 = n4;
            }
        }
        return object;
    }

    private final void addAdvDataToBuf(byte[] object, byte[] byArray, byte by, int n2) {
        Object object2;
        ArrayList arrayList;
        Object object3 = Build.DEVICE;
        Object object4 = LogUtil.INSTANCE;
        ((LogUtil)object4).i(Intrinsics.stringPlus((String)"localName is ", (Object)object3));
        object3 = arrayList;
        arrayList = new ArrayList();
        new ArrayList();
        ((LogUtil)object4).e("startAdvertisement: \u51c6\u5907\u53d1\u6570\u636e\uff01");
        if (byArray.length <= 22) {
            Object object5 = object3;
            object3.add((byte)-18);
            object5.add(by);
            object5.add((byte)0);
            List list = ArraysKt.toMutableList((byte[])object);
            object = list;
            DataAdvertisTool dataAdvertisTool = object2;
            DataAdvertisTool dataAdvertisTool2 = object2;
            object.addAll(ArraysKt.toMutableList((byte[])byArray));
            object2 = ((DataAdvertisTool)object2).foundEncodeKey(CollectionsKt.toByteArray((Collection)object3));
            object3.addAll(ArraysKt.toMutableList((byte[])dataAdvertisTool2.dataEncode((byte[])object2, CollectionsKt.toByteArray((Collection)object))));
            ((LogUtil)object4).i("\u5355\u4e2a\u5305\u7684\u5e7f\u64ad\uff0c\u5c06\u6570\u636e\u52a0\u5165\u5f85\u53d1\u5e7f\u64ad\u7f13\u5b58\u5373\u53ef");
            DataTransformUtil.INSTANCE.print(CollectionsKt.toByteArray((Collection)object3));
            dataAdvertisTool.addAdvData(CollectionsKt.toByteArray((Collection)object3));
            mAdvTotalNum = 1;
            list.clear();
            object3.clear();
        } else {
            int n3 = 0;
            object4 = ArraysKt.toMutableList((byte[])byArray);
            mAdvTotalNum = 0;
            while (CollectionsKt.toByteArray((Collection)object4).length > 22) {
                Object object6 = object4;
                object3.add((byte)-18);
                object3.add(by);
                object3.add((byte)(n3 << 0 | 0x10));
                List list = ArraysKt.toMutableList((byte[])object);
                Object object7 = object3;
                list.addAll(ArraysKt.toMutableList((byte[])CollectionsKt.toByteArray((Collection)CollectionsKt.take((Iterable)object4, (int)22))));
                object4 = super.foundEncodeKey(CollectionsKt.toByteArray((Collection)object3));
                object7.addAll(ArraysKt.toMutableList((byte[])super.dataEncode((byte[])object4, CollectionsKt.toByteArray((Collection)list))));
                super.addAdvData(CollectionsKt.toByteArray((Collection)object7));
                ++mAdvTotalNum;
                object3.clear();
                list.clear();
                object4 = CollectionsKt.toMutableList((Collection)CollectionsKt.drop((Iterable)object6, (int)22));
                n3 = n3 == 15 ? 0 : ++n3;
                LogUtil.INSTANCE.i(Intrinsics.stringPlus((String)"advIndex is ", (Object)n3));
            }
            object3.add((byte)-18);
            object3.add(by);
            object3.add((byte)(n3 << 0 | 0));
            object = ArraysKt.toMutableList((byte[])object);
            Object object8 = object2;
            Object object9 = object3;
            Object object10 = object2;
            object.addAll(ArraysKt.toMutableList((byte[])CollectionsKt.toByteArray((Collection)CollectionsKt.take((Iterable)object4, (int)22))));
            object2 = super.foundEncodeKey(CollectionsKt.toByteArray((Collection)object3));
            object9.addAll(ArraysKt.toMutableList((byte[])super.dataEncode((byte[])object2, CollectionsKt.toByteArray((Collection)object))));
            super.addAdvData(CollectionsKt.toByteArray((Collection)object9));
            ++mAdvTotalNum;
            object3.clear();
            object.clear();
        }
    }

    private final void finalStartAdvertise(int n2, byte[] object, int n3) {
        if (mIsStopAdv) {
            LogUtil.INSTANCE.w("finalStartAdvertise\uff1astopAdv, do nothing");
            return;
        }
        DataAdvertisTool dataAdvertisTool = mBluetoothAdapter;
        if (!dataAdvertisTool.isEnabled()) {
            LogUtil.INSTANCE.e("finalStartAdvertise mBluetoothAdapter.isEnabled:" + dataAdvertisTool.isEnabled() + ", do nothing");
            return;
        }
        LogUtil logUtil = LogUtil.INSTANCE;
        DataAdvertisTool dataAdvertisTool2 = dataAdvertisTool;
        logUtil.i("finalStartAdvertise\uff1a\u53d1\u9001\u7b2c" + mRemainAdvDataIndex + "\u5305\uff0c\u5305\u5185\u5bb9\uff1a");
        DataTransformUtil.INSTANCE.print((byte[])object);
        dataAdvertisTool = new AdvertiseData.Builder().setIncludeTxPowerLevel(false).setIncludeDeviceName(false).addManufacturerData(n2, object).build();
        Intrinsics.checkNotNullExpressionValue((Object)dataAdvertisTool, (String)"Builder()\n            .setIncludeTxPowerLevel(false)\n            .setIncludeDeviceName(false)\n            //.addServiceUuid(ParcelUuid(SERVICE_UUID))\n            .addManufacturerData(manufacturerId,manufacturerSpecificData).build()");
        AdvertiseSettings advertiseSettings = new AdvertiseSettings.Builder().setAdvertiseMode(2).setTimeout(0).setConnectable(false).setTxPowerLevel(3).build();
        Intrinsics.checkNotNullExpressionValue((Object)advertiseSettings, (String)"Builder()\n            .setAdvertiseMode(AdvertiseSettings.ADVERTISE_MODE_LOW_LATENCY)\n            .setTimeout(0)\n            .setConnectable(false)\n            .setTxPowerLevel(AdvertiseSettings.ADVERTISE_TX_POWER_HIGH)\n            .build()");
        BluetoothLeAdvertiser bluetoothLeAdvertiser = dataAdvertisTool2.getBluetoothLeAdvertiser();
        object = bluetoothLeAdvertiser;
        mAdvertiser = bluetoothLeAdvertiser;
        logUtil.i(Intrinsics.stringPlus((String)"startAdvertisement: with advertiser ", (Object)object));
        if (mAdvertiseCallback == null) {
            welink_a welink_a2;
            object = (Object)welink_a2;
            welink_a2 = mAdvertiseCallback = new welink_a();
            BluetoothLeAdvertiser bluetoothLeAdvertiser2 = mAdvertiser;
            if (bluetoothLeAdvertiser2 != null) {
                bluetoothLeAdvertiser2.startAdvertising(advertiseSettings, (AdvertiseData)dataAdvertisTool, (AdvertiseCallback)object);
            }
            logUtil.i(Intrinsics.stringPlus((String)"\u5e7f\u64ad\u53d1\u9001\u5b8c\u6bd5,\u5f53\u524d\u7ebf\u7a0b\uff1a", (Object)Thread.currentThread().getName()));
        }
    }

    private final synchronized void addAdvData(byte[] byArray) {
        mRemainAdvDataMutableList.add(byArray);
    }

    private final synchronized void clearAdvData() {
        mRemainAdvDataIndex = 0;
        mRemainAdvDataMutableList.clear();
    }

    private final void stopAdvertising() {
        if (!BluetoothAdapter.getDefaultAdapter().isEnabled()) {
            LogUtil.INSTANCE.e("stopBtDiscoverable: \u84dd\u7259\u5df2\u5173\u95ed\uff01");
            return;
        }
        Object object = LogUtil.INSTANCE;
        ((LogUtil)object).i(Intrinsics.stringPlus((String)"Stopping Advertising with advertiser ", (Object)mAdvertiser));
        if (mAdvertiser != null && mAdvertiseCallback != null) {
            ((LogUtil)object).i("now stop adv finally");
            object = mAdvertiser;
            if (object != null) {
                object.stopAdvertising(mAdvertiseCallback);
            }
            mAdvertiser = null;
            mAdvertiseCallback = null;
        }
    }

    static {
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        Intrinsics.checkNotNullExpressionValue((Object)bluetoothAdapter, (String)"getDefaultAdapter()");
        mBluetoothAdapter = bluetoothAdapter;
        UUID uUID = UUID.fromString("0000FD35-0000-1000-8000-00805f9b34fb");
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(\"0000FD35-0000-1000-8000-00805f9b34fb\")");
        SERVICE_UUID = uUID;
        mPoolExist = new AtomicBoolean(false);
        mRemainAdvDataMutableList = new ArrayList<byte[]>();
    }

    public final int getMRemainAdvDataIndex() {
        return mRemainAdvDataIndex;
    }

    public final void setMRemainAdvDataIndex(int n2) {
        mRemainAdvDataIndex = n2;
    }

    public final int getMAdvTotalNum() {
        return mAdvTotalNum;
    }

    public final void setMAdvTotalNum(int n2) {
        mAdvTotalNum = n2;
    }

    @NotNull
    public final List<byte[]> getMRemainAdvDataMutableList() {
        return mRemainAdvDataMutableList;
    }

    public final void setMRemainAdvDataMutableList(@NotNull List<byte[]> list) {
        List<byte[]> list2 = list;
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        mRemainAdvDataMutableList = list2;
    }

    @Nullable
    public final ExecutorService getMPool() {
        return mPool;
    }

    public final void setMPool(@Nullable ExecutorService executorService) {
        mPool = executorService;
    }

    public final int getMTimeout() {
        return mTimeout;
    }

    public final void setMTimeout(int n2) {
        mTimeout = n2;
    }

    public final boolean getMIsStopAdv() {
        return mIsStopAdv;
    }

    public final void setMIsStopAdv(boolean bl) {
        mIsStopAdv = bl;
    }

    public final void stopAdvertiseData() {
        DataAdvertisTool dataAdvertisTool = this;
        LogUtil.INSTANCE.e("stopAdvertiseData: \u505c\u6b62\u5e7f\u64ad\uff0c\u5173\u95ed\u7ebf\u7a0b\u6c60\uff01");
        mIsStopAdv = true;
        dataAdvertisTool.shutdownPool();
        dataAdvertisTool.stopAdvertising();
        dataAdvertisTool.clearAdvertiseData();
    }

    public final void stopPhoneClonerAdvertise() {
        this.stopAdvertiseData();
    }

    public final void startPhoneClonerAdvertise(@NotNull PhoneCloneInfo object, int n2) {
        PhoneCloneInfo phoneCloneInfo = object;
        Intrinsics.checkNotNullParameter((Object)phoneCloneInfo, (String)"phoneCloneInfo");
        if (phoneCloneInfo.getSsid() != null && ((PhoneCloneInfo)object).getSsid().length() == 2) {
            LogUtil.INSTANCE.i("startPhoneClonerAdvertise\uff1atimeout is " + n2 + ", \u5f00\u59cb\u5e7f\u64ad\uff0c\u5f00\u542f\u7ebf\u7a0b\u6c60");
            ((DataAdvertisTool)object2).clearAdvertiseData();
            if (mPoolExist.compareAndSet(false, true)) {
                mPool = Executors.newSingleThreadExecutor();
            }
            byte by = 10;
            String string = ((PhoneCloneInfo)object).getSsid();
            Charset charset = Charsets.UTF_8;
            if (string != null) {
                DataAdvertisTool dataAdvertisTool = object2;
                byte[] byArray = string.getBytes(charset);
                Object object2 = byArray;
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
                object = ((PhoneCloneInfo)object).toSendCommand();
                dataAdvertisTool.startAdvertiseData(by, (byte[])object2, (byte[])object, n2);
                return;
            }
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        LogUtil.INSTANCE.e("startPhoneClonerAdvertise: phoneCloneInfo.ssid.length is not 2, return now\uff01");
    }

    public final void startP2pInfoAdvertise(@NotNull P2pInfo object, int n2) {
        P2pInfo p2pInfo = object;
        Intrinsics.checkNotNullParameter((Object)p2pInfo, (String)"p2pInfo");
        if (p2pInfo.getMacAddress() != null && ((P2pInfo)object).getMacAddress().length() == 17) {
            LogUtil.INSTANCE.i("startP2pInfoAdvertise\uff1atimeout is " + n2 + ", \u5f00\u59cb\u5e7f\u64ad\uff0c\u5f00\u542f\u7ebf\u7a0b\u6c60");
            ((DataAdvertisTool)object2).clearAdvertiseData();
            if (mPoolExist.compareAndSet(false, true)) {
                mPool = Executors.newSingleThreadExecutor();
            }
            DataAdvertisTool dataAdvertisTool = object2;
            P2pInfo p2pInfo2 = object;
            Object object2 = DataTransformUtil.INSTANCE.macStringToByteArray(((P2pInfo)object).getMacAddress());
            byte[] byArray = new byte[2];
            object = byArray;
            object[0] = object2[4];
            byArray[1] = (byte)object2[5];
            object2 = p2pInfo2.toSendCommand();
            dataAdvertisTool.startAdvertiseData((byte)8, (byte[])object, (byte[])object2, n2);
            return;
        }
        LogUtil.INSTANCE.e("startP2pInfoAdvertise: p2pInfo.macAddress.length is not 17, return now\uff01");
    }

    public final synchronized void startAdvFromRemainAdvData() {
        if (!mIsStopAdv) {
            int n2 = (UByte.constructor-impl((byte)((byte)9)) & 0xFF) << 8 | (UByte.constructor-impl((byte)((byte)66)) & 0xFF) << 0;
            LogUtil logUtil = LogUtil.INSTANCE;
            logUtil.i("still adv, before finalStartAdvertise");
            byte[] byArray = null;
            if (mRemainAdvDataMutableList.isEmpty()) {
                logUtil.w("startAdvFromRemainAdvData mRemainAdvDataMutableList is empty");
                return;
            }
            if (mRemainAdvDataIndex < mRemainAdvDataMutableList.size()) {
                logUtil.i("\u5269\u4f59\u5f85\u53d1index\u5408\u6cd5:" + mRemainAdvDataIndex + "\uff0cfinalStartAdvertise");
                try {
                    byArray = mRemainAdvDataMutableList.get(mRemainAdvDataIndex);
                }
                catch (Exception exception) {
                    LogUtil.INSTANCE.e(Intrinsics.stringPlus((String)"startAdvFromRemainAdvData error:", (Object)exception.getMessage()));
                }
            }
            if (byArray != null) {
                DataAdvertisTool dataAdvertisTool = INSTANCE;
                int n3 = dataAdvertisTool.getMTimeout();
                dataAdvertisTool.finalStartAdvertise(n2, byArray, n3);
            }
        }
    }

    public static final class welink_a
    extends AdvertiseCallback {
        public static final void welink_a() {
            DataAdvertisTool dataAdvertisTool = INSTANCE;
            if (!dataAdvertisTool.getMIsStopAdv()) {
                if (dataAdvertisTool.getMRemainAdvDataIndex() == dataAdvertisTool.getMAdvTotalNum() - 1) {
                    dataAdvertisTool.setMRemainAdvDataIndex(0);
                } else {
                    DataAdvertisTool dataAdvertisTool2 = dataAdvertisTool;
                    dataAdvertisTool2.setMRemainAdvDataIndex(dataAdvertisTool2.getMRemainAdvDataIndex() + 1);
                }
                LogUtil logUtil = LogUtil.INSTANCE;
                logUtil.i("Thread " + Thread.currentThread().getName() + ", Thread.sleep " + dataAdvertisTool.getMTimeout() + " ms");
                Thread.sleep(dataAdvertisTool.getMTimeout());
                logUtil.i("after Thread.sleep " + dataAdvertisTool.getMTimeout() + " ms");
                int n2 = dataAdvertisTool.getMTimeout() > 100 ? 50 : dataAdvertisTool.getMTimeout() + 13;
                DataAdvertisTool dataAdvertisTool3 = dataAdvertisTool;
                DataAdvertisTool dataAdvertisTool4 = dataAdvertisTool;
                dataAdvertisTool4.setMTimeout(n2);
                logUtil.i(Intrinsics.stringPlus((String)"stop adv after mTimeout: ", (Object)dataAdvertisTool4.getMTimeout()));
                dataAdvertisTool3.stopAdvertising();
                logUtil.i(Intrinsics.stringPlus((String)"start next adv after mTimeout, mRemainAdvDataIndex is ", (Object)dataAdvertisTool3.getMRemainAdvDataIndex()));
                dataAdvertisTool.startAdvFromRemainAdvData();
            } else {
                dataAdvertisTool.stopPhoneClonerAdvertise();
            }
            LogUtil.INSTANCE.i("Advertising start successfully");
        }

        public void onStartFailure(int n2) {
            super.onStartFailure(n2);
            LogUtil.INSTANCE.e("Advertising start failed");
        }

        public void onStartSuccess(@NotNull AdvertiseSettings advertiseSettings) {
            AdvertiseSettings advertiseSettings2 = advertiseSettings;
            Intrinsics.checkNotNullParameter((Object)advertiseSettings2, (String)"settingsInEffect");
            super.onStartSuccess(advertiseSettings2);
            if (!mPoolExist.get()) {
                LogUtil.INSTANCE.e(Intrinsics.stringPlus((String)"mPoolExist is :", (Object)mPoolExist.get()));
                return;
            }
            ExecutorService executorService = INSTANCE.getMPool();
            if (executorService != null) {
                executorService.execute(welink_a::welink_a);
            }
        }
    }
}

