/*
 * Decompiled with CFR 0.152.
 */
package com.welink.protocol.ble;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import androidx.annotation.RequiresApi;
import com.welink.protocol.model.P2pInfo;
import com.welink.protocol.model.PhoneCloneInfo;
import com.welink.protocol.utils.DataTransformUtil;
import com.welink.protocol.utils.LogUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.ExperimentalUnsignedTypes;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0095\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001P\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b^\u0010\bJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\t\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\t\u0010\bJ\u0017\u0010\u000b\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u000b\u0010\u0006J\u0017\u0010\u000e\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001f\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0019\u0010\u0016\u001a\u00020\u00042\b\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J2\u0010\u001e\u001a\u00020\u00042!\u0010\u001d\u001a\u001d\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u00040\u0018H\u0007\u00a2\u0006\u0004\b\u001e\u0010\u001fJ2\u0010\"\u001a\u00020\u00042!\u0010\u001d\u001a\u001d\u0012\u0013\u0012\u00110 \u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(!\u0012\u0004\u0012\u00020\u00040\u0018H\u0007\u00a2\u0006\u0004\b\"\u0010\u001fJ\r\u0010#\u001a\u00020\u0004\u00a2\u0006\u0004\b#\u0010\bJ\r\u0010$\u001a\u00020\u0004\u00a2\u0006\u0004\b$\u0010\bJ\r\u0010%\u001a\u00020\u0004\u00a2\u0006\u0004\b%\u0010\bR(\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020&8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R(\u0010-\u001a\b\u0012\u0004\u0012\u00020\f0&8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b-\u0010(\u001a\u0004\b.\u0010*\"\u0004\b/\u0010,R\u0016\u00100\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b0\u00101R\u0016\u00103\u001a\u0002028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b3\u00104R\"\u00105\u001a\u0002028\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b5\u00104\u001a\u0004\b6\u00107\"\u0004\b8\u00109R\u0016\u0010:\u001a\u0002028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b:\u00104R\u0016\u0010<\u001a\u00020;8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b<\u0010=R\u0016\u0010>\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b>\u00101R\u0016\u0010?\u001a\u0002028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b?\u00104R3\u0010@\u001a\u001f\u0012\u0013\u0012\u00110 \u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(!\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b@\u0010AR\u0016\u0010B\u001a\u00020\f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bB\u0010CR3\u0010D\u001a\u001f\u0012\u0013\u0012\u00110\u0019\u00a2\u0006\f\b\u001a\u0012\b\b\u001b\u0012\u0004\b\b(\u001c\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00188\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bD\u0010AR\u0016\u0010F\u001a\u00020E8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bF\u0010GR\u0016\u0010H\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\bH\u00101R\u0016\u0010I\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\bI\u00101R\u0016\u0010K\u001a\u00020J8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bK\u0010LR\u0016\u0010N\u001a\u00020M8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bN\u0010OR\u0016\u0010Q\u001a\u00020P8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bQ\u0010RR&\u0010V\u001a\u0012\u0012\u0004\u0012\u00020T0Sj\b\u0012\u0004\u0012\u00020T`U8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bV\u0010WR\u0016\u0010Y\u001a\u00020X8\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\bY\u0010ZR\u0018\u0010\\\u001a\u0004\u0018\u00010[8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\\\u0010]\u00a8\u0006_"}, d2={"Lcom/welink/protocol/ble/DataBleScanTool;", "", "", "functionCode", "", "startScanData", "(B)V", "analysisPhoneCloneInfo", "()V", "analysisP2pInfo", "funcCode", "analysisCompleteDataBuf", "", "suffix", "foundDecodeKey", "([B)[B", "key", "data", "dataDecode", "([B[B)[B", "Landroid/bluetooth/le/ScanResult;", "result", "analysisScanResult", "(Landroid/bluetooth/le/ScanResult;)V", "Lkotlin/Function1;", "Lcom/welink/protocol/model/PhoneCloneInfo;", "Lkotlin/ParameterName;", "name", "phoneCloneInfo", "scanResultCallBack", "startScanPhoneCloneInfoData", "(Lkotlin/jvm/functions/Function1;)V", "Lcom/welink/protocol/model/P2pInfo;", "p2pInfo", "startScanP2pInfoData", "stopScanPhoneCloneInfoData", "clearScanResultBuf", "stopScanData", "", "mDataMutableList", "Ljava/util/List;", "getMDataMutableList", "()Ljava/util/List;", "setMDataMutableList", "(Ljava/util/List;)V", "mDataByteArrayMutableList", "getMDataByteArrayMutableList", "setMDataByteArrayMutableList", "mFunctionCode", "B", "", "DATA_HEAD_SIZE", "I", "mLastAdvIndex", "getMLastAdvIndex", "()I", "setMLastAdvIndex", "(I)V", "P2P_INFO_MIN_SIZE", "", "mIsAdvIDStore", "Z", "GET_P2P_INFO", "PHONE_CLONER_MIN_SIZE", "mP2pInfoScanCallback", "Lkotlin/jvm/functions/Function1;", "mAdvID", "[B", "mPhoneCloneInfoScanCallback", "Ljava/util/UUID;", "SERVICE_UUID", "Ljava/util/UUID;", "GET_PHONE_CLONE_INFO", "HEADER_IDENTIFY", "Landroid/bluetooth/le/ScanFilter$Builder;", "mScanFilterBuilder", "Landroid/bluetooth/le/ScanFilter$Builder;", "Landroid/bluetooth/BluetoothAdapter;", "mBluetoothAdapter", "Landroid/bluetooth/BluetoothAdapter;", "com/welink/protocol/ble/DataBleScanTool$welink_a", "mScanCallback", "Lcom/welink/protocol/ble/DataBleScanTool$welink_a;", "Ljava/util/ArrayList;", "Landroid/bluetooth/le/ScanFilter;", "Lkotlin/collections/ArrayList;", "mFilterList", "Ljava/util/ArrayList;", "", "DECODE_KEY_PREFIX", "Ljava/lang/String;", "Landroid/bluetooth/le/BluetoothLeScanner;", "mBluetoothScanner", "Landroid/bluetooth/le/BluetoothLeScanner;", "<init>", "welinkSDK_release"})
@ExperimentalUnsignedTypes
public final class DataBleScanTool {
    @NotNull
    public static final DataBleScanTool INSTANCE = new DataBleScanTool();
    @NotNull
    private static final ArrayList<ScanFilter> mFilterList = new ArrayList();
    private static byte mFunctionCode;
    private static boolean mIsAdvIDStore;
    @NotNull
    private static byte[] mAdvID;
    @NotNull
    private static final BluetoothAdapter mBluetoothAdapter;
    private static final byte GET_PHONE_CLONE_INFO = 10;
    private static final byte GET_P2P_INFO = 8;
    private static final int DATA_HEAD_SIZE = 3;
    private static final byte HEADER_IDENTIFY = -18;
    private static final int PHONE_CLONER_MIN_SIZE = 8;
    private static final int P2P_INFO_MIN_SIZE = 13;
    @NotNull
    private static final String DECODE_KEY_PREFIX = "TRANSSION";
    @Nullable
    private static BluetoothLeScanner mBluetoothScanner;
    @Nullable
    private static Function1<? super PhoneCloneInfo, Unit> mPhoneCloneInfoScanCallback;
    @Nullable
    private static Function1<? super P2pInfo, Unit> mP2pInfoScanCallback;
    @NotNull
    private static final UUID SERVICE_UUID;
    @NotNull
    private static List<Byte> mDataMutableList;
    @NotNull
    private static List<byte[]> mDataByteArrayMutableList;
    private static int mLastAdvIndex;
    @NotNull
    private static final ScanFilter.Builder mScanFilterBuilder;
    @NotNull
    private static final welink_a mScanCallback;

    private DataBleScanTool() {
    }

    @RequiresApi(value=26)
    private final void startScanData(byte by) {
        BluetoothLeScanner bluetoothLeScanner;
        mIsAdvIDStore = false;
        mAdvID = new byte[]{0, 0};
        mDataMutableList.clear();
        mDataByteArrayMutableList.clear();
        mFunctionCode = by;
        ArrayList<ScanFilter> arrayList = mFilterList;
        arrayList.add(mScanFilterBuilder.build());
        LogUtil.INSTANCE.i("startScanAndConnect: now start scan in sticky mode......");
        mBluetoothScanner = bluetoothLeScanner = mBluetoothAdapter.getBluetoothLeScanner();
        if (bluetoothLeScanner != null) {
            bluetoothLeScanner.startScan((List)arrayList, new ScanSettings.Builder().setScanMode(2).build(), (ScanCallback)mScanCallback);
        }
    }

    private final void analysisPhoneCloneInfo() {
        PhoneCloneInfo phoneCloneInfo;
        if (mDataMutableList.size() < 8) {
            LogUtil.INSTANCE.i("analysisPhoneCloner: mDataMutableList.size: " + mDataMutableList.size() + " is wrong");
            return;
        }
        Function1<? super PhoneCloneInfo, Unit> function1 = DataTransformUtil.INSTANCE;
        String string = function1.toASCIIString(mAdvID);
        int n2 = UByte.constructor-impl((byte)((Number)mDataMutableList.get(0)).byteValue()) & 0xFF;
        boolean bl = ((Number)mDataMutableList.get(1)).byteValue() == 1;
        int n3 = UByte.constructor-impl((byte)((Number)mDataMutableList.get(2)).byteValue()) & 0xFF;
        int n4 = UByte.constructor-impl((byte)((Number)mDataMutableList.get(3)).byteValue()) & 0xFF;
        int n5 = UByte.constructor-impl((byte)((Number)mDataMutableList.get(4)).byteValue()) & 0xFF;
        int n6 = UByte.constructor-impl((byte)((Number)mDataMutableList.get(5)).byteValue()) & 0xFF;
        int n7 = UByte.constructor-impl((byte)((Number)mDataMutableList.get(6)).byteValue()) & 0xFF;
        int n8 = UByte.constructor-impl((byte)((Number)mDataMutableList.get(7)).byteValue()) & 0xFF;
        n6 = (n5 += 8) + n6;
        n7 = n6 + n7;
        n8 = n7 + n8;
        if (mDataMutableList.size() < n8) {
            LogUtil.INSTANCE.i("analysisPhoneCloner: mDataMutableList.size: " + mDataMutableList.size() + " is not whole size: " + n8 + ", error");
            return;
        }
        Function1<? super PhoneCloneInfo, Unit> function12 = function1;
        function1 = function12.toASCIIString(CollectionsKt.toByteArray(mDataMutableList.subList(8, n5)));
        String string2 = function12.toASCIIString(CollectionsKt.toByteArray(mDataMutableList.subList(n5, n6)));
        String string3 = function12.toASCIIString(CollectionsKt.toByteArray(mDataMutableList.subList(n6, n7)));
        String string4 = function12.toASCIIString(CollectionsKt.toByteArray(mDataMutableList.subList(n7, n8)));
        PhoneCloneInfo phoneCloneInfo2 = phoneCloneInfo;
        phoneCloneInfo = new PhoneCloneInfo(n2, bl, n3, n4, (String)function1, string2, string3, string, string4);
        mDataMutableList.clear();
        mDataByteArrayMutableList.clear();
        mIsAdvIDStore = false;
        DataBleScanTool.mAdvID[0] = 0;
        DataBleScanTool.mAdvID[1] = 0;
        mLastAdvIndex = 0;
        LogUtil.INSTANCE.i("\u89e3\u6790\u5b8c\u6bd5\uff0cphoneCloneInfo: " + phoneCloneInfo2 + " , \u56de\u8c03\u7ed9\u4e0a\u5c42\uff0c\u7136\u540e\u505c\u6b62\u626b\u63cf");
        function1 = mPhoneCloneInfoScanCallback;
        if (function1 != null && function1 != null) {
            function1.invoke((Object)phoneCloneInfo2);
        }
    }

    private final void analysisP2pInfo() {
        if (mDataMutableList.size() < 13) {
            LogUtil.INSTANCE.i("analysisP2pInfo: mDataMutableList.size: " + mDataMutableList.size() + " is wrong");
            return;
        }
        boolean bl = ((Number)mDataMutableList.get(0)).byteValue() == 1;
        StringBuilder stringBuilder = new StringBuilder();
        String string = String.format("%02x", Arrays.copyOf(new Object[]{mDataMutableList.get(1)}, 1));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(format, *args)");
        StringBuilder stringBuilder2 = stringBuilder.append(string).append(':');
        String string2 = String.format("%02x", Arrays.copyOf(new Object[]{mDataMutableList.get(2)}, 1));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
        StringBuilder stringBuilder3 = stringBuilder2.append(string2).append(':');
        String string3 = String.format("%02x", Arrays.copyOf(new Object[]{mDataMutableList.get(3)}, 1));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
        StringBuilder stringBuilder4 = stringBuilder3.append(string3).append(':');
        String string4 = String.format("%02x", Arrays.copyOf(new Object[]{mDataMutableList.get(4)}, 1));
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
        StringBuilder stringBuilder5 = stringBuilder4.append(string4).append(':');
        String string5 = String.format("%02x", Arrays.copyOf(new Object[]{mDataMutableList.get(5)}, 1));
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(format, *args)");
        StringBuilder stringBuilder6 = stringBuilder5.append(string5).append(':');
        String string6 = String.format("%02x", Arrays.copyOf(new Object[]{mDataMutableList.get(6)}, 1));
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"java.lang.String.format(format, *args)");
        Function1<? super P2pInfo, Unit> function1 = stringBuilder6.append(string6).toString();
        int n2 = (UByte.constructor-impl((byte)((Number)mDataMutableList.get(11)).byteValue()) & 0xFF) << 8 | (UByte.constructor-impl((byte)((Number)mDataMutableList.get(12)).byteValue()) & 0xFF) << 0;
        Object object = new P2pInfo(bl, (String)function1, "" + (UByte.constructor-impl((byte)((Number)mDataMutableList.get(7)).byteValue()) & 0xFF) + '.' + (UByte.constructor-impl((byte)((Number)mDataMutableList.get(8)).byteValue()) & 0xFF) + '.' + (UByte.constructor-impl((byte)((Number)mDataMutableList.get(9)).byteValue()) & 0xFF) + '.' + (UByte.constructor-impl((byte)((Number)mDataMutableList.get(10)).byteValue()) & 0xFF), n2);
        mDataMutableList.clear();
        mDataByteArrayMutableList.clear();
        mIsAdvIDStore = false;
        mAdvID = new byte[]{0, 0};
        mLastAdvIndex = 0;
        LogUtil.INSTANCE.i("\u89e3\u6790\u5b8c\u6bd5\uff0cp2pInfo: " + object + " , \u56de\u8c03\u7ed9\u4e0a\u5c42\uff0c\u7136\u540e\u505c\u6b62\u626b\u63cf");
        function1 = mP2pInfoScanCallback;
        if (function1 != null && function1 != null) {
            function1.invoke(object);
        }
    }

    private final void analysisCompleteDataBuf(byte by) {
        if (by == 10) {
            this.analysisPhoneCloneInfo();
        } else if (by == 8) {
            this.analysisP2pInfo();
        } else {
            LogUtil.INSTANCE.i(Intrinsics.stringPlus((String)"This protocol is not support the function code : ", (Object)by));
        }
    }

    private final byte[] foundDecodeKey(byte[] byArray) {
        byte[] byArray2 = DECODE_KEY_PREFIX.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"(this as java.lang.String).getBytes(charset)");
        List list = ArraysKt.toMutableList((byte[])byArray2);
        list.addAll(ArraysKt.toMutableList((byte[])byArray));
        return CollectionsKt.toByteArray((Collection)list);
    }

    private final byte[] dataDecode(byte[] byArray, byte[] byArray2) {
        Object object = new byte[byArray2.length];
        int n2 = 0;
        int n3 = byArray2.length + -1;
        if (n3 >= 0) {
            while (true) {
                int n4 = n2 + 1;
                object[n2] = (byte)(byArray2[n2] ^ byArray[n2 % byArray.length]);
                if (n4 > n3) break;
                n2 = n4;
            }
        }
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final void analysisScanResult(ScanResult scanResult) {
        block16: {
            Object object;
            block19: {
                block18: {
                    void var3_13;
                    int n2;
                    byte[] byArray;
                    block17: {
                        int n3;
                        if (scanResult == null) {
                            return;
                        }
                        int n4 = (UByte.constructor-impl((byte)((byte)9)) & 0xFF) << 8 | (UByte.constructor-impl((byte)((byte)66)) & 0xFF) << 0;
                        Object object2 = scanResult.getScanRecord();
                        object = object2 == null ? null : object2.getManufacturerSpecificData(n4);
                        if (object == null || ((byte[])object).length <= 5 || object[0] != -18) break block16;
                        object2 = LogUtil.INSTANCE;
                        ((LogUtil)object2).i("manufacturerData is :");
                        DataTransformUtil object3 = DataTransformUtil.INSTANCE;
                        object3.print((byte[])object);
                        byArray = this.foundDecodeKey(CollectionsKt.toByteArray((Collection)ArraysKt.take((byte[])object, (int)3)));
                        byArray = this.dataDecode(byArray, CollectionsKt.toByteArray((Collection)ArraysKt.drop((byte[])object, (int)3)));
                        ((LogUtil)object2).i("mAdvID is " + object3.toASCIIString(mAdvID) + ", decodedManuData is :");
                        object3.print(byArray);
                        if (mIsAdvIDStore) {
                            byte[] n32 = mAdvID;
                            if (mAdvID[0] != byArray[0] || n32[1] != byArray[1]) {
                                ((LogUtil)object2).i("analysisScanResult: not our package, ignore it");
                                return;
                            }
                        }
                        if ((n3 = UByte.constructor-impl((byte)object[1]) & 0xFF) != (UByte.constructor-impl((byte)mFunctionCode) & 0xFF)) {
                            ((LogUtil)object2).i("funcCode: " + n3 + ",mFunctionCode: " + mFunctionCode + ",\u4e0d\u662f\u76ee\u6807\u529f\u80fd\u7801\u7684\u5305\uff0c\u4e0d\u5904\u7406");
                            return;
                        }
                        if (((UByte.constructor-impl((byte)object[2]) & 0xFF) >> 4 & 1) == 0) {
                            boolean bl = true;
                        } else {
                            boolean bl = false;
                        }
                        n2 = UByte.constructor-impl((byte)object[2]) & 0xFF & 0xF;
                        ((LogUtil)object2).i("\u89e3\u6790\u540e\u7684isCompleteData: " + (boolean)var3_13 + ", advIndex: " + n2);
                        if (n2 != 0 || var3_13 == false) break block17;
                        ((LogUtil)object2).i("this is a single complete adv, now analysis it directly");
                        mDataMutableList.addAll(CollectionsKt.toMutableList((Collection)ArraysKt.drop((byte[])byArray, (int)2)));
                        DataBleScanTool.mAdvID[0] = byArray[0];
                        DataBleScanTool.mAdvID[1] = byArray[1];
                        this.analysisCompleteDataBuf(mFunctionCode);
                        break block18;
                    }
                    int n5 = 0;
                    int n4 = mDataByteArrayMutableList.size() + -1;
                    if (n4 >= 0) {
                        while (true) {
                            int n6 = n5 + 1;
                            if (n2 == (UByte.constructor-impl((byte)mDataByteArrayMutableList.get(n5)[2]) & 0xFF & 0xF)) {
                                LogUtil.INSTANCE.i("\u6b64\u5305\u5b58\u50a8\u8fc7\uff0c\u5ffd\u7565");
                                return;
                            }
                            if (n6 > n4) break;
                            n5 = n6;
                        }
                    }
                    mDataByteArrayMutableList.add((byte[])object);
                    mIsAdvIDStore = true;
                    DataBleScanTool.mAdvID[0] = byArray[0];
                    DataBleScanTool.mAdvID[1] = byArray[1];
                    LogUtil logUtil = LogUtil.INSTANCE;
                    object = logUtil;
                    logUtil.i(Intrinsics.stringPlus((String)"\u5b58\u50a8advID: ", (Object)DataTransformUtil.INSTANCE.toASCIIString(mAdvID)));
                    if (var3_13 != false) {
                        mLastAdvIndex = n2;
                    }
                    object.i(Intrinsics.stringPlus((String)"mDataByteArrayMutableList.size is ", (Object)mDataByteArrayMutableList.size()));
                    if (mLastAdvIndex == 0) {
                        object.i("\u8fd8\u6ca1\u62ff\u5230\u603b\u5305\u4e2a\u6570\uff0c\u5373\u6ca1\u6536\u5230\u6700\u540e\u4e00\u4e2a\u5305\uff0c\u6240\u4ee5\u6682\u65f6\u4e0d\u505a\u5176\u4ed6\u5904\u7406");
                        return;
                    }
                    if (mDataByteArrayMutableList.size() != mLastAdvIndex + 1) break block19;
                    object.i("\u7f13\u5b58\u7684\u5305\u5927\u5c0f\u5df2\u7ecf\u662f\u5b8c\u6574\u7684\u4e86\uff0c\u73b0\u5728\u5f00\u59cb\u7ec4\u5305");
                    int n8 = 0;
                    n5 = 0;
                    while (n5 < mDataByteArrayMutableList.size() && n8 < mDataByteArrayMutableList.size()) {
                        if (n8 == (UByte.constructor-impl((byte)mDataByteArrayMutableList.get(n5)[2]) & 0xFF & 0xF)) {
                            DataBleScanTool dataBleScanTool = this;
                            mDataMutableList.addAll(CollectionsKt.toMutableList((Collection)ArraysKt.drop((byte[])dataBleScanTool.dataDecode(dataBleScanTool.foundDecodeKey(CollectionsKt.toByteArray((Collection)ArraysKt.take((byte[])mDataByteArrayMutableList.get(n5), (int)3))), CollectionsKt.toByteArray((Collection)ArraysKt.drop((byte[])mDataByteArrayMutableList.get(n5), (int)3))), (int)2)));
                            ++n8;
                            n5 = 0;
                            continue;
                        }
                        ++n5;
                    }
                    LogUtil.INSTANCE.i("all\uff1a\u7ec4\u5305\u540e\u7684\u5b8c\u6574\u6570\u636emDataMutableList\u662f\uff1a");
                    DataTransformUtil.INSTANCE.print(CollectionsKt.toByteArray(mDataMutableList));
                    this.analysisCompleteDataBuf(mFunctionCode);
                }
                return;
            }
            object.i("\u7f13\u5b58\u7684\u5305\u5927\u5c0f\u4e0d\u5b8c\u6574\uff0c\u7ee7\u7eed\u7b49\u5f85\u4e0b\u4e2a\u5305");
            return;
        }
    }

    static {
        mAdvID = new byte[]{0, 0};
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        Intrinsics.checkNotNullExpressionValue((Object)bluetoothAdapter, (String)"getDefaultAdapter()");
        mBluetoothAdapter = bluetoothAdapter;
        UUID uUID = UUID.fromString("0000FD35-0000-1000-8000-00805f9b34fb");
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(\"0000FD35-0000-1000-8000-00805f9b34fb\")");
        SERVICE_UUID = uUID;
        mDataMutableList = new ArrayList<Byte>();
        mDataByteArrayMutableList = new ArrayList<byte[]>();
        mScanFilterBuilder = new ScanFilter.Builder();
        mScanCallback = new ScanCallback(){

            public void onScanResult(int n2, @Nullable ScanResult scanResult) {
                super.onScanResult(n2, scanResult);
                INSTANCE.analysisScanResult(scanResult);
            }

            public void onBatchScanResults(@Nullable List<ScanResult> list) {
                super.onBatchScanResults(list);
                if (list != null) {
                    Iterator<ScanResult> iterator = list.iterator();
                    while (iterator.hasNext()) {
                        ScanResult cfr_ignored_0 = (ScanResult)iterator.next();
                    }
                }
            }

            public void onScanFailed(int n2) {
                super.onScanFailed(n2);
                LogUtil.INSTANCE.e(Intrinsics.stringPlus((String)"onScanFailed errorCode:", (Object)n2));
            }
        };
    }

    @NotNull
    public final List<Byte> getMDataMutableList() {
        return mDataMutableList;
    }

    public final void setMDataMutableList(@NotNull List<Byte> list) {
        List<Byte> list2 = list;
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        mDataMutableList = list2;
    }

    @NotNull
    public final List<byte[]> getMDataByteArrayMutableList() {
        return mDataByteArrayMutableList;
    }

    public final void setMDataByteArrayMutableList(@NotNull List<byte[]> list) {
        List<byte[]> list2 = list;
        Intrinsics.checkNotNullParameter(list2, (String)"<set-?>");
        mDataByteArrayMutableList = list2;
    }

    public final int getMLastAdvIndex() {
        return mLastAdvIndex;
    }

    public final void setMLastAdvIndex(int n2) {
        mLastAdvIndex = n2;
    }

    @RequiresApi(value=26)
    public final void startScanPhoneCloneInfoData(@NotNull Function1<? super PhoneCloneInfo, Unit> function1) {
        Function1<? super PhoneCloneInfo, Unit> function12 = function1;
        Intrinsics.checkNotNullParameter(function12, (String)"scanResultCallBack");
        mPhoneCloneInfoScanCallback = function12;
        this.startScanData((byte)10);
    }

    @RequiresApi(value=26)
    public final void startScanP2pInfoData(@NotNull Function1<? super P2pInfo, Unit> function1) {
        Function1<? super P2pInfo, Unit> function12 = function1;
        Intrinsics.checkNotNullParameter(function12, (String)"scanResultCallBack");
        mP2pInfoScanCallback = function12;
        this.startScanData((byte)8);
    }

    public final void stopScanPhoneCloneInfoData() {
        this.stopScanData();
    }

    public final void clearScanResultBuf() {
        LogUtil.INSTANCE.i("now clearScanResultBuf....");
        mDataMutableList.clear();
        mDataByteArrayMutableList.clear();
        mFunctionCode = 0;
        mIsAdvIDStore = false;
        mAdvID = new byte[]{0, 0};
        mLastAdvIndex = 0;
        mPhoneCloneInfoScanCallback = null;
        mP2pInfoScanCallback = null;
        mBluetoothScanner = null;
    }

    public final void stopScanData() {
        BluetoothAdapter bluetoothAdapter = mBluetoothAdapter;
        if (bluetoothAdapter == null) {
            LogUtil.INSTANCE.e("stopScan: mBluetoothAdapter\u4e3anull\uff0c\u672c\u673a\u53ef\u80fd\u4e0d\u652f\u6301\u84dd\u7259");
            return;
        }
        if (!bluetoothAdapter.isEnabled()) {
            LogUtil.INSTANCE.e("stopScan: \u84dd\u7259\u6ca1\u5f00\uff0c\u5565\u90fd\u4e0d\u505a");
            return;
        }
        if (mBluetoothScanner != null) {
            LogUtil.INSTANCE.i("now stop ble scan....");
            bluetoothAdapter = mBluetoothScanner;
            if (bluetoothAdapter != null) {
                bluetoothAdapter.stopScan((ScanCallback)mScanCallback);
            }
        }
        this.clearScanResultBuf();
    }
}

