/*
 * Decompiled with CFR 0.152.
 */
package com.welink.protocol.nfbd;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.wifi.WifiManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Parcelable;
import android.os.PowerManager;
import android.provider.Settings;
import androidx.annotation.RequiresApi;
import com.transsion.kolun.kolunscanner.KolunScannerManager;
import com.welink.protocol.ble.AdvertiseTool;
import com.welink.protocol.ble.BleScanFilter;
import com.welink.protocol.ble.BleScanTool;
import com.welink.protocol.event.OnStatusChangeListener;
import com.welink.protocol.model.BloodOxygen;
import com.welink.protocol.model.BloodPressure;
import com.welink.protocol.model.PhoneCloneInfo;
import com.welink.protocol.model.Support5GAndMac;
import com.welink.protocol.model.WifiInfo;
import com.welink.protocol.nfbd.ScreenStateService;
import com.welink.protocol.nfbd.TranFileTransferController;
import com.welink.protocol.nfbd.TranGattServicerManager;
import com.welink.protocol.nfbd.TranProfileService;
import com.welink.protocol.nfbd.TranssionBleFactory;
import com.welink.protocol.utils.DataTransformUtil;
import com.welink.protocol.utils.DeviceInfo;
import com.welink.protocol.utils.LogUtil;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0093\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007*\u0001<\u0018\u0000 \\2\u00020\u0001:\u0002\\]B\u0007\u00a2\u0006\u0004\b[\u0010\tJ\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0017\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u000f\u0010\n\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\n\u0010\tJ\u000f\u0010\u000b\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u000b\u0010\tJ\u000f\u0010\f\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\f\u0010\tJ\u0019\u0010\u000f\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0011\u0010\tJ\u000f\u0010\u0012\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0012\u0010\tJ\u000f\u0010\u0013\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0013\u0010\tJ\u000f\u0010\u0014\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0014\u0010\tJ)\u0010\u0019\u001a\u00020\u00022\b\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0002H\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u000f\u0010\u001b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u001b\u0010\tJ\u0019\u0010\u001d\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0019\u0010 \u001a\u00020\u001f2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u0016\u00a2\u0006\u0004\b \u0010!J\u0017\u0010\"\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\"\u0010\u0006J\u0017\u0010#\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b#\u0010\u0006R\u0016\u0010$\u001a\u00020\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0016\u0010&\u001a\u00020\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010%R\u0016\u0010'\u001a\u00020\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b'\u0010%RV\u00100\u001a6\u0012\u0013\u0012\u00110)\u00a2\u0006\f\b*\u0012\b\b+\u0012\u0004\b\b(,\u0012\u0013\u0012\u00110-\u00a2\u0006\f\b*\u0012\b\b+\u0012\u0004\b\b(.\u0012\u0004\u0012\u00020\u00040(j\u0002`/8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b0\u00101\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u0018\u00107\u001a\u0004\u0018\u0001068\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b7\u00108R\u0016\u00109\u001a\u00020\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b9\u0010%R\u0018\u0010:\u001a\u0004\u0018\u00010\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b:\u0010;R\u0016\u0010=\u001a\u00020<8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b=\u0010>R\u001c\u0010@\u001a\b\u0018\u00010?R\u00020\u00008\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b@\u0010AR\u0016\u0010B\u001a\u00020\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bB\u0010%R\u0016\u0010C\u001a\u00020\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bC\u0010%R\u0018\u0010D\u001a\u0004\u0018\u00010\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bD\u0010;R\u0016\u0010F\u001a\u00020E8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bF\u0010GR\u0018\u0010I\u001a\u0004\u0018\u00010H8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bI\u0010JR\u0016\u0010K\u001a\u00020\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bK\u0010%R\u0016\u0010L\u001a\u00020\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bL\u0010%R\u0018\u0010M\u001a\u0004\u0018\u00010\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bM\u0010NR\u0016\u0010O\u001a\u00020\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bO\u0010%R\u0018\u0010Q\u001a\u0004\u0018\u00010P8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bQ\u0010RR\u0016\u0010T\u001a\u00020S8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bT\u0010UR\u0016\u0010V\u001a\u00020\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bV\u0010%R\u0018\u0010X\u001a\u0004\u0018\u00010W8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bX\u0010YR\u0018\u0010Z\u001a\u0004\u0018\u00010\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bZ\u0010;\u00a8\u0006^"}, d2={"Lcom/welink/protocol/nfbd/ScreenStateService;", "Lcom/welink/protocol/nfbd/TranProfileService;", "", "value", "", "cleanup", "(I)V", "resetDevice", "startScan", "()V", "stopScan", "getDeviceName", "detectVendorPid", "", "pid", "startAdvertising", "(Ljava/lang/String;)V", "stopAdvertising", "onScreenOn", "onScreenOff", "onCreate", "Landroid/content/Intent;", "intent", "flags", "startId", "onStartCommand", "(Landroid/content/Intent;II)I", "onDestroy", "Landroid/os/IBinder;", "onBind", "(Landroid/content/Intent;)Landroid/os/IBinder;", "", "onUnbind", "(Landroid/content/Intent;)Z", "start", "stop", "mScanDisabled", "Z", "mBleAdvDisabled", "mGroupCanceled", "Lkotlin/Function2;", "Landroid/bluetooth/le/ScanResult;", "Lkotlin/ParameterName;", "name", "result", "Lcom/welink/protocol/utils/DeviceInfo;", "devinfo", "Lcom/welink/protocol/nfbd/scanCallback_t;", "mScanresLmd", "Lkotlin/jvm/functions/Function2;", "getMScanresLmd", "()Lkotlin/jvm/functions/Function2;", "setMScanresLmd", "(Lkotlin/jvm/functions/Function2;)V", "Lcom/welink/protocol/ble/BleScanTool;", "mBleScanTool", "Lcom/welink/protocol/ble/BleScanTool;", "isReceiverRegistered", "mAdapterAddress", "Ljava/lang/String;", "com/welink/protocol/nfbd/ScreenStateService$stateChangeListener$1", "stateChangeListener", "Lcom/welink/protocol/nfbd/ScreenStateService$stateChangeListener$1;", "Lcom/welink/protocol/nfbd/ScreenStateService$ScreenStateReceiver;", "mReceiver", "Lcom/welink/protocol/nfbd/ScreenStateService$ScreenStateReceiver;", "isScreenOn", "mRemoteConnectInviting", "mVendorPid", "Landroid/os/HandlerThread;", "mHandlerThread", "Landroid/os/HandlerThread;", "Landroid/os/Handler;", "mHandler", "Landroid/os/Handler;", "mLocalConnectRunning", "mBluetoothDisabled", "mSmartState", "Ljava/lang/Boolean;", "mWifiDisabled", "Lcom/welink/protocol/nfbd/TranFileTransferController;", "mFileTransferController", "Lcom/welink/protocol/nfbd/TranFileTransferController;", "Ljava/lang/Runnable;", "connectNotifyTimeout", "Ljava/lang/Runnable;", "mIsGattServer", "Lcom/welink/protocol/nfbd/TranGattServicerManager;", "mTranGattServer", "Lcom/welink/protocol/nfbd/TranGattServicerManager;", "mDeviceName", "<init>", "Companion", "ScreenStateReceiver", "welinkSDK_release"})
public final class ScreenStateService
extends TranProfileService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String TAG = "ScreenStateService";
    @NotNull
    public static final String SDKVERSION = "1.9.10-2022/08/18-09:45";
    public static final int BD_ADDR_LEN = 6;
    public static final int MIN_RSSI = -200;
    @NotNull
    public static final String MAC_STRING = "%02x:%02x:%02x:%02x:%02x:%02x";
    @NotNull
    public static final String ACTION_RECEIVE_FILE_ACCEPT = "com.welink.protocol.nfbd.action.RECEIVE_FILE_ACCEPT";
    @NotNull
    public static final String ACTION_RECEIVE_FILE_DECLINE = "com.welink.protocol.nfbd.action.RECEIVE_FILE_DECLINE";
    @NotNull
    public static final String ACTION_DISCONNECT_REMOTE_DEVICE = "com.welink.protocol.nfbd.action.DISCONNECT_REMOTE_DEVICE";
    @NotNull
    public static final String ACTION_DISCONNECT_RESET_CONN = "com.welink.protocol.nfbd.action.DISCONNECT_RESET_CONN";
    @NotNull
    public static final String ACTION_DISCONNECT_CANCEL_CONN = "com.welink.protocol.nfbd.action.DISCONNECT_CANCEL_CONN";
    @NotNull
    public static final String ACTION_UNREG_CONN_NOTIFY = "com.welink.protocol.nfbd.action.UNREG_CONN_NOTIFY";
    @NotNull
    public static final String ACTION_START_SCAN_DEVICE = "com.welink.protocol.nfbd.action.START_SCAN_DEVICE";
    @NotNull
    public static final String ACTION_STOP_SCAN_DEVICE = "com.welink.protocol.nfbd.action.STOP_SCAN_DEVICE";
    @NotNull
    public static final String ACTION_PAUSE_SCAN_DEVICE = "com.welink.protocol.nfbd.action.PAUSE_SCAN_DEVICE";
    @NotNull
    public static final String ACTION_REQUEST_CONNECT_DEVICE = "com.welink.protocol.nfbd.action.REQUEST_CONNECT_DEVICE";
    @NotNull
    public static final String ACTION_NOTIFY_CONNECT_DEVICE = "com.welink.protocol.nfbd.action.NOTIFY_CONNECT_DEVICE";
    @NotNull
    public static final String ACTION_NOTIFY_CREATE_GO = "com.welink.protocol.nfbd.action.NOTIFY_CREATE_GO";
    @NotNull
    public static final String ACTION_NOTIFY_GO_STARTED = "com.welink.protocol.nfbd.action.NOTIFY_GO_STARTED";
    @NotNull
    public static final String ACTION_NOTIFY_P2P_DISCONNECT = "com.welink.protocol.nfbd.action.NOTIFY_P2P_DISCONNECT";
    @NotNull
    public static final String ACTION_START_ADV_DEVICE = "com.welink.protocol.nfbd.action.START_ADV_DEVICE";
    @NotNull
    public static final String ACTION_STOP_ADV_DEVICE = "com.welink.protocol.nfbd.action.STOP_ADV_DEVICE";
    @NotNull
    public static final String ACTION_NOTIFY_QRSCAN_CONNECT_DEVICE = "com.welink.protocol.nfbd.action.NOTIFY_QRSCAN_CONNECT_DEVICE";
    @NotNull
    public static final String ACTION_UPDATE_CON_STATE = "com.welink.protocol.nfbd.action.ACTION_UPDATE_CON_STATE";
    @NotNull
    public static final String ACTION_REVIVE_SERVICE = "com.welink.protocol.nfbd.action.ACTION_REVIVE_SERVICE";
    @NotNull
    public static final String ACTION_ADV_PARAMS_UPDATE = "com.welink.protocol.nfbd.action.ADV_PARAMS_UPDATE";
    @NotNull
    public static final String EXTRA_RESULTS = "com.welink.protocol.nfbd.extra.RESULTS";
    @NotNull
    public static final String EXTRA_DEVINFO = "com.welink.protocol.nfbd.extra.DEVINFO";
    @NotNull
    public static final String EXTRA_SRCADDR = "com.welink.protocol.nfbd.extra.SRCADDR";
    @NotNull
    public static final String EXTRA_LOCADDR = "com.welink.protocol.nfbd.extra.LOCADDR";
    @NotNull
    public static final String EXTRA_CMDREQU = "com.welink.protocol.nfbd.extra.CMDREQU";
    @NotNull
    public static final String EXTRA_TYPE = "com.welink.protocol.nfbd.extra.type";
    @NotNull
    public static final String EXTRA_EVENT = "com.welink.protocol.nfbd.extra.event";
    @NotNull
    public static final String EXTRA_SSID = "com.welink.protocol.nfbd.extra.ssid";
    @NotNull
    public static final String EXTRA_PWD = "com.welink.protocol.nfbd.extra.pwd";
    private static final int PROFILE_SERVICE_MODE = 1;
    @Nullable
    private static ScreenStateService sService;
    private boolean mIsGattServer;
    @Nullable
    private ScreenStateReceiver mReceiver;
    private boolean isReceiverRegistered;
    private boolean isScreenOn;
    @Nullable
    private TranFileTransferController mFileTransferController;
    @Nullable
    private TranGattServicerManager mTranGattServer;
    @Nullable
    private BleScanTool mBleScanTool;
    @Nullable
    private String mAdapterAddress;
    @Nullable
    private String mVendorPid;
    @Nullable
    private String mDeviceName;
    private boolean mGroupCanceled;
    @Nullable
    private Boolean mSmartState;
    @NotNull
    private final HandlerThread mHandlerThread;
    @Nullable
    private Handler mHandler;
    private boolean mRemoteConnectInviting;
    private boolean mLocalConnectRunning;
    private boolean mBleAdvDisabled;
    private boolean mScanDisabled;
    private boolean mBluetoothDisabled;
    private boolean mWifiDisabled;
    @NotNull
    private Function2<? super ScanResult, ? super DeviceInfo, Unit> mScanresLmd;
    @NotNull
    private stateChangeListener.1 stateChangeListener;
    @NotNull
    private final Runnable connectNotifyTimeout;

    public ScreenStateService() {
        ScreenStateService screenStateService = this;
        screenStateService.mSmartState = Boolean.FALSE;
        screenStateService.mHandlerThread = new HandlerThread("ScreenStateServiceHandlerThread");
        screenStateService.mBleAdvDisabled = true;
        screenStateService.mScanDisabled = true;
        screenStateService.mScanresLmd = new Function2<ScanResult, DeviceInfo, Unit>(this){
            public final /* synthetic */ ScreenStateService this$0;
            {
                this.this$0 = screenStateService;
                super(2);
            }

            public final void invoke(@NotNull ScanResult scanResult, @NotNull DeviceInfo deviceInfo) {
                DeviceInfo deviceInfo2 = deviceInfo;
                Intrinsics.checkNotNullParameter((Object)scanResult, (String)"result");
                Intrinsics.checkNotNullParameter((Object)deviceInfo2, (String)"devInfo");
                byte by = deviceInfo2.getProductSubType();
                if (by == 10) {
                    ScanRecord scanRecord = scanResult.getScanRecord();
                    Intrinsics.checkNotNull((Object)scanRecord);
                    Object object = scanRecord.getServiceData(TranssionBleFactory.INSTANCE.getTRAN_SERVICE_UUID());
                    Object object2 = new byte[6];
                    Intrinsics.checkNotNull((Object)object);
                    System.arraycopy(object, 0, object2, 0, 6);
                    Object[] objectArray = new Object[6];
                    Object object3 = objectArray;
                    object3[0] = object2[0];
                    object3[1] = object2[1];
                    object3[2] = object2[2];
                    object3[3] = object2[3];
                    object3[4] = object2[4];
                    objectArray[5] = object2[5];
                    String string = String.format("%02x:%02x:%02x:%02x:%02x:%02x", Arrays.copyOf(objectArray, 6));
                    object2 = string;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(format, *args)");
                    object3 = TranProfileService.Companion;
                    if (((TranProfileService.Companion)object3).getShowScanResult()) {
                        LogUtil.INSTANCE.i("src add = " + (String)object2 + ", cmd= " + object[12]);
                    }
                    if (object[12] == 7) {
                        Object object4 = new byte[6];
                        System.arraycopy(object, 6, object4, 0, 6);
                        Object[] objectArray2 = new Object[6];
                        Object object5 = objectArray2;
                        object5[0] = object4[0];
                        object5[1] = object4[1];
                        object5[2] = object4[2];
                        object5[3] = object4[3];
                        object5[4] = object4[4];
                        objectArray2[5] = object4[5];
                        String string2 = String.format("%02x:%02x:%02x:%02x:%02x:%02x", Arrays.copyOf(objectArray2, 6));
                        object4 = string2;
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                        object5 = LogUtil.INSTANCE;
                        ((LogUtil)object5).i("Target addr = " + (String)object4 + ", adapter= " + ScreenStateService.access$getMAdapterAddress$p(this.this$0));
                        if (StringsKt.equals((String)ScreenStateService.access$getMAdapterAddress$p(this.this$0), (String)object4, (boolean)true) && object[12] == 7) {
                            if (((TranProfileService.Companion)object3).getShowScanResult()) {
                                ((LogUtil)object5).d("result: " + scanResult + "  devInfo: " + deviceInfo + ", notify to request");
                                ((LogUtil)object5).d(Intrinsics.stringPlus((String)"CLass name is: ", (Object)((Object)((Object)this.this$0)).getClass().getName()));
                            }
                            if (!ScreenStateService.access$getMRemoteConnectInviting$p(this.this$0) && !ScreenStateService.access$getMLocalConnectRunning$p(this.this$0)) {
                                Intent intent;
                                Object object6 = object = intent;
                                object6(this.this$0.getApplicationContext(), ((Object)((Object)this.this$0)).getClass());
                                object6.setAction("com.welink.protocol.nfbd.action.NOTIFY_CONNECT_DEVICE");
                                object6.putExtra("com.welink.protocol.nfbd.extra.RESULTS", (Parcelable)scanResult);
                                object6.putExtra("com.welink.protocol.nfbd.extra.DEVINFO", (Parcelable)deviceInfo);
                                object6.putExtra("com.welink.protocol.nfbd.extra.SRCADDR", (String)object2);
                                intent.putExtra("com.welink.protocol.nfbd.extra.LOCADDR", ScreenStateService.access$getMAdapterAddress$p(this.this$0));
                                intent.putExtra("com.welink.protocol.nfbd.extra.CMDREQU", 7);
                                this.this$0.startService((Intent)object);
                            } else {
                                ((LogUtil)object5).w("Connect is running already,");
                                if (ScreenStateService.access$getMRemoteConnectInviting$p(this.this$0)) {
                                    ((LogUtil)object5).w("Remote Invite Running Already");
                                } else if (ScreenStateService.access$getMLocalConnectRunning$p(this.this$0)) {
                                    ((LogUtil)object5).w("Local Connect Running Already");
                                }
                            }
                        }
                    } else {
                        if (((TranProfileService.Companion)object3).getShowScanResult()) {
                            LogUtil.INSTANCE.d("result: " + scanResult + "  devInfo: " + deviceInfo + ", device found event");
                        }
                        TranFileTransferController tranFileTransferController = ScreenStateService.access$getMFileTransferController$p(this.this$0);
                        object = tranFileTransferController;
                        if (tranFileTransferController != null) {
                            ((TranFileTransferController)object).onScanResult(128, ScreenStateService.access$getMAdapterAddress$p(this.this$0), (String)object2, deviceInfo, scanResult);
                        }
                        if (((TranProfileService.Companion)object3).getShowScanResult()) {
                            LogUtil.INSTANCE.d("result.device.name: " + scanResult.getDevice().getName() + "  devInfo: " + deviceInfo);
                        }
                    }
                } else if (by == 13) {
                    TranFileTransferController tranFileTransferController;
                    ScanRecord scanRecord = scanResult.getScanRecord();
                    Intrinsics.checkNotNull((Object)scanRecord);
                    byte[] byArray = scanRecord.getServiceData(TranssionBleFactory.INSTANCE.getTRAN_SERVICE_UUID());
                    Object object = new byte[6];
                    Intrinsics.checkNotNull((Object)byArray);
                    System.arraycopy(byArray, 0, object, 0, 6);
                    Object[] objectArray = new Object[6];
                    Object object7 = objectArray;
                    object7[0] = object[0];
                    object7[1] = object[1];
                    object7[2] = object[2];
                    object7[3] = object[3];
                    object7[4] = object[4];
                    objectArray[5] = object[5];
                    String string = String.format("%02x:%02x:%02x:%02x:%02x:%02x", Arrays.copyOf(objectArray, 6));
                    object = string;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(format, *args)");
                    object7 = TranProfileService.Companion;
                    if (((TranProfileService.Companion)object7).getShowScanResult()) {
                        LogUtil.INSTANCE.d("result: " + scanResult + "  devInfo: " + deviceInfo + ", device found event");
                    }
                    if ((tranFileTransferController = ScreenStateService.access$getMFileTransferController$p(this.this$0)) != null) {
                        tranFileTransferController.onScanResult(255, ScreenStateService.access$getMAdapterAddress$p(this.this$0), (String)object, deviceInfo, scanResult);
                    }
                    if (((TranProfileService.Companion)object7).getShowScanResult()) {
                        LogUtil.INSTANCE.d("result.device.name: " + scanResult.getDevice().getName() + "  devInfo: " + deviceInfo);
                    }
                } else if (TranProfileService.Companion.getShowScanResult()) {
                    LogUtil.INSTANCE.d("result: " + scanResult + "  devInfo: " + deviceInfo + ", Illegal Event");
                }
            }
        };
        screenStateService.stateChangeListener = new OnStatusChangeListener(this){
            public final /* synthetic */ ScreenStateService this$0;
            {
                this.this$0 = screenStateService;
            }

            public void statusChange(int n2) {
                switch (n2) {
                    default: {
                        break;
                    }
                    case 505: {
                        if (!ScreenStateService.access$getMGroupCanceled$p(object.this$0)) {
                            Intent intent;
                            Intent intent2 = intent;
                            new Intent(object.this$0.getApplicationContext(), stateChangeListener.1.class).setAction("com.welink.protocol.nfbd.action.NOTIFY_CREATE_GO");
                            object.this$0.startService(intent2);
                            break;
                        }
                        ScreenStateService.access$setMGroupCanceled$p(object.this$0, false);
                        break;
                    }
                    case 504: {
                        stateChangeListener.1 v1 = object;
                        ScreenStateService.access$setMGroupCanceled$p(v1.this$0, false);
                        ScreenStateService.access$setMRemoteConnectInviting$p(v1.this$0, false);
                        break;
                    }
                    case 503: {
                        TranFileTransferController tranFileTransferController = ScreenStateService.access$getMFileTransferController$p(object.this$0);
                        if (tranFileTransferController != null) {
                            tranFileTransferController.gattServerRemoteCancel();
                        }
                        ScreenStateService.access$setMGroupCanceled$p(object.this$0, true);
                        break;
                    }
                    case 502: {
                        stateChangeListener.1 v2 = object;
                        ScreenStateService.access$setMGroupCanceled$p(v2.this$0, false);
                        TranFileTransferController tranFileTransferController = ScreenStateService.access$getMFileTransferController$p(v2.this$0);
                        if (tranFileTransferController != null) {
                            tranFileTransferController.gattServerRemoteReject();
                        }
                        Object object = ScreenStateService.access$getMFileTransferController$p(object.this$0);
                        if (object == null) break;
                        ((TranFileTransferController)object).removeGroup();
                        break;
                    }
                    case 501: {
                        ScreenStateService.access$setMGroupCanceled$p(object.this$0, false);
                        LogUtil.INSTANCE.i("Remote Accept Connect Request");
                        break;
                    }
                    case 500: {
                        Object object = ScreenStateService.access$getMFileTransferController$p(object.this$0);
                        if (object == null) break;
                        ((TranFileTransferController)object).gattServerRemoteNotify();
                    }
                }
            }

            public void onRequestPortInfo(@NotNull Function2<? super Integer, ? super Integer, Unit> function2) {
                Intrinsics.checkNotNullParameter(function2, (String)"callback");
                Object object = ScreenStateService.access$getMFileTransferController$p(object2.this$0);
                object = object == null ? null : Integer.valueOf(((TranFileTransferController)object).onGetMessagePort());
                Intrinsics.checkNotNull((Object)object);
                Object object2 = ScreenStateService.access$getMFileTransferController$p(object2.this$0);
                object2 = object2 == null ? null : Integer.valueOf(((TranFileTransferController)object2).onGetDataPort());
                Intrinsics.checkNotNull((Object)object2);
                function2.invoke(object, object2);
            }

            public void statusCommandExecuteResult(byte by, int n2) {
            }

            public void onRealtimeReportBloodPressure(@NotNull BloodPressure bloodPressure) {
                Intrinsics.checkNotNullParameter((Object)bloodPressure, (String)"bloodPressure");
            }

            public void onRealtimeReportHeartRate(int n2) {
            }

            public void onRealtimeReportBloodOxygen(@NotNull BloodOxygen bloodOxygen) {
                Intrinsics.checkNotNullParameter((Object)bloodOxygen, (String)"bloodOxygen");
            }

            public void onDail(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"dailNumber");
            }

            public void onHugeDataSendPercent(byte by, int n2) {
            }

            public void onWifiInfoAndSupport5GAndMac(@NotNull Support5GAndMac support5GAndMac, @NotNull WifiInfo wifiInfo) {
                Intrinsics.checkNotNullParameter((Object)support5GAndMac, (String)"support5GAndMac");
                Intrinsics.checkNotNullParameter((Object)wifiInfo, (String)"wifiInfo");
            }

            public void onWifiEventChange(@NotNull WifiInfo wifiInfo) {
                Intrinsics.checkNotNullParameter((Object)wifiInfo, (String)"wifiInfo");
            }

            public void onPhoneCloneInfo(@NotNull PhoneCloneInfo phoneCloneInfo) {
                Intrinsics.checkNotNullParameter((Object)phoneCloneInfo, (String)"phoneCloneInfo");
            }

            public void onPortNumber(int n2) {
            }
        };
        screenStateService.connectNotifyTimeout = () -> ScreenStateService.connectNotifyTimeout$lambda-0(screenStateService);
    }

    private final void cleanup(int n2) {
        Object object;
        if (!((ScreenStateService)((Object)object)).mIsGattServer) {
            object = ((ScreenStateService)((Object)object)).mFileTransferController;
            if (object != null) {
                ((TranFileTransferController)object).cleanup(n2);
            }
        } else {
            ((ScreenStateService)((Object)object)).mGroupCanceled = false;
            object = ((ScreenStateService)((Object)object)).mFileTransferController;
            if (object != null) {
                ((TranFileTransferController)object).gattServerCleanup();
            }
        }
    }

    private final void resetDevice(int n2) {
        LogUtil logUtil = LogUtil.INSTANCE;
        logUtil.e("reset Device");
        if (n2 != 0 && n2 != 2 && n2 != 4 && n2 != 3) {
            logUtil.e(Intrinsics.stringPlus((String)"Unknown Reset Event value ", (Object)n2));
            return;
        }
        if (this.isReceiverRegistered) {
            ScreenStateService screenStateService = this;
            screenStateService.isReceiverRegistered = false;
            screenStateService.unregisterReceiver(screenStateService.mReceiver);
        }
        this.mRemoteConnectInviting = false;
        this.onScreenOff();
    }

    private final void startScan() {
        BleScanFilter bleScanFilter;
        BleScanFilter bleScanFilter2 = bleScanFilter;
        bleScanFilter = new BleScanFilter();
        boolean bl = KolunScannerManager.getInstance().isKolunExists();
        if (function2.mIsGattServer) {
            bleScanFilter2.setProductSubTypeList(CollectionsKt.arrayListOf((Object[])new Byte[]{(byte)13}));
        } else {
            bleScanFilter2.setProductSubTypeList(CollectionsKt.arrayListOf((Object[])new Byte[]{(byte)10}));
        }
        bleScanFilter2.setMinRssi(-200);
        Object object = function2.mBleScanTool;
        if (object != null) {
            ((BleScanTool)object).setIsNeedAllScanResult(false);
        }
        object = function2.mFileTransferController;
        if (object != null) {
            ((TranFileTransferController)object).onSendFileActivityStart();
        }
        LogUtil.INSTANCE.e(Intrinsics.stringPlus((String)"Kolun Enable is ", (Object)bl));
        object = function2.mBleScanTool;
        if (object != null) {
            Function2<? super ScanResult, ? super DeviceInfo, Unit> function2 = function2.mScanresLmd;
            ((BleScanTool)object).startScanAndConnect(bl, bleScanFilter2, false, 2, function2);
        }
    }

    private final void stopScan() {
        LogUtil.INSTANCE.w("ScreenStateService,stopScan");
        TranFileTransferController tranFileTransferController = ((ScreenStateService)((Object)bleScanTool)).mFileTransferController;
        if (tranFileTransferController != null) {
            tranFileTransferController.onSendFileActivityStop();
        }
        BleScanTool bleScanTool = ((ScreenStateService)((Object)bleScanTool)).mBleScanTool;
        if (bleScanTool != null) {
            bleScanTool.stopScan();
        }
    }

    private final void getDeviceName() {
        Object object;
        if (this.mDeviceName == null) {
            object = this.mFileTransferController;
            object = object == null ? null : ((TranFileTransferController)object).onGetDeviceName();
            this.mDeviceName = object;
            LogUtil.INSTANCE.i(Intrinsics.stringPlus((String)"DeviceName is ", (Object)object));
        }
        if (this.mDeviceName == null) {
            object = Settings.Global.getString((ContentResolver)this.getContentResolver(), (String)"device_name");
            if (((String)object).length() > 9) {
                StringBuilder stringBuilder;
                StringBuilder stringBuilder2 = stringBuilder;
                Object object2 = object;
                stringBuilder2();
                Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"deviceName");
                String string = ((String)object2).substring(0, 4);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                StringBuilder stringBuilder3 = stringBuilder.append(string).append("..");
                Object object3 = object;
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"deviceName");
                int n2 = ((String)object3).length() - 3;
                String string2 = ((String)object3).substring(n2, ((String)object3).length());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                object = stringBuilder3.append(string2).toString();
            }
            this.mDeviceName = object;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void detectVendorPid() {
        Object object;
        if (this.mVendorPid == null) {
            object = this.mFileTransferController;
            object = object == null ? null : ((TranFileTransferController)object).onGetAdvPidInfo();
            this.mVendorPid = object;
        }
        if ((object = this.mVendorPid) == null || object != null && Intrinsics.compare((int)((String)object).length(), (int)18) == -1) {
            this.mVendorPid = "060D00040001100001";
        }
        byte[] byArray = (object = this.mVendorPid) == null ? null : DataTransformUtil.INSTANCE.decodeHex((String)object);
        Intrinsics.checkNotNull((Object)byArray);
        if (byArray[1] == 10) {
            this.mIsGattServer = true;
            object = "FF:FF:FF:FF:FF:FF";
            String string = this.mVendorPid;
            this.mVendorPid = Intrinsics.stringPlus(string == null ? null : Intrinsics.stringPlus((String)string, (Object)StringsKt.replace$default((String)object, (String)":", (String)"", (boolean)false, (int)4, null)), (Object)"0F");
        }
        LogUtil.INSTANCE.e("vendorid=" + this.mVendorPid + "is Gatt " + this.mIsGattServer);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final void startAdvertising(String string) {
        void var1_2;
        Object object = this.mBleScanTool;
        if (object != null && !((BleScanTool)object).isAdapterEnabled()) {
            return;
        }
        boolean bl = false;
        if (bl) {
            return;
        }
        object = AdvertiseTool.INSTANCE;
        if (((AdvertiseTool)object).isAdvertising()) {
            return;
        }
        if (var1_2 == null) {
            return;
        }
        if (this.mIsGattServer) {
            ((AdvertiseTool)object).startAdvertisement((String)var1_2, 0, false, 0, 2, true);
            return;
        }
        String string2 = this.mDeviceName;
        if (string2 != null) {
            ((AdvertiseTool)object).setDeviceName(string2);
        }
        ((AdvertiseTool)object).startAdvertisement((String)var1_2, 0, true, 0, 2, false);
    }

    private final void stopAdvertising() {
        AdvertiseTool advertiseTool = AdvertiseTool.INSTANCE;
        if (advertiseTool.isAdvertising()) {
            advertiseTool.stopAdvertising();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void onScreenOn() {
        Object object = LogUtil.INSTANCE;
        ((LogUtil)object).e("onScreenOn, advDisable=" + this.mBleAdvDisabled + ", scanDisable=" + this.mScanDisabled + " smartState: " + this.mSmartState);
        this.isScreenOn = true;
        if (Intrinsics.areEqual((Object)this.mSmartState, (Object)Boolean.FALSE)) {
            ((LogUtil)object).e("smart connect disabled");
            return;
        }
        TranFileTransferController tranFileTransferController = this.mFileTransferController;
        if (!(tranFileTransferController != null && tranFileTransferController.onIsTransferStateIdle())) {
            ((LogUtil)object).e("Smart Connect is Running, wait for completing");
            return;
        }
        if (!this.mBleAdvDisabled && !this.mBluetoothDisabled) {
            ScreenStateService screenStateService = this;
            screenStateService.startAdvertising(screenStateService.mVendorPid);
        }
        if (!this.mIsGattServer) {
            if (this.mScanDisabled) return;
            if (this.mBluetoothDisabled) return;
            this.startScan();
            return;
        }
        object = this.mTranGattServer;
        if (object != null) {
            ((TranGattServicerManager)object).startServer();
        }
        object = this.mTranGattServer;
        if (object == null) {
            return;
        }
        ((TranGattServicerManager)object).setOnStatusChangeListener(this.stateChangeListener);
    }

    private final void onScreenOff() {
        ScreenStateService screenStateService = tranGattServicerManager;
        LogUtil.INSTANCE.e("onScreenOff, advDisable=" + ((ScreenStateService)((Object)tranGattServicerManager)).mBleAdvDisabled + ", scanDisable=" + ((ScreenStateService)((Object)tranGattServicerManager)).mScanDisabled + " smartState: " + ((ScreenStateService)((Object)tranGattServicerManager)).mSmartState);
        screenStateService.isScreenOn = false;
        screenStateService.stopScan();
        screenStateService.stopAdvertising();
        if (screenStateService.mIsGattServer) {
            ((ScreenStateService)((Object)tranGattServicerManager)).mGroupCanceled = false;
            TranGattServicerManager tranGattServicerManager = ((ScreenStateService)((Object)tranGattServicerManager)).mTranGattServer;
            if (tranGattServicerManager != null) {
                tranGattServicerManager.stopServer();
            }
        }
    }

    private static final void connectNotifyTimeout$lambda-0(ScreenStateService object) {
        ScreenStateService screenStateService = object;
        Intrinsics.checkNotNullParameter((Object)((Object)screenStateService), (String)"this$0");
        LogUtil.INSTANCE.e("connectNotifyTimeoute");
        screenStateService.stopAdvertising();
        if (screenStateService.isScreenOn && (object = ((ScreenStateService)((Object)object)).mFileTransferController) != null) {
            ((TranFileTransferController)object).gattServerConnectFailed();
        }
    }

    public static final /* synthetic */ String access$getMAdapterAddress$p(ScreenStateService screenStateService) {
        return screenStateService.mAdapterAddress;
    }

    public static final /* synthetic */ boolean access$getMRemoteConnectInviting$p(ScreenStateService screenStateService) {
        return screenStateService.mRemoteConnectInviting;
    }

    public static final /* synthetic */ boolean access$getMLocalConnectRunning$p(ScreenStateService screenStateService) {
        return screenStateService.mLocalConnectRunning;
    }

    public static final /* synthetic */ TranFileTransferController access$getMFileTransferController$p(ScreenStateService screenStateService) {
        return screenStateService.mFileTransferController;
    }

    public static final /* synthetic */ boolean access$getMGroupCanceled$p(ScreenStateService screenStateService) {
        return screenStateService.mGroupCanceled;
    }

    public static final /* synthetic */ void access$setMGroupCanceled$p(ScreenStateService screenStateService, boolean bl) {
        screenStateService.mGroupCanceled = bl;
    }

    public static final /* synthetic */ void access$setMRemoteConnectInviting$p(ScreenStateService screenStateService, boolean bl) {
        screenStateService.mRemoteConnectInviting = bl;
    }

    @NotNull
    public final Function2<ScanResult, DeviceInfo, Unit> getMScanresLmd() {
        return this.mScanresLmd;
    }

    public final void setMScanresLmd(@NotNull Function2<? super ScanResult, ? super DeviceInfo, Unit> function2) {
        Intrinsics.checkNotNullParameter(function2, (String)"<set-?>");
        this.mScanresLmd = function2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void onCreate() {
        BleScanTool bleScanTool;
        LogUtil logUtil = LogUtil.INSTANCE;
        ScreenStateService screenStateService = this;
        Object object = this.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"applicationContext");
        logUtil.d(Intrinsics.stringPlus((String)"ScreenStateService,onCreate, context: ", (Object)object));
        super.onCreate();
        screenStateService.mHandlerThread.start();
        screenStateService.mHandler = new Handler(this.mHandlerThread.getLooper());
        screenStateService.mGroupCanceled = false;
        ScreenStateService.Companion.setService(this);
        logUtil.i("initBlescanTool, sdk version: 1.9.10-2022/08/18-09:45");
        Object object2 = object = bleScanTool;
        Context context = this.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
        ((BleScanTool)object2)(context);
        this.mBleScanTool = object2;
        object = bleScanTool == null ? null : ((BleScanTool)object).getAdapterAddress();
        this.mAdapterAddress = object;
        logUtil.d(Intrinsics.stringPlus((String)"Adapter Address is ", (Object)object));
        object = this.mAdapterAddress;
        if (object != null && (object = StringsKt.replace((String)object, (String)":", (String)"", (boolean)false)) != null) {
            DataTransformUtil dataTransformUtil = DataTransformUtil.INSTANCE;
            byte[] byArray = dataTransformUtil.decodeHex((String)object);
            object = byArray;
            if (byArray != null) {
                dataTransformUtil.print((byte[])object);
            }
        }
        this.mReceiver = new ScreenStateReceiver();
        logUtil.d("initFileTransferController");
        Context context2 = this.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"applicationContext");
        object = (TranFileTransferController)TranFileTransferController.Companion.getInstance(context2);
        this.mFileTransferController = object;
        if (object != null && ((TranFileTransferController)object).onGetAdvFunState()) {
            this.mBleAdvDisabled = false;
        }
        if ((object = this.mFileTransferController) != null && ((TranFileTransferController)object).onGetScanFunState()) {
            this.mScanDisabled = false;
        }
        object = (object = this.mFileTransferController) == null ? null : Boolean.valueOf(((TranFileTransferController)object).onGetSmartFunState());
        ScreenStateService screenStateService2 = this;
        screenStateService2.mSmartState = object;
        screenStateService2.detectVendorPid();
        screenStateService2.getDeviceName();
        if (screenStateService2.mIsGattServer && (object = this.mFileTransferController) != null) {
            ((TranFileTransferController)object).enableP2pListener();
        }
        LogUtil logUtil2 = logUtil;
        logUtil2.i(Intrinsics.stringPlus((String)"mVendor Pid=", (Object)this.mVendorPid));
        logUtil2.d("gatt service init");
        Context context3 = this.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"applicationContext");
        this.mTranGattServer = (TranGattServicerManager)TranGattServicerManager.Companion.getInstance(context3);
        if (Intrinsics.areEqual((Object)this.mSmartState, (Object)Boolean.TRUE)) {
            logUtil.i("Smart Config Enabled, start again");
            this.start(5);
        }
        logUtil.i("Create Complete");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    @Override
    @RequiresApi(value=29)
    public int onStartCommand(@Nullable Intent var1_1, int var2_2, int var3_3) {
        if (var1_1 == null) {
            return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
        }
        var4_4 = LogUtil.INSTANCE;
        var4_4.d(Intrinsics.stringPlus((String)"ScreenStateService,onStartCommand action:", (Object)var1_1.getAction()));
        var5_6 = var1_1.getAction();
        if (var5_6 == null) return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
        tmp = -1;
        switch (var5_6.hashCode()) {
            case 1867694174: {
                if (!var5_6.equals("com.welink.protocol.nfbd.action.DISCONNECT_RESET_CONN")) break;
                tmp = 1;
                break;
            }
            case 1621353406: {
                if (!var5_6.equals("com.welink.protocol.nfbd.action.STOP_ADV_DEVICE")) break;
                tmp = 2;
                break;
            }
            case 1332581235: {
                if (!var5_6.equals("com.welink.protocol.nfbd.action.ACTION_REVIVE_SERVICE")) break;
                tmp = 3;
                break;
            }
            case 1304311190: {
                if (!var5_6.equals("com.welink.protocol.nfbd.action.NOTIFY_CREATE_GO")) break;
                tmp = 4;
                break;
            }
            case 1296180006: {
                if (!var5_6.equals("com.welink.protocol.nfbd.action.ACTION_UPDATE_CON_STATE")) break;
                tmp = 5;
                break;
            }
            case 1210516695: {
                if (!var5_6.equals("com.welink.protocol.nfbd.action.UNREG_CONN_NOTIFY")) break;
                tmp = 6;
                break;
            }
            case 215901582: {
                if (!var5_6.equals("com.welink.protocol.nfbd.action.PAUSE_SCAN_DEVICE")) break;
                tmp = 7;
                break;
            }
            case 174457792: {
                if (!var5_6.equals("com.welink.protocol.nfbd.action.NOTIFY_CONNECT_DEVICE")) break;
                tmp = 8;
                break;
            }
            case 91405581: {
                if (!var5_6.equals("com.welink.protocol.nfbd.action.DISCONNECT_REMOTE_DEVICE")) break;
                tmp = 9;
                break;
            }
            case 82387580: {
                if (!var5_6.equals("com.welink.protocol.nfbd.action.REQUEST_CONNECT_DEVICE")) break;
                tmp = 10;
                break;
            }
            case 50077167: {
                if (!var5_6.equals("com.welink.protocol.nfbd.action.DISCONNECT_CANCEL_CONN")) break;
                tmp = 11;
                break;
            }
            case 41814542: {
                if (!var5_6.equals("com.welink.protocol.nfbd.action.RECEIVE_FILE_ACCEPT")) break;
                tmp = 12;
                break;
            }
            case -168062048: {
                if (!var5_6.equals("com.welink.protocol.nfbd.action.START_ADV_DEVICE")) break;
                tmp = 13;
                break;
            }
            case -275683401: {
                if (!var5_6.equals("com.welink.protocol.nfbd.action.NOTIFY_QRSCAN_CONNECT_DEVICE")) break;
                tmp = 14;
                break;
            }
            case -278745456: {
                if (!var5_6.equals("com.welink.protocol.nfbd.action.RECEIVE_FILE_DECLINE")) break;
                tmp = 15;
                break;
            }
            case -613852395: {
                if (!var5_6.equals("com.welink.protocol.nfbd.action.ADV_PARAMS_UPDATE")) break;
                tmp = 16;
                break;
            }
            case -672751838: {
                if (!var5_6.equals("com.welink.protocol.nfbd.action.NOTIFY_P2P_DISCONNECT")) break;
                tmp = 17;
                break;
            }
            case -816135686: {
                if (!var5_6.equals("com.welink.protocol.nfbd.action.START_SCAN_DEVICE")) break;
                tmp = 18;
                break;
            }
            case -1020160289: {
                if (!var5_6.equals("com.welink.protocol.nfbd.action.NOTIFY_GO_STARTED")) break;
                tmp = 19;
                break;
            }
            case -1178831460: {
                if (!var5_6.equals("com.welink.protocol.nfbd.action.STOP_SCAN_DEVICE")) break;
                tmp = 20;
                break;
            }
        }
        switch (tmp) {
            default: {
                return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
            }
            case 1: {
                var5_7 = var1_1.getIntExtra("TRANDIR", 0);
                if (var5_7 == 0) ** GOTO lbl110
                if (var5_7 == 1) ** GOTO lbl104
                if (var5_7 != 2) {
                    var4_4.w("Unknown Reset Event");
                } else {
                    var4_4.d("Active Reset QR Mode Flag");
                    var4_4 = this.mFileTransferController;
                    if (var4_4 != null) {
                        var4_4.unregisterConnCallback();
                    }
                }
                ** GOTO lbl112
lbl104:
                // 1 sources

                var4_4.d("Active Reset Inviting Flag");
                var4_4 = this.mFileTransferController;
                if (var4_4 != null) {
                    var4_4.unregisterConnCallback();
                }
                this.mLocalConnectRunning = false;
                ** GOTO lbl112
lbl110:
                // 1 sources

                var4_4.d("Passive Reset Inviting Flag");
                this.mRemoteConnectInviting = false;
lbl112:
                // 4 sources

                this.onScreenOn();
                return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
            }
            case 2: {
                var4_4.d("ACTION_STOP_ADV_DEVICE");
                this.mBleAdvDisabled = true;
                var4_4 = this.mFileTransferController;
                if (var4_4 != null) {
                    var4_4.onAdvFunEnable(false);
                }
                this.stopAdvertising();
                return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
            }
            case 3: {
                var4_4.d("ACTION_REVIVE_SERVICE");
                return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
            }
            case 4: {
                if (this.mGroupCanceled) ** GOTO lbl369
                v0 = this;
                v0.stopAdvertising();
                var4_4 = v0.mFileTransferController;
                if (var4_4 == null) {
                    return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
                }
                ** GOTO lbl332
            }
            case 5: {
                var4_4.d("ACTION_UPDATE_CON_STATE");
                if (var1_1.getBooleanExtra("STATE", false)) {
                    var4_4.d("Active Connect Successfully");
                    this.mLocalConnectRunning = false;
                    return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
                }
                var4_4.d("Passive Connect Successfully");
                this.mRemoteConnectInviting = false;
                var5_6 = this.mFileTransferController;
                if ((var5_6 != null && var5_6.getConnCallbackRegisterState() == true) == false) return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
                var4_4.w("Unexpected active connect request registered, force unregister it now");
                var4_4 = this.mFileTransferController;
                if (var4_4 == null) {
                    return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
                }
                var4_4.unregisterConnCallback();
                return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
            }
            case 6: {
                var4_4 = this.mFileTransferController;
                if (var4_4 == null) {
                    return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
                }
                var4_4.unregisterConnReqCallback();
                return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
            }
            case 7: {
                var4_4.d("ACTION_PAUSE_SCAN_DEVICE");
                this.stopScan();
                return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
            }
            case 8: {
                var4_4.e("ACTION_NOTIFY_CONNECT_DEVICE enter");
                var5_6 = this.mFileTransferController;
                if (!(var5_6 == null ? false : Intrinsics.areEqual((Object)var5_6.onGetRcvTransferState(), (Object)0))) {
                    v1 = this;
                    this = "ERROR: Notify connect passive running already, Device state: ";
                    var1_1 = v1.mFileTransferController;
                    var1_1 = var1_1 == null ? null : var1_1.onGetRcvTransferState();
                    var4_4.e(Intrinsics.stringPlus((String)this, (Object)var1_1));
                    return 1;
                }
                var5_6 = this.mFileTransferController;
                if (!(var5_6 == null ? false : Intrinsics.areEqual((Object)var5_6.onGetSndTransferState(), (Object)0))) {
                    v2 = this;
                    this = "ERROR: Notify connect active running already, Device state: ";
                    var1_1 = v2.mFileTransferController;
                    var1_1 = var1_1 == null ? null : var1_1.onGetSndTransferState();
                    var4_4.e(Intrinsics.stringPlus((String)this, (Object)var1_1));
                    return 1;
                }
                if (this.mLocalConnectRunning) {
                    var4_4.w("warning: Local Connection is Running, Ignore this Command Operation");
                    return 1;
                }
                v3 = var1_1;
                v4 = this;
                var4_4.e("ACTION_NOTIFY_CONNECT_DEVICE start connect");
                super.stopScan();
                super.stopAdvertising();
                var4_4 = v3.getStringExtra("com.welink.protocol.nfbd.extra.LOCADDR");
                var5_6 = v3.getStringExtra("com.welink.protocol.nfbd.extra.SRCADDR");
                var6_13 = (ScanResult)v3.getParcelableExtra("com.welink.protocol.nfbd.extra.RESULTS");
                var7_18 = (DeviceInfo)v3.getParcelableExtra("com.welink.protocol.nfbd.extra.DEVINFO");
                if (v3.getIntExtra("com.welink.protocol.nfbd.extra.CMDREQU", 7) != 7) return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
                this.mRemoteConnectInviting = true;
                var8_22 = this.mFileTransferController;
                if (var8_22 == null) {
                    return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
                }
                v5 = var8_22;
                var8_22 = 7;
                Intrinsics.checkNotNull((Object)var7_18);
                Intrinsics.checkNotNull((Object)var6_13);
                v5.onScanResult((Integer)var8_22, (String)var4_4, (String)var5_6, var7_18, var6_13);
                return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
            }
            case 9: {
                var4_4.d("ACTION_DISCONNECT_REMOTE_DEVICE");
                if (!this.mIsGattServer) {
                    var4_5 = var1_1.getIntExtra("TRANDIR", 0);
                    var5_6 = this.mFileTransferController;
                    if (var5_6 != null) {
                        var5_6.onTransferComplete();
                    }
                    v6 = this;
                    v6.mRemoteConnectInviting = false;
                    v6.mLocalConnectRunning = false;
                    if (var4_5 == 1) return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
                    if (var4_5 != 2) {
                        return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
                    }
                    var4_4 = this.mFileTransferController;
                    if (var4_4 == null) {
                        return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
                    }
                } else {
                    var4_4 = this.mTranGattServer;
                    if (var4_4 != null) {
                        var4_4.disconnect();
                    }
                    var4_4 = this.mFileTransferController;
                    if (var4_4 != null) {
                        var4_4.removeGroup();
                    }
                    var4_4 = this.mFileTransferController;
                    if (var4_4 == null) {
                        return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
                    }
                    var4_4.gattServerDisconnectRemote();
                    return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
                }
            }
            case 10: {
                var5_8 = this.mIsGattServer;
                if (!var5_8) {
                    var5_9 = this.mFileTransferController;
                    if (!(var5_9 == null ? false : Intrinsics.areEqual((Object)var5_9.onGetSndTransferState(), (Object)0))) {
                        v7 = this;
                        this = "ERROR: Request connect active running already, Device state: ";
                        var1_1 = v7.mFileTransferController;
                        var1_1 = var1_1 == null ? null : var1_1.onGetSndTransferState();
                        var4_4.e(Intrinsics.stringPlus((String)this, (Object)var1_1));
                        return 1;
                    }
                    var5_9 = this.mFileTransferController;
                    if (!(var5_9 == null ? false : Intrinsics.areEqual((Object)var5_9.onGetRcvTransferState(), (Object)0))) {
                        v8 = this;
                        this = "ERROR: Request connect passive running already, Device state: ";
                        var1_1 = v8.mFileTransferController;
                        var1_1 = var1_1 == null ? null : var1_1.onGetRcvTransferState();
                        var4_4.e(Intrinsics.stringPlus((String)this, (Object)var1_1));
                        return 1;
                    }
                    if (this.mRemoteConnectInviting) {
                        var4_4.w("warning: Remote Invite Connection is Running, Ignore this Command Operation");
                        return 1;
                    }
                    var5_9 = var1_1.getStringExtra("selectedMac");
                    v9 = var1_1;
                    var6_14 = v9.getStringExtra("fileName");
                    var7_19 = v9.getIntExtra("fileCount", 1);
                    var8_23 = v9.getLongExtra("fileSize", 0L);
                    var10_25 = v9.getStringExtra("fileType");
                    var11_26 = v9.getIntExtra("p2pPort", 51888);
                    if (var5_9 == null) {
                        var4_4.e("ERROR, invalid device address");
                        return 1;
                    }
                    var12_27 = this.mFileTransferController;
                    if (var12_27 != null && var12_27.onCheckDeviceList((String)var5_9) == false) {
                        var4_4.e("ERROR, not found valid device in list");
                        return 1;
                    }
                    v10 = this;
                    v10.mLocalConnectRunning = true;
                    super.stopAdvertising();
                    var4_4 = v11;
                    Intrinsics.checkNotNull((Object)var6_14);
                    Intrinsics.checkNotNull((Object)var10_25);
                    v11 = new TranFileTransferController.SendFileInfo((String)var5_9, var6_14, var7_19, var8_23, var10_25, var11_26);
                    var5_9 = v10.mFileTransferController;
                    if (var5_9 == null) {
                        return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
                    }
                    var5_9.sendFile((TranFileTransferController.SendFileInfo)var4_4);
                    return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
                }
                if (var5_8 != true) return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
                var4_4 = this.mTranGattServer;
                if (var4_4 != null && !var4_4.isDeviceListEmpty()) {
                    return 1;
                }
                v12 = false;
                if (v12) {
                    return 1;
                }
                v13 = this;
                super.stopScan();
                super.stopAdvertising();
                var4_4 = var1_1.getStringExtra("selectedMac");
                var5_10 = this.mVendorPid;
                if (var5_10 == null) {
                    v14 = null;
                } else {
                    var4_4 = var4_4 == null ? null : StringsKt.replace$default((String)var4_4, (String)":", (String)"", (boolean)false, (int)4, null);
                    v14 = Intrinsics.stringPlus((String)var5_10, (Object)var4_4);
                }
                var4_4 = Intrinsics.stringPlus(v14, (Object)"07");
                v15 = this;
                super.startAdvertising((String)var4_4);
                v16 = v15.mHandler;
                Intrinsics.checkNotNull((Object)v16);
                if (v16.hasCallbacks(this.connectNotifyTimeout) != false) return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
                var4_4 = this.mHandler;
                if (var4_4 == null) {
                    return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
                }
                var4_4.postDelayed(this.connectNotifyTimeout, 6000L);
                return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
            }
            case 11: {
                if (!this.mIsGattServer) {
                    v17 = this.mFileTransferController;
                    Intrinsics.checkNotNull((Object)v17);
                    v17.onTransferCancel();
                } else {
                    var4_4 = this.mTranGattServer;
                    if (var4_4 != null) {
                        var4_4.sendCancalOrRejectNotify();
                    }
                    var4_4 = this.mFileTransferController;
                    if (var4_4 != null) {
                        var4_4.gattServerConnectCancel();
                    }
                }
                this.mRemoteConnectInviting = false;
                return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
            }
            case 12: {
                var4_4.d("ACTION_RECEIVE_FILE_ACCEPT");
                if (!this.mIsGattServer) {
                    var4_4 = this.mFileTransferController;
                    if (var4_4 == null) {
                        return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
                    }
                    var4_4.onActionAccept();
                    return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
                }
                if (this.mGroupCanceled) ** GOTO lbl369
                v18 = this;
                v18.stopAdvertising();
                var4_4 = v18.mFileTransferController;
                if (var4_4 == null) return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
lbl332:
                // 2 sources

                var4_4.createAutoGO();
                return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
            }
            case 13: {
                var4_4.d("ACTION_START_ADV_DEVICE");
                this.mBleAdvDisabled = false;
                var4_4 = this.mFileTransferController;
                if (var4_4 != null) {
                    var4_4.onAdvFunEnable(true);
                }
                v19 = this;
                v19.startAdvertising(v19.mVendorPid);
                return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
            }
            case 14: {
                v20 = var1_1;
                v21 = this;
                var4_4.d("ACTION_NOTIFY_QRSCAN_CONNECT_DEVICE");
                v21.stopScan();
                v21.stopAdvertising();
                var4_4 = v20.getStringExtra("SSID");
                var5_6 = v20.getStringExtra("PWD");
                var6_15 = this.mFileTransferController;
                if (var6_15 != null) {
                    var6_15.enableP2pListener();
                }
                var6_15 = this.mFileTransferController;
                if (var6_15 == null) {
                    return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
                }
                var6_15.connectP2p((String)var4_4, (String)var5_6);
                return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
            }
            case 15: {
                var4_4.d("ACTION_RECEIVE_FILE_DECLINE");
                if (!this.mIsGattServer) {
                    var4_4 = this.mFileTransferController;
                    if (var4_4 == null) {
                        return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
                    }
                    var4_4.onActionDecline();
                    return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
                }
                if (!this.mGroupCanceled) ** GOTO lbl371
lbl369:
                // 3 sources

                this.mGroupCanceled = false;
                return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
lbl371:
                // 1 sources

                var4_4 = this.mTranGattServer;
                if (var4_4 != null) {
                    var4_4.sendCancalOrRejectNotify();
                }
                var4_4 = this.mFileTransferController;
                if (var4_4 == null) {
                    return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
                }
                var4_4.gattServerConnectReject();
                return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
            }
            case 16: {
                var4_4.d("ACTION_ADV_PARAMS_UPDATE");
                var5_11 = var1_1.getIntExtra("com.welink.protocol.nfbd.extra.event", -1);
                if (var5_11 == 3) {
                    this.mVendorPid = null;
                    this.detectVendorPid();
                    return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
                }
                if (var5_11 != 4) {
                    var4_4.d("Unknown Update BLE params event, ignore");
                    return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
                }
                this.mDeviceName = null;
                this.getDeviceName();
                return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
            }
            case 17: {
                var5_12 = var1_1.getIntExtra("com.welink.protocol.nfbd.extra.type", 0);
                var4_4.i(Intrinsics.stringPlus((String)"Get P2p disconnect event: ", (Object)var5_12));
                if (var5_12 != 0 && var5_12 != 1 && var5_12 != 2) {
                    var4_4.d(Intrinsics.stringPlus((String)"P2p disconnect unknown event: ", (Object)var5_12));
                    return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
                }
                var4_4.d("P2p disconnect Successfully");
                var4_4 = this.mFileTransferController;
                if (var4_4 == null) {
                    return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
                }
                var4_4.disableP2pListener(var5_12);
                return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
            }
            case 18: {
                this.mScanDisabled = false;
                var4_4 = this.mFileTransferController;
                if (var4_4 != null) {
                    var4_4.onScanFunEnable(true);
                }
                this.startScan();
                return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
            }
            case 19: {
                if (var1_1.getIntExtra("com.welink.protocol.nfbd.extra.event", 0) == 0 && !this.mGroupCanceled) {
                    v22 = var1_1;
                    var4_4 = v22.getStringExtra("com.welink.protocol.nfbd.extra.ssid");
                    var5_6 = v22.getStringExtra("com.welink.protocol.nfbd.extra.pwd");
                    if (this.mIsGattServer && (var6_16 = this.mTranGattServer) != null) {
                        Intrinsics.checkNotNull((Object)var4_4);
                        Intrinsics.checkNotNull((Object)var5_6);
                        var7_20 = this.mFileTransferController;
                        var7_20 = var7_20 == null ? null : Integer.valueOf(var7_20.onGetMessagePort());
                        v23 = var7_20;
                        Intrinsics.checkNotNull((Object)v23);
                        var7_21 = v23.intValue();
                        var8_24 = this.mFileTransferController;
                        var8_24 = var8_24 == null ? null : Integer.valueOf(var8_24.onGetDataPort());
                        v24 = var8_24;
                        Intrinsics.checkNotNull((Object)v24);
                        var6_17 = v24.intValue();
                        var6_16.sendInfoReadyNotify((String)var4_4, (String)var5_6, var7_21, var6_17);
                    }
                }
                if (this.mGroupCanceled == false) return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
                this.mGroupCanceled = false;
                var4_4 = this.mFileTransferController;
                if (var4_4 == null) return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
                var4_4.removeGroup();
                return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
            }
            case 20: 
        }
        var4_4 = this.mFileTransferController;
        if (var4_4 != null) {
            var4_4.unregisterScanCallback();
        }
        this.mScanDisabled = true;
        var4_4 = this.mFileTransferController;
        if (var4_4 != null) {
            var4_4.onScanFunEnable(false);
        }
        this.stopScan();
        return super.onStartCommand((Intent)var1_1, var2_2, var3_3);
    }

    public void onDestroy() {
        ScreenStateService screenStateService = this;
        LogUtil.INSTANCE.w("ScreenStateService,onDestroy");
        screenStateService.resetDevice(3);
        ScreenStateService.Companion.clearService(this);
        TranFileTransferController tranFileTransferController = screenStateService.mFileTransferController;
        if (tranFileTransferController != null) {
            tranFileTransferController.onNotifyServiceDied();
        }
        ScreenStateService screenStateService2 = this;
        super.onDestroy();
        screenStateService2.mHandlerThread.quitSafely();
    }

    @Override
    @Nullable
    public IBinder onBind(@NotNull Intent intent) {
        Intent intent2 = intent;
        Intrinsics.checkNotNullParameter((Object)intent2, (String)"intent");
        LogUtil.INSTANCE.i("ScreenStateService,onBind");
        return super.onBind(intent2);
    }

    public boolean onUnbind(@Nullable Intent intent) {
        LogUtil.INSTANCE.w("ScreenStateService,onUnbind");
        return super.onUnbind(intent);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void start(int n2) {
        Object object;
        block14: {
            block13: {
                block11: {
                    block12: {
                        object = LogUtil.INSTANCE;
                        ((LogUtil)object).e("start");
                        if (n2 != 1 && n2 != 5 && n2 != 2 && n2 != 4) {
                            ((LogUtil)object).e(Intrinsics.stringPlus((String)"Unknown Start value ", (Object)n2));
                            return;
                        }
                        if (!this.isReceiverRegistered) {
                            IntentFilter intentFilter;
                            ScreenStateService screenStateService = this;
                            screenStateService.isReceiverRegistered = true;
                            object = intentFilter;
                            new IntentFilter().addAction("android.intent.action.SCREEN_ON");
                            object.addAction("android.intent.action.SCREEN_OFF");
                            screenStateService.registerReceiver(screenStateService.mReceiver, (IntentFilter)object);
                        }
                        if ((object = this.mFileTransferController) != null) {
                            ((TranFileTransferController)object).onSmartFunEnable(true);
                        }
                        this.mSmartState = Boolean.TRUE;
                        if (n2 == 1) break block11;
                        if (n2 == 2) break block12;
                        if (n2 == 4) break block13;
                        break block14;
                    }
                    this.mBluetoothDisabled = false;
                    break block14;
                }
                object = BluetoothAdapter.getDefaultAdapter();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getDefaultAdapter()");
                Object object2 = this.getSystemService("wifi");
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.net.wifi.WifiManager");
                }
                Object object3 = object;
                object = (WifiManager)object2;
                if (object3.isEnabled()) {
                    this.mBluetoothDisabled = false;
                }
                if (!object.isWifiEnabled()) break block14;
            }
            this.mWifiDisabled = false;
        }
        object = this.mFileTransferController;
        if (object != null) {
            ((TranFileTransferController)object).onNotifyServiceEnabled(n2);
        }
        Object object4 = this.getSystemService("power");
        if (object4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type android.os.PowerManager");
        }
        if (((PowerManager)object4).isInteractive()) {
            this.onScreenOn();
        }
    }

    @Override
    public void stop(int n2) {
        Object object = LogUtil.INSTANCE;
        ((LogUtil)object).e("stop Device");
        if (n2 != 2 && n2 != 4 && n2 != 0) {
            ((LogUtil)object).e(Intrinsics.stringPlus((String)"Unknown Stop Event value ", (Object)n2));
            return;
        }
        if (n2 != 0) {
            if (n2 != 2) {
                if (n2 == 4) {
                    this.mWifiDisabled = true;
                }
            } else {
                this.mBluetoothDisabled = true;
            }
        } else {
            ScreenStateService screenStateService = this;
            screenStateService.mScanDisabled = true;
            screenStateService.mBleAdvDisabled = true;
        }
        ScreenStateService screenStateService = this;
        screenStateService.resetDevice(n2);
        screenStateService.mSmartState = Boolean.FALSE;
        object = screenStateService.mFileTransferController;
        if (object != null) {
            ((TranFileTransferController)object).onSmartFunEnable(false);
        }
        this.cleanup(n2);
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bR\u0016\u0010\n\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Lcom/welink/protocol/nfbd/ScreenStateService$ScreenStateReceiver;", "Landroid/content/BroadcastReceiver;", "Landroid/content/Context;", "context", "Landroid/content/Intent;", "intent", "", "onReceive", "(Landroid/content/Context;Landroid/content/Intent;)V", "Lcom/welink/protocol/nfbd/ScreenStateService;", "outObj", "Lcom/welink/protocol/nfbd/ScreenStateService;", "<init>", "(Lcom/welink/protocol/nfbd/ScreenStateService;)V", "welinkSDK_release"})
    public final class ScreenStateReceiver
    extends BroadcastReceiver {
        @NotNull
        private ScreenStateService outObj;

        public ScreenStateReceiver() {
            Intrinsics.checkNotNullParameter((Object)((Object)ScreenStateService.this), (String)"this$0");
            this.outObj = ScreenStateService.this;
        }

        public void onReceive(@NotNull Context object, @NotNull Intent intent) {
            Intent intent2 = intent;
            Intrinsics.checkNotNullParameter((Object)object, (String)"context");
            Intrinsics.checkNotNullParameter((Object)intent2, (String)"intent");
            object = intent2.getAction();
            LogUtil.INSTANCE.e(Intrinsics.stringPlus((String)"onReceive : ", (Object)object));
            if (Intrinsics.areEqual((Object)object, (Object)"android.intent.action.SCREEN_ON")) {
                this.outObj.onScreenOn();
            } else if (Intrinsics.areEqual((Object)object, (Object)"android.intent.action.SCREEN_OFF")) {
                this.outObj.onScreenOff();
            }
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0015\n\u0002\u0010\b\n\u0002\b\u0015\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b5\u00106J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R(\u0010\u000b\u001a\u0004\u0018\u00010\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\u00028F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u0006R\u0016\u0010\r\u001a\u00020\f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u00020\f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u000eR\u0016\u0010\u0010\u001a\u00020\f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u000eR\u0016\u0010\u0011\u001a\u00020\f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u000eR\u0016\u0010\u0012\u001a\u00020\f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u000eR\u0016\u0010\u0013\u001a\u00020\f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u000eR\u0016\u0010\u0014\u001a\u00020\f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u000eR\u0016\u0010\u0015\u001a\u00020\f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u000eR\u0016\u0010\u0016\u001a\u00020\f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u000eR\u0016\u0010\u0017\u001a\u00020\f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u000eR\u0016\u0010\u0018\u001a\u00020\f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u000eR\u0016\u0010\u0019\u001a\u00020\f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u000eR\u0016\u0010\u001a\u001a\u00020\f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u000eR\u0016\u0010\u001b\u001a\u00020\f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u000eR\u0016\u0010\u001c\u001a\u00020\f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u000eR\u0016\u0010\u001d\u001a\u00020\f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u000eR\u0016\u0010\u001e\u001a\u00020\f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u000eR\u0016\u0010\u001f\u001a\u00020\f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u000eR\u0016\u0010 \u001a\u00020\f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b \u0010\u000eR\u0016\u0010!\u001a\u00020\f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b!\u0010\u000eR\u0016\u0010#\u001a\u00020\"8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0016\u0010%\u001a\u00020\f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b%\u0010\u000eR\u0016\u0010&\u001a\u00020\f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b&\u0010\u000eR\u0016\u0010'\u001a\u00020\f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b'\u0010\u000eR\u0016\u0010(\u001a\u00020\f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b(\u0010\u000eR\u0016\u0010)\u001a\u00020\f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b)\u0010\u000eR\u0016\u0010*\u001a\u00020\f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b*\u0010\u000eR\u0016\u0010+\u001a\u00020\f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b+\u0010\u000eR\u0016\u0010,\u001a\u00020\f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b,\u0010\u000eR\u0016\u0010-\u001a\u00020\f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b-\u0010\u000eR\u0016\u0010.\u001a\u00020\f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b.\u0010\u000eR\u0016\u0010/\u001a\u00020\"8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b/\u0010$R\u0016\u00100\u001a\u00020\"8\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b0\u0010$R\u0016\u00101\u001a\u00020\f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b1\u0010\u000eR\u0016\u00102\u001a\u00020\f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b2\u0010\u000eR\u0018\u00103\u001a\u0004\u0018\u00010\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b3\u00104\u00a8\u00067"}, d2={"Lcom/welink/protocol/nfbd/ScreenStateService$Companion;", "", "Lcom/welink/protocol/nfbd/ScreenStateService;", "current", "", "clearService", "(Lcom/welink/protocol/nfbd/ScreenStateService;)V", "instance", "getService", "()Lcom/welink/protocol/nfbd/ScreenStateService;", "setService", "service", "", "ACTION_ADV_PARAMS_UPDATE", "Ljava/lang/String;", "ACTION_DISCONNECT_CANCEL_CONN", "ACTION_DISCONNECT_REMOTE_DEVICE", "ACTION_DISCONNECT_RESET_CONN", "ACTION_NOTIFY_CONNECT_DEVICE", "ACTION_NOTIFY_CREATE_GO", "ACTION_NOTIFY_GO_STARTED", "ACTION_NOTIFY_P2P_DISCONNECT", "ACTION_NOTIFY_QRSCAN_CONNECT_DEVICE", "ACTION_PAUSE_SCAN_DEVICE", "ACTION_RECEIVE_FILE_ACCEPT", "ACTION_RECEIVE_FILE_DECLINE", "ACTION_REQUEST_CONNECT_DEVICE", "ACTION_REVIVE_SERVICE", "ACTION_START_ADV_DEVICE", "ACTION_START_SCAN_DEVICE", "ACTION_STOP_ADV_DEVICE", "ACTION_STOP_SCAN_DEVICE", "ACTION_UNREG_CONN_NOTIFY", "ACTION_UPDATE_CON_STATE", "", "BD_ADDR_LEN", "I", "EXTRA_CMDREQU", "EXTRA_DEVINFO", "EXTRA_EVENT", "EXTRA_LOCADDR", "EXTRA_PWD", "EXTRA_RESULTS", "EXTRA_SRCADDR", "EXTRA_SSID", "EXTRA_TYPE", "MAC_STRING", "MIN_RSSI", "PROFILE_SERVICE_MODE", "SDKVERSION", "TAG", "sService", "Lcom/welink/protocol/nfbd/ScreenStateService;", "<init>", "()V", "welinkSDK_release"})
    public static final class Companion {
        private Companion() {
        }

        private final synchronized void setService(ScreenStateService screenStateService) {
            LogUtil.INSTANCE.e(Intrinsics.stringPlus((String)"setAdapterService() - trying to set service to ", (Object)((Object)screenStateService)));
            if (screenStateService == null) {
                return;
            }
            sService = screenStateService;
        }

        private final synchronized void clearService(ScreenStateService screenStateService) {
            if (sService == screenStateService) {
                sService = null;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        @Nullable
        public final synchronized ScreenStateService getService() {
            LogUtil.INSTANCE.e(Intrinsics.stringPlus((String)"getAdapterService() - returning ", (Object)((Object)sService)));
            return sService;
        }
    }
}

