/*
 * Decompiled with CFR 0.152.
 */
package com.welink.protocol.nfbd;

import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import android.content.Context;
import android.content.Intent;
import android.net.wifi.p2p.WifiP2pDeviceList;
import android.os.Handler;
import android.os.HandlerThread;
import androidx.annotation.RequiresApi;
import com.welink.protocol.nfbd.ScreenStateService;
import com.welink.protocol.nfbd.TranFileReceiveController;
import com.welink.protocol.nfbd.TranFileTransferController;
import com.welink.protocol.nfbd.TranP2pConnectHelper;
import com.welink.protocol.nfbd.TranssionBleFactory;
import com.welink.protocol.nfbd.TranssionBleUtil;
import com.welink.protocol.utils.DeviceInfo;
import com.welink.protocol.utils.LogUtil;
import java.util.Arrays;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 f2\u00020\u0001:\u0002fgB\u000f\u0012\u0006\u0010]\u001a\u00020$\u00a2\u0006\u0004\be\u0010'J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006JE\u0010\u000f\u001a\u00020\u00042\b\u0010\b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u00022\b\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u00022\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0015\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\r\u0010\u0017\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J-\u0010\u001e\u001a\u00020\u00042\b\u0010\u001a\u001a\u0004\u0018\u00010\u00192\n\u0010\u000e\u001a\u00060\u001bR\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\r\u0010 \u001a\u00020\u0004\u00a2\u0006\u0004\b \u0010\u0016J\u0015\u0010\"\u001a\u00020\u00042\u0006\u0010!\u001a\u00020\u0002\u00a2\u0006\u0004\b\"\u0010\u0006J\r\u0010#\u001a\u00020\u0004\u00a2\u0006\u0004\b#\u0010\u0016J\u0015\u0010&\u001a\u00020\u00042\u0006\u0010%\u001a\u00020$\u00a2\u0006\u0004\b&\u0010'J4\u0010.\u001a\u00020\u00042%\u0010-\u001a!\u0012\u0013\u0012\u00110)\u00a2\u0006\f\b*\u0012\b\b\u000b\u0012\u0004\b\b(+\u0012\u0004\u0012\u00020\u00040(j\u0002`,\u00a2\u0006\u0004\b.\u0010/J\r\u00100\u001a\u00020\u0004\u00a2\u0006\u0004\b0\u0010\u0016J\u0015\u00102\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u0002\u00a2\u0006\u0004\b2\u0010\u0006J\r\u00103\u001a\u00020\u0004\u00a2\u0006\u0004\b3\u0010\u0016J\r\u00104\u001a\u00020\u0004\u00a2\u0006\u0004\b4\u0010\u0016J\r\u00105\u001a\u00020\u0004\u00a2\u0006\u0004\b5\u0010\u0016R\u0016\u00107\u001a\u0002068\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00108R\u0016\u00109\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b9\u0010:R\u001c\u0010;\u001a\b\u0018\u00010\u001bR\u00020\u001c8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b;\u0010<R\u0018\u0010=\u001a\u0004\u0018\u00010\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b=\u0010>R\u0018\u0010?\u001a\u0004\u0018\u00010\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b?\u0010>R\u0016\u0010@\u001a\u0002068\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b@\u00108R\u0018\u0010A\u001a\u0004\u0018\u00010\u00078\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bA\u0010>R9\u0010B\u001a%\u0012\u0013\u0012\u00110)\u00a2\u0006\f\b*\u0012\b\b\u000b\u0012\u0004\b\b(+\u0012\u0004\u0012\u00020\u0004\u0018\u00010(j\u0004\u0018\u0001`,8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bB\u0010CR\u0016\u0010D\u001a\u0002068\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bD\u00108R\u0016\u0010F\u001a\u00020E8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bF\u0010GR\u0018\u0010I\u001a\u0004\u0018\u00010H8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bI\u0010JR\u0016\u0010K\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bK\u0010:R$\u0010M\u001a\u00020\u00022\u0006\u0010L\u001a\u00020\u00028\u0004@BX\u0084\u000e\u00a2\u0006\f\n\u0004\bM\u0010:\u001a\u0004\bN\u0010\u0018R\u0016\u0010O\u001a\u0002068\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bO\u00108R\u0016\u0010P\u001a\u0002068\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bP\u00108R\u0018\u0010Q\u001a\u0004\u0018\u00010\r8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bQ\u0010RR\u0018\u0010T\u001a\u0004\u0018\u00010S8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bT\u0010UR\u0016\u0010V\u001a\u00020\u00028\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bV\u0010:R\u0016\u0010X\u001a\u00020W8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bX\u0010YR\u0018\u0010[\u001a\u0004\u0018\u00010Z8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b[\u0010\\R\u0016\u0010]\u001a\u00020$8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b]\u0010^R\u001c\u0010`\u001a\b\u0018\u00010_R\u00020\u00008\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b`\u0010aR\u0018\u0010c\u001a\u0004\u0018\u00010b8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bc\u0010d\u00a8\u0006h"}, d2={"Lcom/welink/protocol/nfbd/TranFileReceiveController;", "", "", "type", "", "p2pResultEventNotify", "(I)V", "", "ip", "dport", "cport", "name", "event", "Lcom/welink/protocol/utils/DeviceInfo;", "info", "connectResultEventNotify", "(Ljava/lang/String;IILjava/lang/String;ILcom/welink/protocol/utils/DeviceInfo;)V", "", "fileData", "onReadSendDeviceInfo", "([B)V", "closeBleConnect", "()V", "getTransferState", "()I", "Landroid/bluetooth/le/ScanResult;", "result", "Lcom/welink/protocol/nfbd/TranFileTransferController$TransferConnectInfo;", "Lcom/welink/protocol/nfbd/TranFileTransferController;", "deviceInfo", "onReceiveFile", "(Landroid/bluetooth/le/ScanResult;Lcom/welink/protocol/nfbd/TranFileTransferController$TransferConnectInfo;Lcom/welink/protocol/utils/DeviceInfo;)V", "onTransferComplete", "disconnect", "cleanup", "unsetP2pListener", "Landroid/content/Context;", "context", "updateContext", "(Landroid/content/Context;)V", "Lkotlin/Function1;", "Lcom/welink/protocol/nfbd/TranFileTransferController$MessageInfo;", "Lkotlin/ParameterName;", "msgInfo", "Lcom/welink/protocol/nfbd/ConReqCallback;", "connReqCallback", "registerConnReqCallback", "(Lkotlin/jvm/functions/Function1;)V", "unregisterConnReqCallback", "value", "notifyServiceEnabled", "notifyServiceDied", "onActionAccept", "onActionDecline", "Ljava/lang/Runnable;", "connectTimeoutRunnable", "Ljava/lang/Runnable;", "mP2pFilePort", "I", "mTransferInfo", "Lcom/welink/protocol/nfbd/TranFileTransferController$TransferConnectInfo;", "mPcName", "Ljava/lang/String;", "mP2pSSID", "connectTerminateRunnable", "mP2pPWD", "mConnReqCallback", "Lkotlin/jvm/functions/Function1;", "bleWriteCharacteristicTimeoutRunnable", "", "mIsAccept", "Z", "Landroid/bluetooth/BluetoothDevice;", "mSendDevice", "Landroid/bluetooth/BluetoothDevice;", "mConnectCount", "<set-?>", "mTransferState", "getMTransferState", "onTransferDeviceConfict", "disconnectTimeoutRunnable", "mCurrentDeviceInfo", "Lcom/welink/protocol/utils/DeviceInfo;", "Landroid/os/Handler;", "mHandler", "Landroid/os/Handler;", "mP2pMessagePort", "Landroid/bluetooth/BluetoothGattCallback;", "gattCallback", "Landroid/bluetooth/BluetoothGattCallback;", "Landroid/bluetooth/BluetoothGatt;", "mConnectGatt", "Landroid/bluetooth/BluetoothGatt;", "mContext", "Landroid/content/Context;", "Lcom/welink/protocol/nfbd/TranFileReceiveController$P2pConnectListener;", "mP2pConnectListener", "Lcom/welink/protocol/nfbd/TranFileReceiveController$P2pConnectListener;", "Lcom/welink/protocol/nfbd/TranP2pConnectHelper;", "mP2pConnectHelper", "Lcom/welink/protocol/nfbd/TranP2pConnectHelper;", "<init>", "Companion", "P2pConnectListener", "welinkSDK_release"})
public final class TranFileReceiveController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG = "TranFileReceiveController";
    @NotNull
    private static final String INFINIX = "Infinix";
    @NotNull
    private static final String TECNO = "Tecno";
    @NotNull
    private static final String ITEL = "Itel";
    @NotNull
    private Context mContext;
    private int mTransferState;
    @Nullable
    private BluetoothDevice mSendDevice;
    @Nullable
    private String mPcName;
    @Nullable
    private DeviceInfo mCurrentDeviceInfo;
    @Nullable
    private BluetoothGatt mConnectGatt;
    private int mConnectCount;
    @Nullable
    private String mP2pSSID;
    @Nullable
    private String mP2pPWD;
    private int mP2pFilePort;
    private int mP2pMessagePort;
    private boolean mIsAccept;
    @Nullable
    private TranP2pConnectHelper mP2pConnectHelper;
    @Nullable
    private P2pConnectListener mP2pConnectListener;
    @Nullable
    private TranFileTransferController.TransferConnectInfo mTransferInfo;
    @Nullable
    private Function1<? super TranFileTransferController.MessageInfo, Unit> mConnReqCallback;
    @Nullable
    private Handler mHandler;
    @NotNull
    private final Runnable onTransferDeviceConfict;
    @NotNull
    private final Runnable connectTimeoutRunnable;
    @NotNull
    private final Runnable disconnectTimeoutRunnable;
    @NotNull
    private final Runnable connectTerminateRunnable;
    @NotNull
    private final Runnable bleWriteCharacteristicTimeoutRunnable;
    @NotNull
    private final BluetoothGattCallback gattCallback;

    public TranFileReceiveController(@NotNull Context context) {
        HandlerThread handlerThread;
        TranFileReceiveController tranFileReceiveController = this;
        Intrinsics.checkNotNullParameter((Object)context, (String)"mContext");
        tranFileReceiveController.mContext = context;
        context = handlerThread;
        new HandlerThread("TranFileReceiveControllerHandlerThread").start();
        tranFileReceiveController.mHandler = new Handler(context.getLooper());
        tranFileReceiveController.mP2pConnectHelper = new TranP2pConnectHelper(this.mContext);
        tranFileReceiveController.mP2pConnectListener = new P2pConnectListener();
        tranFileReceiveController.onTransferDeviceConfict = () -> TranFileReceiveController.onTransferDeviceConfict$lambda-0(tranFileReceiveController);
        tranFileReceiveController.connectTimeoutRunnable = () -> TranFileReceiveController.connectTimeoutRunnable$lambda-2(tranFileReceiveController);
        tranFileReceiveController.disconnectTimeoutRunnable = () -> TranFileReceiveController.disconnectTimeoutRunnable$lambda-3(tranFileReceiveController);
        tranFileReceiveController.connectTerminateRunnable = () -> TranFileReceiveController.connectTerminateRunnable$lambda-4(tranFileReceiveController);
        tranFileReceiveController.bleWriteCharacteristicTimeoutRunnable = () -> TranFileReceiveController.bleWriteCharacteristicTimeoutRunnable$lambda-5(tranFileReceiveController);
        tranFileReceiveController.gattCallback = new BluetoothGattCallback(this){
            public final /* synthetic */ TranFileReceiveController this$0;
            {
                this.this$0 = tranFileReceiveController;
            }

            public void onPhyUpdate(@NotNull BluetoothGatt bluetoothGatt, int n2, int n3, int n4) {
                BluetoothGatt bluetoothGatt2 = bluetoothGatt;
                Intrinsics.checkNotNullParameter((Object)bluetoothGatt2, (String)"gatt");
                super.onPhyUpdate(bluetoothGatt2, n2, n3, n4);
                LogUtil.INSTANCE.i("onPhyUpdate");
            }

            public void onPhyRead(@NotNull BluetoothGatt bluetoothGatt, int n2, int n3, int n4) {
                BluetoothGatt bluetoothGatt2 = bluetoothGatt;
                Intrinsics.checkNotNullParameter((Object)bluetoothGatt2, (String)"gatt");
                super.onPhyRead(bluetoothGatt2, n2, n3, n4);
                LogUtil.INSTANCE.i("onPhyRead");
            }

            public void onConnectionStateChange(@NotNull BluetoothGatt bluetoothGatt, int n2, int n3) {
                BluetoothGatt bluetoothGatt2 = bluetoothGatt;
                Intrinsics.checkNotNullParameter((Object)bluetoothGatt2, (String)"gatt");
                super.onConnectionStateChange(bluetoothGatt2, n2, n3);
                LogUtil logUtil = LogUtil.INSTANCE;
                logUtil.i("onConnectionStateChange " + n2 + " -> " + n3);
                if (n3 == 2) {
                    TranFileReceiveController.access$setMTransferState$p(this.this$0, 2);
                    bluetoothGatt.discoverServices();
                } else if (n3 == 0 && n2 != 2) {
                    logUtil.i("retry connect");
                    if (TranFileReceiveController.access$getMSendDevice$p(this.this$0) != null && TranFileReceiveController.access$getMConnectCount$p(this.this$0) < 3) {
                        gattCallback.1 v1 = this;
                        TranFileReceiveController tranFileReceiveController = v1.this$0;
                        BluetoothDevice bluetoothDevice = TranFileReceiveController.access$getMSendDevice$p(tranFileReceiveController);
                        Intrinsics.checkNotNull((Object)bluetoothDevice);
                        TranFileReceiveController.access$setMConnectGatt$p(tranFileReceiveController, bluetoothDevice.connectGatt(TranFileReceiveController.access$getMContext$p(this.this$0), false, (BluetoothGattCallback)this, 2));
                        TranFileReceiveController tranFileReceiveController2 = v1.this$0;
                        TranFileReceiveController.access$setMConnectCount$p(tranFileReceiveController2, TranFileReceiveController.access$getMConnectCount$p(tranFileReceiveController2) + 1);
                    } else {
                        gattCallback.1 v5 = this;
                        TranFileReceiveController.access$setMConnectCount$p(v5.this$0, 0);
                        TranFileReceiveController.access$setMSendDevice$p(v5.this$0, null);
                        if (TranFileReceiveController.access$getMConnReqCallback$p(v5.this$0) != null) {
                            TranFileReceiveController.access$connectResultEventNotify(this.this$0, null, -2, 0, "PC", 4, null);
                        }
                        TranFileReceiveController.access$closeBleConnect(this.this$0);
                    }
                }
            }

            public void onServicesDiscovered(@NotNull BluetoothGatt bluetoothGatt, int n2) {
                BluetoothGatt bluetoothGatt2 = bluetoothGatt;
                Intrinsics.checkNotNullParameter((Object)bluetoothGatt2, (String)"gatt");
                super.onServicesDiscovered(bluetoothGatt2, n2);
                LogUtil logUtil = LogUtil.INSTANCE;
                logUtil.i(Intrinsics.stringPlus((String)"onServicesDiscovered : ", (Object)n2));
                if (n2 == 0) {
                    TranssionBleFactory transsionBleFactory = TranssionBleFactory.INSTANCE;
                    UUID uUID = transsionBleFactory.getFILE_TRANSFER_RECEIVE_UUID();
                    Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"TranssionBleFactory.FILE_TRANSFER_RECEIVE_UUID");
                    uUID = TranssionBleUtil.INSTANCE.getCharacteristic(bluetoothGatt, uUID);
                    if (uUID != null) {
                        bluetoothGatt.setCharacteristicNotification((BluetoothGattCharacteristic)uUID, true);
                        BluetoothGattDescriptor bluetoothGattDescriptor = uUID.getDescriptor(transsionBleFactory.getDESCRIPTOR_UUID());
                        bluetoothGattDescriptor.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
                        if (!bluetoothGatt.writeDescriptor(bluetoothGattDescriptor)) {
                            logUtil.i("writeDescriptor fail");
                            TranFileReceiveController.access$closeBleConnect(this.this$0);
                        }
                    }
                } else {
                    TranFileReceiveController.access$closeBleConnect(this.this$0);
                }
            }

            public void onCharacteristicRead(@NotNull BluetoothGatt object, @NotNull BluetoothGattCharacteristic bluetoothGattCharacteristic, int n2) {
                Intrinsics.checkNotNullParameter((Object)object, (String)"gatt");
                Intrinsics.checkNotNullParameter((Object)bluetoothGattCharacteristic, (String)"characteristic");
                super.onCharacteristicRead((BluetoothGatt)object, bluetoothGattCharacteristic, n2);
                object = LogUtil.INSTANCE;
                ((LogUtil)object).i(Intrinsics.stringPlus((String)"onCharacteristicRead : ", (Object)n2));
                if (n2 == 0) {
                    if (Intrinsics.areEqual((Object)bluetoothGattCharacteristic.getUuid(), (Object)TranssionBleFactory.INSTANCE.getFILE_TRANSFER_RECEIVE_UUID())) {
                        byte[] byArray = bluetoothGattCharacteristic.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"data");
                        ((LogUtil)object).i(TranssionBleUtil.INSTANCE.printHexBinary(byArray));
                        if (byArray.length == 1 && byArray[0] == -16) {
                            ((LogUtil)object).i("Remote is Not ready, message will send via notification later");
                        } else {
                            byte[] byArray2 = bluetoothGattCharacteristic.getValue();
                            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"characteristic.value");
                            TranFileReceiveController.access$onReadSendDeviceInfo(this.this$0, byArray2);
                        }
                    }
                } else {
                    TranFileReceiveController.access$closeBleConnect(this.this$0);
                }
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            @RequiresApi(value=29)
            public void onCharacteristicWrite(@NotNull BluetoothGatt object, @NotNull BluetoothGattCharacteristic bluetoothGattCharacteristic, int n2) {
                block8: {
                    block7: {
                        Handler handler;
                        void var3_8;
                        void var2_7;
                        Intrinsics.checkNotNullParameter((Object)object, (String)"gatt");
                        Intrinsics.checkNotNullParameter((Object)var2_7, (String)"characteristic");
                        super.onCharacteristicWrite(object, (BluetoothGattCharacteristic)var2_7, (int)var3_8);
                        LogUtil.INSTANCE.i(Intrinsics.stringPlus((String)"onCharacteristicWrite : ", (Object)((int)var3_8)));
                        if (var3_8 != false) break block7;
                        if (!Intrinsics.areEqual((Object)var2_7.getUuid(), (Object)TranssionBleFactory.INSTANCE.getFILE_TRANSFER_RECEIVE_UUID())) break block8;
                        Handler handler2 = TranFileReceiveController.access$getMHandler$p(this.this$0);
                        if (handler2 != null && handler2.hasCallbacks(TranFileReceiveController.access$getBleWriteCharacteristicTimeoutRunnable$p(this.this$0)) && (handler = TranFileReceiveController.access$getMHandler$p(this.this$0)) != null) {
                            handler.removeCallbacks(TranFileReceiveController.access$getBleWriteCharacteristicTimeoutRunnable$p(this.this$0));
                        }
                        if (TranFileReceiveController.access$getMIsAccept$p(this.this$0)) {
                            gattCallback.1 v0 = this;
                            TranFileReceiveController.access$setMTransferState$p(v0.this$0, 3);
                            TranP2pConnectHelper tranP2pConnectHelper = TranFileReceiveController.access$getMP2pConnectHelper$p(v0.this$0);
                            if (tranP2pConnectHelper != null) {
                                gattCallback.1 v1 = this;
                                String string = TranFileReceiveController.access$getMP2pPWD$p(v1.this$0);
                                tranP2pConnectHelper.startConnectP2p(TranFileReceiveController.access$getMP2pSSID$p(this.this$0), string, TranFileReceiveController.access$getMP2pConnectListener$p(v1.this$0));
                            }
                        } else if (TranFileReceiveController.access$getMConnReqCallback$p(this.this$0) != null) {
                            TranFileReceiveController.access$connectResultEventNotify(this.this$0, null, -1, 0, null, 4, null);
                        }
                    }
                    TranFileReceiveController.access$closeBleConnect(this.this$0);
                }
            }

            public void onCharacteristicChanged(@NotNull BluetoothGatt object, @NotNull BluetoothGattCharacteristic bluetoothGattCharacteristic) {
                Intrinsics.checkNotNullParameter((Object)object, (String)"gatt");
                Intrinsics.checkNotNullParameter((Object)bluetoothGattCharacteristic, (String)"characteristic");
                super.onCharacteristicChanged((BluetoothGatt)object, bluetoothGattCharacteristic);
                object = LogUtil.INSTANCE;
                ((LogUtil)object).i(Intrinsics.stringPlus((String)"onCharacteristicChanged : ", (Object)bluetoothGattCharacteristic.getUuid()));
                if (Intrinsics.areEqual((Object)bluetoothGattCharacteristic.getUuid(), (Object)TranssionBleFactory.INSTANCE.getFILE_TRANSFER_RECEIVE_UUID())) {
                    byte[] byArray = bluetoothGattCharacteristic.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"data");
                    ((LogUtil)object).i(TranssionBleUtil.INSTANCE.printHexBinary(byArray));
                    if (byArray.length == 1 && byArray[0] == -1) {
                        gattCallback.1 v0 = this;
                        ((LogUtil)object).i("PC CANCEL");
                        TranFileReceiveController.access$closeBleConnect(v0.this$0);
                        if (TranFileReceiveController.access$getMConnReqCallback$p(v0.this$0) != null) {
                            TranFileReceiveController.access$connectResultEventNotify(this.this$0, null, 0, 0, "PC", 4, null);
                        }
                    } else {
                        byte[] byArray2 = bluetoothGattCharacteristic.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"characteristic.value");
                        TranFileReceiveController.access$onReadSendDeviceInfo(this.this$0, byArray2);
                    }
                }
            }

            public void onDescriptorRead(@NotNull BluetoothGatt bluetoothGatt, @NotNull BluetoothGattDescriptor bluetoothGattDescriptor, int n2) {
                Intrinsics.checkNotNullParameter((Object)bluetoothGatt, (String)"gatt");
                Intrinsics.checkNotNullParameter((Object)bluetoothGattDescriptor, (String)"descriptor");
                super.onDescriptorRead(bluetoothGatt, bluetoothGattDescriptor, n2);
                LogUtil.INSTANCE.i("onDescriptorRead");
            }

            public void onDescriptorWrite(@NotNull BluetoothGatt bluetoothGatt, @NotNull BluetoothGattDescriptor object, int n2) {
                Intrinsics.checkNotNullParameter((Object)bluetoothGatt, (String)"gatt");
                Intrinsics.checkNotNullParameter((Object)object, (String)"descriptor");
                super.onDescriptorWrite(bluetoothGatt, (BluetoothGattDescriptor)object, n2);
                object = LogUtil.INSTANCE;
                ((LogUtil)object).i(Intrinsics.stringPlus((String)"onDescriptorWrite : ", (Object)n2));
                if (n2 == 0) {
                    UUID uUID = TranssionBleFactory.INSTANCE.getFILE_TRANSFER_RECEIVE_UUID();
                    Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"TranssionBleFactory.FILE_TRANSFER_RECEIVE_UUID");
                    uUID = TranssionBleUtil.INSTANCE.getCharacteristic(bluetoothGatt, uUID);
                    if (uUID != null && !bluetoothGatt.readCharacteristic((BluetoothGattCharacteristic)uUID)) {
                        ((LogUtil)object).i("readCharacteristic fail");
                        TranFileReceiveController.access$closeBleConnect(this.this$0);
                    }
                } else {
                    TranFileReceiveController.access$closeBleConnect(this.this$0);
                }
            }

            public void onReliableWriteCompleted(@NotNull BluetoothGatt bluetoothGatt, int n2) {
                BluetoothGatt bluetoothGatt2 = bluetoothGatt;
                Intrinsics.checkNotNullParameter((Object)bluetoothGatt2, (String)"gatt");
                super.onReliableWriteCompleted(bluetoothGatt2, n2);
                LogUtil.INSTANCE.i("onReliableWriteCompleted");
            }

            public void onReadRemoteRssi(@NotNull BluetoothGatt bluetoothGatt, int n2, int n3) {
                BluetoothGatt bluetoothGatt2 = bluetoothGatt;
                Intrinsics.checkNotNullParameter((Object)bluetoothGatt2, (String)"gatt");
                super.onReadRemoteRssi(bluetoothGatt2, n2, n3);
                LogUtil.INSTANCE.i("onReadRemoteRssi");
            }

            public void onMtuChanged(@NotNull BluetoothGatt bluetoothGatt, int n2, int n3) {
                BluetoothGatt bluetoothGatt2 = bluetoothGatt;
                Intrinsics.checkNotNullParameter((Object)bluetoothGatt2, (String)"gatt");
                super.onMtuChanged(bluetoothGatt2, n2, n3);
                LogUtil.INSTANCE.i(Intrinsics.stringPlus((String)"onMtuChanged : ", (Object)n3));
            }
        };
    }

    private final void p2pResultEventNotify(int n2) {
        Intent intent;
        Intent intent2 = intent;
        new Intent(this.mContext, ScreenStateService.class).setAction("com.welink.protocol.nfbd.action.NOTIFY_P2P_DISCONNECT");
        intent2.putExtra("com.welink.protocol.nfbd.extra.type", n2);
        this.mContext.startService(intent2);
    }

    private final void connectResultEventNotify(String string, int n2, int n3, String string2, int n4, DeviceInfo deviceInfo) {
        TranFileTransferController.MessageInfo messageInfo;
        TranFileReceiveController tranFileReceiveController = runnable;
        TranFileTransferController.MessageInfo messageInfo2 = messageInfo;
        messageInfo = new TranFileTransferController.MessageInfo(string, n2, n3, string2, n4, deviceInfo);
        Runnable runnable = () -> TranFileReceiveController.connectResultEventNotify$lambda-1(n4, (TranFileReceiveController)((Object)runnable), messageInfo2);
        string = tranFileReceiveController.mHandler;
        if (string != null) {
            string.post(runnable);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void onReadSendDeviceInfo(byte[] object) {
        JSONObject jSONObject;
        Object object2 = jSONObject;
        JSONObject jSONObject2 = object2;
        jSONObject2(new String((byte[])object, Charsets.UTF_8));
        object = null;
        Object object3 = null;
        LogUtil logUtil = LogUtil.INSTANCE;
        String string = object2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsobject.toString()");
        logUtil.i(string);
        this.mP2pSSID = jSONObject2.getString("Ssid");
        this.mP2pPWD = object2.getString("Pwd");
        this.mP2pFilePort = object2.getInt("FilePort");
        this.mP2pMessagePort = object2.getInt("MessagePort");
        if (!jSONObject.isNull("DeviceName")) {
            object3 = object2.getString("DeviceName");
        }
        if ((object2 = this.mPcName) != null && !(object2.length() == 0)) {
            object3 = this.mPcName;
        } else if ((object3 == null || object3.length() == 0) && ((object2 = this.mPcName) == null || object2 != null && object2.length() == 0)) {
            object3 = "PC";
        }
        object2 = this.mCurrentDeviceInfo;
        if (object2 != null) {
            String string2;
            StringBuilder stringBuilder;
            object = "DeviceInfo Match Brand: ";
            object2 = object2 == null ? null : Byte.valueOf(((DeviceInfo)object2).getProductBrandName());
            logUtil.d(Intrinsics.stringPlus((String)object, (Object)object2));
            object = this.mCurrentDeviceInfo;
            object = object == null ? null : Byte.valueOf(((DeviceInfo)object).getProductBrandName());
            byte by = 2;
            if (object != null && (Byte)object == by) {
                logUtil.d("DeviceInfo Match ITEL Brand");
                stringBuilder = new StringBuilder();
                string2 = "Itel###";
            } else {
                by = 3;
                if (object != null && (Byte)object == by) {
                    logUtil.d("DeviceInfo Match TECNO Brand");
                    stringBuilder = new StringBuilder();
                    string2 = "Tecno###";
                } else {
                    by = 4;
                    if (object != null && (Byte)object == by) {
                        logUtil.d("DeviceInfo Match INFINIX Brand");
                        stringBuilder = new StringBuilder();
                        string2 = "Infinix###";
                    } else {
                        logUtil.d("DeviceInfo Match Unknown Brand");
                        stringBuilder = new StringBuilder();
                        string2 = "Unknown###";
                    }
                }
            }
            StringBuilder stringBuilder2 = stringBuilder.append(string2);
            Object object4 = object3;
            Intrinsics.checkNotNull((Object)object4);
            StringBuilder stringBuilder3 = stringBuilder2.append((String)object4).append("###");
            DeviceInfo deviceInfo = this.mCurrentDeviceInfo;
            Intrinsics.checkNotNull((Object)deviceInfo);
            object = stringBuilder3.append((Object)deviceInfo.getDeviceMac()).toString();
        }
        if (this.mConnReqCallback != null) {
            TranFileReceiveController tranFileReceiveController = this;
            int n2 = tranFileReceiveController.mP2pFilePort;
            int n3 = tranFileReceiveController.mP2pMessagePort;
            object3 = tranFileReceiveController.mCurrentDeviceInfo;
            tranFileReceiveController.connectResultEventNotify(null, n2, n3, (String)object, 3, (DeviceInfo)object3);
        }
    }

    private final void closeBleConnect() {
        BluetoothGatt bluetoothGatt;
        LogUtil.INSTANCE.i("closeBleConnect");
        this.mIsAccept = false;
        if (this.mTransferState < 3) {
            this.mTransferState = 0;
            bluetoothGatt = this.mHandler;
            if (bluetoothGatt != null) {
                bluetoothGatt.removeCallbacks(this.connectTimeoutRunnable);
            }
        }
        if ((bluetoothGatt = this.mConnectGatt) != null) {
            BluetoothGatt bluetoothGatt2 = bluetoothGatt;
            Intrinsics.checkNotNull((Object)bluetoothGatt2);
            bluetoothGatt2.disconnect();
            BluetoothGatt bluetoothGatt3 = this.mConnectGatt;
            Intrinsics.checkNotNull((Object)bluetoothGatt3);
            bluetoothGatt3.close();
            this.mConnectGatt = null;
        }
    }

    private static final void onTransferDeviceConfict$lambda-0(TranFileReceiveController tranFileReceiveController) {
        TranFileReceiveController tranFileReceiveController2 = tranFileReceiveController;
        Intrinsics.checkNotNullParameter((Object)tranFileReceiveController2, (String)"this$0");
        LogUtil.INSTANCE.d(Intrinsics.stringPlus((String)"Connect has conflict with current device, current state : ", (Object)tranFileReceiveController.getMTransferState()));
        if (tranFileReceiveController2.mConnReqCallback != null) {
            tranFileReceiveController.connectResultEventNotify(null, 13, 0, null, 4, null);
        }
    }

    private static final void connectResultEventNotify$lambda-1(int n2, TranFileReceiveController tranFileReceiveController, TranFileTransferController.MessageInfo messageInfo) {
        Intrinsics.checkNotNullParameter((Object)tranFileReceiveController, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)messageInfo, (String)"$msgInfo");
        LogUtil.INSTANCE.i(Intrinsics.stringPlus((String)"notify event: ", (Object)n2));
        Function1<? super TranFileTransferController.MessageInfo, Unit> function1 = tranFileReceiveController.mConnReqCallback;
        if (function1 != null) {
            function1.invoke((Object)messageInfo);
        }
    }

    private static final void connectTimeoutRunnable$lambda-2(TranFileReceiveController tranFileReceiveController) {
        TranP2pConnectHelper tranP2pConnectHelper;
        TranFileReceiveController tranFileReceiveController2 = tranFileReceiveController;
        Intrinsics.checkNotNullParameter((Object)tranFileReceiveController2, (String)"this$0");
        LogUtil.INSTANCE.i("connect timeout");
        tranFileReceiveController2.closeBleConnect();
        if (tranFileReceiveController2.getMTransferState() > 2 && (tranP2pConnectHelper = tranFileReceiveController.mP2pConnectHelper) != null) {
            tranP2pConnectHelper.cancelConnectP2p();
        }
        tranFileReceiveController.mTransferState = 0;
        if (tranFileReceiveController.mConnReqCallback != null) {
            tranFileReceiveController.connectResultEventNotify(null, 6, 0, "PC", 4, null);
        }
    }

    private static final void disconnectTimeoutRunnable$lambda-3(TranFileReceiveController tranFileReceiveController) {
        TranFileReceiveController tranFileReceiveController2 = tranFileReceiveController;
        Intrinsics.checkNotNullParameter((Object)tranFileReceiveController2, (String)"this$0");
        LogUtil.INSTANCE.d(Intrinsics.stringPlus((String)"Passive Disconnect timeout current state : ", (Object)tranFileReceiveController.getMTransferState()));
        TranP2pConnectHelper tranP2pConnectHelper = tranFileReceiveController2.mP2pConnectHelper;
        if (tranP2pConnectHelper != null) {
            tranP2pConnectHelper.unregisterP2pConnectState();
        }
        tranFileReceiveController.mTransferState = 0;
        if (tranFileReceiveController.mConnReqCallback != null) {
            tranFileReceiveController.connectResultEventNotify(null, 11, 0, "PC", 4, null);
        }
    }

    private static final void connectTerminateRunnable$lambda-4(TranFileReceiveController tranFileReceiveController) {
        TranFileReceiveController tranFileReceiveController2 = tranFileReceiveController;
        Intrinsics.checkNotNullParameter((Object)tranFileReceiveController2, (String)"this$0");
        LogUtil.INSTANCE.d(Intrinsics.stringPlus((String)"Passive Terminate Current connection : ", (Object)tranFileReceiveController.getMTransferState()));
        if (tranFileReceiveController2.mConnReqCallback != null) {
            tranFileReceiveController.connectResultEventNotify(null, 15, 0, "PC", 4, null);
        }
    }

    private static final void bleWriteCharacteristicTimeoutRunnable$lambda-5(TranFileReceiveController tranFileReceiveController) {
        TranFileReceiveController tranFileReceiveController2 = tranFileReceiveController;
        Intrinsics.checkNotNullParameter((Object)tranFileReceiveController2, (String)"this$0");
        LogUtil.INSTANCE.d("Ble write characteristic timeout: " + tranFileReceiveController.getMTransferState() + ", accpet: " + tranFileReceiveController.mIsAccept);
        tranFileReceiveController2.mTransferState = 0;
        if (tranFileReceiveController2.mConnReqCallback != null) {
            if (!tranFileReceiveController.mIsAccept) {
                tranFileReceiveController.connectResultEventNotify(null, 17, 0, "PC", 4, null);
            } else {
                tranFileReceiveController.connectResultEventNotify(null, 16, 0, "PC", 4, null);
            }
        }
    }

    public static final /* synthetic */ BluetoothDevice access$getMSendDevice$p(TranFileReceiveController tranFileReceiveController) {
        return tranFileReceiveController.mSendDevice;
    }

    public static final /* synthetic */ int access$getMConnectCount$p(TranFileReceiveController tranFileReceiveController) {
        return tranFileReceiveController.mConnectCount;
    }

    public static final /* synthetic */ void access$setMConnectGatt$p(TranFileReceiveController tranFileReceiveController, BluetoothGatt bluetoothGatt) {
        tranFileReceiveController.mConnectGatt = bluetoothGatt;
    }

    public static final /* synthetic */ Context access$getMContext$p(TranFileReceiveController tranFileReceiveController) {
        return tranFileReceiveController.mContext;
    }

    public static final /* synthetic */ void access$setMConnectCount$p(TranFileReceiveController tranFileReceiveController, int n2) {
        tranFileReceiveController.mConnectCount = n2;
    }

    public static final /* synthetic */ void access$setMSendDevice$p(TranFileReceiveController tranFileReceiveController, BluetoothDevice bluetoothDevice) {
        tranFileReceiveController.mSendDevice = bluetoothDevice;
    }

    public static final /* synthetic */ void access$closeBleConnect(TranFileReceiveController tranFileReceiveController) {
        tranFileReceiveController.closeBleConnect();
    }

    public static final /* synthetic */ void access$onReadSendDeviceInfo(TranFileReceiveController tranFileReceiveController, byte[] byArray) {
        tranFileReceiveController.onReadSendDeviceInfo(byArray);
    }

    public static final /* synthetic */ Runnable access$getBleWriteCharacteristicTimeoutRunnable$p(TranFileReceiveController tranFileReceiveController) {
        return tranFileReceiveController.bleWriteCharacteristicTimeoutRunnable;
    }

    public static final /* synthetic */ boolean access$getMIsAccept$p(TranFileReceiveController tranFileReceiveController) {
        return tranFileReceiveController.mIsAccept;
    }

    public static final /* synthetic */ TranP2pConnectHelper access$getMP2pConnectHelper$p(TranFileReceiveController tranFileReceiveController) {
        return tranFileReceiveController.mP2pConnectHelper;
    }

    public static final /* synthetic */ String access$getMP2pSSID$p(TranFileReceiveController tranFileReceiveController) {
        return tranFileReceiveController.mP2pSSID;
    }

    public static final /* synthetic */ String access$getMP2pPWD$p(TranFileReceiveController tranFileReceiveController) {
        return tranFileReceiveController.mP2pPWD;
    }

    public static final /* synthetic */ P2pConnectListener access$getMP2pConnectListener$p(TranFileReceiveController tranFileReceiveController) {
        return tranFileReceiveController.mP2pConnectListener;
    }

    public final int getMTransferState() {
        return this.mTransferState;
    }

    public final int getTransferState() {
        return this.mTransferState;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    public final void onReceiveFile(@Nullable ScanResult scanResult, @NotNull TranFileTransferController.TransferConnectInfo transferConnectInfo, @Nullable DeviceInfo deviceInfo) {
        void var2_5;
        void var3_7;
        BluetoothDevice bluetoothDevice;
        Intrinsics.checkNotNullParameter((Object)transferConnectInfo, (String)"info");
        LogUtil logUtil = LogUtil.INSTANCE;
        logUtil.i(Intrinsics.stringPlus((String)"onReceiveFile Start connect transfer state : ", (Object)this.mTransferState));
        BluetoothDevice bluetoothDevice2 = this.mSendDevice;
        if (bluetoothDevice2 != null && bluetoothDevice2 == (bluetoothDevice = scanResult == null ? null : scanResult.getDevice())) {
            logUtil.i("same device return");
            return;
        }
        if (this.mTransferState != 0) {
            byte[] byArray;
            TranFileTransferController.TransferConnectInfo transferConnectInfo2 = this.mTransferInfo;
            if (transferConnectInfo2 != null && transferConnectInfo2 != null && (byArray = transferConnectInfo2.getPcMac()) != null && !Arrays.equals(byArray, transferConnectInfo.getPcMac()) && this.mTransferState < 3) {
                TranFileReceiveController tranFileReceiveController = this;
                logUtil.i("ble connecting but pc ble mac change need update");
                tranFileReceiveController.closeBleConnect();
                logUtil = tranFileReceiveController.mHandler;
                if (logUtil != null) {
                    logUtil.post(this.onTransferDeviceConfict);
                }
            } else {
                logUtil.i("same device connecting, return");
                return;
            }
        }
        TranFileReceiveController tranFileReceiveController = this;
        tranFileReceiveController.mCurrentDeviceInfo = var3_7;
        tranFileReceiveController.mTransferInfo = transferConnectInfo;
        if (scanResult == null) {
            Object var2_3 = null;
        } else {
            ScanRecord scanRecord = scanResult.getScanRecord();
        }
        void v2 = var2_5;
        Intrinsics.checkNotNull((Object)v2);
        this.mPcName = v2.getDeviceName();
        BluetoothDevice bluetoothDevice3 = scanResult.getDevice();
        scanResult = bluetoothDevice3;
        TranFileReceiveController tranFileReceiveController2 = this;
        this.mSendDevice = scanResult;
        Intrinsics.checkNotNull((Object)scanResult);
        scanResult = tranFileReceiveController2.mContext;
        BluetoothGattCallback bluetoothGattCallback = tranFileReceiveController2.gattCallback;
        this.mConnectGatt = bluetoothDevice3.connectGatt((Context)scanResult, false, bluetoothGattCallback, 2);
        scanResult = this.mHandler;
        if (scanResult != null) {
            scanResult.postDelayed(this.connectTimeoutRunnable, 20000L);
        }
        TranFileReceiveController tranFileReceiveController3 = this;
        tranFileReceiveController3.mTransferState = 1;
        tranFileReceiveController3.mConnectCount = 0;
    }

    public final void onTransferComplete() {
        LogUtil.INSTANCE.i("onTransferComplete");
        this.cleanup(2);
    }

    public final void cleanup(int n2) {
        LogUtil logUtil = LogUtil.INSTANCE;
        logUtil.i(Intrinsics.stringPlus((String)"Receive cleanup, ", (Object)n2));
        if (n2 <= 3) {
            int n3 = this.mTransferState;
            if (n3 > 2) {
                TranP2pConnectHelper tranP2pConnectHelper = this.mP2pConnectHelper;
                if (tranP2pConnectHelper != null) {
                    tranP2pConnectHelper.cancelConnectP2p();
                }
                tranP2pConnectHelper = this.mHandler;
                if (tranP2pConnectHelper != null) {
                    tranP2pConnectHelper.postDelayed(this.disconnectTimeoutRunnable, 10000L);
                }
            } else if (n3 > 0) {
                Handler handler;
                this.closeBleConnect();
                if (n2 == 0 && (handler = this.mHandler) != null) {
                    handler.postDelayed(this.connectTerminateRunnable, 500L);
                }
            }
            this.mTransferState = 0;
        } else if (n2 == 4) {
            logUtil.i("Rcv Receive Adapter BT OFF Bypass event");
        } else {
            logUtil.i("Rcv Receive Unknown Cleanup Event");
        }
        if (this.mConnReqCallback != null) {
            int n4 = n2;
            n2 = 0;
            switch (n4) {
                default: {
                    break;
                }
                case 4: {
                    n2 = 12;
                    break;
                }
                case 3: {
                    n2 = 9;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 10;
                    break;
                }
                case 0: {
                    n2 = 1;
                }
            }
            this.connectResultEventNotify(null, n2, 0, null, 4, null);
        }
    }

    public final void unsetP2pListener() {
        TranP2pConnectHelper tranP2pConnectHelper = ((TranFileReceiveController)((Object)tranP2pConnectHelper)).mP2pConnectHelper;
        if (tranP2pConnectHelper != null) {
            tranP2pConnectHelper.unregisterP2pConnectState();
        }
    }

    public final void updateContext(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context == ((TranFileReceiveController)((Object)tranP2pConnectHelper)).mContext) {
            return;
        }
        ((TranFileReceiveController)((Object)tranP2pConnectHelper)).mContext = context;
        TranP2pConnectHelper tranP2pConnectHelper = ((TranFileReceiveController)((Object)tranP2pConnectHelper)).mP2pConnectHelper;
        if (tranP2pConnectHelper != null) {
            tranP2pConnectHelper.updateContext(context);
        }
    }

    public final void registerConnReqCallback(@NotNull Function1<? super TranFileTransferController.MessageInfo, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"connReqCallback");
        this.mConnReqCallback = function1;
    }

    public final void unregisterConnReqCallback() {
        this.mConnReqCallback = null;
    }

    public final void notifyServiceEnabled(int n2) {
        if (this.mConnReqCallback != null) {
            this.connectResultEventNotify(null, n2, 0, "phone", 6, null);
        }
    }

    public final void notifyServiceDied() {
        if (this.mConnReqCallback != null) {
            this.connectResultEventNotify(null, 7, 0, "phone", 5, null);
        }
    }

    public final void onActionAccept() {
        LogUtil logUtil = LogUtil.INSTANCE;
        logUtil.i("onActionAccept");
        this.mIsAccept = true;
        UUID uUID = TranssionBleFactory.INSTANCE.getFILE_TRANSFER_RECEIVE_UUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"TranssionBleFactory.FILE_TRANSFER_RECEIVE_UUID");
        BluetoothGattCharacteristic bluetoothGattCharacteristic = TranssionBleUtil.INSTANCE.getCharacteristic(this.mConnectGatt, uUID);
        if (bluetoothGattCharacteristic != null) {
            bluetoothGattCharacteristic.setValue(new byte[]{0});
            BluetoothGatt bluetoothGatt = this.mConnectGatt;
            Intrinsics.checkNotNull((Object)bluetoothGatt);
            if (!bluetoothGatt.writeCharacteristic(bluetoothGattCharacteristic)) {
                logUtil.i("writeCharacteristic fail");
                this.closeBleConnect();
            } else {
                logUtil = this.mHandler;
                if (logUtil != null) {
                    logUtil.postDelayed(this.bleWriteCharacteristicTimeoutRunnable, 6000L);
                }
            }
        }
    }

    public final void onActionDecline() {
        LogUtil logUtil = LogUtil.INSTANCE;
        logUtil.i("onActionDecline");
        UUID uUID = TranssionBleFactory.INSTANCE.getFILE_TRANSFER_RECEIVE_UUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"TranssionBleFactory.FILE_TRANSFER_RECEIVE_UUID");
        BluetoothGattCharacteristic bluetoothGattCharacteristic = TranssionBleUtil.INSTANCE.getCharacteristic(this.mConnectGatt, uUID);
        if (bluetoothGattCharacteristic != null) {
            this.mIsAccept = false;
            bluetoothGattCharacteristic.setValue(new byte[]{-1});
            BluetoothGatt bluetoothGatt = this.mConnectGatt;
            Intrinsics.checkNotNull((Object)bluetoothGatt);
            if (!bluetoothGatt.writeCharacteristic(bluetoothGattCharacteristic)) {
                logUtil.i("writeCharacteristic fail");
                this.closeBleConnect();
            } else {
                logUtil = this.mHandler;
                if (logUtil != null) {
                    logUtil.postDelayed(this.bleWriteCharacteristicTimeoutRunnable, 6000L);
                }
            }
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\u0007\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\bJ#\u0010\f\u001a\u00020\u00042\b\u0010\n\u001a\u0004\u0018\u00010\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000e\u001a\u00020\u0004H\u0017\u00a2\u0006\u0004\b\u000e\u0010\b\u00a8\u0006\u0011"}, d2={"Lcom/welink/protocol/nfbd/TranFileReceiveController$P2pConnectListener;", "Lcom/welink/protocol/nfbd/TranP2pConnectHelper$IP2pConnectListener;", "Landroid/net/wifi/p2p/WifiP2pDeviceList;", "wifiP2pDeviceList", "", "onPeersActionChanged", "(Landroid/net/wifi/p2p/WifiP2pDeviceList;)V", "onConnectFail", "()V", "", "serverIp", "clientIp", "onConnectSuccess", "(Ljava/lang/String;Ljava/lang/String;)V", "onDisconnected", "<init>", "(Lcom/welink/protocol/nfbd/TranFileReceiveController;)V", "welinkSDK_release"})
    public final class P2pConnectListener
    implements TranP2pConnectHelper.IP2pConnectListener {
        public P2pConnectListener() {
            Intrinsics.checkNotNullParameter((Object)TranFileReceiveController.this, (String)"this$0");
        }

        @Override
        public void onPeersActionChanged(@NotNull WifiP2pDeviceList wifiP2pDeviceList3) {
            WifiP2pDeviceList wifiP2pDeviceList2 = wifiP2pDeviceList3;
            Intrinsics.checkNotNullParameter((Object)wifiP2pDeviceList2, (String)"wifiP2pDeviceList");
            for (WifiP2pDeviceList wifiP2pDeviceList3 : wifiP2pDeviceList2.getDeviceList()) {
                LogUtil logUtil = LogUtil.INSTANCE;
                logUtil.i(Intrinsics.stringPlus((String)"WIFI_P2P_PEER_CONNECTED: GC Addr:", (Object)wifiP2pDeviceList3.deviceAddress));
                int n2 = wifiP2pDeviceList3.status;
                if (n2 != 0) {
                    if (n2 != 3) continue;
                    logUtil.i("P2P Peer IDLE");
                    continue;
                }
                logUtil.i("P2P Peer Connected");
            }
        }

        @Override
        public void onConnectFail() {
            LogUtil.INSTANCE.i("P2P onConnectFail");
            Handler handler = TranFileReceiveController.this.mHandler;
            if (handler != null) {
                handler.removeCallbacks(TranFileReceiveController.this.connectTimeoutRunnable);
            }
            TranFileReceiveController.this.mTransferState = 0;
        }

        @Override
        public void onConnectSuccess(@Nullable String string, @Nullable String object) {
            LogUtil.INSTANCE.i("P2P onConnectSuccess");
            object = TranFileReceiveController.this.mHandler;
            if (object != null) {
                object.removeCallbacks(TranFileReceiveController.this.connectTimeoutRunnable);
            }
            P2pConnectListener p2pConnectListener = this;
            p2pConnectListener.TranFileReceiveController.this.mTransferState = 4;
            if (p2pConnectListener.TranFileReceiveController.this.mConnReqCallback != null) {
                P2pConnectListener p2pConnectListener2 = this;
                TranFileReceiveController tranFileReceiveController = p2pConnectListener2.TranFileReceiveController.this;
                object = tranFileReceiveController;
                P2pConnectListener p2pConnectListener3 = this;
                int n2 = ((TranFileReceiveController)object).mP2pFilePort;
                int n3 = p2pConnectListener3.TranFileReceiveController.this.mP2pMessagePort;
                object = p2pConnectListener3.TranFileReceiveController.this.mPcName;
                DeviceInfo deviceInfo = p2pConnectListener3.TranFileReceiveController.this.mCurrentDeviceInfo;
                tranFileReceiveController.connectResultEventNotify(string, n2, n3, (String)object, 2, deviceInfo);
                p2pConnectListener2.TranFileReceiveController.this.mTransferState = 5;
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        @RequiresApi(value=29)
        public void onDisconnected() {
            LogUtil.INSTANCE.d("P2P Passive Dir onDisconnected");
            Handler handler = TranFileReceiveController.this.mHandler;
            if (handler != null && handler.hasCallbacks(TranFileReceiveController.this.disconnectTimeoutRunnable) && (handler = TranFileReceiveController.this.mHandler) != null) {
                handler.removeCallbacks(TranFileReceiveController.this.disconnectTimeoutRunnable);
            }
            P2pConnectListener p2pConnectListener = this;
            p2pConnectListener.TranFileReceiveController.this.mTransferState = 0;
            p2pConnectListener.TranFileReceiveController.this.p2pResultEventNotify(2);
            if (p2pConnectListener.TranFileReceiveController.this.mConnReqCallback != null) {
                TranFileReceiveController.this.connectResultEventNotify("0", 5, -1, "PC", 4, null);
            }
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\b\u0010\tR\u0016\u0010\u0003\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004R\u0016\u0010\u0005\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0004R\u0016\u0010\u0006\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0004R\u0016\u0010\u0007\u001a\u00020\u00028\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0004\u00a8\u0006\n"}, d2={"Lcom/welink/protocol/nfbd/TranFileReceiveController$Companion;", "", "", "INFINIX", "Ljava/lang/String;", "ITEL", "TAG", "TECNO", "<init>", "()V", "welinkSDK_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

