/*
 * Decompiled with CFR 0.152.
 */
package com.welink.protocol.nfbd;

import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import com.welink.protocol.utils.LogUtil;
import java.nio.charset.Charset;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001f\u0010 J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\u0007J/\u0010\u000f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\f\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0011\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0019\u0010\u0015\u001a\u00020\u00148\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0017\u0010\u0018R\u0019\u0010\u0019\u001a\u00020\u00148\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0016\u001a\u0004\b\u001a\u0010\u0018R\u0019\u0010\u001b\u001a\u00020\u00148\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u001b\u0010\u0016\u001a\u0004\b\u001c\u0010\u0018R\u0019\u0010\u001d\u001a\u00020\u00148\u0006@\u0006\u00a2\u0006\f\n\u0004\b\u001d\u0010\u0016\u001a\u0004\b\u001e\u0010\u0018\u00a8\u0006!"}, d2={"Lcom/welink/protocol/nfbd/TranNfbdProfile;", "", "Landroid/bluetooth/BluetoothGattService;", "createNfbdService", "()Landroid/bluetooth/BluetoothGattService;", "", "getReadyMsg", "()[B", "getBusyMsg", "", "ssid", "password", "", "msgPort", "dataPort", "getLocalRequestMsg", "(Ljava/lang/String;Ljava/lang/String;II)[B", "value", "decodeRequestMsg", "([B)Ljava/lang/String;", "Ljava/util/UUID;", "SERVICE_UUID", "Ljava/util/UUID;", "getSERVICE_UUID", "()Ljava/util/UUID;", "CLIENT_DESCRIPTOR", "getCLIENT_DESCRIPTOR", "INCOMING_REMOTE", "getINCOMING_REMOTE", "NOTIFY_REMOTE", "getNOTIFY_REMOTE", "<init>", "()V", "welinkSDK_release"})
public final class TranNfbdProfile {
    @NotNull
    public static final TranNfbdProfile INSTANCE = new TranNfbdProfile();
    @NotNull
    private static final UUID SERVICE_UUID;
    @NotNull
    private static final UUID NOTIFY_REMOTE;
    @NotNull
    private static final UUID INCOMING_REMOTE;
    @NotNull
    private static final UUID CLIENT_DESCRIPTOR;

    private TranNfbdProfile() {
    }

    static {
        UUID uUID = UUID.fromString("0000FD35-0000-1000-8000-00805f9b34fb");
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(\"0000FD35-0000-1000-8000-00805f9b34fb\")");
        SERVICE_UUID = uUID;
        UUID uUID2 = UUID.fromString("00000002-0000-1000-8000-00805f9b34fb");
        Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"fromString(\"00000002-0000-1000-8000-00805f9b34fb\")");
        NOTIFY_REMOTE = uUID2;
        UUID uUID3 = UUID.fromString("00000003-0000-1000-8000-00805f9b34fb");
        Intrinsics.checkNotNullExpressionValue((Object)uUID3, (String)"fromString(\"00000003-0000-1000-8000-00805f9b34fb\")");
        INCOMING_REMOTE = uUID3;
        UUID uUID4 = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");
        Intrinsics.checkNotNullExpressionValue((Object)uUID4, (String)"fromString(\"00002902-0000-1000-8000-00805f9b34fb\")");
        CLIENT_DESCRIPTOR = uUID4;
    }

    @NotNull
    public final UUID getSERVICE_UUID() {
        return SERVICE_UUID;
    }

    @NotNull
    public final UUID getNOTIFY_REMOTE() {
        return NOTIFY_REMOTE;
    }

    @NotNull
    public final UUID getINCOMING_REMOTE() {
        return INCOMING_REMOTE;
    }

    @NotNull
    public final UUID getCLIENT_DESCRIPTOR() {
        return CLIENT_DESCRIPTOR;
    }

    @NotNull
    public final BluetoothGattService createNfbdService() {
        BluetoothGattDescriptor bluetoothGattDescriptor;
        BluetoothGattCharacteristic bluetoothGattCharacteristic;
        BluetoothGattCharacteristic bluetoothGattCharacteristic2;
        BluetoothGattService bluetoothGattService = new BluetoothGattService(SERVICE_UUID, 0);
        TranNfbdProfile tranNfbdProfile = bluetoothGattCharacteristic2;
        bluetoothGattCharacteristic2 = new BluetoothGattCharacteristic(NOTIFY_REMOTE, 30, 17);
        BluetoothGattCharacteristic bluetoothGattCharacteristic3 = bluetoothGattCharacteristic;
        TranNfbdProfile tranNfbdProfile2 = tranNfbdProfile;
        bluetoothGattCharacteristic3(INCOMING_REMOTE, 30, 17);
        tranNfbdProfile = bluetoothGattDescriptor;
        tranNfbdProfile2.addDescriptor(new BluetoothGattDescriptor(CLIENT_DESCRIPTOR, 17));
        bluetoothGattCharacteristic.addDescriptor((BluetoothGattDescriptor)tranNfbdProfile);
        bluetoothGattService.addCharacteristic(bluetoothGattCharacteristic2);
        bluetoothGattService.addCharacteristic(bluetoothGattCharacteristic3);
        return bluetoothGattService;
    }

    @NotNull
    public final byte[] getReadyMsg() {
        return new byte[]{16};
    }

    @NotNull
    public final byte[] getBusyMsg() {
        return new byte[]{-16};
    }

    @Nullable
    public final byte[] getLocalRequestMsg(@NotNull String string, @NotNull String string2, int n2, int n3) {
        JSONObject jSONObject;
        JSONObject jSONObject2;
        JSONObject jSONObject3;
        JSONObject jSONObject4;
        JSONObject jSONObject5;
        JSONObject jSONObject6;
        JSONObject jSONObject7;
        JSONObject jSONObject8;
        Intrinsics.checkNotNullParameter((Object)string, (String)"ssid");
        Intrinsics.checkNotNullParameter((Object)string2, (String)"password");
        try {
            JSONObject jSONObject9;
            jSONObject8 = jSONObject9;
            jSONObject7 = jSONObject9;
            jSONObject6 = jSONObject9;
            jSONObject5 = jSONObject9;
            jSONObject4 = jSONObject9;
            jSONObject3 = jSONObject9;
            jSONObject2 = jSONObject9;
            jSONObject9 = new JSONObject();
            jSONObject = jSONObject9;
            jSONObject9.put("DeviceName", (Object)"laptop");
        }
        catch (JSONException jSONException) {
            LogUtil.INSTANCE.e(Intrinsics.stringPlus((String)"JSONException", (Object)jSONException.getMessage()));
            return null;
        }
        jSONObject3.put("FileCount", 1);
        jSONObject2.put("FileName", (Object)"Connect Notification");
        jSONObject5.put("TotalFileSize", 0L);
        jSONObject4.put("Ssid", (Object)string);
        jSONObject7.put("Pwd", (Object)string2);
        jSONObject6.put("FilePort", n3);
        jSONObject.put("MessagePort", n2);
        String string3 = jSONObject8.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"jsObject.toString()");
        Charset charset = Charset.forName("utf-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"Charset.forName(charsetName)");
        byte[] byArray = string3.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return byArray;
    }

    @Nullable
    public final String decodeRequestMsg(@NotNull byte[] byArray) {
        JSONObject jSONObject;
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"value");
        TranNfbdProfile tranNfbdProfile = jSONObject;
        jSONObject = new JSONObject(new String(byArray, Charsets.UTF_8));
        String string = tranNfbdProfile.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsobject.toString()");
        LogUtil.INSTANCE.i(string);
        jSONObject.getString("FileName");
        jSONObject.getInt("FileSize");
        jSONObject.getInt("FileCount");
        jSONObject.getInt("Port");
        jSONObject.getString("DeviceName");
        return jSONObject.getString("DeviceMac");
    }
}

