/*
 * Decompiled with CFR 0.152.
 */
package com.welink.protocol.nfbd;

import android.bluetooth.le.AdvertiseData;
import android.bluetooth.le.ScanFilter;
import android.os.ParcelUuid;
import com.welink.protocol.nfbd.TranssionBleUtil;
import com.welink.protocol.utils.LogUtil;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0005\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\r\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\bD\u0010EJ\u0017\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0007\u0010\u0005J\u0017\u0010\n\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\f\u0010\u000bJ\r\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\r\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\b\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\b\u00a2\u0006\u0004\b\u0015\u0010\u0014J\r\u0010\u0016\u001a\u00020\r\u00a2\u0006\u0004\b\u0016\u0010\u000fJ\r\u0010\u0017\u001a\u00020\r\u00a2\u0006\u0004\b\u0017\u0010\u000fJ\u0017\u0010\u0018\u001a\u00020\u00102\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\r\u0010\u001a\u001a\u00020\r\u00a2\u0006\u0004\b\u001a\u0010\u000fJ\u0017\u0010\u001b\u001a\u00020\u00102\b\u0010\u0006\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u001b\u0010\u0019J\r\u0010\u001c\u001a\u00020\r\u00a2\u0006\u0004\b\u001c\u0010\u000fR\u001c\u0010\u001e\u001a\u00020\u001d8\u0006@\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\u001e\u0010\u001f\u001a\u0004\b \u0010!R\u001c\u0010\"\u001a\u00020\u001d8\u0006@\u0006X\u0086D\u00a2\u0006\f\n\u0004\b\"\u0010\u001f\u001a\u0004\b#\u0010!R\u001c\u0010$\u001a\u00020\u001d8\u0006@\u0006X\u0086D\u00a2\u0006\f\n\u0004\b$\u0010\u001f\u001a\u0004\b%\u0010!R\u001c\u0010&\u001a\u00020\u001d8\u0006@\u0006X\u0086D\u00a2\u0006\f\n\u0004\b&\u0010\u001f\u001a\u0004\b'\u0010!R\u0019\u0010)\u001a\u00020(8\u0006@\u0006\u00a2\u0006\f\n\u0004\b)\u0010*\u001a\u0004\b+\u0010,R!\u0010/\u001a\n .*\u0004\u0018\u00010-0-8\u0006@\u0006\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b1\u00102R\u0016\u00103\u001a\u00020\b8\u0002@\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b3\u00104R!\u00105\u001a\n .*\u0004\u0018\u00010-0-8\u0006@\u0006\u00a2\u0006\f\n\u0004\b5\u00100\u001a\u0004\b6\u00102R\u001c\u00107\u001a\u00020\u001d8\u0006@\u0006X\u0086D\u00a2\u0006\f\n\u0004\b7\u0010\u001f\u001a\u0004\b8\u0010!R!\u0010:\u001a\n .*\u0004\u0018\u000109098\u0006@\u0006\u00a2\u0006\f\n\u0004\b:\u0010;\u001a\u0004\b<\u0010=R!\u0010>\u001a\n .*\u0004\u0018\u00010-0-8\u0006@\u0006\u00a2\u0006\f\n\u0004\b>\u00100\u001a\u0004\b?\u00102R\u001c\u0010@\u001a\u00020\u001d8\u0006@\u0006X\u0086D\u00a2\u0006\f\n\u0004\b@\u0010\u001f\u001a\u0004\bA\u0010!R!\u0010B\u001a\n .*\u0004\u0018\u00010-0-8\u0006@\u0006\u00a2\u0006\f\n\u0004\bB\u00100\u001a\u0004\bC\u00102\u00a8\u0006F"}, d2={"Lcom/welink/protocol/nfbd/TranssionBleFactory;", "", "", "mac", "getHotspotFastConnectMacInfo", "([B)[B", "pwd", "getHotspotFastConnectPwdInfo", "", "localMac", "getPhoneInfo", "(Ljava/lang/String;)[B", "getDiscoverInfo", "Landroid/bluetooth/le/ScanFilter;", "phoneSwitchHotspotScanFilter", "()Landroid/bluetooth/le/ScanFilter;", "Landroid/bluetooth/le/AdvertiseData;", "getPhoneInfoAdv", "()Landroid/bluetooth/le/AdvertiseData;", "getPhoneInfoAdvResponse", "(Ljava/lang/String;)Landroid/bluetooth/le/AdvertiseData;", "getDiscoverAdv", "screenOnScanFilter", "connectableScanFilter", "getHotspotFastConnectMacAdv", "([B)Landroid/bluetooth/le/AdvertiseData;", "hotspotFastConnectMacScanFilter", "getHotspotFastConnectPwdAdv", "hotspotFastConnectPwdScanFilter", "", "TYPE_HOTSPOT_FAST_CONNECT_PWD", "B", "getTYPE_HOTSPOT_FAST_CONNECT_PWD", "()B", "TYPE_HOTSPOT_FAST_CONNECT_MAC", "getTYPE_HOTSPOT_FAST_CONNECT_MAC", "TYPE_PHONE_SWITCH_HOTSPOT_INFO", "getTYPE_PHONE_SWITCH_HOTSPOT_INFO", "TYPE_DEVICE_FOUND", "getTYPE_DEVICE_FOUND", "", "TRANSSION_MAUN_ID", "I", "getTRANSSION_MAUN_ID", "()I", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "FILE_TRANSFER_SEND_UUID", "Ljava/util/UUID;", "getFILE_TRANSFER_SEND_UUID", "()Ljava/util/UUID;", "TAG", "Ljava/lang/String;", "HOTSPOT_UUID", "getHOTSPOT_UUID", "TYPE_TWS", "getTYPE_TWS", "Landroid/os/ParcelUuid;", "TRAN_SERVICE_UUID", "Landroid/os/ParcelUuid;", "getTRAN_SERVICE_UUID", "()Landroid/os/ParcelUuid;", "FILE_TRANSFER_RECEIVE_UUID", "getFILE_TRANSFER_RECEIVE_UUID", "TYPE_PHONE_SWITCH_DEVICE_INFO", "getTYPE_PHONE_SWITCH_DEVICE_INFO", "DESCRIPTOR_UUID", "getDESCRIPTOR_UUID", "<init>", "()V", "welinkSDK_release"})
public final class TranssionBleFactory {
    @NotNull
    public static final TranssionBleFactory INSTANCE = new TranssionBleFactory();
    @NotNull
    private static final String TAG = "TranssionBleFactory";
    private static final int TRANSSION_MAUN_ID = (UByte.constructor-impl((byte)((byte)9)) & 0xFF) << 8 | (UByte.constructor-impl((byte)((byte)66)) & 0xFF) << 0;
    private static final ParcelUuid TRAN_SERVICE_UUID = ParcelUuid.fromString((String)"0000FD35-0000-1000-8000-00805F9B34FB");
    private static final UUID HOTSPOT_UUID = UUID.fromString("00000001-0000-1000-8000-00805F9B34FB");
    private static final UUID FILE_TRANSFER_RECEIVE_UUID = UUID.fromString("00000002-0000-1000-8000-00805F9B34FB");
    private static final UUID FILE_TRANSFER_SEND_UUID = UUID.fromString("00000003-0000-1000-8000-00805F9B34FB");
    private static final UUID DESCRIPTOR_UUID = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");
    private static final byte TYPE_TWS = 1;
    private static final byte TYPE_HOTSPOT_FAST_CONNECT_MAC = (byte)2;
    private static final byte TYPE_HOTSPOT_FAST_CONNECT_PWD = (byte)3;
    private static final byte TYPE_PHONE_SWITCH_DEVICE_INFO = (byte)4;
    private static final byte TYPE_PHONE_SWITCH_HOTSPOT_INFO = (byte)5;
    private static final byte TYPE_DEVICE_FOUND = (byte)6;

    private TranssionBleFactory() {
    }

    private final byte[] getHotspotFastConnectMacInfo(byte[] byArray) {
        byte[] byArray2 = new byte[8];
        Object object = this = (Object)byArray2;
        object[0] = TYPE_HOTSPOT_FAST_CONNECT_MAC;
        object[1] = true;
        System.arraycopy(byArray, 0, this, 2, 6);
        return byArray2;
    }

    private final byte[] getHotspotFastConnectPwdInfo(byte[] byArray) {
        byte[] byArray2 = new byte[8];
        Object object = this = (Object)byArray2;
        object[0] = TYPE_HOTSPOT_FAST_CONNECT_PWD;
        object[1] = true;
        System.arraycopy(byArray, 0, this, 2, 6);
        return byArray2;
    }

    private final byte[] getPhoneInfo(String string) {
        byte[] byArray = new byte[19];
        Object object = byArray;
        byArray[0] = 15;
        byArray[1] = 0;
        TranssionBleUtil transsionBleUtil = TranssionBleUtil.INSTANCE;
        byte[] byArray2 = transsionBleUtil.getPhoneTag(string);
        int n2 = byArray2.length;
        System.arraycopy(byArray2, 0, object, 2, n2);
        LogUtil logUtil = LogUtil.INSTANCE;
        logUtil.i(transsionBleUtil.printHexBinary((byte[])object));
        System.arraycopy(new byte[]{2, 17, 1}, 0, object, 16, 3);
        logUtil.i(transsionBleUtil.printHexBinary((byte[])object));
        return byArray;
    }

    private final byte[] getDiscoverInfo(String string) {
        byte[] byArray = new byte[19];
        Object object = byArray;
        byArray[0] = 15;
        byArray[1] = 0;
        TranssionBleUtil transsionBleUtil = TranssionBleUtil.INSTANCE;
        byte[] byArray2 = transsionBleUtil.getPhoneTag(string);
        int n2 = byArray2.length;
        System.arraycopy(byArray2, 0, object, 2, n2);
        LogUtil logUtil = LogUtil.INSTANCE;
        logUtil.i(transsionBleUtil.printHexBinary((byte[])object));
        System.arraycopy(new byte[]{2, 16, 1}, 0, object, 16, 3);
        logUtil.i(transsionBleUtil.printHexBinary((byte[])object));
        return byArray;
    }

    public final int getTRANSSION_MAUN_ID() {
        return TRANSSION_MAUN_ID;
    }

    public final ParcelUuid getTRAN_SERVICE_UUID() {
        return TRAN_SERVICE_UUID;
    }

    public final UUID getHOTSPOT_UUID() {
        return HOTSPOT_UUID;
    }

    public final UUID getFILE_TRANSFER_RECEIVE_UUID() {
        return FILE_TRANSFER_RECEIVE_UUID;
    }

    public final UUID getFILE_TRANSFER_SEND_UUID() {
        return FILE_TRANSFER_SEND_UUID;
    }

    public final UUID getDESCRIPTOR_UUID() {
        return DESCRIPTOR_UUID;
    }

    public final byte getTYPE_TWS() {
        return TYPE_TWS;
    }

    public final byte getTYPE_HOTSPOT_FAST_CONNECT_MAC() {
        return TYPE_HOTSPOT_FAST_CONNECT_MAC;
    }

    public final byte getTYPE_HOTSPOT_FAST_CONNECT_PWD() {
        return TYPE_HOTSPOT_FAST_CONNECT_PWD;
    }

    public final byte getTYPE_PHONE_SWITCH_DEVICE_INFO() {
        return TYPE_PHONE_SWITCH_DEVICE_INFO;
    }

    public final byte getTYPE_PHONE_SWITCH_HOTSPOT_INFO() {
        return TYPE_PHONE_SWITCH_HOTSPOT_INFO;
    }

    public final byte getTYPE_DEVICE_FOUND() {
        return TYPE_DEVICE_FOUND;
    }

    @NotNull
    public final ScanFilter phoneSwitchHotspotScanFilter() {
        ScanFilter scanFilter = new ScanFilter.Builder().setManufacturerData(TRANSSION_MAUN_ID, new byte[]{TYPE_PHONE_SWITCH_HOTSPOT_INFO}).build();
        Intrinsics.checkNotNullExpressionValue((Object)scanFilter, (String)"Builder()\n            .setManufacturerData(TRANSSION_MAUN_ID, byteArrayOf(TYPE_PHONE_SWITCH_HOTSPOT_INFO))\n            .build()");
        return scanFilter;
    }

    @NotNull
    public final AdvertiseData getPhoneInfoAdv() {
        AdvertiseData advertiseData = new AdvertiseData.Builder().addManufacturerData(TRANSSION_MAUN_ID, new byte[]{0}).setIncludeDeviceName(true).build();
        Intrinsics.checkNotNullExpressionValue((Object)advertiseData, (String)"Builder()\n            .addManufacturerData(TRANSSION_MAUN_ID, byteArrayOf(0x00))\n            .setIncludeDeviceName(true)\n            .build()");
        return advertiseData;
    }

    @NotNull
    public final AdvertiseData getPhoneInfoAdvResponse(@NotNull String string) {
        AdvertiseData.Builder builder;
        Intrinsics.checkNotNullParameter((Object)string, (String)"mac");
        AdvertiseData.Builder builder2 = builder;
        builder2();
        int n2 = TRANSSION_MAUN_ID;
        AdvertiseData advertiseData = builder.addManufacturerData(n2, this.getPhoneInfo(string)).setIncludeDeviceName(false).build();
        Intrinsics.checkNotNullExpressionValue((Object)advertiseData, (String)"Builder()\n            .addManufacturerData(TRANSSION_MAUN_ID, getPhoneInfo(mac))\n            .setIncludeDeviceName(false)\n            .build()");
        return advertiseData;
    }

    @NotNull
    public final AdvertiseData getDiscoverAdv(@NotNull String string) {
        AdvertiseData.Builder builder;
        Intrinsics.checkNotNullParameter((Object)string, (String)"mac");
        AdvertiseData.Builder builder2 = builder;
        builder2();
        int n2 = TRANSSION_MAUN_ID;
        AdvertiseData advertiseData = builder.addManufacturerData(n2, this.getDiscoverInfo(string)).setIncludeDeviceName(false).build();
        Intrinsics.checkNotNullExpressionValue((Object)advertiseData, (String)"Builder()\n            .addManufacturerData(TRANSSION_MAUN_ID, getDiscoverInfo(mac))\n            .setIncludeDeviceName(false)\n            .build()");
        return advertiseData;
    }

    @NotNull
    public final ScanFilter screenOnScanFilter() {
        ScanFilter scanFilter = new ScanFilter.Builder().setManufacturerData(TRANSSION_MAUN_ID, new byte[]{15}).build();
        Intrinsics.checkNotNullExpressionValue((Object)scanFilter, (String)"Builder()\n            .setManufacturerData(TRANSSION_MAUN_ID, byteArrayOf(0x0f))\n            .build()");
        return scanFilter;
    }

    @NotNull
    public final ScanFilter connectableScanFilter() {
        ScanFilter scanFilter = new ScanFilter.Builder().setServiceUuid(TRAN_SERVICE_UUID).build();
        Intrinsics.checkNotNullExpressionValue((Object)scanFilter, (String)"Builder()\n            .setServiceUuid(TRAN_SERVICE_UUID)\n            .build()");
        return scanFilter;
    }

    @NotNull
    public final AdvertiseData getHotspotFastConnectMacAdv(@Nullable byte[] byArray) {
        AdvertiseData.Builder builder;
        AdvertiseData.Builder builder2 = builder;
        builder = new AdvertiseData.Builder();
        int n2 = TRANSSION_MAUN_ID;
        if (byArray != null) {
            AdvertiseData advertiseData = builder2.addManufacturerData(n2, this.getHotspotFastConnectMacInfo(byArray)).setIncludeDeviceName(false).build();
            Intrinsics.checkNotNullExpressionValue((Object)advertiseData, (String)"Builder()\n            .addManufacturerData(TRANSSION_MAUN_ID, getHotspotFastConnectMacInfo(mac as ByteArray))\n            .setIncludeDeviceName(false)\n            .build()");
            return advertiseData;
        }
        throw new NullPointerException("null cannot be cast to non-null type kotlin.ByteArray");
    }

    @NotNull
    public final ScanFilter hotspotFastConnectMacScanFilter() {
        ScanFilter scanFilter = new ScanFilter.Builder().setManufacturerData(TRANSSION_MAUN_ID, new byte[]{TYPE_HOTSPOT_FAST_CONNECT_MAC}).build();
        Intrinsics.checkNotNullExpressionValue((Object)scanFilter, (String)"Builder()\n            .setManufacturerData(TRANSSION_MAUN_ID, byteArrayOf(TYPE_HOTSPOT_FAST_CONNECT_MAC))\n            .build()");
        return scanFilter;
    }

    @NotNull
    public final AdvertiseData getHotspotFastConnectPwdAdv(@Nullable byte[] byArray) {
        AdvertiseData.Builder builder;
        AdvertiseData.Builder builder2 = builder;
        builder = new AdvertiseData.Builder();
        int n2 = TRANSSION_MAUN_ID;
        if (byArray != null) {
            AdvertiseData advertiseData = builder2.addManufacturerData(n2, this.getHotspotFastConnectPwdInfo(byArray)).setIncludeDeviceName(false).build();
            Intrinsics.checkNotNullExpressionValue((Object)advertiseData, (String)"Builder()\n            .addManufacturerData(TRANSSION_MAUN_ID, getHotspotFastConnectPwdInfo(pwd as ByteArray))\n            .setIncludeDeviceName(false)\n            .build()");
            return advertiseData;
        }
        throw new NullPointerException("null cannot be cast to non-null type kotlin.ByteArray");
    }

    @NotNull
    public final ScanFilter hotspotFastConnectPwdScanFilter() {
        ScanFilter scanFilter = new ScanFilter.Builder().setManufacturerData(TRANSSION_MAUN_ID, new byte[]{TYPE_HOTSPOT_FAST_CONNECT_PWD}).build();
        Intrinsics.checkNotNullExpressionValue((Object)scanFilter, (String)"Builder()\n            .setManufacturerData(TRANSSION_MAUN_ID, byteArrayOf(TYPE_HOTSPOT_FAST_CONNECT_PWD))\n            .build()");
        return scanFilter;
    }
}

