/*
 * Decompiled with CFR 0.152.
 */
package com.welink.protocol.nfbd;

import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.os.SystemProperties;
import com.welink.protocol.nfbd.TranssionBleFactory;
import com.welink.protocol.utils.LogUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\"B\t\b\u0002\u00a2\u0006\u0004\b \u0010!J\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\b\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\u0004\b\b\u0010\tJ\u0019\u0010\n\u001a\u0004\u0018\u00010\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\n\u0010\u0006J\u0015\u0010\f\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\tJ\u0015\u0010\r\u001a\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\r\u0010\tJ%\u0010\u0012\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000f2\u0006\u0010\u000e\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J!\u0010\u0019\u001a\u0004\u0018\u00010\u00182\b\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0017\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\u00020\u00108\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\u00020\u00048\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0016\u0010\u001f\u001a\u00020\u00108\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001c\u00a8\u0006#"}, d2={"Lcom/welink/protocol/nfbd/TranssionBleUtil;", "", "", "data", "", "printHexBinary", "([B)Ljava/lang/String;", "address", "getBytesFromAddress", "(Ljava/lang/String;)[B", "getAddressStringFromByte", "localMac", "getPhoneTag", "string2Hex", "resultData", "Ljava/util/HashMap;", "", "Lcom/welink/protocol/nfbd/TranssionBleUtil$PhoneCapacity;", "decodeDeviceFoundData", "([B)Ljava/util/HashMap;", "Landroid/bluetooth/BluetoothGatt;", "gatt", "Ljava/util/UUID;", "uuid", "Landroid/bluetooth/BluetoothGattCharacteristic;", "getCharacteristic", "(Landroid/bluetooth/BluetoothGatt;Ljava/util/UUID;)Landroid/bluetooth/BluetoothGattCharacteristic;", "BD_UUID_LEN", "I", "TAG", "Ljava/lang/String;", "BD_ADDR_LEN", "<init>", "()V", "PhoneCapacity", "welinkSDK_release"})
public final class TranssionBleUtil {
    @NotNull
    public static final TranssionBleUtil INSTANCE = new TranssionBleUtil();
    @NotNull
    private static final String TAG = "TranssionBleUtil";
    public static final int BD_ADDR_LEN = 6;
    public static final int BD_UUID_LEN = 16;

    private TranssionBleUtil() {
    }

    @NotNull
    public final String printHexBinary(@NotNull byte[] byArray) {
        StringBuilder stringBuilder;
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"data");
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        for (byte by : byArray) {
            String string = String.format("0x%02X ", Arrays.copyOf(new Object[]{by}, 1));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"java.lang.String.format(format, *args)");
            stringBuilder2.append(string);
        }
        String string = stringBuilder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"r.toString()");
        return string;
    }

    @NotNull
    public final byte[] getBytesFromAddress(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"address");
        int n2 = 0;
        byte[] byArray = new byte[6];
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) == ':') continue;
            int n3 = i2++;
            String string2 = string.substring(n3, n3 + 2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            byArray[n2] = (byte)Integer.parseInt(string2, CharsKt.checkRadix((int)16));
            ++n2;
        }
        return byArray;
    }

    @Nullable
    public final String getAddressStringFromByte(@Nullable byte[] byArray) {
        Object object;
        if (byArray != null && byArray.length == 6) {
            Object[] objectArray = new Object[6];
            object = objectArray;
            object[0] = byArray[0];
            object[1] = byArray[1];
            object[2] = byArray[2];
            object[3] = byArray[3];
            object[4] = byArray[4];
            objectArray[5] = byArray[5];
            object = String.format("%02X:%02X:%02X:%02X:%02X:%02X", Arrays.copyOf(objectArray, 6));
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"java.lang.String.format(format, *args)");
        } else {
            object = null;
        }
        return object;
    }

    @NotNull
    public final byte[] getPhoneTag(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"localMac");
        Object object = SystemProperties.get((String)"persist.sys.nfbd.temptag");
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(\"persist.sys.nfbd.temptag\")");
        LogUtil logUtil = LogUtil.INSTANCE;
        logUtil.i(Intrinsics.stringPlus((String)"tempTag : ", (Object)object));
        byte[] byArray = new byte[14];
        byte[] byArray2 = this.string2Hex((String)object);
        object = byArray2;
        logUtil.i(this.printHexBinary((byte[])object));
        int n2 = byArray2.length;
        System.arraycopy(byArray2, 0, byArray, 0, n2);
        byte[] byArray3 = new byte[9];
        byArray3[0] = 1;
        byArray3[1] = 6;
        System.arraycopy(this.getBytesFromAddress(string), 0, byArray3, 2, 6);
        byArray3[8] = 1;
        int n3 = ((Object)object).length;
        System.arraycopy(byArray3, 0, byArray, n3, 9);
        logUtil.i(this.printHexBinary(byArray));
        return byArray;
    }

    @NotNull
    public final byte[] string2Hex(@NotNull String object) {
        String string = object;
        Intrinsics.checkNotNullParameter((Object)string, (String)"data");
        int n2 = 0;
        char[] cArray = string.toCharArray();
        object = cArray;
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        byte[] byArray = new byte[cArray.length / 2];
        for (int n3 = 0; n3 < ((Object)object).length; n3 = (int)((byte)(n3 + 2))) {
            block6: {
                block10: {
                    Object object2;
                    Object object3;
                    block8: {
                        block9: {
                            block7: {
                                block4: {
                                    block5: {
                                        block3: {
                                            object3 = object[n3];
                                            object2 = object[n3 + 1];
                                            if (!(48 <= object3 && object3 <= 57)) break block3;
                                            object3 = (byte)(object3 - 48);
                                            break block4;
                                        }
                                        if (!(65 <= object3 && object3 <= 70)) break block5;
                                        object3 = (byte)(object3 - 65 + 10);
                                        break block4;
                                    }
                                    if (!(97 <= object3 && object3 <= 102)) break block6;
                                    object3 = (byte)(object3 - 97 + 10);
                                }
                                if (!(48 <= object2 && object2 <= 57)) break block7;
                                object2 = (byte)(object2 - 48);
                                break block8;
                            }
                            if (!(65 <= object2 && object2 <= 70)) break block9;
                            object2 = (byte)(object2 - 65 + 10);
                            break block8;
                        }
                        if (!(97 <= object2 && object2 <= 102)) break block10;
                        object2 = (byte)(object2 - 97 + 10);
                    }
                    int n4 = n2;
                    n2 = (byte)(n2 + 1);
                    byArray[n4] = (byte)(object3 << 4 | object2);
                    continue;
                }
                return byArray;
            }
            return byArray;
        }
        return byArray;
    }

    @NotNull
    public final HashMap<Integer, PhoneCapacity> decodeDeviceFoundData(@NotNull byte[] byArray) {
        byte by;
        HashMap<Integer, PhoneCapacity> hashMap;
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"resultData");
        HashMap<Integer, PhoneCapacity> hashMap2 = hashMap;
        hashMap = new HashMap<Integer, PhoneCapacity>();
        for (int i2 = 0; i2 < byArray.length; i2 += by + 1) {
            int n2;
            PhoneCapacity phoneCapacity;
            PhoneCapacity phoneCapacity2 = phoneCapacity;
            phoneCapacity = new PhoneCapacity();
            by = byArray[i2];
            if (by <= 0 || (n2 = i2 + by) >= byArray.length) break;
            phoneCapacity2.setType(byArray[i2 + 1]);
            phoneCapacity2.setData(ArraysKt.copyOfRange((byte[])byArray, (int)(i2 + 2), (int)(n2 + 1)));
            hashMap2.put(phoneCapacity2.getType(), phoneCapacity2);
            LogUtil.INSTANCE.i(phoneCapacity2.toString());
        }
        return hashMap2;
    }

    @Nullable
    public final BluetoothGattCharacteristic getCharacteristic(@Nullable BluetoothGatt bluetoothGatt2, @NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"uuid");
        if (bluetoothGatt2 == null) {
            LogUtil.INSTANCE.i("GATT NULL");
            return null;
        }
        BluetoothGattService bluetoothGattService = bluetoothGatt2.getService(TranssionBleFactory.INSTANCE.getTRAN_SERVICE_UUID().getUuid());
        if (bluetoothGattService == null) {
            LogUtil.INSTANCE.i("GATT Service NULL");
            return null;
        }
        List list = bluetoothGattService.getCharacteristics();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"gattService.characteristics");
        for (BluetoothGatt bluetoothGatt2 : list) {
            UUID uUID2 = bluetoothGatt2.getUuid();
            Intrinsics.checkNotNullExpressionValue((Object)uUID2, (String)"c.uuid");
            LogUtil.INSTANCE.i(Intrinsics.stringPlus((String)"characteristic : ", (Object)uUID2));
            if (!Intrinsics.areEqual((Object)bluetoothGatt2.getUuid(), (Object)uUID)) continue;
            return bluetoothGatt2;
        }
        return null;
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0003\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004R$\u0010\u0006\u001a\u0004\u0018\u00010\u00058\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\"\u0010\r\u001a\u00020\f8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lcom/welink/protocol/nfbd/TranssionBleUtil$PhoneCapacity;", "", "", "toString", "()Ljava/lang/String;", "", "data", "[B", "getData", "()[B", "setData", "([B)V", "", "type", "I", "getType", "()I", "setType", "(I)V", "<init>", "()V", "welinkSDK_release"})
    public static final class PhoneCapacity {
        private int type;
        @Nullable
        private byte[] data;

        public final int getType() {
            return this.type;
        }

        public final void setType(int n2) {
            this.type = n2;
        }

        @Nullable
        public final byte[] getData() {
            return this.data;
        }

        public final void setData(@Nullable byte[] byArray) {
            this.data = byArray;
        }

        @NotNull
        public String toString() {
            PhoneCapacity phoneCapacity = stringBuilder;
            StringBuilder stringBuilder = new StringBuilder().append("type : ").append(((PhoneCapacity)((Object)stringBuilder)).type).append(" data : ");
            TranssionBleUtil transsionBleUtil = INSTANCE;
            byte[] byArray = phoneCapacity.data;
            if (phoneCapacity.data != null) {
                return stringBuilder.append(transsionBleUtil.printHexBinary(byArray)).toString();
            }
            throw new NullPointerException("null cannot be cast to non-null type kotlin.ByteArray");
        }
    }
}

