/*
 * Decompiled with CFR 0.152.
 */
package com.welink.protocol.nfbd;

import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.wifi.WifiManager;
import com.transsion.kolun.kolunscanner.KolunScannerManager;
import com.welink.protocol.nfbd.TranProfileConfig;
import com.welink.protocol.utils.LogUtil;
import com.welink.protocol.utils.SingleArgSingletonHolder;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 *2\u00020\u0001:\u0002*+B\u0011\b\u0002\u0012\u0006\u0010 \u001a\u00020\u001f\u00a2\u0006\u0004\b(\u0010)J\u000f\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0017\u0010\u0007\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0017\u0010\t\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\t\u0010\bJ\u0017\u0010\n\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\n\u0010\bJ\u0017\u0010\u000b\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u000b\u0010\bJ1\u0010\u0010\u001a\u00020\u00022\u0010\u0010\u000e\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\f2\u0006\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0005H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\r\u0010\u0012\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0004J\u0015\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0013\u0010\bJ\r\u0010\u0014\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0016\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0016\u0010\bJ\r\u0010\u0017\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0004J\r\u0010\u0018\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0004R\u0016\u0010\u001a\u001a\u00020\u00198\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001d\u001a\b\u0018\u00010\u001cR\u00020\u00008\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0016\u0010 \u001a\u00020\u001f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b \u0010!R\u0018\u0010#\u001a\u0004\u0018\u00010\"8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0018\u0010&\u001a\u0004\u0018\u00010%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b&\u0010'\u00a8\u0006,"}, d2={"Lcom/welink/protocol/nfbd/TranssionBluetoothManager;", "", "", "onEnableWirelessAdapter", "()V", "", "value", "doStart", "(I)V", "doStop", "startProfileServices", "stopProfileServices", "Ljava/util/ArrayList;", "Ljava/lang/Class;", "services", "state", "setAllProfileServiceStates", "(Ljava/util/ArrayList;II)V", "onWirelessStateChanged", "onSmartConnStateChanged", "onGetSmartConnState", "()I", "onSetSmartConnState", "onAutoSmartConnState", "stop", "", "mSmartState", "Z", "Lcom/welink/protocol/nfbd/TranssionBluetoothManager$TranssionScanEventReceiver;", "mReceiver", "Lcom/welink/protocol/nfbd/TranssionBluetoothManager$TranssionScanEventReceiver;", "Landroid/content/Context;", "mContext", "Landroid/content/Context;", "Landroid/bluetooth/BluetoothAdapter;", "mAdapter", "Landroid/bluetooth/BluetoothAdapter;", "Landroid/net/wifi/WifiManager;", "mWifiManager", "Landroid/net/wifi/WifiManager;", "<init>", "(Landroid/content/Context;)V", "Companion", "TranssionScanEventReceiver", "welinkSDK_release"})
public final class TranssionBluetoothManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String TAG = "TranssionBluetoothManager";
    @NotNull
    private static final String ACTION_PRE_QUICK_CONNECT = "transsion.nfbd.wlan.action.QUICK_PRE_CONNECT";
    @NotNull
    private static final String ACTION_QUICK_CONNECT = "transsion.nfbd.wlan.action.QUICK_CONNECT";
    @NotNull
    private static final String ACTION_QUICK_PWD = "transsion.nfbd.wlan.action.QUICK_CONNECT_PWD";
    @NotNull
    private static final String ACTION_QUICK_SELECT_RESULT = "transsion.nfbd.wlan.action.QUICK_CONNECT_SELECT_RESULT";
    @NotNull
    private static final String ACTION_GET_SMART_CONNECT_STATUS = "transsion.bluetooth.intent.action.GET_SMART_CONNECT_STATUS";
    @NotNull
    private static final String ACTION_SET_SMART_CONNECT_STATUS = "transsion.bluetooth.intent.action.SET_SMART_CONNECT_STATUS";
    @NotNull
    private static final String ACTION_SMART_CONNECT_STATUS = "transsion.bluetooth.intent.action.SMART_CONNECT_STATUS";
    @NotNull
    private static final String ACTION_SMART_CONNECT_STATUS_CHANGED = "transsion.bluetooth.intent.action.SMART_CONNECT_STATUS_CHANGED";
    @NotNull
    private static final String EXTRA_STATE = "state";
    @NotNull
    public static final String EXTRA_ACTION = "action";
    @NotNull
    public static final String EXTRA_SMART_STATE = "smart_state";
    @NotNull
    public static final String ACTION_SERVICE_STATE_CHANGED = "com.android.bluetooth.btservice.action.STATE_CHANGED";
    public static final int EVENT_SMART_CONFIG_DISABLED = 0;
    public static final int EVENT_SMART_CONFIG_ENABLED = 1;
    public static final int EVENT_BLUETOOTH_ENABLED = 2;
    public static final int EVENT_BLUETOOTH_DISABLED = 2;
    public static final int EVENT_SERVICE_DESTROYED = 3;
    public static final int EVENT_WIFI_ENABLED = 4;
    public static final int EVENT_WIFI_DISABLED = 4;
    public static final int EVENT_SERVICE_RECOVERED = 5;
    @NotNull
    private Context mContext;
    @Nullable
    private TranssionScanEventReceiver mReceiver;
    @Nullable
    private BluetoothAdapter mAdapter;
    @Nullable
    private WifiManager mWifiManager;
    private boolean mSmartState;

    private TranssionBluetoothManager(Context object) {
        this.mContext = object;
        TranProfileConfig tranProfileConfig = TranProfileConfig.INSTANCE;
        tranProfileConfig.init(object.getApplicationContext());
        this.mReceiver = new TranssionScanEventReceiver();
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        object = this.mContext.getSystemService("wifi");
        if (object != null) {
            IntentFilter intentFilter;
            this.mWifiManager = (WifiManager)object;
            this.mSmartState = false;
            object = intentFilter;
            new IntentFilter().addAction("android.bluetooth.adapter.action.STATE_CHANGED");
            object.addAction("android.net.wifi.WIFI_STATE_CHANGED");
            this.mContext.registerReceiver((BroadcastReceiver)this.mReceiver, (IntentFilter)object);
            tranProfileConfig.getSupportedProfiles();
            return;
        }
        throw new NullPointerException("null cannot be cast to non-null type android.net.wifi.WifiManager");
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void onEnableWirelessAdapter() {
        if (KolunScannerManager.getInstance().isKolunExists()) {
            WifiManager wifiManager = transsionBluetoothManager.mWifiManager;
            if (wifiManager != null && !wifiManager.isWifiEnabled()) {
                KolunScannerManager.getInstance().setWifiEnable(true);
            }
            if (!((transsionBluetoothManager = transsionBluetoothManager.mAdapter) != null && !transsionBluetoothManager.isEnabled())) return;
            KolunScannerManager.getInstance().enableBluetooth(true);
            return;
        }
        WifiManager wifiManager = transsionBluetoothManager.mWifiManager;
        if (wifiManager != null && !wifiManager.isWifiEnabled() && (wifiManager = transsionBluetoothManager.mWifiManager) != null) {
            wifiManager.setWifiEnabled(true);
        }
        if (!((wifiManager = transsionBluetoothManager.mAdapter) != null && !wifiManager.isEnabled())) return;
        TranssionBluetoothManager transsionBluetoothManager = transsionBluetoothManager.mAdapter;
        if (transsionBluetoothManager == null) {
            return;
        }
        transsionBluetoothManager.enable();
    }

    private final void doStart(int n2) {
        this.startProfileServices(n2);
    }

    private final void doStop(int n2) {
        this.stopProfileServices(n2);
    }

    private final void startProfileServices(int n2) {
        LogUtil.INSTANCE.i("startTranProfileManager()");
        this.setAllProfileServiceStates(TranProfileConfig.INSTANCE.getSupportedProfiles(), 12, n2);
    }

    private final void stopProfileServices(int n2) {
        LogUtil.INSTANCE.i("stopTranProfileManager()");
        this.setAllProfileServiceStates(TranProfileConfig.INSTANCE.getSupportedProfiles(), 10, n2);
    }

    private final void setAllProfileServiceStates(ArrayList<Class<?>> object, int n2, int n3) {
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            Intent intent;
            Class clazz = (Class)object.next();
            LogUtil.INSTANCE.i("Context packname " + this.mContext.getPackageName() + " Service name is " + clazz.getName());
            Intent intent2 = intent;
            new Intent(this.mContext.getApplicationContext(), clazz).putExtra(EXTRA_ACTION, ACTION_SERVICE_STATE_CHANGED);
            intent2.putExtra(EXTRA_SMART_STATE, n3);
            intent2.putExtra("android.bluetooth.adapter.extra.STATE", n2);
            this.mContext.startService(intent2);
        }
    }

    public /* synthetic */ TranssionBluetoothManager(Context context, DefaultConstructorMarker defaultConstructorMarker) {
        this(context);
    }

    public final void onWirelessStateChanged() {
        boolean bl = this.mSmartState;
        TranssionBluetoothManager transsionBluetoothManager = this;
        BluetoothAdapter bluetoothAdapter = transsionBluetoothManager.mAdapter;
        Intrinsics.checkNotNull((Object)bluetoothAdapter);
        boolean bl2 = bluetoothAdapter.isEnabled();
        WifiManager wifiManager = transsionBluetoothManager.mWifiManager;
        Intrinsics.checkNotNull((Object)wifiManager);
        boolean bl3 = wifiManager.isWifiEnabled();
        LogUtil.INSTANCE.i("isSmartConnectEnable : " + bl + " isBluetoothEnable : " + bl2 + " isWifiEnable : " + bl3);
        if (bl && bl2 && bl3) {
            this.doStart(1);
        } else {
            this.doStop(0);
        }
    }

    public final void onSmartConnStateChanged(int n2) {
        LogUtil.INSTANCE.i(Intrinsics.stringPlus((String)"state : ", (Object)n2));
        if (n2 != 0) {
            if (n2 != 1) {
                if (n2 == 2) {
                    this.mSmartState = false;
                }
            } else {
                this.mSmartState = true;
                this.doStart(1);
            }
        } else {
            this.mSmartState = false;
            this.doStop(0);
        }
    }

    public final int onGetSmartConnState() {
        TranssionBluetoothManager transsionBluetoothManager = object2;
        boolean bl = transsionBluetoothManager.mSmartState;
        int n2 = 0;
        LogUtil.INSTANCE.i(Intrinsics.stringPlus((String)"state : ", (Object)bl));
        Object object = transsionBluetoothManager.mAdapter;
        object = object == null ? null : Boolean.valueOf(object.isEnabled());
        Object object2 = ((TranssionBluetoothManager)object2).mWifiManager;
        object2 = object2 == null ? null : Boolean.valueOf(object2.isWifiEnabled());
        if (bl && (Intrinsics.areEqual((Object)object, (Object)(object = Boolean.FALSE)) || Intrinsics.areEqual((Object)object2, (Object)object))) {
            n2 = 2;
        } else if (bl) {
            n2 = 1;
        }
        return n2;
    }

    public final void onSetSmartConnState(int n2) {
        if (n2 == 1) {
            TranssionBluetoothManager transsionBluetoothManager = this;
            transsionBluetoothManager.mSmartState = true;
            transsionBluetoothManager.onEnableWirelessAdapter();
            transsionBluetoothManager.doStart(1);
        }
    }

    public final void onAutoSmartConnState() {
        this.onWirelessStateChanged();
    }

    public final void stop() {
        this.doStop(0);
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0016\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\u000b"}, d2={"Lcom/welink/protocol/nfbd/TranssionBluetoothManager$TranssionScanEventReceiver;", "Landroid/content/BroadcastReceiver;", "Landroid/content/Context;", "context", "Landroid/content/Intent;", "intent", "", "onReceive", "(Landroid/content/Context;Landroid/content/Intent;)V", "<init>", "(Lcom/welink/protocol/nfbd/TranssionBluetoothManager;)V", "welinkSDK_release"})
    public final class TranssionScanEventReceiver
    extends BroadcastReceiver {
        public TranssionScanEventReceiver() {
            Intrinsics.checkNotNullParameter((Object)TranssionBluetoothManager.this, (String)"this$0");
        }

        /*
         * WARNING - void declaration
         */
        public void onReceive(@NotNull Context object, @NotNull Intent intent) {
            void var2_7;
            void v0 = var2_7;
            Intrinsics.checkNotNullParameter((Object)object, (String)"context");
            Intrinsics.checkNotNullParameter((Object)v0, (String)"intent");
            String bl = v0.getAction();
            LogUtil logUtil = LogUtil.INSTANCE;
            logUtil.i(Intrinsics.stringPlus((String)"onReceive : ", (Object)bl));
            if (Intrinsics.areEqual((Object)bl, (Object)"android.bluetooth.adapter.action.STATE_CHANGED")) {
                int bl2 = var2_7.getIntExtra("android.bluetooth.adapter.extra.PREVIOUS_STATE", Integer.MIN_VALUE);
                int n2 = var2_7.getIntExtra("android.bluetooth.adapter.extra.STATE", Integer.MIN_VALUE);
                logUtil.i("BT state change " + bl2 + " -> " + n2);
                if (bl2 == 12) {
                    TranssionBluetoothManager.this.doStop(2);
                } else if (n2 == 12) {
                    boolean bl3 = TranssionBluetoothManager.this.mSmartState;
                    WifiManager wifiManager = TranssionBluetoothManager.this.mWifiManager;
                    Intrinsics.checkNotNull((Object)wifiManager);
                    boolean bl4 = wifiManager.isWifiEnabled();
                    logUtil.i("isSmartConnectEnable : " + bl3 + " isWifiEnable : " + bl4);
                    if (bl3 && bl4) {
                        TranssionBluetoothManager.this.doStart(2);
                    }
                }
            } else if (Intrinsics.areEqual((Object)bl, (Object)"android.net.wifi.WIFI_STATE_CHANGED")) {
                int n3 = var2_7.getIntExtra("previous_wifi_state", 4);
                int n4 = var2_7.getIntExtra("wifi_state", 4);
                logUtil.i("WIFI state change " + n3 + " -> " + n4);
                if (n3 == 3) {
                    TranssionBluetoothManager.this.doStop(4);
                } else if (n4 == 3) {
                    boolean bl5 = TranssionBluetoothManager.this.mSmartState;
                    BluetoothAdapter bluetoothAdapter = TranssionBluetoothManager.this.mAdapter;
                    Intrinsics.checkNotNull((Object)bluetoothAdapter);
                    boolean bl6 = bluetoothAdapter.isEnabled();
                    logUtil.i("isSmartConnectEnable : " + bl5 + " isBluetoothEnable : " + bl6);
                    if (bl5 && bl6) {
                        TranssionBluetoothManager.this.doStart(4);
                    }
                }
            }
        }
    }

    @Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0010\b\u0086\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u0016\u0010\u0005\u001a\u00020\u00048\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u00020\u00048\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0016\u0010\b\u001a\u00020\u00048\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0006R\u0016\u0010\t\u001a\u00020\u00048\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\t\u0010\u0006R\u0016\u0010\n\u001a\u00020\u00048\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u0006R\u0016\u0010\u000b\u001a\u00020\u00048\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0006R\u0016\u0010\f\u001a\u00020\u00048\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\f\u0010\u0006R\u0016\u0010\r\u001a\u00020\u00048\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0006R\u0016\u0010\u000e\u001a\u00020\u00048\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000e\u0010\u0006R\u0016\u0010\u0010\u001a\u00020\u000f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\u00020\u000f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0011R\u0016\u0010\u0013\u001a\u00020\u000f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0011R\u0016\u0010\u0014\u001a\u00020\u000f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0011R\u0016\u0010\u0015\u001a\u00020\u000f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u0011R\u0016\u0010\u0016\u001a\u00020\u000f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0011R\u0016\u0010\u0017\u001a\u00020\u000f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0017\u0010\u0011R\u0016\u0010\u0018\u001a\u00020\u000f8\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0011R\u0016\u0010\u0019\u001a\u00020\u00048\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u0006R\u0016\u0010\u001a\u001a\u00020\u00048\u0006@\u0006X\u0086T\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u0006R\u0016\u0010\u001b\u001a\u00020\u00048\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u0006R\u0016\u0010\u001c\u001a\u00020\u00048\u0002@\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u0006\u00a8\u0006\u001f"}, d2={"Lcom/welink/protocol/nfbd/TranssionBluetoothManager$Companion;", "Lcom/welink/protocol/utils/SingleArgSingletonHolder;", "Lcom/welink/protocol/nfbd/TranssionBluetoothManager;", "Landroid/content/Context;", "", "ACTION_GET_SMART_CONNECT_STATUS", "Ljava/lang/String;", "ACTION_PRE_QUICK_CONNECT", "ACTION_QUICK_CONNECT", "ACTION_QUICK_PWD", "ACTION_QUICK_SELECT_RESULT", "ACTION_SERVICE_STATE_CHANGED", "ACTION_SET_SMART_CONNECT_STATUS", "ACTION_SMART_CONNECT_STATUS", "ACTION_SMART_CONNECT_STATUS_CHANGED", "", "EVENT_BLUETOOTH_DISABLED", "I", "EVENT_BLUETOOTH_ENABLED", "EVENT_SERVICE_DESTROYED", "EVENT_SERVICE_RECOVERED", "EVENT_SMART_CONFIG_DISABLED", "EVENT_SMART_CONFIG_ENABLED", "EVENT_WIFI_DISABLED", "EVENT_WIFI_ENABLED", "EXTRA_ACTION", "EXTRA_SMART_STATE", "EXTRA_STATE", "TAG", "<init>", "()V", "welinkSDK_release"})
    public static final class Companion
    extends SingleArgSingletonHolder<TranssionBluetoothManager, Context> {
        private Companion() {
            super(1.INSTANCE);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

