/*
 * Decompiled with CFR 0.152.
 */
package com.welink.protocol.spp;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.transsion.kolun.kolunscanner.KolunScannerManager;
import com.welink.protocol.CommonConstant;
import com.welink.protocol.spp.ClassicBtScanFilter;
import com.welink.protocol.utils.DataTransformUtil;
import com.welink.protocol.utils.DeviceInfo;
import com.welink.protocol.utils.LogUtil;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0005\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 42\u00020\u0001:\u00015B\u000f\u0012\u0006\u0010$\u001a\u00020#\u00a2\u0006\u0004\b2\u00103J\u000f\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001b\u0010\b\u001a\u0004\u0018\u00010\u00072\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u000f\u0010\u0010\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0004JQ\u0010\u0017\u001a\u00020\u00022\b\u0010\u0012\u001a\u0004\u0018\u00010\u001128\u0010\u0016\u001a4\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0014\u0012\b\b\u0006\u0012\u0004\b\b(\u000b\u0012\u0015\u0012\u0013\u0018\u00010\u0007\u00a2\u0006\f\b\u0014\u0012\b\b\u0006\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00020\u0013\u00a2\u0006\u0004\b\u0017\u0010\u0018J\r\u0010\u0019\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0019\u0010\u0004R\u0016\u0010\u001a\u001a\u00020\f8\u0002@\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001d\u001a\u00020\u001c8\u0002@\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR\u0016\u0010\u001f\u001a\u00020\f8\u0002@\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001bR\u0016\u0010 \u001a\u00020\u001c8\u0002@\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b \u0010\u001eRJ\u0010!\u001a6\u0012\u0013\u0012\u00110\n\u00a2\u0006\f\b\u0014\u0012\b\b\u0006\u0012\u0004\b\b(\u000b\u0012\u0015\u0012\u0013\u0018\u00010\u0007\u00a2\u0006\f\b\u0014\u0012\b\b\u0006\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00138\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0019\u0010$\u001a\u00020#8\u0006@\u0006\u00a2\u0006\f\n\u0004\b$\u0010%\u001a\u0004\b&\u0010'R\u0016\u0010(\u001a\u00020\u001c8\u0002@\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b(\u0010\u001eR\u0018\u0010)\u001a\u0004\u0018\u00010\u00118\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b)\u0010*R\u0016\u0010,\u001a\u00020+8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010-R\u0018\u0010/\u001a\u0004\u0018\u00010.8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b/\u00100R\u0016\u00101\u001a\u00020\u001c8\u0002@\u0002X\u0082D\u00a2\u0006\u0006\n\u0004\b1\u0010\u001e\u00a8\u00066"}, d2={"Lcom/welink/protocol/spp/ClassicScanTool;", "", "", "initBluetoothBroadcast", "()V", "", "name", "Lcom/welink/protocol/utils/DeviceInfo;", "analysisDeviceInfo", "(Ljava/lang/String;)Lcom/welink/protocol/utils/DeviceInfo;", "Landroid/bluetooth/BluetoothDevice;", "bluetoothDevice", "", "rssi", "analysisClassicBtDevice", "(Landroid/bluetooth/BluetoothDevice;I)V", "unRegisterBtReceiver", "Lcom/welink/protocol/spp/ClassicBtScanFilter;", "classicBtScanFilter", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "deviceInfo", "discoveryCallback", "startDiscovery", "(Lcom/welink/protocol/spp/ClassicBtScanFilter;Lkotlin/jvm/functions/Function2;)V", "stopDiscovery", "HEADER_FLAG_SIZE", "I", "", "HEADER_FLAG_3", "B", "SHORT_PID_SIZE", "HEADER_FLAG_2", "mDiscoveryCallback", "Lkotlin/jvm/functions/Function2;", "Landroid/content/Context;", "mContext", "Landroid/content/Context;", "getMContext", "()Landroid/content/Context;", "HEADER_FLAG_4", "mClassicBtScanFilter", "Lcom/welink/protocol/spp/ClassicBtScanFilter;", "Landroid/bluetooth/BluetoothAdapter;", "mBluetoothAdapter", "Landroid/bluetooth/BluetoothAdapter;", "Landroid/content/BroadcastReceiver;", "mBluetoothReceiver", "Landroid/content/BroadcastReceiver;", "HEADER_FLAG_1", "<init>", "(Landroid/content/Context;)V", "Companion", "welink_a", "welinkSDK_release"})
public final class ClassicScanTool {
    @NotNull
    public static final welink_a Companion = new welink_a();
    public static final byte PRODUCT_SUB_TYPE_WATCH = 0;
    public static final byte PRODUCT_SUB_TYPE_BAND = 1;
    public static final byte PRODUCT_SUB_TYPE_TWS_EARBUD = 2;
    public static final byte PRODUCT_SUB_TYPE_TV = 7;
    public static final byte PRODUCT_SUB_TYPE_PHONE = 13;
    public static final byte PRODUCT_SUB_TYPE_LAPTOP = 10;
    public static final byte PRODUCT_SUB_TYPE_UNKNOWN = -1;
    public static final byte PRODUCT_BRAND_NAME_ORAIMO = 0;
    public static final byte PRODUCT_BRAND_NAME_SYINIX = 1;
    public static final byte PRODUCT_BRAND_NAME_ITEL = 2;
    public static final byte PRODUCT_BRAND_NAME_TECNO = 3;
    public static final byte PRODUCT_BRAND_NAME_INFINIX = 4;
    public static final byte PRODUCT_BRAND_NAME_BOOMPLAY = 5;
    public static final byte PRODUCT_BRAND_NAME_UNKNOWN = -1;
    @NotNull
    private final Context mContext;
    private final int HEADER_FLAG_SIZE;
    private final int SHORT_PID_SIZE;
    private final byte HEADER_FLAG_1;
    private final byte HEADER_FLAG_2;
    private final byte HEADER_FLAG_3;
    private final byte HEADER_FLAG_4;
    @Nullable
    private ClassicBtScanFilter mClassicBtScanFilter;
    @NotNull
    private final BluetoothAdapter mBluetoothAdapter;
    @Nullable
    private Function2<? super BluetoothDevice, ? super DeviceInfo, Unit> mDiscoveryCallback;
    @Nullable
    private BroadcastReceiver mBluetoothReceiver;

    public ClassicScanTool(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"mContext");
        classicScanTool.mContext = context;
        classicScanTool.HEADER_FLAG_SIZE = 4;
        classicScanTool.SHORT_PID_SIZE = 8;
        classicScanTool.HEADER_FLAG_1 = (byte)82;
        classicScanTool.HEADER_FLAG_2 = (byte)49;
        classicScanTool.HEADER_FLAG_3 = (byte)35;
        classicScanTool.HEADER_FLAG_4 = (byte)126;
        ClassicScanTool classicScanTool = BluetoothAdapter.getDefaultAdapter();
        Intrinsics.checkNotNullExpressionValue((Object)classicScanTool, (String)"getDefaultAdapter()");
        v0.mBluetoothAdapter = classicScanTool;
    }

    private final void initBluetoothBroadcast() {
        BroadcastReceiver broadcastReceiver;
        IntentFilter intentFilter;
        IntentFilter intentFilter2 = intentFilter;
        new IntentFilter("android.bluetooth.adapter.action.STATE_CHANGED").addAction("android.bluetooth.adapter.action.SCAN_MODE_CHANGED");
        intentFilter2.addAction("android.bluetooth.adapter.action.DISCOVERY_STARTED");
        intentFilter2.addAction("android.bluetooth.adapter.action.DISCOVERY_FINISHED");
        intentFilter2.addAction("android.bluetooth.device.action.FOUND");
        BroadcastReceiver broadcastReceiver2 = broadcastReceiver;
        this.mBluetoothReceiver = new BroadcastReceiver(){

            public void onReceive(@NotNull Context context, @NotNull Intent intent) {
                Intent intent2 = intent;
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)intent2, (String)"intent");
                if (intent2.getAction().equals("android.bluetooth.device.action.FOUND")) {
                    context = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                    if (context == null) {
                        LogUtil.INSTANCE.i("\u626b\u63cf\u5230\u7684\u84dd\u7259\u8bbe\u5907\u4e3anull");
                        return;
                    }
                    LogUtil.INSTANCE.i("\u626b\u63cf\u5230\u84dd\u7259\u8bbe\u5907: " + context + ", \u8bbe\u5907\u540d\u79f0\uff1a" + context.getName());
                    short s2 = intent.getShortExtra("android.bluetooth.device.extra.RSSI", (short)-50);
                    this.analysisClassicBtDevice((BluetoothDevice)context, s2);
                } else if (intent.getAction().equals("android.bluetooth.adapter.action.DISCOVERY_STARTED")) {
                    LogUtil.INSTANCE.i("\u626b\u63cf\u5df2\u5f00\u59cb");
                } else if (intent.getAction().equals("android.bluetooth.adapter.action.DISCOVERY_FINISHED")) {
                    LogUtil.INSTANCE.i("\u626b\u63cf\u5df2\u7ed3\u675f");
                    this.unRegisterBtReceiver();
                }
            }
        };
        this.mContext.registerReceiver(broadcastReceiver2, intentFilter2);
    }

    private final DeviceInfo analysisDeviceInfo(String object) {
        if (object != null && ((String)object).length() >= 12) {
            Object object2 = ((String)object).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"(this as java.lang.String).getBytes(charset)");
            Object object3 = LogUtil.INSTANCE;
            ((LogUtil)object3).i("analysisDeviceInfo: data in byte array is :");
            DataTransformUtil dataTransformUtil = DataTransformUtil.INSTANCE;
            dataTransformUtil.print((byte[])object2);
            if (object2[0] == ((ClassicScanTool)((Object)logUtil)).HEADER_FLAG_1 && object2[1] == ((ClassicScanTool)((Object)logUtil)).HEADER_FLAG_2 && object2[2] == ((ClassicScanTool)((Object)logUtil)).HEADER_FLAG_3 && object2[3] == ((ClassicScanTool)((Object)logUtil)).HEADER_FLAG_4) {
                LogUtil logUtil = object3;
                int n2 = ((ClassicScanTool)((Object)logUtil)).HEADER_FLAG_SIZE;
                String string = ((String)object).substring(n2, n2 + ((ClassicScanTool)((Object)logUtil)).SHORT_PID_SIZE);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                object2 = dataTransformUtil.stringToByteArrayInHexInDouble(string);
                Object object4 = object;
                ((LogUtil)object3).i("analysisDeviceInfo: shortPid :");
                dataTransformUtil.print((byte[])object2);
                int n3 = ((ClassicScanTool)((Object)logUtil)).HEADER_FLAG_SIZE + ((ClassicScanTool)((Object)logUtil)).SHORT_PID_SIZE;
                String string2 = ((String)object4).substring(n3, ((String)object4).length());
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                ((LogUtil)object3).i(Intrinsics.stringPlus((String)"analysisDeviceInfo: deviceName is ", (Object)string2));
                byte by = object2[0];
                object = String.format("%02x", Arrays.copyOf(new Object[]{by}, 1));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"java.lang.String.format(format, *args)");
                ((LogUtil)object3).i(Intrinsics.stringPlus((String)"productSubType is 0x", (Object)object));
                byte by2 = object2[1];
                object3 = String.format("%02x", Arrays.copyOf(new Object[]{by2}, 1));
                Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"java.lang.String.format(format, *args)");
                logUtil.i(Intrinsics.stringPlus((String)"productBrandName is 0x", (Object)object3));
                String string3 = String.format("%02x", Arrays.copyOf(new Object[]{object2[2]}, 1));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
                String string4 = String.format("%02x", Arrays.copyOf(new Object[]{object2[3]}, 1));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
                object2 = Intrinsics.stringPlus((String)string3, (Object)string4);
                Boolean bl = Boolean.FALSE;
                return new DeviceInfo(by, by2, (String)object2, null, bl, null);
            }
            ((LogUtil)object3).i("analysisDeviceInfo: not our device, ignore");
            return null;
        }
        LogUtil logUtil = LogUtil.INSTANCE;
        StringBuilder stringBuilder = new StringBuilder().append("analysisDeviceInfo: name is null or length: ");
        object = object == null ? null : Integer.valueOf(((String)object).length());
        logUtil.e(stringBuilder.append(object).append(" is error, return").toString());
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void analysisClassicBtDevice(BluetoothDevice object, int n2) {
        Object object2;
        Function2<? super BluetoothDevice, ? super DeviceInfo, Unit> function2 = object2;
        DeviceInfo deviceInfo = function2.analysisDeviceInfo(object.getName());
        Object object3 = function2.mClassicBtScanFilter;
        if (object3 != null) {
            Object object4;
            if ((object3 == null ? null : ((ClassicBtScanFilter)object3).getProductSubTypeList()) != null) {
                object3 = ((ClassicScanTool)object2).mClassicBtScanFilter;
                object3 = object3 == null ? null : ((ClassicBtScanFilter)object3).getProductSubTypeList();
                Intrinsics.checkNotNull((Object)object3);
                object4 = deviceInfo == null ? null : Byte.valueOf(deviceInfo.getProductSubType());
                if (CollectionsKt.contains((Iterable)object3, (Object)object4)) {
                    LogUtil.INSTANCE.i("analysisClassicBtDevice: SubTypeMatched");
                } else {
                    object2 = LogUtil.INSTANCE;
                    object = new StringBuilder().append("analysisClassicBtDevice:productSubType:");
                    Byte by = deviceInfo == null ? null : Byte.valueOf(deviceInfo.getProductSubType());
                    ((LogUtil)object2).e(((StringBuilder)object).append(by).append(" not match").toString());
                    return;
                }
            }
            if (((object3 = ((ClassicScanTool)object2).mClassicBtScanFilter) == null ? null : ((ClassicBtScanFilter)object3).getMacAddress()) != null) {
                object3 = object.getAddress();
                if (Intrinsics.areEqual((Object)object3, (Object)(object4 = (object4 = ((ClassicScanTool)object2).mClassicBtScanFilter) == null ? null : ((ClassicBtScanFilter)object4).getMacAddress()))) {
                    LogUtil.INSTANCE.i("analysisClassicBtDevice:MacAddress Matched");
                } else {
                    Object object5 = object2;
                    object2 = LogUtil.INSTANCE;
                    object = new StringBuilder().append("analysisClassicBtDevice:macAddress:").append((Object)object.getAddress()).append(" targetMacAddress:");
                    Object object6 = object5.mClassicBtScanFilter;
                    object6 = object6 == null ? null : ((ClassicBtScanFilter)object6).getMacAddress();
                    ((LogUtil)object2).e(((StringBuilder)object).append(object6).append(" not match").toString());
                    return;
                }
            }
            if (!((object3 = ((ClassicScanTool)object2).mClassicBtScanFilter) != null && ((ClassicBtScanFilter)object3).getMinRssi() == -100)) {
                object3 = ((ClassicScanTool)object2).mClassicBtScanFilter;
                object3 = object3 == null ? null : Integer.valueOf(((ClassicBtScanFilter)object3).getMinRssi());
                Object object7 = object3;
                Intrinsics.checkNotNull((Object)object7);
                if (n2 >= (Integer)object7) {
                    LogUtil.INSTANCE.i("analysisClassicBtDevice: Rssi Matched");
                } else {
                    Object object8 = object2;
                    object2 = LogUtil.INSTANCE;
                    object = new StringBuilder().append("analysisClassicBtDevice: rssi:").append(n2).append(" minRssi:");
                    Object object9 = ((ClassicScanTool)object8).mClassicBtScanFilter;
                    object9 = object9 == null ? null : Integer.valueOf(((ClassicBtScanFilter)object9).getMinRssi());
                    Object object10 = object9;
                    Intrinsics.checkNotNull((Object)object10);
                    ((LogUtil)object2).e(((StringBuilder)object).append((Integer)object10).append(" not match").toString());
                    return;
                }
            }
        }
        LogUtil.INSTANCE.i("analysisClassicBtDevice: Filter All Matched, now call back mDiscoveryCallback");
        object2 = ((ClassicScanTool)object2).mDiscoveryCallback;
        if (object2 == null) return;
        if (object2 == null) {
            return;
        }
        object2.invoke(object, (Object)deviceInfo);
    }

    private final void unRegisterBtReceiver() {
        LogUtil.INSTANCE.i("unRegisterBtReceiver");
        BroadcastReceiver broadcastReceiver = this.mBluetoothReceiver;
        if (broadcastReceiver != null) {
            this.mContext.unregisterReceiver(broadcastReceiver);
            this.mBluetoothReceiver = null;
        }
    }

    @NotNull
    public final Context getMContext() {
        return this.mContext;
    }

    public final void startDiscovery(@Nullable ClassicBtScanFilter object, @NotNull Function2<? super BluetoothDevice, ? super DeviceInfo, Unit> function2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(function2, (String)"discoveryCallback");
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (bluetoothAdapter == null) {
            LogUtil.INSTANCE.e("mBluetoothAdapter\u4e3anull\uff0c\u672c\u673a\u53ef\u80fd\u4e0d\u652f\u6301\u84dd\u7259");
            bl = false;
        } else {
            long l2 = System.currentTimeMillis();
            int n2 = 0;
            if (!bluetoothAdapter.isEnabled()) {
                LogUtil.INSTANCE.i("\u84dd\u7259\u6ca1\u6253\u5f00\uff0c\u73b0\u5728\u5f00\u542f\u84dd\u7259......");
                if (CommonConstant.INSTANCE.isKolunLegal()) {
                    KolunScannerManager.getInstance().enableBluetooth(true);
                } else {
                    bluetoothAdapter.enable();
                }
            }
            while (!bluetoothAdapter.isEnabled() && n2 < 6) {
                n2 = (int)((System.currentTimeMillis() - l2) / (long)1000);
            }
            if (!bluetoothAdapter.isEnabled() && n2 >= 6) {
                LogUtil.INSTANCE.e("\u84dd\u7259\u5f00\u542f\u8d85\u8fc76s\uff0c\u5f00\u542f\u8d85\u65f6\uff0c\u9000\u51fa\uff01");
                bl = false;
            } else {
                LogUtil.INSTANCE.i("\u84dd\u7259\u5df2\u5f00\u542f\uff01");
                bl = true;
            }
        }
        if (!bl) {
            LogUtil.INSTANCE.e("startScanAndConnect: \u84dd\u7259\u5f00\u542f\u8d85\u65f6\uff0c\u9000\u51fa\uff01");
            return;
        }
        ClassicScanTool classicScanTool = this;
        this.mClassicBtScanFilter = object;
        classicScanTool.mDiscoveryCallback = function2;
        object = LogUtil.INSTANCE;
        ((LogUtil)object).i("startDiscoveryAndConnect: \u5f00\u59cb\u6ce8\u518c\u84dd\u7259\u5e7f\u64ad");
        classicScanTool.initBluetoothBroadcast();
        if (!classicScanTool.mBluetoothAdapter.isDiscovering()) {
            ((LogUtil)object).i("startScanAndConnect: now use system api to start discovery ......");
            this.mBluetoothAdapter.startDiscovery();
        } else {
            ((LogUtil)object).i("startScanAndConnect: discovery has been started......");
        }
    }

    public final void stopDiscovery() {
        ClassicScanTool classicScanTool = this;
        LogUtil logUtil = LogUtil.INSTANCE;
        logUtil.i("stopDiscovery: \u89e3\u9664\u6ce8\u518c\u84dd\u7259\u5e7f\u64ad");
        classicScanTool.unRegisterBtReceiver();
        if (classicScanTool.mBluetoothAdapter.isDiscovering()) {
            logUtil.i("stopDiscovery: now stop classic bluetooth discovery....");
            this.mBluetoothAdapter.cancelDiscovery();
        } else {
            logUtil.i("stopDiscovery: discovery has been stopped....");
        }
    }

    public static final class welink_a {
    }
}

