/*
 * Decompiled with CFR 0.152.
 */
package com.welink.protocol.wifi;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.NetworkInfo;
import android.net.wifi.WifiManager;
import android.net.wifi.p2p.WifiP2pConfig;
import android.net.wifi.p2p.WifiP2pDevice;
import android.net.wifi.p2p.WifiP2pDeviceList;
import android.net.wifi.p2p.WifiP2pGroup;
import android.net.wifi.p2p.WifiP2pInfo;
import android.net.wifi.p2p.WifiP2pManager;
import android.os.Looper;
import android.widget.Toast;
import androidx.annotation.RequiresApi;
import com.transsion.kolun.kolunscanner.KolunScannerManager;
import com.welink.protocol.CommonConstant;
import com.welink.protocol.event.P2pActionListener;
import com.welink.protocol.model.P2pInfo;
import com.welink.protocol.utils.LogUtil;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Collection;
import java.util.Enumeration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, bv={1, 0, 3}, k=1, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010H\u001a\u00020\n\u00a2\u0006\u0004\bR\u0010\u000eJ\u0019\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ#\u0010\u0012\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J!\u0010\u0014\u001a\u00020\f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0011\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u0015\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0014\u0010\u0017J\r\u0010\u0018\u001a\u00020\f\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0015\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001a\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\r\u0010\u001e\u001a\u00020\f\u00a2\u0006\u0004\b\u001e\u0010\u0019J\r\u0010\u001f\u001a\u00020\f\u00a2\u0006\u0004\b\u001f\u0010\u0019J\r\u0010 \u001a\u00020\f\u00a2\u0006\u0004\b \u0010\u0019J\u0015\u0010!\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\u0015\u00a2\u0006\u0004\b!\u0010\u0017J\r\u0010\"\u001a\u00020\f\u00a2\u0006\u0004\b\"\u0010\u0019J\r\u0010#\u001a\u00020\u000f\u00a2\u0006\u0004\b#\u0010$J\r\u0010&\u001a\u00020%\u00a2\u0006\u0004\b&\u0010'J\u000f\u0010(\u001a\u0004\u0018\u00010\u000f\u00a2\u0006\u0004\b(\u0010$J\u001d\u0010,\u001a\u00020\f2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020)\u00a2\u0006\u0004\b,\u0010-J\r\u0010.\u001a\u00020)\u00a2\u0006\u0004\b.\u0010/J\r\u00100\u001a\u00020\f\u00a2\u0006\u0004\b0\u0010\u0019J\r\u00101\u001a\u00020\f\u00a2\u0006\u0004\b1\u0010\u0019J\u0015\u00102\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b2\u0010\u000eR\u0016\u00104\u001a\u0002038\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b4\u00105R\u0016\u00106\u001a\u00020%8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b6\u00107R\u0018\u00109\u001a\u0004\u0018\u0001088\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b9\u0010:R\u0018\u0010;\u001a\u0004\u0018\u00010\u00158\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b;\u0010<R\u0018\u0010>\u001a\u0004\u0018\u00010=8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b>\u0010?R\u0018\u0010@\u001a\u0004\u0018\u00010\u001a8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b@\u0010AR\u0018\u0010B\u001a\u0004\u0018\u00010\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bB\u0010CR\u0018\u0010D\u001a\u0004\u0018\u00010\u000f8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bD\u0010CR\u0018\u0010F\u001a\u0004\u0018\u00010E8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bF\u0010GR\"\u0010H\u001a\u00020\n8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\bH\u0010I\u001a\u0004\bJ\u0010K\"\u0004\bL\u0010\u000eR\u0016\u0010N\u001a\u00020M8\u0002@\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\bN\u0010OR\u0016\u0010P\u001a\u00020)8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\bP\u0010Q\u00a8\u0006S"}, d2={"Lcom/welink/protocol/wifi/P2pTool;", "", "Landroid/net/wifi/p2p/WifiP2pGroup;", "info", "Ljava/net/Inet4Address;", "getInterfaceAddress", "(Landroid/net/wifi/p2p/WifiP2pGroup;)Ljava/net/Inet4Address;", "Landroid/content/IntentFilter;", "getIntentFilter", "()Landroid/content/IntentFilter;", "Landroid/content/Context;", "context", "", "updateP2pListener", "(Landroid/content/Context;)V", "", "ssid", "passwd", "connectWithSsidPwd", "(Ljava/lang/String;Ljava/lang/String;)V", "connectP2pDevice", "Lcom/welink/protocol/model/P2pInfo;", "p2pInfo", "(Lcom/welink/protocol/model/P2pInfo;)V", "unsetP2pListener", "()V", "Lcom/welink/protocol/event/P2pActionListener;", "p2pActionListener", "setP2pListener", "(Lcom/welink/protocol/event/P2pActionListener;)V", "startDiscoverPeers", "stopDiscoverPeers", "createGroup", "connectPeer", "removeGroup", "getP2p0MacAddress", "()Ljava/lang/String;", "", "isSupport5G", "()Z", "getP2p0Ip", "", "listenChannel", "operationChannel", "setChannel", "(II)V", "getP2pState", "()I", "resetP2p", "disconnectP2p", "updateContext", "Landroid/net/wifi/p2p/WifiP2pManager$ActionListener;", "mRemoveGroupListener", "Landroid/net/wifi/p2p/WifiP2pManager$ActionListener;", "mDiscovering", "Z", "Landroid/net/wifi/p2p/WifiP2pManager;", "mWifiP2pManager", "Landroid/net/wifi/p2p/WifiP2pManager;", "mP2pInfo", "Lcom/welink/protocol/model/P2pInfo;", "Landroid/net/wifi/p2p/WifiP2pManager$Channel;", "mChannel", "Landroid/net/wifi/p2p/WifiP2pManager$Channel;", "mP2pActionListener", "Lcom/welink/protocol/event/P2pActionListener;", "mPassword", "Ljava/lang/String;", "mSsid", "Landroid/content/BroadcastReceiver;", "mP2pReceiver", "Landroid/content/BroadcastReceiver;", "mContext", "Landroid/content/Context;", "getMContext", "()Landroid/content/Context;", "setMContext", "Landroid/net/wifi/p2p/WifiP2pManager$GroupInfoListener;", "mGroupInfoListener", "Landroid/net/wifi/p2p/WifiP2pManager$GroupInfoListener;", "mConnectionStatus", "I", "<init>", "welinkSDK_release"})
public final class P2pTool {
    @NotNull
    private Context mContext;
    @Nullable
    private WifiP2pManager mWifiP2pManager;
    @Nullable
    private WifiP2pManager.Channel mChannel;
    @Nullable
    private P2pActionListener mP2pActionListener;
    private boolean mDiscovering;
    @Nullable
    private String mPassword;
    @Nullable
    private String mSsid;
    @Nullable
    private BroadcastReceiver mP2pReceiver;
    @NotNull
    private final WifiP2pManager.GroupInfoListener mGroupInfoListener;
    @NotNull
    private final WifiP2pManager.ActionListener mRemoveGroupListener;
    private int mConnectionStatus;
    @Nullable
    private P2pInfo mP2pInfo;

    public P2pTool(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"mContext");
        this.mContext = context;
        this.mP2pReceiver = new BroadcastReceiver(){

            public static final void welink_a(P2pTool object, WifiP2pDeviceList wifiP2pDeviceList) {
                P2pTool p2pTool = object;
                Intrinsics.checkNotNullParameter((Object)p2pTool, (String)"this$0");
                LogUtil.INSTANCE.i(Intrinsics.stringPlus((String)"WIFI_P2P_PEERS_CHANGED_ACTION: peers is ", (Object)wifiP2pDeviceList));
                object = p2pTool.mP2pActionListener;
                if (object != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)wifiP2pDeviceList, (String)"peers");
                    object.onPeersActionChanged(wifiP2pDeviceList);
                }
            }

            public static final void welink_a(WifiP2pDevice wifiP2pDevice) {
                LogUtil.INSTANCE.i(Intrinsics.stringPlus((String)"requestDeviceInfo wifiP2pDevice: ", (Object)wifiP2pDevice));
            }

            public static final void welink_a(P2pTool p2pTool, Collection object, WifiP2pGroup object2, WifiP2pInfo wifiP2pInfo) {
                P2pTool p2pTool2 = p2pTool;
                Intrinsics.checkNotNullParameter((Object)p2pTool2, (String)"this$0");
                p2pTool2.mConnectionStatus = 2;
                P2pActionListener p2pActionListener = p2pTool2.mP2pActionListener;
                if (p2pActionListener != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"clientList");
                    p2pActionListener.onConnected(wifiP2pInfo, (Collection<? extends WifiP2pDevice>)object);
                }
                if (object2.isGroupOwner() && (p2pActionListener = p2pTool.mP2pActionListener) != null) {
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"clientList");
                    p2pActionListener.onGoConnected((WifiP2pGroup)object2, wifiP2pInfo, (Collection<? extends WifiP2pDevice>)object);
                }
                if (wifiP2pInfo.groupFormed && !object2.isGroupOwner()) {
                    WifiP2pGroup wifiP2pGroup = object2;
                    object = wifiP2pInfo.groupOwnerAddress.getHostAddress();
                    Intrinsics.checkNotNullExpressionValue((Object)wifiP2pGroup, (String)"wifiP2pGroup");
                    object2 = p2pTool.getInterfaceAddress(wifiP2pGroup);
                    object2 = object2 == null ? null : ((Inet4Address)object2).getHostAddress();
                    LogUtil.INSTANCE.i("WIFI_P2P_CONNECTION_CHANGED_ACTION: GC P2P device, GC Addr:" + object2 + ", GO Addr:" + object);
                    P2pActionListener p2pActionListener2 = p2pTool.mP2pActionListener;
                    Intrinsics.checkNotNull((Object)p2pActionListener2);
                    p2pActionListener2.onConnected((String)object, (String)object2);
                }
            }

            public static final void welink_a(P2pTool object, Ref.ObjectRef object2, WifiP2pGroup wifiP2pGroup) {
                Intrinsics.checkNotNullParameter((Object)object, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)object2, (String)"$networkInfo");
                LogUtil logUtil = LogUtil.INSTANCE;
                logUtil.i(Intrinsics.stringPlus((String)"requestGroupInfo wifiP2pGroup: ", (Object)wifiP2pGroup));
                if (wifiP2pGroup != null) {
                    Collection collection = wifiP2pGroup.getClientList();
                    if (collection.isEmpty()) {
                        logUtil.i("\u6ca1\u6709\u8bbe\u5907\u8fde\u63a5\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
                        if (((P2pTool)object).mConnectionStatus == 2 && wifiP2pGroup.isGroupOwner()) {
                            Object object3 = object;
                            logUtil.i("\u6ca1\u6709\u8bbe\u5907\u8fde\u63a5 \u5f53\u524d\u8bbe\u5907\u65ad\u5f00");
                            ((P2pTool)object3).mConnectionStatus = 0;
                            ((P2pTool)object3).mP2pInfo = null;
                            object = ((P2pTool)object3).mP2pActionListener;
                            if (object != null) {
                                object.onDisconnected();
                            }
                            return;
                        }
                    } else {
                        logUtil.i("\u6709\u8bbe\u5907\u8fde\u63a5\u4e0a\u4e86\u3002\u3002\u3002\u3002\u3002\u3002\u3002");
                    }
                    if ((object2 = object2.element) != null && ((NetworkInfo)object2).isConnected()) {
                        object2 = ((P2pTool)object).mWifiP2pManager;
                        if (object2 != null) {
                            Object object4 = object;
                            object = ((P2pTool)object4).mChannel;
                            object2.requestConnectionInfo((WifiP2pManager.Channel)object, arg_0 -> welink_e.welink_a((P2pTool)object4, collection, wifiP2pGroup, arg_0));
                        }
                        logUtil.i("WIFI_P2P_CONNECTION_CHANGED_ACTION: \u5df2\u8fde\u63a5p2p\u8bbe\u5907, onConnectionInfoAvailable");
                    } else {
                        Object object5 = object;
                        ((P2pTool)object5).mConnectionStatus = 0;
                        ((P2pTool)object5).mP2pInfo = null;
                        object = ((P2pTool)object5).mP2pActionListener;
                        if (object != null) {
                            object.onDisconnected();
                        }
                        logUtil.i("WIFI_P2P_CONNECTION_CHANGED_ACTION: \u4e0ep2p\u8bbe\u5907\u5df2\u65ad\u5f00\u8fde\u63a5");
                    }
                } else if (((P2pTool)object).mConnectionStatus == 2) {
                    P2pTool p2pTool = object;
                    p2pTool.mConnectionStatus = 0;
                    p2pTool.mP2pInfo = null;
                    object = p2pTool.mP2pActionListener;
                    if (object != null) {
                        object.onDisconnected();
                    }
                    logUtil.i("wifiP2pGroup: null report disconnect");
                }
            }

            @RequiresApi(value=29)
            public void onReceive(@NotNull Context object, @NotNull Intent intent) {
                Intent intent2 = intent;
                Intrinsics.checkNotNullParameter((Object)object, (String)"context");
                Intrinsics.checkNotNullParameter((Object)intent2, (String)"intent");
                object = intent2.getAction();
                if (object != null) {
                    int n2 = ((String)object).hashCode();
                    if (n2 != -1772632330) {
                        Object object2;
                        if (n2 != -1566767901) {
                            if (n2 != -1394739139) {
                                if (n2 == 1695662461 && ((String)object).equals("android.net.wifi.p2p.STATE_CHANGED")) {
                                    if (intent.getIntExtra("wifi_p2p_state", -100) == 2) {
                                        LogUtil.INSTANCE.i("WIFI_P2P_STATE_ENABLED ");
                                        object2 = mP2pActionListener;
                                        if (object2 != null) {
                                            object2.wifiP2pEnabled(true);
                                        }
                                    } else {
                                        LogUtil.INSTANCE.i("WIFI_P2P_STATE_DISABLED ");
                                        object2 = mP2pActionListener;
                                        if (object2 != null) {
                                            object2.wifiP2pEnabled(false);
                                        }
                                    }
                                }
                            } else if (((String)object).equals("android.net.wifi.p2p.PEERS_CHANGED")) {
                                if (!mDiscovering) {
                                    return;
                                }
                                object = mWifiP2pManager;
                                if (object != null) {
                                    object.requestPeers(mChannel, arg_0 -> welink_e.welink_a(object2.this, arg_0));
                                }
                            }
                        } else if (((String)object).equals("android.net.wifi.p2p.THIS_DEVICE_CHANGED")) {
                            welink_e welink_e2 = object2;
                            LogUtil.INSTANCE.i("WIFI_P2P_THIS_DEVICE_CHANGED_ACTION: \u672c\u8bbe\u5907\u72b6\u6001\u53d1\u751f\u53d8\u5316\uff0conSelfDeviceAvailable");
                            object2 = (WifiP2pDevice)intent.getParcelableExtra("wifiP2pDevice");
                            object = mP2pActionListener;
                            if (object != null) {
                                object.onSelfDeviceActionChanged((WifiP2pDevice)object2);
                            }
                        }
                    } else if (((String)object).equals("android.net.wifi.p2p.CONNECTION_STATE_CHANGE")) {
                        Ref.ObjectRef objectRef;
                        LogUtil.INSTANCE.i("==========WIFI_P2P_CONNECTION_CHANGED_ACTION================");
                        object = objectRef;
                        object();
                        objectRef.element = intent.getParcelableExtra("networkInfo");
                        intent = mWifiP2pManager;
                        if (intent != null) {
                            WifiP2pManager.Channel channel = mChannel;
                            Intrinsics.checkNotNull((Object)channel);
                            intent.requestDeviceInfo(channel, welink_e::welink_a);
                        }
                        intent = mWifiP2pManager;
                        if (intent != null) {
                            WifiP2pManager.Channel channel = mChannel;
                            Intrinsics.checkNotNull((Object)channel);
                            intent.requestGroupInfo(channel, arg_0 -> welink_e.welink_a(object2.this, (Ref.ObjectRef)object, arg_0));
                        }
                    }
                }
            }
        };
        this.mGroupInfoListener = arg_0 -> P2pTool.mGroupInfoListener$lambda-0(this, arg_0);
        this.mRemoveGroupListener = new WifiP2pManager.ActionListener(){

            @RequiresApi(value=29)
            public void onSuccess() {
                LogUtil.INSTANCE.i("removeGroup onSuccess");
                P2pTool p2pTool = this;
                p2pTool.connectWithSsidPwd(p2pTool.mSsid, mPassword);
            }

            public void onFailure(int n2) {
                welink_f welink_f2 = this;
                LogUtil.INSTANCE.i("removeGroup onFailure");
                mConnectionStatus = 0;
                mP2pInfo = null;
                P2pActionListener p2pActionListener = mP2pActionListener;
                Intrinsics.checkNotNull((Object)p2pActionListener);
                p2pActionListener.onConnectFailed();
            }
        };
    }

    private final Inet4Address getInterfaceAddress(WifiP2pGroup wifiP2pGroup) {
        try {
            NetworkInterface networkInterface = NetworkInterface.getByName(wifiP2pGroup.getInterface());
            Intrinsics.checkNotNullExpressionValue((Object)networkInterface, (String)"{\n            NetworkInterface.getByName(info.getInterface())\n        }");
            Enumeration<InetAddress> enumeration = networkInterface.getInetAddresses();
        }
        catch (SocketException socketException) {
            LogUtil.INSTANCE.w(Intrinsics.stringPlus((String)"Could not obtain address of network interface ", (Object)wifiP2pGroup.getInterface()));
            socketException.printStackTrace();
            return null;
        }
        Intrinsics.checkNotNullExpressionValue(enumeration, (String)"iface.inetAddresses");
        while (enumeration.hasMoreElements()) {
            InetAddress inetAddress = (InetAddress)enumeration.nextElement();
            if (!(inetAddress instanceof Inet4Address)) continue;
            return (Inet4Address)inetAddress;
        }
        LogUtil.INSTANCE.w("Could not obtain address of network interface " + wifiP2pGroup.getInterface() + " because it had no IPv4 addresses.");
        return null;
    }

    private final IntentFilter getIntentFilter() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.net.wifi.p2p.STATE_CHANGED");
        intentFilter.addAction("android.net.wifi.p2p.PEERS_CHANGED");
        intentFilter.addAction("android.net.wifi.p2p.CONNECTION_STATE_CHANGE");
        intentFilter.addAction("android.net.wifi.p2p.THIS_DEVICE_CHANGED");
        return intentFilter;
    }

    private final void updateP2pListener(Context object) {
        p2pTool4.mContext.unregisterReceiver(p2pTool4.mP2pReceiver);
        p2pTool4.mChannel = null;
        p2pTool4.mWifiP2pManager = null;
        p2pTool4.mContext = object;
        object = object.getSystemService("wifip2p");
        if (object != null) {
            P2pTool p2pTool;
            object = (WifiP2pManager)object;
            p2pTool4.mWifiP2pManager = object;
            if (object == null) {
                object = null;
            } else {
                Object object2 = object;
                P2pTool p2pTool2 = p2pTool4;
                object = p2pTool2.mContext;
                Looper looper = Looper.getMainLooper();
                P2pActionListener p2pActionListener = p2pTool2.mP2pActionListener;
                object = object2.initialize(object, looper, (WifiP2pManager.ChannelListener)p2pActionListener);
            }
            p2pTool4.mChannel = object;
            P2pTool p2pTool3 = p2pTool4;
            P2pTool p2pTool4 = p2pTool3.mP2pReceiver;
            p2pTool.mContext.registerReceiver((BroadcastReceiver)p2pTool4, p2pTool3.getIntentFilter());
            return;
        }
        throw new NullPointerException("null cannot be cast to non-null type android.net.wifi.p2p.WifiP2pManager");
    }

    private final void connectWithSsidPwd(String string, String string2) {
        WifiP2pConfig.Builder builder;
        Object object = builder;
        String string3 = string;
        object();
        Intrinsics.checkNotNull((Object)string3);
        WifiP2pConfig.Builder builder2 = builder.setNetworkName(string3);
        String string4 = string2;
        Intrinsics.checkNotNull((Object)string4);
        string = builder2.setPassphrase(string4).build();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"Builder()\n            .setNetworkName(ssid!!)\n            .setPassphrase(passwd!!).build()");
        LogUtil.INSTANCE.i(Intrinsics.stringPlus((String)"Connecting ", (Object)string.getNetworkName()));
        string2 = this.mWifiP2pManager;
        if (string2 != null) {
            WifiP2pManager.ActionListener actionListener;
            String string5 = string2;
            string2 = this.mChannel;
            Intrinsics.checkNotNull((Object)string2);
            object = actionListener;
            actionListener = new WifiP2pManager.ActionListener(){

                public void onSuccess() {
                    LogUtil.INSTANCE.i("connect onSuccess");
                    mConnectionStatus = 1;
                }

                public void onFailure(int n2) {
                    welink_b welink_b2 = this;
                    LogUtil.INSTANCE.e(Intrinsics.stringPlus((String)"connect failed: ", (Object)n2));
                    mConnectionStatus = 0;
                    mP2pInfo = null;
                }
            };
            string5.connect((WifiP2pManager.Channel)string2, (WifiP2pConfig)string, (WifiP2pManager.ActionListener)object);
        }
    }

    private static final void mGroupInfoListener$lambda-0(P2pTool object, WifiP2pGroup wifiP2pGroup) {
        Intrinsics.checkNotNullParameter((Object)object, (String)"this$0");
        LogUtil.INSTANCE.i("onGroupInfoAvailable");
        if (wifiP2pGroup != null) {
            P2pTool p2pTool = object;
            Toast.makeText((Context)p2pTool.getMContext(), (CharSequence)"Apps using Wi-Fi P2P channels are already turned off", (int)1).show();
            wifiP2pGroup = p2pTool.mWifiP2pManager;
            if (wifiP2pGroup != null) {
                Object object2 = object;
                object = ((P2pTool)object2).mChannel;
                Intrinsics.checkNotNull((Object)object);
                wifiP2pGroup.removeGroup((WifiP2pManager.Channel)object, ((P2pTool)object2).mRemoveGroupListener);
            }
        } else {
            P2pTool p2pTool = object;
            object = p2pTool.mSsid;
            p2pTool.connectWithSsidPwd((String)object, p2pTool.mPassword);
        }
    }

    @NotNull
    public final Context getMContext() {
        return this.mContext;
    }

    public final void setMContext(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"<set-?>");
        this.mContext = context;
    }

    public final void connectP2pDevice(@Nullable String string, @Nullable String string2) {
        P2pInfo p2pInfo;
        if (((P2pTool)((Object)p2pInfo3)).mConnectionStatus == 0 && !Intrinsics.areEqual((Object)((p2pInfo = ((P2pTool)((Object)p2pInfo3)).mP2pInfo) == null ? null : p2pInfo.getMacAddress()), (Object)"02:00:00:00:00:00")) {
            P2pInfo p2pInfo2;
            LogUtil.INSTANCE.i("connectP2pDevice: now connect {" + string + '}');
            ((P2pTool)((Object)p2pInfo3)).mSsid = string;
            ((P2pTool)((Object)p2pInfo3)).mPassword = string2;
            string = ((P2pTool)((Object)p2pInfo3)).mWifiP2pManager;
            if (string != null) {
                String string3 = string;
                P2pTool p2pTool = p2pInfo3;
                string = p2pTool.mChannel;
                Intrinsics.checkNotNull((Object)string);
                string3.requestGroupInfo((WifiP2pManager.Channel)string, p2pTool.mGroupInfoListener);
            }
            P2pTool p2pTool = p2pInfo3;
            P2pInfo p2pInfo3 = p2pInfo2;
            p2pInfo2 = new P2pInfo(true, "02:00:00:00:00:00", "192.168.44.1", 2412);
            p2pTool.mP2pInfo = p2pInfo3;
        } else {
            LogUtil.INSTANCE.i("connectP2pDevice: has connect this device before, do not need connect it again, ignore");
        }
    }

    public final void connectP2pDevice(@NotNull P2pInfo p2pInfo) {
        Intrinsics.checkNotNullParameter((Object)p2pInfo, (String)"p2pInfo");
        if (this.mConnectionStatus == 0 && !Intrinsics.areEqual((Object)this.mP2pInfo, (Object)p2pInfo)) {
            LogUtil.INSTANCE.i(Intrinsics.stringPlus((String)"connectP2pDevice: now connect ", (Object)p2pInfo.getMacAddress()));
            this.connectPeer(p2pInfo);
            this.mP2pInfo = p2pInfo;
        } else {
            LogUtil.INSTANCE.i("connectP2pDevice: has connect this device before, do not need connect it again, ignore");
        }
    }

    public final void unsetP2pListener() {
        if (this.mP2pActionListener == null) {
            return;
        }
        this.mContext.unregisterReceiver(this.mP2pReceiver);
        this.mChannel = null;
        this.mWifiP2pManager = null;
        this.mP2pActionListener = null;
    }

    public final void setP2pListener(@NotNull P2pActionListener p2pActionListener) {
        Intrinsics.checkNotNullParameter((Object)p2pActionListener, (String)"p2pActionListener");
        if (p2pTool3.mP2pActionListener == null) {
            p2pTool3.mP2pActionListener = p2pActionListener;
            Object object = p2pTool3.mContext.getSystemService("wifip2p");
            if (object != null) {
                P2pTool p2pTool;
                object = (WifiP2pManager)object;
                p2pTool3.mWifiP2pManager = object;
                if (object == null) {
                    p2pActionListener = null;
                } else {
                    Object object2 = object;
                    object = p2pTool3.mContext;
                    p2pActionListener = object2.initialize((Context)object, object.getMainLooper(), (WifiP2pManager.ChannelListener)p2pActionListener);
                }
                p2pTool3.mChannel = p2pActionListener;
                P2pTool p2pTool2 = p2pTool3;
                P2pTool p2pTool3 = p2pTool2.mP2pReceiver;
                p2pTool.mContext.registerReceiver((BroadcastReceiver)p2pTool3, p2pTool2.getIntentFilter());
            } else {
                throw new NullPointerException("null cannot be cast to non-null type android.net.wifi.p2p.WifiP2pManager");
            }
        }
    }

    public final void startDiscoverPeers() {
        this.mDiscovering = true;
        WifiP2pManager wifiP2pManager = this.mWifiP2pManager;
        if (wifiP2pManager != null) {
            WifiP2pManager.ActionListener actionListener;
            WifiP2pManager wifiP2pManager2 = wifiP2pManager;
            wifiP2pManager = this.mChannel;
            WifiP2pManager.ActionListener actionListener2 = actionListener;
            actionListener = new WifiP2pManager.ActionListener(){

                public void onSuccess() {
                    P2pActionListener p2pActionListener = mP2pActionListener;
                    if (p2pActionListener != null) {
                        p2pActionListener.onDiscoverPeersSuccess();
                    }
                }

                public void onFailure(int n2) {
                    P2pActionListener p2pActionListener = mP2pActionListener;
                    if (p2pActionListener != null) {
                        p2pActionListener.onDiscoverPeersFail(n2);
                    }
                }
            };
            wifiP2pManager2.discoverPeers((WifiP2pManager.Channel)wifiP2pManager, actionListener2);
        }
    }

    public final void stopDiscoverPeers() {
        this.mDiscovering = false;
        WifiP2pManager wifiP2pManager = this.mWifiP2pManager;
        if (wifiP2pManager != null) {
            wifiP2pManager.stopPeerDiscovery(this.mChannel, null);
        }
    }

    public final void createGroup() {
        WifiP2pManager wifiP2pManager = this.mWifiP2pManager;
        if (wifiP2pManager != null) {
            WifiP2pManager.ActionListener actionListener;
            WifiP2pManager wifiP2pManager2 = wifiP2pManager;
            wifiP2pManager = this.mChannel;
            WifiP2pManager.ActionListener actionListener2 = actionListener;
            actionListener = new WifiP2pManager.ActionListener(){

                public void onSuccess() {
                    LogUtil.INSTANCE.i("createGroup onSuccess");
                    P2pActionListener p2pActionListener = mP2pActionListener;
                    if (p2pActionListener != null) {
                        p2pActionListener.onCreateGroupSuccess();
                    }
                }

                public void onFailure(int n2) {
                    LogUtil.INSTANCE.i("createGroup onFailure");
                    P2pActionListener p2pActionListener = mP2pActionListener;
                    if (p2pActionListener != null) {
                        p2pActionListener.onCreateGroupFail();
                    }
                }
            };
            wifiP2pManager2.createGroup((WifiP2pManager.Channel)wifiP2pManager, actionListener2);
        }
    }

    public final void connectPeer(@NotNull P2pInfo p2pInfo) {
        WifiP2pConfig wifiP2pConfig;
        Intrinsics.checkNotNullParameter((Object)p2pInfo, (String)"p2pInfo");
        WifiP2pConfig wifiP2pConfig2 = wifiP2pConfig;
        wifiP2pConfig2();
        wifiP2pConfig.deviceAddress = p2pInfo.getMacAddress();
        wifiP2pConfig.wps.setup = 0;
        wifiP2pConfig.groupOwnerIntent = 0;
        LogUtil.INSTANCE.i(Intrinsics.stringPlus((String)"\u6b63\u5728\u8fde\u63a5 ", (Object)p2pInfo.getMacAddress()));
        p2pInfo = this.mWifiP2pManager;
        if (p2pInfo != null) {
            WifiP2pManager.ActionListener actionListener;
            P2pInfo p2pInfo2 = p2pInfo;
            p2pInfo = this.mChannel;
            WifiP2pManager.ActionListener actionListener2 = actionListener;
            actionListener = new WifiP2pManager.ActionListener(){

                public void onSuccess() {
                    LogUtil.INSTANCE.i("connect onSuccess");
                    mConnectionStatus = 1;
                }

                public void onFailure(int n2) {
                    welink_a welink_a2 = this;
                    LogUtil.INSTANCE.e(Intrinsics.stringPlus((String)"connect failed: ", (Object)n2));
                    mConnectionStatus = 0;
                    mP2pInfo = null;
                }
            };
            p2pInfo2.connect((WifiP2pManager.Channel)p2pInfo, wifiP2pConfig2, actionListener2);
        }
    }

    public final void removeGroup() {
        WifiP2pManager wifiP2pManager = this.mWifiP2pManager;
        if (wifiP2pManager != null) {
            WifiP2pManager.ActionListener actionListener;
            WifiP2pManager wifiP2pManager2 = wifiP2pManager;
            wifiP2pManager = this.mChannel;
            WifiP2pManager.ActionListener actionListener2 = actionListener;
            actionListener = new WifiP2pManager.ActionListener(){

                public void onFailure(int n2) {
                    LogUtil.INSTANCE.e(Intrinsics.stringPlus((String)"removeGroup onFailure:", (Object)n2));
                }

                public void onSuccess() {
                    LogUtil.INSTANCE.i("removeGroup onSuccess");
                    mP2pInfo = null;
                }
            };
            wifiP2pManager2.removeGroup((WifiP2pManager.Channel)wifiP2pManager, actionListener2);
        }
    }

    @NotNull
    public final String getP2p0MacAddress() {
        String string = KolunScannerManager.getInstance().getP2pMac();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getInstance().p2pMac");
        String string2 = string.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase()");
        LogUtil.INSTANCE.i(Intrinsics.stringPlus((String)"=====getP2p0MacAddress======macAddress is ", (Object)string2));
        return string2;
    }

    public final boolean isSupport5G() {
        Object object = CommonConstant.INSTANCE.getMContext();
        object = object == null ? null : object.getSystemService("wifi");
        if (object != null) {
            return ((WifiManager)object).is5GHzBandSupported();
        }
        throw new NullPointerException("null cannot be cast to non-null type android.net.wifi.WifiManager");
    }

    @Nullable
    public final String getP2p0Ip() {
        String string = KolunScannerManager.getInstance().getP2pIp();
        LogUtil.INSTANCE.i(Intrinsics.stringPlus((String)"=====getP2p0Ip======p2pIp is ", (Object)string));
        return string;
    }

    public final void setChannel(int n2, int n3) {
        LogUtil.INSTANCE.i("=====setChannel======listenChannel is " + n2 + "==operationChannel is " + n3 + "==");
        KolunScannerManager.getInstance().setWifiP2pChannels(n2, n3);
    }

    public final int getP2pState() {
        return this.mConnectionStatus;
    }

    public final void resetP2p() {
        if (this.mConnectionStatus != 0) {
            P2pTool p2pTool = this;
            p2pTool.mConnectionStatus = 0;
            p2pTool.mP2pInfo = null;
        }
    }

    public final void disconnectP2p() {
        if (this.mConnectionStatus == 2) {
            this.removeGroup();
        } else {
            WifiP2pManager wifiP2pManager = this.mWifiP2pManager;
            if (wifiP2pManager != null) {
                WifiP2pManager.ActionListener actionListener;
                WifiP2pManager wifiP2pManager2 = wifiP2pManager;
                wifiP2pManager = this.mChannel;
                WifiP2pManager.ActionListener actionListener2 = actionListener;
                actionListener = new WifiP2pManager.ActionListener(){

                    public void onFailure(int n2) {
                        LogUtil.INSTANCE.e(Intrinsics.stringPlus((String)"disconnect P2P onFailure:", (Object)n2));
                    }

                    public void onSuccess() {
                        welink_d welink_d2 = p2pActionListener;
                        LogUtil.INSTANCE.i("disconnect P2P onSuccess");
                        mConnectionStatus = 0;
                        mP2pInfo = null;
                        P2pActionListener p2pActionListener = mP2pActionListener;
                        if (p2pActionListener != null) {
                            p2pActionListener.onDisconnected();
                        }
                    }
                };
                wifiP2pManager2.cancelConnect((WifiP2pManager.Channel)wifiP2pManager, actionListener2);
            }
        }
    }

    public final void updateContext(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (context == this.mContext) {
            return;
        }
        if (this.mP2pActionListener != null) {
            this.updateP2pListener(context);
        } else {
            this.mContext = context;
        }
    }
}

