/*
 * Decompiled with CFR 0.152.
 */
package welink_a.welink_a.welink_a.welink_a.welink_c;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattServer;
import android.bluetooth.BluetoothGattServerCallback;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.os.Build;
import com.transsion.kolun.kolunscanner.KolunScannerManager;
import com.welink.protocol.CommonConstant;
import com.welink.protocol.ble.AdvertiseTool;
import com.welink.protocol.event.OnStatusChangeListener;
import com.welink.protocol.model.HugeDataModel;
import com.welink.protocol.model.SendDataModel;
import com.welink.protocol.utils.DataTransformUtil;
import com.welink.protocol.utils.LogUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import kotlin.Triple;
import kotlin.UByte;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.IntCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class welink_a {
    @NotNull
    public static final welink_a Companion = new welink_a();
    public static final byte WELINK_VERSION = 16;
    private static final UUID SERVICE_UUID = UUID.fromString("0000FD35-0000-1000-8000-00805f9b34fb");
    private static final UUID READ_WRITE_UUID = UUID.fromString("00009231-0000-1000-8000-00805f9b34fb");
    private static final UUID DESCRIPTOR_UUID = UUID.fromString("00003166-0000-1000-8000-00805f9b34fb");
    public static final byte HEADER_IDENTIFY = -18;
    public static final byte VALUE_RECEIVER_SUCCESS = 0;
    public static final byte VALUE_RECEIVER_ERROR = 1;
    private static final int FLAG_SEND = 1;
    private static final int FLAG_RECEIVE = 2;
    private static final int RETRY_TIME = 5000;
    private static final long DELAY_TIME = 1L;
    private static final int RESEND_TIME = 10;
    private static final long RESEND_DELAY = 50L;
    private static final byte GET_MAX_MTU = 62;
    private static final int BLUETOOTH_DEFAULT_MAX_ATT_MTU_SIZE = 23;
    private static final int BLUETOOTH_5_0_MAX_ATT_MTU_SIZE = 517;
    private static final int BLUETOOTH_4_2_MAX_ATT_MTU_SIZE = 247;
    private static int DATA_MAX_LENGTH = 15;
    private static int FRAME_HEAD_LENGTH = 5;
    @NotNull
    private static final ArrayBlockingQueue<Triple<Integer, Object, welink_a>> mArrayBlockingQueue = new ArrayBlockingQueue(20);
    private static boolean mIsDevice;
    @NotNull
    private static HugeDataModel mHugeDataModel;
    private static boolean mThreadRunning;
    private static int mConnectNum;
    @Nullable
    private final String address;
    @NotNull
    private final Context mContext;
    private final BluetoothAdapter mBluetoothAdapter;
    @Nullable
    private BluetoothGatt mBluetoothGatt;
    @Nullable
    private BluetoothGattCharacteristic mReadWriteCharacteristic;
    @Nullable
    private BluetoothGattServer mGattServer;
    @Nullable
    private BluetoothDevice mPhone;
    @NotNull
    private List<Byte> mDataBuff;
    private boolean mIsDescriptorWriteSuccess;
    private boolean mIsGattConnect;
    private boolean mIsMTURequested;
    private boolean mGattNeedReconnect;
    @Nullable
    private OnStatusChangeListener mOnStatusChangeListener;
    @NotNull
    private final BluetoothGattServerCallback mGattServerCallback;
    private boolean mIsAutoConnectWifi;
    private boolean mIsSetAttMtu;
    private int mAttMtu;
    @NotNull
    private final BluetoothGattCallback mGattCallback;
    private boolean mIsLastSendOK;

    public welink_a(@Nullable String string, @NotNull Context context) {
        welink_a welink_a2 = this;
        Intrinsics.checkNotNullParameter((Object)context, (String)"mContext");
        this.address = string;
        welink_a2.mContext = context;
        welink_a2.mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        welink_a2.mDataBuff = new ArrayList<Byte>();
        welink_a2.mGattNeedReconnect = true;
        welink_a2.mGattServerCallback = new BluetoothGattServerCallback(){

            public void onServiceAdded(int n2, @NotNull BluetoothGattService bluetoothGattService) {
                Intrinsics.checkNotNullParameter((Object)bluetoothGattService, (String)"service");
                super.onServiceAdded(n2, bluetoothGattService);
                LogUtil.INSTANCE.i("Device: onServiceAdded: status: " + n2 + ", service: " + bluetoothGattService.getUuid());
            }

            /*
             * Unable to fully structure code
             */
            public void onConnectionStateChange(@NotNull BluetoothDevice var1_1, int var2_2, int var3_4) {
                Intrinsics.checkNotNullParameter((Object)var1_1, (String)"device");
                super.onConnectionStateChange((BluetoothDevice)var1_1, var2_2, var3_4);
                var4_6 = LogUtil.INSTANCE;
                var4_6.i("Device: onConnectionStateChange status:" + var2_2 + "  newState:" + var3_4);
                if (var3_4 != 0) {
                    if (var3_4 == 2) {
                        v0 = this;
                        var4_6.i(Intrinsics.stringPlus((String)"Device: Gatt connected, now stop stopAdvertising and connect device, mGattServer is ", (Object)welink_a.access$getMGattServer$p(this)));
                        AdvertiseTool.INSTANCE.stopAdvertising();
                        welink_a.access$setMPhone$p(v0.this, (BluetoothDevice)var1_1);
                        welink_a.access$setMIsGattConnect$p(v0.this, true);
                        var1_1 = welink_a.Companion;
                        var1_1.welink_b();
                        var2_3 = v0.this.getMOnStatusChangeListener();
                        if (var2_3 != null) {
                            var2_3.statusChange(100);
                        }
                        var2_3 = this;
                        var3_5 = welink_a.access$getMGattServer$p((welink_a)var2_3);
                        if (var3_5 == null) {
                            while (true) {
                                var1_1 = null;
                                break;
                            }
                        } else {
                            var1_1.getClass();
                            var1_1 = var3_5.getService(welink_a.access$getSERVICE_UUID$cp());
                            if (var1_1 == null) ** continue;
                            var1_1 = var1_1.getCharacteristic(welink_a.access$getREAD_WRITE_UUID$cp());
                        }
                        welink_a.access$setMReadWriteCharacteristic$p((welink_a)var2_3, (BluetoothGattCharacteristic)var1_1);
                        var4_6.i(Intrinsics.stringPlus((String)"Device: Gatt connected, mReadWriteCharacteristic is ", (Object)welink_a.access$getMReadWriteCharacteristic$p(this)));
                    }
                } else {
                    v1 = this;
                    var4_6.i("Device: Gatt disconnect");
                    var4_6.i(Intrinsics.stringPlus((String)"Device: Gatt disconnect, now startAdvertisement continue, mGattServer is ", (Object)welink_a.access$getMGattServer$p(this)));
                    AdvertiseTool.INSTANCE.startAdvertisementContinue();
                    welink_a.access$setMIsGattConnect$p(v1.this, false);
                    welink_a.access$setMIsMTURequested$p(v1.this, false);
                    welink_a.access$setMIsDescriptorWriteSuccess$p(v1.this, false);
                    var1_1 = v1.this.getMOnStatusChangeListener();
                    if (var1_1 != null) {
                        var1_1.statusChange(101);
                    }
                    welink_a.Companion.welink_c();
                    welink_a.access$setMPhone$p(this, null);
                }
            }

            public void onCharacteristicReadRequest(@NotNull BluetoothDevice bluetoothDevice, int n2, int n3, @NotNull BluetoothGattCharacteristic bluetoothGattCharacteristic) {
                Intrinsics.checkNotNullParameter((Object)bluetoothDevice, (String)"device");
                Intrinsics.checkNotNullParameter((Object)bluetoothGattCharacteristic, (String)"characteristic");
                super.onCharacteristicReadRequest(bluetoothDevice, n2, n3, bluetoothGattCharacteristic);
                LogUtil.INSTANCE.i("Device: onCharacteristicReadRequest: device: " + bluetoothDevice + ", requestId: " + n2 + ",offset: " + n3);
            }

            public void onCharacteristicWriteRequest(@NotNull BluetoothDevice object, int n2, @NotNull BluetoothGattCharacteristic bluetoothGattCharacteristic, boolean bl, boolean bl2, int n3, @Nullable byte[] byArray) {
                Intrinsics.checkNotNullParameter((Object)object, (String)"device");
                Intrinsics.checkNotNullParameter((Object)bluetoothGattCharacteristic, (String)"characteristic");
                LogUtil logUtil = LogUtil.INSTANCE;
                StringBuilder stringBuilder = new StringBuilder().append("Device: in onCharacteristicWriteRequest offset: ").append(n3).append(", responseNeeded: ").append(bl2).append(",preparedWrite: ").append(bl).append(", gattServer is ").append(mGattServer).append(", device: ").append(object).append(", requestId: ").append(n2).append(",\nvalue size is ");
                Integer n4 = byArray == null ? null : Integer.valueOf(byArray.length);
                logUtil.i(stringBuilder.append(n4).toString());
                if (bl2 && (stringBuilder = mGattServer) != null) {
                    stringBuilder.sendResponse((BluetoothDevice)object, n2, 0, 0, byArray);
                }
                welink_c welink_c2 = object2;
                super.onCharacteristicWriteRequest(object, n2, bluetoothGattCharacteristic, bl, bl2, n3, byArray);
                if (Intrinsics.areEqual((Object)object, (Object)mPhone)) {
                    logUtil.i("Device: onCharacteristicWriteRequest, device is welink mDevice");
                    if (Intrinsics.areEqual((Object)bluetoothGattCharacteristic.getUuid(), (Object)READ_WRITE_UUID)) {
                        if (byArray == null) {
                            logUtil.e("Device Error: \u624b\u673a\u53d1\u6765\u6d88\u606f value is null !!!");
                            return;
                        }
                        if (byArray.length == 0) {
                            logUtil.e("Device Error: received value is empty");
                            return;
                        }
                        if (byArray.length < 4) {
                            logUtil.e("Device Error: received value size is value!!.size");
                            return;
                        }
                        logUtil.i("Device: Received the phone's info, value size is: ");
                        DataTransformUtil.INSTANCE.print(byArray);
                        Companion.getClass();
                        welink_c welink_c3 = object2;
                        Object object2 = 2;
                        object = welink_c3.this;
                        mArrayBlockingQueue.add(new Triple(object2, (Object)byArray, object));
                    }
                }
            }

            public void onDescriptorReadRequest(@NotNull BluetoothDevice bluetoothDevice, int n2, int n3, @NotNull BluetoothGattDescriptor bluetoothGattDescriptor) {
                Intrinsics.checkNotNullParameter((Object)bluetoothDevice, (String)"device");
                Intrinsics.checkNotNullParameter((Object)bluetoothGattDescriptor, (String)"descriptor");
                super.onDescriptorReadRequest(bluetoothDevice, n2, n3, bluetoothGattDescriptor);
                LogUtil.INSTANCE.i("Devices: onDescriptorReadRequest: device: " + bluetoothDevice + ", requestId: " + n2 + ",offset: " + n3 + ", descriptor: " + bluetoothGattDescriptor.getUuid() + ' ');
            }

            public void onDescriptorWriteRequest(@NotNull BluetoothDevice bluetoothDevice, int n2, @NotNull BluetoothGattDescriptor bluetoothGattDescriptor, boolean bl, boolean bl2, int n3, @NotNull byte[] byArray) {
                BluetoothGattServer bluetoothGattServer;
                Intrinsics.checkNotNullParameter((Object)bluetoothDevice, (String)"device");
                Intrinsics.checkNotNullParameter((Object)bluetoothGattDescriptor, (String)"descriptor");
                Intrinsics.checkNotNullParameter((Object)byArray, (String)"value");
                super.onDescriptorWriteRequest(bluetoothDevice, n2, bluetoothGattDescriptor, bl, bl2, n3, byArray);
                if (bl2 && (bluetoothGattServer = mGattServer) != null) {
                    bluetoothGattServer.sendResponse(bluetoothDevice, n2, 0, 0, byArray);
                }
                LogUtil logUtil = LogUtil.INSTANCE;
                logUtil.i("Devices: onDescriptorWriteRequest: device: " + bluetoothDevice + ", requestId: " + n2 + ",responseNeeded: " + bl2 + ", descriptor: " + bluetoothGattDescriptor.getUuid() + " value is :");
                if (Intrinsics.areEqual((Object)bluetoothDevice, (Object)mPhone)) {
                    logUtil.i("Device: onDescriptorWriteRequest, device is welink mDevice");
                    if (Intrinsics.areEqual((Object)bluetoothGattDescriptor.getUuid(), (Object)DESCRIPTOR_UUID)) {
                        welink_c welink_c2 = object;
                        logUtil.i("Devices: onDescriptorWriteRequest: success");
                        mIsDescriptorWriteSuccess = true;
                        if (!mIsSetAttMtu) {
                            int n4 = Build.VERSION.SDK_INT;
                            n4 = 24 <= n4 && n4 <= 25 ? 247 : (n4 > 25 ? 517 : 23);
                            logUtil.i("send localMaxAttMTU:" + n4 + " to phone");
                            Object object = DataTransformUtil.INSTANCE.toByteArray(n4, 2);
                            object.this.sendData$welinkSDK_release((byte)62, false, false, (byte[])object);
                        }
                    }
                    DataTransformUtil.INSTANCE.print(byArray);
                }
            }

            public void onExecuteWrite(@NotNull BluetoothDevice bluetoothDevice, int n2, boolean bl) {
                BluetoothDevice bluetoothDevice2 = bluetoothDevice;
                Intrinsics.checkNotNullParameter((Object)bluetoothDevice2, (String)"device");
                super.onExecuteWrite(bluetoothDevice2, n2, bl);
                LogUtil.INSTANCE.i(Intrinsics.stringPlus((String)"Devices: onExecuteWrite, execute: ", (Object)bl));
            }

            public void onNotificationSent(@NotNull BluetoothDevice bluetoothDevice, int n2) {
                welink_c welink_c2 = this;
                BluetoothDevice bluetoothDevice2 = bluetoothDevice;
                Intrinsics.checkNotNullParameter((Object)bluetoothDevice2, (String)"device");
                super.onNotificationSent(bluetoothDevice2, n2);
                mIsLastSendOK = true;
                LogUtil.INSTANCE.i(Intrinsics.stringPlus((String)"Devices: mIsLastSendOK, onNotificationSent, status: ", (Object)n2));
            }

            public void onMtuChanged(@NotNull BluetoothDevice object, int n2) {
                BluetoothDevice bluetoothDevice = object;
                welink_c welink_c2 = object3;
                BluetoothDevice bluetoothDevice2 = object;
                Intrinsics.checkNotNullParameter((Object)bluetoothDevice2, (String)"device");
                super.onMtuChanged(bluetoothDevice2, n2);
                object = LogUtil.INSTANCE;
                object.i(Intrinsics.stringPlus((String)"Devices: onMtuChanged, attMtu: ", (Object)n2));
                if (Intrinsics.areEqual((Object)bluetoothDevice, (Object)mPhone)) {
                    object.i("Device: onMtuChanged, device is welink mDevice");
                    if (n2 > 20) {
                        welink_c welink_c3 = object3;
                        welink_a welink_a2 = Companion;
                        DATA_MAX_LENGTH = n2 - 3 - FRAME_HEAD_LENGTH;
                        object.i("Devices: gatt mtu is " + n2 + ",DATA_MAX_LENGTH: " + DATA_MAX_LENGTH + ", ");
                        mIsMTURequested = true;
                        Object object2 = welink_c3.this.getMOnStatusChangeListener();
                        if (object2 != null) {
                            object2.statusChange(103);
                        }
                        if (mIsAutoConnectWifi) {
                            object.i("Devices: onMtuChanged, mIsAutoConnectWifi is true, now send device's wifi info and 5G_Mac info to phone");
                            byte[] byArray = new byte[5];
                            object = byArray;
                            byArray[0] = -18;
                            byArray[1] = 0;
                            byArray[2] = 9;
                            byArray[3] = 0;
                            byArray[4] = 0;
                            welink_a2.getClass();
                            welink_c welink_c4 = object3;
                            Object object3 = 2;
                            object2 = welink_c4.this;
                            mArrayBlockingQueue.add(new Triple(object3, object, object2));
                        }
                    }
                }
            }
        };
        welink_a2.mGattCallback = new BluetoothGattCallback(){

            public void onConnectionStateChange(@NotNull BluetoothGatt bluetoothGatt, int n2, int n3) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)bluetoothGatt, (String)"gatt");
                LogUtil logUtil = LogUtil.INSTANCE;
                logUtil.i("Phone: onConnectionStateChange status:" + n2 + "  newState:" + n3);
                if (n3 != 0) {
                    if (n3 == 2) {
                        logUtil.i("GATT STATE_CONNECTED: gatt is " + bluetoothGatt + "\uff0cmBluetoothGatt is " + mBluetoothGatt + '!');
                        logUtil.i("GATT STATE_CONNECTED: requestConnectionPriority result is " + bluetoothGatt.requestConnectionPriority(1) + '!');
                        if (mBluetoothGatt == null) {
                            mBluetoothGatt = bluetoothGatt;
                        }
                        welink_b welink_b2 = object;
                        bluetoothGatt.discoverServices();
                        mIsGattConnect = true;
                        object = welink_b2.this.getMOnStatusChangeListener();
                        if (object != null) {
                            object.statusChange(100);
                        }
                        Companion.welink_b();
                    }
                } else {
                    welink_b welink_b3 = object;
                    logUtil.e("GATT STATE_DISCONNECTED: gatt is " + bluetoothGatt + "\uff0cmBluetoothGatt is " + mBluetoothGatt + '!');
                    mIsGattConnect = false;
                    mIsMTURequested = false;
                    mIsDescriptorWriteSuccess = false;
                    logUtil.i("\u5148\u91ca\u653e\u8d44\u6e90!");
                    if (mBluetoothGatt != null && !Intrinsics.areEqual((Object)mBluetoothGatt, (Object)bluetoothGatt)) {
                        welink_b welink_b4 = object;
                        welink_a welink_a2 = welink_b4.this;
                        BluetoothGatt bluetoothGatt2 = welink_a2.mBluetoothGatt;
                        Intrinsics.checkNotNull((Object)bluetoothGatt2);
                        welink_a2.freeGattResource(bluetoothGatt2);
                        mBluetoothGatt = null;
                    }
                    welink_b welink_b5 = object;
                    welink_b5.this.freeGattResource(bluetoothGatt);
                    if (welink_b5.this.getMGattNeedReconnect()) {
                        object.this.connectBleDevice();
                        logUtil.i("\u73b0\u5728\u91cd\u65b0\u5efa\u7acbgatt\u8fde\u63a5\uff0c\u7cfb\u7edf\u9ed8\u8ba4\u8fde\u63a5\u8d85\u65f6\u65f6\u95f4\u662f30s\uff0c\u8d85\u65f6\u540e\u4f1a\u518d\u6b21\u6536\u5230STATE_DISCONNECTED\u4e8b\u4ef6\uff0c\u8fde\u63a5\u6210\u529f\u540e\u4f1a\u6536\u5230STATE_CONNECTED");
                    } else {
                        logUtil.i("\u4e3b\u52a8\u65ad\u8fde\u7684\uff0c\u4e0d\u9700\u8981\u91cd\u8fde!");
                    }
                    object = object.this.getMOnStatusChangeListener();
                    if (object != null) {
                        object.statusChange(101);
                    }
                }
            }

            public void onServicesDiscovered(@NotNull BluetoothGatt bluetoothGatt, int n2) {
                Intrinsics.checkNotNullParameter((Object)bluetoothGatt, (String)"gatt");
                LogUtil logUtil = LogUtil.INSTANCE;
                logUtil.i(Intrinsics.stringPlus((String)"Phone: onServicesDiscovered status:", (Object)n2));
                if (Intrinsics.areEqual((Object)bluetoothGatt, (Object)mBluetoothGatt) && n2 == 0) {
                    logUtil.i("Phone: onServicesDiscovered, and it is welink gatt");
                    OnStatusChangeListener onStatusChangeListener = this.getMOnStatusChangeListener();
                    if (onStatusChangeListener != null) {
                        onStatusChangeListener.statusChange(102);
                    }
                    this.initService(bluetoothGatt);
                }
            }

            public void onCharacteristicRead(@NotNull BluetoothGatt bluetoothGatt, @NotNull BluetoothGattCharacteristic bluetoothGattCharacteristic, int n2) {
                Intrinsics.checkNotNullParameter((Object)bluetoothGatt, (String)"gatt");
                Intrinsics.checkNotNullParameter((Object)bluetoothGattCharacteristic, (String)"characteristic");
                LogUtil.INSTANCE.i("Phone: Read characteristic:" + bluetoothGattCharacteristic + "  status:" + n2);
            }

            public void onDescriptorWrite(@Nullable BluetoothGatt object, @Nullable BluetoothGattDescriptor bluetoothGattDescriptor, int n2) {
                BluetoothGatt bluetoothGatt = object;
                welink_b welink_b2 = this;
                super.onDescriptorWrite((BluetoothGatt)object, bluetoothGattDescriptor, n2);
                object = LogUtil.INSTANCE;
                ((LogUtil)object).i(Intrinsics.stringPlus((String)"Phone: onDescriptorWrite status:", (Object)n2));
                if (Intrinsics.areEqual((Object)bluetoothGatt, (Object)mBluetoothGatt)) {
                    ((LogUtil)object).i("Phone: onDescriptorWrite ,and it is welink gatt");
                    if (n2 == 0) {
                        welink_b welink_b3 = this;
                        ((LogUtil)object).i("Phone: onDescriptorWrite status success and it is welink gatt");
                        mIsDescriptorWriteSuccess = true;
                        if (mIsSetAttMtu) {
                            bluetoothGattDescriptor = mBluetoothGatt;
                            if (bluetoothGattDescriptor != null) {
                                bluetoothGattDescriptor.requestMtu(mAttMtu);
                            }
                            DATA_MAX_LENGTH = mAttMtu - 3 - FRAME_HEAD_LENGTH;
                            ((LogUtil)object).i("Phone: now mAttMtu: " + mAttMtu + ", new DATA_MAX_LENGTH: " + DATA_MAX_LENGTH);
                        }
                    } else {
                        ((LogUtil)object).e("Phone: onDescriptorWrite status error!");
                    }
                }
            }

            public void onMtuChanged(@NotNull BluetoothGatt object, int n2, int n3) {
                welink_b welink_b2 = onStatusChangeListener;
                BluetoothGatt bluetoothGatt = object;
                Intrinsics.checkNotNullParameter((Object)bluetoothGatt, (String)"gatt");
                super.onMtuChanged(bluetoothGatt, n2, n3);
                if (Intrinsics.areEqual((Object)object, (Object)mBluetoothGatt)) {
                    object = LogUtil.INSTANCE;
                    ((LogUtil)object).i("Phone: onMtuChanged, and it is welink gatt");
                    if (n3 == 0) {
                        ((LogUtil)object).i(Intrinsics.stringPlus((String)"Phone: onMtuChanged success, att mtu = ", (Object)n2));
                    } else {
                        ((LogUtil)object).i("Phone: onMtuChanged fail");
                    }
                    welink_b welink_b3 = onStatusChangeListener;
                    mIsMTURequested = true;
                    OnStatusChangeListener onStatusChangeListener = welink_b3.this.getMOnStatusChangeListener();
                    if (onStatusChangeListener != null) {
                        onStatusChangeListener.statusChange(103);
                    }
                }
            }

            /*
             * WARNING - void declaration
             * Enabled aggressive block sorting
             */
            public void onCharacteristicChanged(@NotNull BluetoothGatt object, @NotNull BluetoothGattCharacteristic object2) {
                void var2_5;
                Object object3;
                Intrinsics.checkNotNullParameter((Object)object3, (String)"gatt");
                Intrinsics.checkNotNullParameter((Object)var2_5, (String)"characteristic");
                if (!Intrinsics.areEqual((Object)object3, (Object)mBluetoothGatt)) {
                    LogUtil.INSTANCE.i("Phone: onCharacteristicChanged , it is not welink gatt");
                    return;
                }
                if (var2_5.getValue() == null) {
                    LogUtil.INSTANCE.e("Phone: \u8bbe\u5907\u53d1\u6765\u6d88\u606f\uff1avalue is null !!!");
                    return;
                }
                object3 = LogUtil.INSTANCE;
                StringBuilder stringBuilder = new StringBuilder().append("Phone: Received the remote's info, value size is ").append(var2_5.getValue().length).append(" \nvalue:");
                byte[] byArray = var2_5.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"characteristic.value");
                ((LogUtil)object3).i(stringBuilder.append(DataTransformUtil.INSTANCE.toHEXString(byArray)).toString());
                if (var2_5.getValue()[0] == -18) {
                    byte by = var2_5.getValue()[2];
                    Companion.getClass();
                    if (by == mHugeDataModel.getFuncCode()) {
                        byte[] byArray2 = var2_5.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"characteristic.value");
                        this.analysisReceiveData(byArray2);
                        return;
                    }
                }
                if (var2_5.getValue()[0] == -18 && var2_5.getValue()[2] == 62) {
                    if (var2_5.getValue().length != FRAME_HEAD_LENGTH + 2) return;
                    int n2 = Build.VERSION.SDK_INT;
                    n2 = 24 <= n2 && n2 <= 25 ? 247 : (n2 > 25 ? 517 : 23);
                    int n3 = (UByte.constructor-impl((byte)var2_5.getValue()[5]) & 0xFF) << 8 | (UByte.constructor-impl((byte)var2_5.getValue()[6]) & 0xFF) << 0;
                    ((LogUtil)object3).i(Intrinsics.stringPlus((String)"Phone: GET_MAX_MTU: get remote support max mtu is: ", (Object)n3));
                    if (n3 < FRAME_HEAD_LENGTH + 1) {
                        DATA_MAX_LENGTH = 20 - FRAME_HEAD_LENGTH;
                        ((LogUtil)object3).e(Intrinsics.stringPlus((String)"Phone: maxAttMTU is illegal, now use default att mtu: 23, DATA_MAX_LENGTH : ", (Object)DATA_MAX_LENGTH));
                        return;
                    }
                    if (n2 > n3) {
                        BluetoothGatt bluetoothGatt = mBluetoothGatt;
                        if (bluetoothGatt != null) {
                            bluetoothGatt.requestMtu(n3);
                        }
                        DATA_MAX_LENGTH = n3 - 3 - FRAME_HEAD_LENGTH;
                        ((LogUtil)object3).i("Phone: now use remoteMaxMTU as att mtu: " + n3 + ", new DATA_MAX_LENGTH: " + DATA_MAX_LENGTH);
                        return;
                    }
                    BluetoothGatt bluetoothGatt = mBluetoothGatt;
                    if (bluetoothGatt != null) {
                        bluetoothGatt.requestMtu(n2);
                    }
                    DATA_MAX_LENGTH = n2 - 3 - FRAME_HEAD_LENGTH;
                    ((LogUtil)object3).i("Phone: now use localMaxAttMTU as att mtu: " + n2 + ", new DATA_MAX_LENGTH: " + DATA_MAX_LENGTH);
                    return;
                }
                Companion.getClass();
                Integer n4 = 2;
                object3 = var2_5.getValue();
                welink_a welink_a2 = this;
                mArrayBlockingQueue.add(new Triple((Object)n4, object3, (Object)welink_a2));
            }

            public void onCharacteristicWrite(@NotNull BluetoothGatt bluetoothGatt, @NotNull BluetoothGattCharacteristic bluetoothGattCharacteristic, int n2) {
                Intrinsics.checkNotNullParameter((Object)bluetoothGatt, (String)"gatt");
                Intrinsics.checkNotNullParameter((Object)bluetoothGattCharacteristic, (String)"characteristic");
                LogUtil.INSTANCE.i("Phone: mIsLastSendOK, Write characteristic:" + bluetoothGattCharacteristic + "  status:" + n2);
                mIsLastSendOK = true;
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    private final void analysisReceiveData(byte[] byArray) {
        List list = ArraysKt.asList((byte[])byArray);
        int n2 = byArray.length;
        if (n2 == 0) {
            LogUtil.INSTANCE.e("receiveData size is 0");
            return;
        }
        if (n2 != 1) {
            if (byArray[0] == -18) {
                int n3;
                if (byArray.length < FRAME_HEAD_LENGTH) {
                    LogUtil.INSTANCE.e(Intrinsics.stringPlus((String)"receiveData size is wrong: ", (Object)byArray.length));
                    return;
                }
                n2 = (UByte.constructor-impl((byte)byArray[3]) & 0xFF & 0x10) >> 4 << 8 | (UByte.constructor-impl((byte)byArray[3]) & 0xFF & 0x20) >> 5 << 9 | UByte.constructor-impl((byte)byArray[1]) & 0xFF;
                if (byArray.length == n2 + (n3 = FRAME_HEAD_LENGTH)) {
                    this.workCompleteData(list);
                    return;
                }
                if (byArray.length < n2 + n3) {
                    welink_a welink_a2 = this;
                    LogUtil.INSTANCE.e("receiveData short");
                    welink_a2.mDataBuff.clear();
                    welink_a2.mDataBuff.addAll(list);
                    return;
                }
                LogUtil.INSTANCE.e("receiveData long");
                this.workCompleteData(list.subList(0, n2 + FRAME_HEAD_LENGTH));
                if (((Number)list.get(n2 + FRAME_HEAD_LENGTH)).byteValue() != -18) return;
                welink_a welink_a3 = this;
                welink_a3.mDataBuff.clear();
                List list2 = list;
                int n4 = n2 + FRAME_HEAD_LENGTH;
                welink_a3.mDataBuff.addAll(list2.subList(n4, list2.size()));
                welink_a3.workDataBuff();
                return;
            }
            if (!this.mDataBuff.isEmpty()) {
                welink_a welink_a4 = this;
                LogUtil.INSTANCE.e("buffer not empty,add in the last");
                welink_a4.mDataBuff.addAll(list);
                welink_a4.workDataBuff();
                return;
            }
            if (list.contains((byte)-18)) {
                welink_a welink_a5 = this;
                LogUtil.INSTANCE.e("receiveData has HEADER_IDENTIFY,but not on the first");
                List list3 = list;
                int n5 = list3.indexOf((byte)-18);
                welink_a5.mDataBuff.addAll(list3.subList(n5, list3.size()));
                welink_a5.workDataBuff();
                return;
            }
            LogUtil.INSTANCE.e("receiveData hasn't HEADER_IDENTIFY");
            return;
        }
        if (byArray[0] == -18) {
            welink_a welink_a6 = this;
            LogUtil.INSTANCE.e("receiveData has HEADER_IDENTIFY only");
            welink_a6.mDataBuff.clear();
            welink_a6.mDataBuff.addAll(list);
            return;
        }
        if (!(this.mDataBuff.isEmpty() ^ true)) return;
        welink_a welink_a7 = this;
        LogUtil.INSTANCE.e("receiveData hasn't HEADER_IDENTIFY,but buffer no empty");
        welink_a7.mDataBuff.addAll(list);
        welink_a7.workDataBuff();
    }

    private final void workDataBuff() {
        if (this.mDataBuff.size() >= 2) {
            if (((Number)this.mDataBuff.get(0)).byteValue() != -18) {
                LogUtil.INSTANCE.i("mDataBuff first is not HEADER_IDENTIFY");
                return;
            }
            if (this.mDataBuff.size() < FRAME_HEAD_LENGTH) {
                LogUtil.INSTANCE.e("mDataBuff's size is wrong, smaller than FRAME_HEAD_LENGTH");
                return;
            }
            int n2 = ((UByte.constructor-impl((byte)((Number)this.mDataBuff.get(3)).byteValue()) & 0xFF & 0x10) >> 4 << 8 | (UByte.constructor-impl((byte)((Number)this.mDataBuff.get(3)).byteValue()) & 0xFF & 0x20) >> 5 << 9 | UByte.constructor-impl((byte)((Number)this.mDataBuff.get(1)).byteValue()) & 0xFF) + FRAME_HEAD_LENGTH;
            while (this.mDataBuff.size() >= n2) {
                if (this.mDataBuff.size() == n2) {
                    welink_a welink_a2 = this;
                    welink_a2.workCompleteData(welink_a2.mDataBuff);
                    welink_a2.mDataBuff.clear();
                    continue;
                }
                if (this.mDataBuff.size() <= n2) continue;
                welink_a welink_a3 = this;
                List<Byte> list = welink_a3.mDataBuff;
                welink_a3.workCompleteData(list.subList(0, list.indexOf((byte)-18)));
                List<Byte> list2 = welink_a3.mDataBuff;
                if (((Number)list2.get(list2.indexOf((byte)-18))).byteValue() == -18) {
                    List<Byte> list3 = this.mDataBuff;
                    this.mDataBuff = list3.subList(list3.indexOf((byte)-18), this.mDataBuff.size());
                    continue;
                }
                this.mDataBuff.clear();
            }
        }
    }

    private final void workCompleteData(List<Byte> list) {
        if (list.size() < FRAME_HEAD_LENGTH) {
            LogUtil.INSTANCE.e("receiveData's size is wrong, smaller than FRAME_HEAD_LENGTH");
            return;
        }
        List<Byte> list2 = list;
        int n2 = ((Number)list2.get(0)).byteValue();
        byte by = ((Number)list2.get(2)).byteValue();
        boolean bl = (byte)(((Number)list2.get(3)).byteValue() & 1) >> 0 == 1;
        boolean bl2 = (byte)(((Number)list.get(3)).byteValue() & 2) >> 1 == 1;
        boolean bl3 = (byte)(((Number)list.get(3)).byteValue() & 4) >> 2 == 1;
        int n3 = UByte.constructor-impl((byte)((Number)list.get(4)).byteValue()) & 0xFF;
        if (n2 != -18) {
            LogUtil.INSTANCE.e(Intrinsics.stringPlus((String)"This is not our packet, packetHeardFlag is ", (Object)((byte)n2)));
            return;
        }
        n2 = (UByte.constructor-impl((byte)((Number)list.get(3)).byteValue()) & 0xFF & 0x10) >> 4 << 8 | (UByte.constructor-impl((byte)((Number)list.get(3)).byteValue()) & 0xFF & 0x20) >> 5 << 9 | UByte.constructor-impl((byte)((Number)list.get(1)).byteValue()) & 0xFF;
        LogUtil logUtil = LogUtil.INSTANCE;
        logUtil.i(Intrinsics.stringPlus((String)"completeDataLength is ", (Object)n2));
        if (n2 == list.size() - FRAME_HEAD_LENGTH) {
            n2 = FRAME_HEAD_LENGTH;
            if (list.size() - n2 <= DATA_MAX_LENGTH) {
                if (bl) {
                    List<Byte> list3 = list;
                    n2 = UByte.constructor-impl((byte)((Number)list3.get(n2)).byteValue()) & 0xFF;
                    bl = (UByte.constructor-impl((byte)((Number)list3.get(FRAME_HEAD_LENGTH + 1)).byteValue()) & 0xFF) == 0;
                    logUtil.i("responseSuccessPackageIndex is " + n2 + ", respondReceivedSuccess is " + bl + " mHugeDataModel.dataPackageIndex is " + mHugeDataModel.getDataPackageIndex());
                    if ((UByte.constructor-impl((byte)mHugeDataModel.getFuncCode()) & 0xFF) == (UByte.constructor-impl((byte)by) & 0xFF) && n2 == mHugeDataModel.getDataPackageIndex()) {
                        if (bl) {
                            mHugeDataModel.setRemoteReceivedSuccess(true);
                            logUtil.i(Intrinsics.stringPlus((String)"Success: in receive : mIsRemoteReceivedSuccess is ", (Object)mHugeDataModel.isRemoteReceivedSuccess()));
                        } else {
                            mHugeDataModel.setRemoteReceivedSuccess(false);
                            logUtil.e(Intrinsics.stringPlus((String)"Error: in receive  : mIsRemoteReceivedSuccess is ", (Object)mHugeDataModel.isRemoteReceivedSuccess()));
                        }
                    }
                }
                welink_a welink_a2 = list4;
                List list4 = CollectionsKt.drop(list, (int)FRAME_HEAD_LENGTH);
                welink_a2.workReceiveData(by, n3, bl2, bl3, list4);
                return;
            }
        }
        logUtil.i(Intrinsics.stringPlus((String)"The length of the data is wrong, packetDataLen is ", (Object)(list.size() - DATA_MAX_LENGTH)));
        if (bl3) {
            ((welink_a)((Object)list4)).responseReceivedError$welinkSDK_release(by, n3);
        }
    }

    private final BluetoothGattService initGattService() {
        BluetoothGattService bluetoothGattService = new BluetoothGattService(SERVICE_UUID, 0);
        BluetoothGattCharacteristic bluetoothGattCharacteristic = new BluetoothGattCharacteristic(READ_WRITE_UUID, 30, 17);
        bluetoothGattCharacteristic.setWriteType(1);
        bluetoothGattCharacteristic.addDescriptor(new BluetoothGattDescriptor(DESCRIPTOR_UUID, 16));
        LogUtil.INSTANCE.i("setupGattService here addCharacteristic");
        bluetoothGattService.addCharacteristic(bluetoothGattCharacteristic);
        return bluetoothGattService;
    }

    private final void setGattServer() {
        Object object = this.mContext.getSystemService("bluetooth");
        if (object != null) {
            BluetoothManager bluetoothManager = (BluetoothManager)object;
            welink_a welink_a2 = this;
            object = welink_a2.mContext;
            if ((object = bluetoothManager.openGattServer((Context)object, welink_a2.mGattServerCallback)) == null) {
                object = null;
            } else {
                object.addService(this.initGattService());
            }
            this.mGattServer = object;
            return;
        }
        throw new NullPointerException("null cannot be cast to non-null type android.bluetooth.BluetoothManager");
    }

    private final void updateConnectParameter(BluetoothGatt bluetoothGatt, int n2, int n3, int n4, int n5, int n6, int n7) {
        Object object;
        block18: {
            block17: {
                object = bluetoothGatt.getClass();
                if (object != null) break block17;
                object = null;
                break block18;
            }
            Class[] classArray = new Class[6];
            classArray[0] = IntCompanionObject.INSTANCE.getClass();
            classArray[1] = IntCompanionObject.INSTANCE.getClass();
            classArray[2] = IntCompanionObject.INSTANCE.getClass();
            classArray[3] = IntCompanionObject.INSTANCE.getClass();
            classArray[4] = IntCompanionObject.INSTANCE.getClass();
            classArray[5] = IntCompanionObject.INSTANCE.getClass();
            object = object.getDeclaredMethod("requestLeConnectionUpdate", classArray);
        }
        Object[] objectArray = object;
        BluetoothGatt bluetoothGatt2 = bluetoothGatt;
        Object[] objectArray2 = new Object[6];
        object = objectArray2;
        int n8 = 0;
        object[n8] = n2;
        n8 = 1;
        object[n8] = n3;
        n8 = 2;
        object[n8] = n4;
        n8 = 3;
        object[n8] = n5;
        n8 = 4;
        object[n8] = n6;
        n8 = 5;
        objectArray2[n8] = n7;
        Object object2 = objectArray.invoke((Object)bluetoothGatt2, objectArray2);
        try {
            LogUtil.INSTANCE.i("now requestLeConnectionUpdate ! result is " + object2 + " gatt is " + bluetoothGatt);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LogUtil.INSTANCE.e(Intrinsics.stringPlus((String)"requestLeConnectionUpdate: error!!!", (Object)exception.getMessage()));
        }
    }

    private final void initService(BluetoothGatt object) {
        BluetoothGattService bluetoothGattService = object.getService(SERVICE_UUID);
        LogUtil logUtil = LogUtil.INSTANCE;
        logUtil.i(Intrinsics.stringPlus((String)"Phone: gattService:", (Object)bluetoothGattService));
        Object object2 = bluetoothGattService == null ? null : bluetoothGattService.getCharacteristic(READ_WRITE_UUID);
        this.mReadWriteCharacteristic = object2;
        object2 = new StringBuilder().append("Phone: mReadWriteCharacteristic:").append(this.mReadWriteCharacteristic).append(", properties: ");
        Object object3 = this.mReadWriteCharacteristic;
        object3 = object3 == null ? null : Integer.valueOf(object3.getProperties());
        logUtil.i(((StringBuilder)object2).append(object3).toString());
        object2 = this.mReadWriteCharacteristic;
        if (object2 != null) {
            object2.setWriteType(1);
        }
        object2 = this.mReadWriteCharacteristic;
        object2 = object2 == null ? null : object2.getDescriptor(DESCRIPTOR_UUID);
        if (bluetoothGattService != null && this.mReadWriteCharacteristic != null && object2 != null) {
            object2.setValue(BluetoothGattDescriptor.ENABLE_NOTIFICATION_VALUE);
            object.setCharacteristicNotification(this.mReadWriteCharacteristic, true);
            object.writeDescriptor((BluetoothGattDescriptor)object2);
            logUtil.i("Phone: initService finish !");
            return;
        }
        logUtil.e("Phone: initService error: gattService is " + bluetoothGattService + ", mReadWriteCharacteristic is " + this.mReadWriteCharacteristic + "descriptor is " + object2 + ", now disconnect gatt");
        object = this.mOnStatusChangeListener;
        if (object != null) {
            object.statusChange(101);
        }
        this.disconnect();
    }

    private final void finalSendData(byte[] byArray, boolean bl) {
        int n2 = 0;
        Object object = LogUtil.INSTANCE;
        ((LogUtil)object).i("finalSendData: mReadWriteCharacteristic " + this.mReadWriteCharacteristic + "  mIsDevice is " + mIsDevice + ' ');
        BluetoothGattCharacteristic bluetoothGattCharacteristic = this.mReadWriteCharacteristic;
        if (bluetoothGattCharacteristic != null) {
            bluetoothGattCharacteristic.setWriteType(1);
            bluetoothGattCharacteristic.setValue(byArray);
            if (mIsDevice) {
                ((LogUtil)object).i("finalSendData: Devices: now in finalSendData, send notify to phone, send value is:");
                object = this.mGattServer;
                if (object != null) {
                    this.mIsLastSendOK = false;
                    n2 = 0;
                    while (!this.mIsLastSendOK && this.getMIsGattConnect() && this.mIsDescriptorWriteSuccess && !object.notifyCharacteristicChanged(this.mPhone, bluetoothGattCharacteristic, false) && n2++ < 5000) {
                        LogUtil.INSTANCE.i("finalSendData: mIsLastSendOK: " + this.mIsLastSendOK + " Devices: gattServer finalSendData retry time: " + n2 + '!');
                        Thread.sleep(1L);
                    }
                    if (n2 >= 5000) {
                        LogUtil.INSTANCE.e("finalSendData: Device: send maybe error, mIsLastSendOK: " + this.mIsLastSendOK + " retry time: " + n2 + '!');
                    }
                }
            } else {
                ((LogUtil)object).i("finalSendData: Phone: now in finalSendData, send writeCharacter to phone, send value is:");
                object = this.mBluetoothGatt;
                if (object != null) {
                    this.mIsLastSendOK = false;
                    n2 = 0;
                    while (!this.mIsLastSendOK && this.getMIsGattConnect() && this.mIsDescriptorWriteSuccess && !object.writeCharacteristic(bluetoothGattCharacteristic) && n2++ < 5000) {
                        Thread.sleep(1L);
                    }
                    if (n2 >= 5000) {
                        LogUtil.INSTANCE.e("finalSendData: Phone: send maybe error, mIsLastSendOK: " + this.mIsLastSendOK + " retry time: " + n2 + '!');
                    }
                }
            }
        }
        if (n2 >= 5000) {
            LogUtil.INSTANCE.e("finalSendData: Error: local send error by retry timeout!");
        } else if (this.mIsGattConnect && this.mIsDescriptorWriteSuccess) {
            LogUtil logUtil = LogUtil.INSTANCE;
            logUtil.i("finalSendData: local send finish!");
            object = CommonConstant.INSTANCE;
            if (((CommonConstant)object).getMIsNeedDisconnectGattAfterSendBleData()) {
                logUtil.i("finalSendData: need disconnect gatt after send the ble data, data send finished, now disconnect gatt");
                this.disconnect();
                ((CommonConstant)object).setMIsNeedDisconnectGattAfterSendBleData(false);
            }
            if (!bl) {
                mHugeDataModel.setRemoteReceivedSuccess(true);
                mHugeDataModel.setDataPackageIndex(UByte.constructor-impl((byte)byArray[4]) & 0xFF);
                logUtil.i("finalSendData: This send package does not need response, mHugeDataModel.dataPackageIndex is " + mHugeDataModel.getDataPackageIndex() + '!');
            }
        } else {
            LogUtil.INSTANCE.e("finalSendData: Error: send error!!! GattConnect is " + this.mIsGattConnect + ", DescriptorWriteStatus is " + this.mIsDescriptorWriteSuccess + '!');
        }
    }

    private final void handleSendData(byte[] byArray, boolean bl) {
        LogUtil logUtil = LogUtil.INSTANCE;
        logUtil.i("handleSendData: size is : " + byArray.length + ", data is: ");
        if (bl) {
            int n2 = 0;
            mHugeDataModel.setRemoteReceivedSuccess(false);
            while (!mHugeDataModel.isRemoteReceivedSuccess() && n2++ < 10) {
                if (n2 > 1) {
                    byArray[3] = (byte)(byArray[3] | 8);
                }
                LogUtil.INSTANCE.i("handleSendData: reSendTime is " + n2 + ", send writeCharacterData is ");
                DataTransformUtil.INSTANCE.print(byArray);
                this.finalSendData(byArray, bl);
                Thread.sleep(50L);
            }
            if (mHugeDataModel.isRemoteReceivedSuccess()) {
                LogUtil logUtil2 = LogUtil.INSTANCE;
                logUtil2.i(Intrinsics.stringPlus((String)"handleSendData: mHugeDataPackageIndex is ", (Object)mHugeDataModel.getDataPackageIndex()));
                mHugeDataModel.setDataPackageIndex(UByte.constructor-impl((byte)byArray[4]) & 0xFF);
                logUtil2.i("handleSendData: send success!!!");
            } else {
                LogUtil.INSTANCE.e("handleSendData: Error: send error by 10 times!!! Now stop send....");
            }
        } else {
            logUtil.i("handleSendData: This package does not need response confirm, now send data is ");
            this.finalSendData(byArray, bl);
        }
    }

    public static final /* synthetic */ UUID access$getSERVICE_UUID$cp() {
        return SERVICE_UUID;
    }

    public static final /* synthetic */ void access$setMIsDevice$cp(boolean bl) {
        mIsDevice = bl;
    }

    public static final /* synthetic */ void access$setMHugeDataModel$cp(HugeDataModel hugeDataModel) {
        mHugeDataModel = hugeDataModel;
    }

    public static final /* synthetic */ void access$setMPhone$p(welink_a welink_a2, BluetoothDevice bluetoothDevice) {
        welink_a2.mPhone = bluetoothDevice;
    }

    public static final /* synthetic */ void access$setMReadWriteCharacteristic$p(welink_a welink_a2, BluetoothGattCharacteristic bluetoothGattCharacteristic) {
        welink_a2.mReadWriteCharacteristic = bluetoothGattCharacteristic;
    }

    public static final /* synthetic */ BluetoothGattCharacteristic access$getMReadWriteCharacteristic$p(welink_a welink_a2) {
        return welink_a2.mReadWriteCharacteristic;
    }

    static {
        mHugeDataModel = new HugeDataModel(-1, true, -1, 0);
    }

    @Nullable
    public final String getAddress() {
        return this.address;
    }

    @NotNull
    public final Context getMContext() {
        return this.mContext;
    }

    public final boolean getMIsGattConnect() {
        return this.mIsGattConnect;
    }

    public final boolean getMIsMTURequested() {
        return this.mIsMTURequested;
    }

    public final boolean getMGattNeedReconnect() {
        return this.mGattNeedReconnect;
    }

    public final void setMGattNeedReconnect(boolean bl) {
        this.mGattNeedReconnect = bl;
    }

    @Nullable
    public final OnStatusChangeListener getMOnStatusChangeListener() {
        return this.mOnStatusChangeListener;
    }

    public final void setMOnStatusChangeListener(@Nullable OnStatusChangeListener onStatusChangeListener) {
        this.mOnStatusChangeListener = onStatusChangeListener;
    }

    public final void setOnStatusBLEChangeListener(@NotNull OnStatusChangeListener onStatusChangeListener) {
        Intrinsics.checkNotNullParameter((Object)onStatusChangeListener, (String)"onStatusChangeListener");
        this.mOnStatusChangeListener = onStatusChangeListener;
    }

    public abstract void workReceiveData(byte var1, int var2, boolean var3, boolean var4, @NotNull List<Byte> var5);

    public final boolean isSupportBle(@NotNull Context context) {
        Context context2 = context;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return context2.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.bluetooth_le");
    }

    public final void startGattServer() {
        boolean bl;
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (bluetoothAdapter == null) {
            LogUtil.INSTANCE.e("mBluetoothAdapter\u4e3anull\uff0c\u672c\u673a\u53ef\u80fd\u4e0d\u652f\u6301\u84dd\u7259");
            bl = false;
        } else {
            long l2 = System.currentTimeMillis();
            int n2 = 0;
            if (!bluetoothAdapter.isEnabled()) {
                LogUtil.INSTANCE.i("\u84dd\u7259\u6ca1\u6253\u5f00\uff0c\u73b0\u5728\u5f00\u542f\u84dd\u7259......");
                if (CommonConstant.INSTANCE.isKolunLegal()) {
                    KolunScannerManager.getInstance().enableBluetooth(true);
                } else {
                    bluetoothAdapter.enable();
                }
            }
            while (!bluetoothAdapter.isEnabled() && n2 < 6) {
                n2 = (int)((System.currentTimeMillis() - l2) / (long)1000);
            }
            if (!bluetoothAdapter.isEnabled() && n2 >= 6) {
                LogUtil.INSTANCE.e("\u84dd\u7259\u5f00\u542f\u8d85\u8fc76s\uff0c\u5f00\u542f\u8d85\u65f6\uff0c\u9000\u51fa\uff01");
                bl = false;
            } else {
                LogUtil.INSTANCE.i("\u84dd\u7259\u5df2\u5f00\u542f\uff01");
                bl = true;
            }
        }
        if (!bl) {
            LogUtil.INSTANCE.e("startGattServer: \u84dd\u7259\u5f00\u542f\u8d85\u65f6\uff0c\u9000\u51fa\uff01");
            return;
        }
        mIsDevice = true;
        this.setGattServer();
    }

    public final void stopGattServer() {
        BluetoothGattServer bluetoothGattServer = welink_a2.mGattServer;
        if (bluetoothGattServer != null) {
            bluetoothGattServer.close();
        }
        welink_a welink_a2 = welink_a2.mGattServer;
        if (welink_a2 != null) {
            welink_a2.clearServices();
        }
    }

    public final void setAutoConnect(boolean bl) {
        this.mIsAutoConnectWifi = bl;
    }

    public final void setAttMTUSize(int n2) {
        welink_a welink_a2 = this;
        welink_a2.mIsSetAttMtu = true;
        welink_a2.mAttMtu = n2;
    }

    public final boolean connectBleDevice() {
        boolean bl;
        BluetoothAdapter bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (bluetoothAdapter == null) {
            LogUtil.INSTANCE.e("mBluetoothAdapter\u4e3anull\uff0c\u672c\u673a\u53ef\u80fd\u4e0d\u652f\u6301\u84dd\u7259");
            bl = false;
        } else {
            long l2 = System.currentTimeMillis();
            int n2 = 0;
            if (!bluetoothAdapter.isEnabled()) {
                LogUtil.INSTANCE.i("\u84dd\u7259\u6ca1\u6253\u5f00\uff0c\u73b0\u5728\u5f00\u542f\u84dd\u7259......");
                if (CommonConstant.INSTANCE.isKolunLegal()) {
                    KolunScannerManager.getInstance().enableBluetooth(true);
                } else {
                    bluetoothAdapter.enable();
                }
            }
            while (!bluetoothAdapter.isEnabled() && n2 < 6) {
                n2 = (int)((System.currentTimeMillis() - l2) / (long)1000);
            }
            if (!bluetoothAdapter.isEnabled() && n2 >= 6) {
                LogUtil.INSTANCE.e("\u84dd\u7259\u5f00\u542f\u8d85\u8fc76s\uff0c\u5f00\u542f\u8d85\u65f6\uff0c\u9000\u51fa\uff01");
                bl = false;
            } else {
                LogUtil.INSTANCE.i("\u84dd\u7259\u5df2\u5f00\u542f\uff01");
                bl = true;
            }
        }
        if (!bl) {
            LogUtil.INSTANCE.e("connect: \u84dd\u7259\u5f00\u542f\u8d85\u65f6\uff0c\u9000\u51fa\uff01");
            return false;
        }
        BluetoothDevice bluetoothDevice = welink_a4.mBluetoothAdapter.getRemoteDevice(welink_a4.address);
        if (bluetoothDevice != null) {
            welink_a welink_a2 = welink_a4;
            BluetoothDevice bluetoothDevice2 = bluetoothDevice;
            welink_a welink_a3 = welink_a4;
            LogUtil.INSTANCE.i("connect gatt new");
            welink_a3.mGattNeedReconnect = true;
            welink_a welink_a4 = welink_a3.mContext;
            bluetoothDevice = welink_a3.mGattCallback;
            welink_a2.mBluetoothGatt = bluetoothDevice2.connectGatt((Context)welink_a4, false, (BluetoothGattCallback)bluetoothDevice, 2);
            return true;
        }
        LogUtil.INSTANCE.e("remote device is null");
        return false;
    }

    public final void freeGattResource(@NotNull BluetoothGatt bluetoothGatt) {
        Object object;
        block6: {
            block5: {
                BluetoothGatt bluetoothGatt2 = bluetoothGatt;
                Intrinsics.checkNotNullParameter((Object)bluetoothGatt2, (String)"gatt");
                bluetoothGatt2.requestConnectionPriority(0);
                object = bluetoothGatt2.getClass();
                if (object != null) break block5;
                object = null;
                break block6;
            }
            object = ((Class)object).getDeclaredMethod("refresh", new Class[0]);
        }
        object = ((Method)object).invoke((Object)bluetoothGatt, new Object[0]);
        try {
            LogUtil.INSTANCE.i("now refresh gatt! result is " + object + " gatt is " + bluetoothGatt);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LogUtil.INSTANCE.e(Intrinsics.stringPlus((String)"refresh: error!!!", (Object)exception.getMessage()));
        }
        bluetoothGatt.close();
        Companion.welink_c();
    }

    public final void disconnect() {
        welink_a2.mGattNeedReconnect = false;
        LogUtil.INSTANCE.i(Intrinsics.stringPlus((String)"\u4e3b\u52a8\u65ad\u5f00gatt\uff0c\u540e\u7eed\u4e0d\u518d\u81ea\u52a8\u56de\u8fdegatt, mBluetoothGatt is ", (Object)welink_a2.mBluetoothGatt));
        welink_a welink_a2 = welink_a2.mBluetoothGatt;
        if (welink_a2 != null) {
            welink_a2.disconnect();
        }
    }

    public final void sendDataTruly(@NotNull SendDataModel sendDataModel) {
        ArrayList<Byte> arrayList;
        SendDataModel sendDataModel2 = sendDataModel;
        Intrinsics.checkNotNullParameter((Object)sendDataModel2, (String)"sendDataModel");
        ArrayList<Byte> arrayList2 = arrayList;
        arrayList = new ArrayList<Byte>();
        byte by = 0;
        int n2 = 0;
        Object object = ArraysKt.toMutableList((byte[])sendDataModel2.getSendArray());
        if (!mIsDevice) {
            LogUtil.INSTANCE.i("update connect parameter before send data");
        }
        if (sendDataModel.isResponseConfirmPacket()) {
            by = (byte)1;
        }
        if (sendDataModel.isNeedResponseConfirm()) {
            by = (byte)(by | 4);
        }
        while (CollectionsKt.toByteArray((Collection)object).length > DATA_MAX_LENGTH) {
            if (this.mIsGattConnect && this.mIsDescriptorWriteSuccess) {
                if ((UByte.constructor-impl((byte)mHugeDataModel.getFuncCode()) & 0xFF) == sendDataModel.getFuncCode()) {
                    if (!mHugeDataModel.isRemoteReceivedSuccess()) {
                        LogUtil.INSTANCE.e("Error: sendDataTruly: the remote received failed, so stop send!!!");
                        return;
                    }
                    HugeDataModel hugeDataModel = mHugeDataModel;
                    int n3 = hugeDataModel.getDataPackageIndex() == 255 ? 0 : mHugeDataModel.getDataPackageIndex() + 1;
                    hugeDataModel.setDataPackageIndex(n3);
                    n2 = mHugeDataModel.getDataPackageIndex();
                    LogUtil.INSTANCE.i(Intrinsics.stringPlus((String)"SendDataTruly: packetIndex: ", (Object)n2));
                }
                arrayList2.add((byte)-18);
                DataTransformUtil dataTransformUtil = DataTransformUtil.INSTANCE;
                arrayList2.add(dataTransformUtil.toByteArray(DATA_MAX_LENGTH, 2)[1]);
                arrayList2.add(sendDataModel.getFuncCode());
                by = (byte)(dataTransformUtil.toByteArray(DATA_MAX_LENGTH, 2)[0] & 1) >> 0 == 1 ? (byte)((byte)(by & 0xFFFFFFEF) | 0x10) : (byte)((byte)(by & 0xFFFFFFEF) | 0);
                by = (byte)(((byte)(dataTransformUtil.toByteArray(DATA_MAX_LENGTH, 2)[0] & 2) >> 1 == 1 ? (byte)((byte)(by & 0xFFFFFFDF) | 0x20) : (byte)((byte)(by & 0xFFFFFFDF) | 0)) & 0xFFFFFFFD);
                List list = object;
                ArrayList<Byte> arrayList3 = arrayList2;
                by = (byte)((byte)by | 2);
                arrayList2.add(by);
                arrayList2.add((byte)n2);
                arrayList3.addAll(CollectionsKt.toMutableList((Collection)CollectionsKt.take((Iterable)object, (int)DATA_MAX_LENGTH)));
                object = CollectionsKt.toByteArray(arrayList3);
                this.handleSendData((byte[])object, sendDataModel.isNeedResponseConfirm());
                object = CollectionsKt.toMutableList((Collection)CollectionsKt.drop((Iterable)list, (int)DATA_MAX_LENGTH));
                if ((UByte.constructor-impl((byte)mHugeDataModel.getFuncCode()) & 0xFF) == sendDataModel.getFuncCode() && mHugeDataModel.isRemoteReceivedSuccess()) {
                    HugeDataModel hugeDataModel = mHugeDataModel;
                    hugeDataModel.setDataSendOffset(hugeDataModel.getDataSendOffset() + DATA_MAX_LENGTH);
                    int n4 = (int)((float)mHugeDataModel.getDataSendOffset() / ((float)mHugeDataModel.getDataSendOffset() + (float)CollectionsKt.toByteArray((Collection)object).length) * (float)100);
                    LogUtil.INSTANCE.i("SendDataTruly: the sent data's percent is ================" + n4 + "%==================\nmHugeDataModel.dataSendOffset: " + mHugeDataModel.getDataSendOffset());
                    OnStatusChangeListener onStatusChangeListener = this.mOnStatusChangeListener;
                    if (onStatusChangeListener != null) {
                        onStatusChangeListener.onHugeDataSendPercent(sendDataModel.getFuncCode(), n4);
                    }
                }
                n2 = n2 == 255 ? 0 : ++n2;
                arrayList2.clear();
                continue;
            }
            LogUtil.INSTANCE.e("Error: sendDataTruly: GattConnect is " + this.mIsGattConnect + ", DescriptorWriteStatus is " + this.mIsDescriptorWriteSuccess + ", stop send data");
            return;
        }
        if ((UByte.constructor-impl((byte)mHugeDataModel.getFuncCode()) & 0xFF) == sendDataModel.getFuncCode()) {
            if (!mHugeDataModel.isRemoteReceivedSuccess()) {
                LogUtil.INSTANCE.e("Error: sendDataTruly: the remote received failed, so stop send!!!");
                return;
            }
            HugeDataModel hugeDataModel = mHugeDataModel;
            int n5 = hugeDataModel.getDataPackageIndex() == 255 ? 0 : mHugeDataModel.getDataPackageIndex() + 1;
            hugeDataModel.setDataPackageIndex(n5);
            n2 = mHugeDataModel.getDataPackageIndex();
            LogUtil.INSTANCE.i(Intrinsics.stringPlus((String)"SendDataTruly: final data, packetIndex: ", (Object)n2));
        }
        arrayList2.add((byte)-18);
        DataTransformUtil dataTransformUtil = DataTransformUtil.INSTANCE;
        arrayList2.add(dataTransformUtil.toByteArray(CollectionsKt.toByteArray((Collection)object).length, 2)[1]);
        arrayList2.add(sendDataModel.getFuncCode());
        by = (byte)(dataTransformUtil.toByteArray(CollectionsKt.toByteArray((Collection)object).length, 2)[0] & 1) >> 0 == 1 ? (byte)((byte)(by & 0xFFFFFFEF) | 0x10) : (byte)((byte)(by & 0xFFFFFFEF) | 0);
        by = (byte)(((byte)(dataTransformUtil.toByteArray(CollectionsKt.toByteArray((Collection)object).length, 2)[0] & 2) >> 1 == 1 ? (byte)((byte)(by & 0xFFFFFFDF) | 0x20) : (byte)((byte)(by & 0xFFFFFFDF) | 0)) & 0xFFFFFFFD);
        ArrayList<Byte> arrayList4 = arrayList2;
        arrayList2.add((byte)((byte)by | 0));
        arrayList2.add((byte)n2);
        arrayList4.addAll((Collection<Byte>)object);
        Object object2 = CollectionsKt.toByteArray(arrayList4);
        this.handleSendData((byte[])object2, sendDataModel.isNeedResponseConfirm());
        if ((UByte.constructor-impl((byte)mHugeDataModel.getFuncCode()) & 0xFF) == sendDataModel.getFuncCode() && mHugeDataModel.isRemoteReceivedSuccess()) {
            HugeDataModel hugeDataModel = mHugeDataModel;
            hugeDataModel.setDataSendOffset(hugeDataModel.getDataSendOffset() + CollectionsKt.toByteArray((Collection)object).length);
            int n6 = 100;
            LogUtil.INSTANCE.i("SendDataTruly: the sent data's percent is ================" + n6 + "%==================\nmHugeDataModel.dataSendOffset: " + mHugeDataModel.getDataSendOffset());
            OnStatusChangeListener onStatusChangeListener = this.mOnStatusChangeListener;
            object2 = onStatusChangeListener;
            if (onStatusChangeListener != null) {
                object2.onHugeDataSendPercent(sendDataModel.getFuncCode(), n6);
            }
            mHugeDataModel.reset();
        }
        arrayList2.clear();
        object.clear();
        if (!mIsDevice) {
            LogUtil.INSTANCE.i("now recovery the connect parameter");
        }
    }

    public final void sendData$welinkSDK_release(byte by, boolean bl, boolean bl2, @NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"sendArray");
        mArrayBlockingQueue.add((Triple<Integer, Object, welink_a>)new Triple((Object)1, (Object)new SendDataModel(by, bl, bl2, byArray), (Object)this));
    }

    public final void responseReceivedSuccess$welinkSDK_release(byte by, int n2) {
        welink_a welink_a2 = object;
        byte[] byArray = new byte[2];
        Object object = byArray;
        byArray[0] = (byte)n2;
        byArray[1] = 0;
        LogUtil.INSTANCE.i("ResponseReceivedSuccess");
        welink_a2.sendData$welinkSDK_release(by, true, false, (byte[])object);
    }

    public final void responseReceivedError$welinkSDK_release(byte by, int n2) {
        welink_a welink_a2 = object;
        byte[] byArray = new byte[2];
        Object object = byArray;
        byArray[0] = (byte)n2;
        byArray[1] = 1;
        LogUtil.INSTANCE.e("ResponseReceivedError");
        welink_a2.sendData$welinkSDK_release(by, true, false, (byte[])object);
    }

    public static final class welink_a.welink_a.welink_a.welink_a.welink_c.welink_a$welink_a {
        public final boolean welink_a() {
            return mIsDevice;
        }

        public final void welink_b() {
            mConnectNum = mConnectNum + 1;
            if (mThreadRunning) {
                return;
            }
            mThreadRunning = true;
            Object object = welink_a.welink_a;
            ThreadsKt.thread$default((boolean)false, (boolean)false, null, null, (int)0, (Function0)object, (int)31, null);
        }

        public final void welink_c() {
            mConnectNum = mConnectNum + -1;
            if (mConnectNum == 0) {
                mThreadRunning = false;
                mArrayBlockingQueue.add(new Triple((Object)0, new Object(), null));
            }
        }
    }
}

