/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetcomposer;

import android.content.Context;
import android.net.Uri;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.squareup.picasso.Picasso;
import com.squareup.picasso.Transformation;
import com.twitter.sdk.android.tweetcomposer.Card;
import com.twitter.sdk.android.tweetcomposer.R;
import com.twitter.sdk.android.tweetcomposer.RoundedCornerTransformation;

public class AppCardView
extends LinearLayout {
    ImageView appImageView;
    ViewGroup appInfoLayout;
    TextView appInstallButton;
    TextView appNameView;
    TextView appStoreNameView;

    public AppCardView(Context context) {
        this(context, null);
    }

    public AppCardView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public AppCardView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context);
    }

    void init(Context context) {
        this.setOrientation(1);
        AppCardView.inflate((Context)context, (int)R.layout.tw__app_card, (ViewGroup)this);
        this.findSubviews();
        this.setButtonColor();
    }

    void findSubviews() {
        this.appImageView = (ImageView)this.findViewById(R.id.tw__app_image);
        this.appNameView = (TextView)this.findViewById(R.id.tw__app_name);
        this.appStoreNameView = (TextView)this.findViewById(R.id.tw__app_store_name);
        this.appInstallButton = (TextView)this.findViewById(R.id.tw__app_install_button);
        this.appInfoLayout = (ViewGroup)this.findViewById(R.id.tw__app_info_layout);
    }

    void setCard(Card card) {
        this.setImage(Uri.parse((String)card.imageUri));
        this.setAppName(card.appName);
    }

    void setImage(Uri uri) {
        int radius = this.getResources().getDimensionPixelSize(R.dimen.tw__card_radius_medium);
        RoundedCornerTransformation transformation = new RoundedCornerTransformation.Builder().setRadii(radius, radius, 0, 0).build();
        Picasso.with((Context)this.getContext()).load(uri).transform((Transformation)transformation).fit().centerCrop().into(this.appImageView);
    }

    void setAppName(String name) {
        this.appNameView.setText((CharSequence)name);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int maxWidth = this.getResources().getDimensionPixelSize(R.dimen.tw__card_maximum_width);
        int measuredWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        if (maxWidth > 0 && maxWidth < measuredWidth) {
            int measureMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)maxWidth, (int)measureMode);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    void setButtonColor() {
        int buttonTextColor = this.getResources().getColor(R.color.tw__composer_blue_text);
        this.appInstallButton.setTextColor(buttonTextColor);
    }
}

