/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetcomposer;

import android.content.Intent;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.View;
import com.twitter.Validator;
import com.twitter.sdk.android.core.Result;
import com.twitter.sdk.android.core.TwitterApiClient;
import com.twitter.sdk.android.core.TwitterCore;
import com.twitter.sdk.android.core.TwitterException;
import com.twitter.sdk.android.core.TwitterSession;
import com.twitter.sdk.android.core.models.User;
import com.twitter.sdk.android.tweetcomposer.Card;
import com.twitter.sdk.android.tweetcomposer.CardViewFactory;
import com.twitter.sdk.android.tweetcomposer.ComposerActivity;
import com.twitter.sdk.android.tweetcomposer.ComposerScribeClient;
import com.twitter.sdk.android.tweetcomposer.ComposerScribeClientImpl;
import com.twitter.sdk.android.tweetcomposer.ComposerView;
import com.twitter.sdk.android.tweetcomposer.R;
import com.twitter.sdk.android.tweetcomposer.TweetComposer;
import com.twitter.sdk.android.tweetcomposer.TweetUploadService;
import java.io.Serializable;
import retrofit2.Callback;

class ComposerController {
    final ComposerView composerView;
    final TwitterSession session;
    final Card card;
    final ComposerActivity.Finisher finisher;
    final DependencyProvider dependencyProvider;

    ComposerController(ComposerView composerView, TwitterSession session, Card card, String hashtags, ComposerActivity.Finisher finisher) {
        this(composerView, session, card, hashtags, finisher, new DependencyProvider());
    }

    ComposerController(ComposerView composerView, TwitterSession session, Card card, String hashtags, ComposerActivity.Finisher finisher, DependencyProvider dependencyProvider) {
        this.composerView = composerView;
        this.session = session;
        this.card = card;
        this.finisher = finisher;
        this.dependencyProvider = dependencyProvider;
        composerView.setCallbacks(new ComposerCallbacksImpl());
        composerView.setTweetText(hashtags);
        this.setProfilePhoto();
        this.setCardView(card);
        dependencyProvider.getScribeClient().impression(card);
    }

    void setProfilePhoto() {
        this.dependencyProvider.getApiClient(this.session).getAccountService().verifyCredentials(Boolean.valueOf(false), Boolean.valueOf(true)).enqueue((Callback)new com.twitter.sdk.android.core.Callback<User>(){

            public void success(Result<User> result) {
                ComposerController.this.composerView.setProfilePhotoView((User)result.data);
            }

            public void failure(TwitterException exception) {
                ComposerController.this.composerView.setProfilePhotoView(null);
            }
        });
    }

    void setCardView(Card card) {
        if (card != null) {
            CardViewFactory cardViewFactory = this.dependencyProvider.getCardViewFactory();
            View view = cardViewFactory.createCard(this.composerView.getContext(), card);
            this.composerView.setCardView(view);
        }
    }

    int tweetTextLength(String text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            return 0;
        }
        return this.dependencyProvider.getTweetValidator().getTweetLength(text);
    }

    static int remainingCharCount(int charCount) {
        return 140 - charCount;
    }

    static boolean isPostEnabled(int charCount) {
        return charCount > 0 && charCount <= 140;
    }

    static boolean isTweetTextOverflow(int charCount) {
        return charCount > 140;
    }

    static class DependencyProvider {
        final CardViewFactory cardViewFactory = new CardViewFactory();
        final Validator tweetValidator = new Validator();

        DependencyProvider() {
        }

        TwitterApiClient getApiClient(TwitterSession session) {
            return TwitterCore.getInstance().getApiClient(session);
        }

        CardViewFactory getCardViewFactory() {
            return this.cardViewFactory;
        }

        Validator getTweetValidator() {
            return this.tweetValidator;
        }

        ComposerScribeClient getScribeClient() {
            return new ComposerScribeClientImpl(TweetComposer.getInstance().getScribeClient());
        }
    }

    class ComposerCallbacksImpl
    implements ComposerCallbacks {
        ComposerCallbacksImpl() {
        }

        @Override
        public void onTextChanged(String text) {
            int charCount = ComposerController.this.tweetTextLength(text);
            ComposerController.this.composerView.setCharCount(ComposerController.remainingCharCount(charCount));
            if (ComposerController.isTweetTextOverflow(charCount)) {
                ComposerController.this.composerView.setCharCountTextStyle(R.style.tw__ComposerCharCountOverflow);
            } else {
                ComposerController.this.composerView.setCharCountTextStyle(R.style.tw__ComposerCharCount);
            }
            ComposerController.this.composerView.postTweetEnabled(ComposerController.isPostEnabled(charCount));
        }

        @Override
        public void onTweetPost(String text) {
            ComposerController.this.dependencyProvider.getScribeClient().click(ComposerController.this.card, "tweet");
            Intent intent = new Intent(ComposerController.this.composerView.getContext(), TweetUploadService.class);
            intent.putExtra("EXTRA_USER_TOKEN", (Parcelable)ComposerController.this.session.getAuthToken());
            intent.putExtra("EXTRA_TWEET_TEXT", text);
            intent.putExtra("EXTRA_TWEET_CARD", (Serializable)ComposerController.this.card);
            ComposerController.this.composerView.getContext().startService(intent);
            ComposerController.this.finisher.finish();
        }

        @Override
        public void onCloseClick() {
            ComposerController.this.dependencyProvider.getScribeClient().click(ComposerController.this.card, "cancel");
            ComposerController.this.finisher.finish();
        }
    }

    public static interface ComposerCallbacks {
        public void onTextChanged(String var1);

        public void onTweetPost(String var1);

        public void onCloseClick();
    }
}

