/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetcomposer;

import com.twitter.sdk.android.core.internal.scribe.EventNamespace;
import com.twitter.sdk.android.core.internal.scribe.ScribeItem;
import com.twitter.sdk.android.tweetcomposer.Card;
import com.twitter.sdk.android.tweetcomposer.ComposerScribeClient;
import com.twitter.sdk.android.tweetcomposer.ScribeClient;
import com.twitter.sdk.android.tweetcomposer.ScribeConstants;
import java.util.ArrayList;

class ComposerScribeClientImpl
implements ComposerScribeClient {
    private final ScribeClient scribeClient;

    ComposerScribeClientImpl(ScribeClient scribeClient) {
        if (scribeClient == null) {
            throw new NullPointerException("scribeClient must not be null");
        }
        this.scribeClient = scribeClient;
    }

    @Override
    public void impression(Card card) {
        EventNamespace ns = ScribeConstants.ComposerEventBuilder.setComponent("").setElement("").setAction("impression").builder();
        ArrayList<ScribeItem> items = new ArrayList<ScribeItem>();
        items.add(ScribeConstants.newCardScribeItem(card));
        this.scribeClient.scribe(ns, items);
    }

    @Override
    public void click(Card card, String element) {
        EventNamespace ns = ScribeConstants.ComposerEventBuilder.setComponent("").setElement(element).setAction("click").builder();
        ArrayList<ScribeItem> items = new ArrayList<ScribeItem>();
        items.add(ScribeConstants.newCardScribeItem(card));
        this.scribeClient.scribe(ns, items);
    }
}

