/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetcomposer;

import android.annotation.TargetApi;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.provider.DocumentsContract;
import android.provider.MediaStore;
import android.text.TextUtils;
import android.webkit.MimeTypeMap;
import java.io.File;

class FileUtils {
    private static final String MEDIA_SCHEME = "com.android.providers.media.documents";

    FileUtils() {
    }

    @TargetApi(value=19)
    static String getPath(Context context, Uri uri) {
        boolean isKitKat;
        boolean bl = isKitKat = Build.VERSION.SDK_INT >= 19;
        if (isKitKat && FileUtils.isMediaDocumentAuthority(uri)) {
            String documentId = DocumentsContract.getDocumentId((Uri)uri);
            String[] parts = documentId.split(":");
            String type = parts[0];
            if (!"image".equals(type)) {
                return null;
            }
            Uri contentUri = MediaStore.Images.Media.EXTERNAL_CONTENT_URI;
            String selection = "_id=?";
            String[] args = new String[]{parts[1]};
            return FileUtils.resolveFilePath(context, contentUri, "_id=?", args);
        }
        if (FileUtils.isContentScheme(uri)) {
            return FileUtils.resolveFilePath(context, uri, null, null);
        }
        if (FileUtils.isFileScheme(uri)) {
            return uri.getPath();
        }
        return null;
    }

    public static boolean isMediaDocumentAuthority(Uri uri) {
        return MEDIA_SCHEME.equalsIgnoreCase(uri.getAuthority());
    }

    public static boolean isContentScheme(Uri uri) {
        return "content".equalsIgnoreCase(uri.getScheme());
    }

    public static boolean isFileScheme(Uri uri) {
        return "file".equalsIgnoreCase(uri.getScheme());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String resolveFilePath(Context context, Uri uri, String selection, String[] args) {
        String[] projection = new String[]{"_data"};
        try (Cursor cursor = null;){
            cursor = context.getContentResolver().query(uri, projection, selection, args, null);
            if (cursor != null && cursor.moveToFirst()) {
                int i = cursor.getColumnIndexOrThrow("_data");
                String string = cursor.getString(i);
                return string;
            }
        }
        return null;
    }

    static String getMimeType(File file) {
        String ext = FileUtils.getExtension(file.getName());
        if (!TextUtils.isEmpty((CharSequence)ext)) {
            return MimeTypeMap.getSingleton().getMimeTypeFromExtension(ext);
        }
        return "application/octet-stream";
    }

    static String getExtension(String filename) {
        if (filename == null) {
            return null;
        }
        int i = filename.lastIndexOf(".");
        return i < 0 ? "" : filename.substring(i + 1);
    }
}

