/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.sdk.android.tweetcomposer;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcelable;
import com.twitter.sdk.android.core.Result;
import com.twitter.sdk.android.core.TwitterAuthToken;
import com.twitter.sdk.android.core.TwitterException;
import com.twitter.sdk.android.core.TwitterSession;
import com.twitter.sdk.android.core.models.Media;
import com.twitter.sdk.android.core.models.Tweet;
import com.twitter.sdk.android.tweetcomposer.Card;
import com.twitter.sdk.android.tweetcomposer.CardDataFactory;
import com.twitter.sdk.android.tweetcomposer.ComposerApiClient;
import com.twitter.sdk.android.tweetcomposer.FileUtils;
import com.twitter.sdk.android.tweetcomposer.TweetComposer;
import com.twitter.sdk.android.tweetcomposer.internal.CardCreate;
import com.twitter.sdk.android.tweetcomposer.internal.CardData;
import io.fabric.sdk.android.Fabric;
import java.io.File;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import retrofit2.Callback;

public class TweetUploadService
extends IntentService {
    public static final String UPLOAD_SUCCESS = "com.twitter.sdk.android.tweetcomposer.UPLOAD_SUCCESS";
    public static final String UPLOAD_FAILURE = "com.twitter.sdk.android.tweetcomposer.UPLOAD_FAILURE";
    public static final String EXTRA_TWEET_ID = "EXTRA_TWEET_ID";
    public static final String EXTRA_RETRY_INTENT = "EXTRA_RETRY_INTENT";
    static final String TAG = "TweetUploadService";
    static final String EXTRA_USER_TOKEN = "EXTRA_USER_TOKEN";
    static final String EXTRA_TWEET_TEXT = "EXTRA_TWEET_TEXT";
    static final String EXTRA_TWEET_CARD = "EXTRA_TWEET_CARD";
    private static final int PLACEHOLDER_ID = -1;
    private static final String PLACEHOLDER_SCREEN_NAME = "";
    DependencyProvider dependencyProvider;
    TwitterSession twitterSession;
    String tweetText;
    Card tweetCard;
    Intent intent;

    public TweetUploadService() {
        this(new DependencyProvider());
    }

    TweetUploadService(DependencyProvider dependencyProvider) {
        super(TAG);
        this.dependencyProvider = dependencyProvider;
    }

    protected void onHandleIntent(Intent intent) {
        TwitterAuthToken token = (TwitterAuthToken)intent.getParcelableExtra(EXTRA_USER_TOKEN);
        this.intent = intent;
        this.twitterSession = new TwitterSession(token, -1L, PLACEHOLDER_SCREEN_NAME);
        this.tweetText = intent.getStringExtra(EXTRA_TWEET_TEXT);
        this.tweetCard = (Card)intent.getSerializableExtra(EXTRA_TWEET_CARD);
        if (Card.isAppCard(this.tweetCard)) {
            this.uploadAppCardTweet(this.twitterSession, this.tweetText, this.tweetCard);
        } else {
            this.uploadTweet(this.twitterSession, this.tweetText);
        }
    }

    void uploadTweet(TwitterSession session, String text) {
        ComposerApiClient client = this.dependencyProvider.getComposerApiClient(session);
        client.getComposerStatusesService().update(text, null).enqueue((Callback)new com.twitter.sdk.android.core.Callback<Tweet>(){

            public void success(Result<Tweet> result) {
                TweetUploadService.this.sendSuccessBroadcast(((Tweet)result.data).getId());
                TweetUploadService.this.stopSelf();
            }

            public void failure(TwitterException exception) {
                TweetUploadService.this.fail(exception);
            }
        });
    }

    void uploadAppCardTweet(TwitterSession session, final String text, final Card card) {
        final ComposerApiClient client = this.dependencyProvider.getComposerApiClient(session);
        Uri uri = Uri.parse((String)card.imageUri);
        String path = FileUtils.getPath((Context)this, uri);
        if (path == null) {
            this.fail(new TwitterException("Uri file path resolved to null"));
            return;
        }
        File file = new File(path);
        String mimeType = FileUtils.getMimeType(file);
        RequestBody media = RequestBody.create((MediaType)MediaType.parse((String)mimeType), (File)file);
        client.getMediaService().upload(media, null, null).enqueue((Callback)new com.twitter.sdk.android.core.Callback<Media>(){

            public void success(Result<Media> result) {
                CardData cardData = CardDataFactory.createAppCardData(card, ((Media)result.data).mediaId, TweetUploadService.this.dependencyProvider.getAdvertisingId());
                client.getCardService().create(cardData).enqueue((Callback)new com.twitter.sdk.android.core.Callback<CardCreate>(){

                    public void success(Result<CardCreate> result) {
                        String cardUri = ((CardCreate)result.data).cardUri;
                        client.getComposerStatusesService().update(text, cardUri).enqueue((Callback)new com.twitter.sdk.android.core.Callback<Tweet>(){

                            public void success(Result<Tweet> result) {
                                TweetUploadService.this.sendSuccessBroadcast(((Tweet)result.data).getId());
                                TweetUploadService.this.stopSelf();
                            }

                            public void failure(TwitterException exception) {
                                TweetUploadService.this.fail(exception);
                            }
                        });
                    }

                    public void failure(TwitterException exception) {
                        TweetUploadService.this.fail(exception);
                    }
                });
            }

            public void failure(TwitterException exception) {
                TweetUploadService.this.fail(exception);
            }
        });
    }

    void fail(TwitterException e) {
        this.sendFailureBroadcast(this.intent);
        Fabric.getLogger().e(TAG, "Post Tweet failed", (Throwable)e);
        this.stopSelf();
    }

    void sendSuccessBroadcast(long tweetId) {
        Intent intent = new Intent(UPLOAD_SUCCESS);
        intent.putExtra(EXTRA_TWEET_ID, tweetId);
        this.sendBroadcast(intent);
    }

    void sendFailureBroadcast(Intent original) {
        Intent intent = new Intent(UPLOAD_FAILURE);
        intent.putExtra(EXTRA_RETRY_INTENT, (Parcelable)original);
        this.sendBroadcast(intent);
    }

    static class DependencyProvider {
        DependencyProvider() {
        }

        ComposerApiClient getComposerApiClient(TwitterSession session) {
            return TweetComposer.getInstance().getApiClient(session);
        }

        String getAdvertisingId() {
            return TweetComposer.getInstance().getAdvertisingId();
        }
    }
}

