/*
 * Decompiled with CFR 0.152.
 */
package com.efs.sdk.base.protocol.file;

import android.text.TextUtils;
import com.efs.sdk.base.a.c.b;
import com.efs.sdk.base.a.d.a;
import com.efs.sdk.base.a.h.d;
import com.efs.sdk.base.protocol.file.AbsFileLog;
import com.efs.sdk.base.protocol.file.section.AbsSection;
import com.efs.sdk.base.protocol.file.section.JSONSection;
import com.efs.sdk.base.protocol.file.section.KVSection;
import com.efs.sdk.base.protocol.file.section.TextSection;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class EfsTextFile
extends AbsFileLog {
    private static final String FILE_START = "*** *** *** *** *** *** *** *** *** *** *** *** *** *** *** ***";
    private static final String SECTION_START = "--- --- --- --- --- --- --- --- --- --- --- --- --- --- --- ---";
    private List<AbsSection> sectionList = new ArrayList<AbsSection>();
    private String mLinkKey = null;
    private String mLinkID = null;
    private boolean mHasInitLinkInfo = false;

    public EfsTextFile(String string) {
        super(string);
    }

    private String changeToStr() {
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder(FILE_START);
        stringBuilder.append("\n");
        for (AbsSection absSection : this.sectionList) {
            if (n > 0) {
                stringBuilder.append("--- --- --- --- --- --- --- --- --- --- --- --- --- --- --- ---\n");
            }
            stringBuilder.append(absSection.changeToStr());
            ++n;
        }
        return stringBuilder.toString();
    }

    public KVSection createAndAddKVSection(String object) {
        object = new KVSection((String)object);
        this.sectionList.add((AbsSection)object);
        return object;
    }

    public TextSection createAndAddTextSection(String object) {
        object = new TextSection((String)object);
        this.sectionList.add((AbsSection)object);
        return object;
    }

    public JSONSection createAndAddJSONSection(String object) {
        object = new JSONSection((String)object);
        this.sectionList.add((AbsSection)object);
        return object;
    }

    @Override
    public void insertGlobal(b b2) {
        this.insertCustomInfoSection();
        String string = this.getLogType();
        ArrayList<KVSection> arrayList = new ArrayList<KVSection>();
        KVSection kVSection = new KVSection("global_head");
        KVSection kVSection2 = kVSection.put("type", string).put("appid", b2.a.get("appid")).put("wid", b2.a.get("wid")).put("pid", b2.a.get("pid")).put("pkg", b2.a.get("pkg")).put("ver", b2.a.get("ver")).put("vcode", b2.a.get("vcode")).put("ps", b2.a.get("ps")).put("stime", b2.a.get("stime"));
        com.efs.sdk.base.a.a.a.a();
        KVSection kVSection3 = kVSection2.put("ctime", com.efs.sdk.base.a.a.a.b() / 1000L);
        com.efs.sdk.base.a.a.a.a();
        kVSection3.put("w_tm", com.efs.sdk.base.a.a.a.b() / 1000L).put("sdk_ver", b2.a.get("sdk_ver"));
        string = String.valueOf(b2.b("uid", ""));
        if (!TextUtils.isEmpty((CharSequence)string)) {
            kVSection.put("uid", string);
        }
        arrayList.add(kVSection);
        kVSection = new KVSection("device_info");
        kVSection.put("lang", b2.a.get("lang")).put("brand", b2.a.get("brand")).put("model", b2.a.get("model")).put("rom", b2.a.get("rom")).put("sdk", b2.a.get("sdk")).put("dsp_h", b2.a.get("dsp_h")).put("dsp_w", b2.a.get("dsp_w")).put("tzone", b2.a.get("tzone")).put("net", b2.a.get("net")).put("fr", b2.a.get("fr"));
        arrayList.add(kVSection);
        this.sectionList.addAll(0, arrayList);
    }

    private void insertCustomInfoSection() {
        KVSection kVSection = new KVSection("custom_info");
        for (Map.Entry<String, String> entry : a.a().a().entrySet()) {
            kVSection.put(entry.getKey(), entry.getValue());
        }
        this.sectionList.add(0, kVSection);
    }

    @Override
    public byte[] generate() {
        String string = this.changeToStr();
        if (a.a().g) {
            d.a("efs.base", string);
        }
        return string.getBytes();
    }

    @Override
    public String generateString() {
        return this.changeToStr();
    }

    @Override
    public String getLinkKey() {
        this.initLinkInfo();
        return this.mLinkKey;
    }

    @Override
    public String getLinkId() {
        this.initLinkInfo();
        return this.mLinkID;
    }

    private void initLinkInfo() {
        if (!TextUtils.isEmpty((CharSequence)this.mLinkID) && !TextUtils.isEmpty((CharSequence)this.mLinkKey)) {
            return;
        }
        if (this.mHasInitLinkInfo) {
            return;
        }
        for (AbsSection absSection : this.sectionList) {
            if (!(absSection instanceof KVSection)) continue;
            Map<String, Object> map = ((KVSection)absSection).getDataMap();
            if (TextUtils.isEmpty((CharSequence)this.mLinkID) && map.containsKey("w_frmid")) {
                this.mLinkID = String.valueOf(map.get("w_frmid"));
            }
            if (!TextUtils.isEmpty((CharSequence)this.mLinkKey) || !map.containsKey("w_linkKey")) continue;
            this.mLinkKey = String.valueOf(map.get("w_linkKey"));
        }
        this.mHasInitLinkInfo = true;
    }
}

