/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.umcrash;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import com.efs.sdk.base.EfsReporter;
import com.efs.sdk.pa.PAFactory;
import com.efs.sdk.pa.config.IEfsReporter;
import com.efs.sdk.pa.config.PackageLevel;
import com.uc.crashsdk.export.CrashApi;
import com.uc.crashsdk.export.CustomLogInfo;
import com.uc.crashsdk.export.ICrashClient;
import com.umeng.umcrash.UMCrashCallback;
import com.umeng.umcrash.UMCrashUtils;
import com.umeng.umcrash.UMCustomLogInfoBuilder;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class UMCrash {
    private static final String TAG = UMCrash.class.getSimpleName();
    private static Context mContext;
    private static boolean isDebug;
    private static boolean isEncrypt;
    private static boolean isZip;
    private static boolean enableNativeLog;
    private static boolean enableANRLog;
    private static boolean enableUnexpLog;
    private static boolean isIntl;
    private static UMCrashCallback mUMCrashCallback;
    private static final String KEY_CALLBACK_USER_STRING = "um_user_string";
    public static final String KEY_CALLBACK_PAGE_ACTION = "um_action_log";
    public static final String KEY_CALLBACK_UMID = "um_umid";
    public static final String KEY_HEADER_APPKEY = "um_app_key";
    public static final String KEY_HEADER_CHANNEL = "um_app_channel";
    public static final String KEY_HEADER_OS = "um_os";
    public static final String KEY_HEADER_CRASH_VERSION = "um_crash_sdk_version";
    public static final String KEY_HEADER_PUID = "um_app_puid";
    public static final String KEY_HEADER_PROVIDER = "um_app_provider";
    public static final String KEY_HEADER_CARRIER = "um_app_carrier";
    public static final String KEY_HEADER_START_TIME = "um_app_start_time";
    public static final String KEY_HEADER_UMID = "um_umid_header";
    public static final String KEY_APM_DEFAULT_SECRET = "NEej8y@anWa*8hep";
    public static final String KEY_APM_ROOT_NAME = "UApm";
    private static String crashSdkVersion;
    private static Object pageArrayLock;
    private static ArrayList<String> mArrayList;
    private static final int KEY_MAX_LENGTH = 256;
    public static EfsReporter sReporter;
    private static boolean isPA;

    private static synchronized String getUMID(Context context) {
        if (context == null) {
            return null;
        }
        String umId = null;
        Class<?> umConfigClass = null;
        try {
            umConfigClass = Class.forName("com.umeng.commonsdk.UMConfigure");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (umConfigClass != null) {
            Method umConfigMethed = null;
            try {
                umConfigMethed = umConfigClass.getMethod("getUMIDString", Context.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (umConfigMethed != null) {
                try {
                    Object o = umConfigMethed.invoke(null, context);
                    if (o != null) {
                        umId = o.toString();
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
        return umId;
    }

    public static String getUMAPMFlag() {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("version", 0);
            jsonObject.put("crash", 1);
            if (enableNativeLog) {
                jsonObject.put("crashNative", 1);
            } else {
                jsonObject.put("crashNative", 0);
            }
            if (enableANRLog) {
                jsonObject.put("anr", 1);
            } else {
                jsonObject.put("anr", 0);
            }
            if (isPA) {
                jsonObject.put("pa", 1);
            } else {
                jsonObject.put("pa", 0);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return jsonObject.toString();
    }

    public static void setDebug(boolean isD) {
        isDebug = isD;
    }

    public static void enableNativeLog(boolean isN) {
        enableNativeLog = isN;
    }

    public static void enableANRLog(boolean isA) {
        enableANRLog = isA;
    }

    public static void enableUnexpLog(boolean isU) {
        enableUnexpLog = isU;
    }

    private static void useIntlServices(boolean isInSer) {
        isIntl = isInSer;
        if (isDebug) {
            Log.i((String)TAG, (String)("useIntlServices is " + isIntl));
        }
    }

    public static void init(Context context, String appkey, String channel) {
        block11: {
            if (context == null || appkey == null) {
                Log.e((String)TAG, (String)"context is null or appkey is null, init failed.");
                return;
            }
            mContext = context;
            try {
                Bundle customInfo = new Bundle();
                customInfo.putBoolean("mDebug", isDebug);
                customInfo.putBoolean("mEncryptLog", isEncrypt);
                customInfo.putBoolean("mZipLog", isZip);
                customInfo.putBoolean("enableNativeLog", enableNativeLog);
                customInfo.putBoolean("enableANRLog", enableANRLog);
                customInfo.putBoolean("enableUnexpLog", enableUnexpLog);
                customInfo.putBoolean("mIsInternational", isIntl);
                CrashApi mCrashApi = CrashApi.createInstanceEx((Context)context, (String)appkey, (boolean)isDebug, (Bundle)customInfo, (ICrashClient)new CrashClientImpl());
                if (mCrashApi != null) {
                    mCrashApi.addHeaderInfo(KEY_HEADER_APPKEY, appkey);
                    mCrashApi.addHeaderInfo(KEY_HEADER_CHANNEL, channel);
                    mCrashApi.addHeaderInfo(KEY_HEADER_OS, "android");
                    mCrashApi.addHeaderInfo(KEY_HEADER_CRASH_VERSION, crashSdkVersion);
                    mCrashApi.addHeaderInfo(KEY_HEADER_UMID, UMCrash.getUMID(context));
                    try {
                        String[] strings = UMCrashUtils.getActiveUser(context);
                        if (strings != null && strings.length == 2) {
                            mCrashApi.addHeaderInfo(KEY_HEADER_PUID, strings[0]);
                            mCrashApi.addHeaderInfo(KEY_HEADER_PROVIDER, strings[1]);
                        }
                    }
                    catch (Throwable e) {
                        mCrashApi.addHeaderInfo(KEY_HEADER_PUID, "");
                        mCrashApi.addHeaderInfo(KEY_HEADER_PROVIDER, "");
                    }
                    mCrashApi.addHeaderInfo(KEY_HEADER_CARRIER, UMCrashUtils.getNetworkOperatorName(context));
                    if (context instanceof Application) {
                        ((Application)context).registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

                            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
                            }

                            public void onActivityStarted(Activity activity) {
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public void onActivityResumed(Activity activity) {
                                Object object = pageArrayLock;
                                synchronized (object) {
                                    if (mArrayList != null) {
                                        if (mArrayList.size() >= 10) {
                                            mArrayList.remove(0);
                                        }
                                        mArrayList.add(activity.getLocalClassName() + "-" + System.currentTimeMillis());
                                    }
                                }
                            }

                            public void onActivityPaused(Activity activity) {
                            }

                            public void onActivityStopped(Activity activity) {
                            }

                            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
                            }

                            public void onActivityDestroyed(Activity activity) {
                            }
                        });
                        int logType = 0x100011;
                        mCrashApi.registerInfoCallback(KEY_CALLBACK_UMID, logType);
                        mCrashApi.registerInfoCallback(KEY_CALLBACK_PAGE_ACTION, logType);
                    } else {
                        Log.e((String)TAG, (String)"context not instanceof application.");
                    }
                    break block11;
                }
                Log.e((String)TAG, (String)"create CrashAPI is null.");
            }
            catch (Throwable customInfo) {
                // empty catch block
            }
        }
        try {
            HashMap<String, String> params = new HashMap<String, String>(1);
            params.put(KEY_HEADER_UMID, UMCrash.getUMID(context));
            params.put(KEY_HEADER_CHANNEL, channel);
            params.put(KEY_HEADER_CARRIER, UMCrashUtils.getNetworkOperatorName(context));
            params.put(KEY_HEADER_OS, "android");
            sReporter = new EfsReporter.Builder(context.getApplicationContext(), appkey, KEY_APM_DEFAULT_SECRET).debug(isDebug).efsDirRootName(KEY_APM_ROOT_NAME).printLogDetail(isDebug).intl(isIntl).build();
            sReporter.addPublicParams(params);
            PAFactory.Builder builder = new PAFactory.Builder(context.getApplicationContext(), new IEfsReporter(){

                public EfsReporter getReporter() {
                    return sReporter;
                }
            });
            builder.packageLevel(PackageLevel.RELEASE);
            PAFactory paFactory = builder.build();
            paFactory.getPaInstance().start();
            isPA = paFactory.getConfigManager().enableTracer();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void registerUMCrashCallback(UMCrashCallback umCrashCallback) {
        if (umCrashCallback != null) {
            mUMCrashCallback = umCrashCallback;
            if (CrashApi.getInstance() != null) {
                int logType = 0x100011;
                CrashApi.getInstance().registerInfoCallback(KEY_CALLBACK_USER_STRING, logType);
            } else {
                Log.e((String)TAG, (String)"callback error, instance is null.");
            }
        } else {
            Log.e((String)TAG, (String)"callback error.");
        }
    }

    public static void generateCustomLog(Throwable e, String type) {
        if (e == null || TextUtils.isEmpty((CharSequence)type)) {
            Log.e((String)TAG, (String)"generate custom log failed ! e is null or type is empty");
            return;
        }
        try {
            CustomLogInfo customLogInfo = new UMCustomLogInfoBuilder(type).stack(e).build();
            ArrayList<String> mCallbacks = new ArrayList<String>();
            mCallbacks.add(KEY_CALLBACK_UMID);
            mCallbacks.add(KEY_CALLBACK_PAGE_ACTION);
            customLogInfo.mCallbacks = mCallbacks;
            CrashApi mCrashApi = CrashApi.getInstance();
            if (mCrashApi == null) {
                Log.e((String)TAG, (String)"CrashApi is null, not init .");
            } else {
                mCrashApi.generateCustomLog(customLogInfo);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void generateCustomLog(String e, String type) {
        if (TextUtils.isEmpty((CharSequence)e) || TextUtils.isEmpty((CharSequence)type)) {
            Log.e((String)TAG, (String)"generate custom log failed ! e is null or type is empty");
            return;
        }
        try {
            CustomLogInfo info = new CustomLogInfo(null, "exception");
            ArrayList<String> mCallbacks = new ArrayList<String>();
            mCallbacks.add(KEY_CALLBACK_UMID);
            mCallbacks.add(KEY_CALLBACK_PAGE_ACTION);
            info.mCallbacks = mCallbacks;
            HashMap<String, String> kvInfoMap = new HashMap<String, String>(20);
            kvInfoMap.put("k_ct", "exception");
            kvInfoMap.put("k_ac", type);
            StringBuffer sb = new StringBuffer();
            for (Map.Entry entry : kvInfoMap.entrySet()) {
                sb.append((String)entry.getKey()).append(":").append((String)entry.getValue()).append("\n");
            }
            String stack = "Exception message:\nBack traces starts.\n" + e + "\n" + "Back traces ends.";
            if (!TextUtils.isEmpty((CharSequence)stack)) {
                sb.append(stack).append("\n");
            }
            info.mData = sb;
            CrashApi mCrashApi = CrashApi.getInstance();
            if (mCrashApi == null) {
                Log.e((String)TAG, (String)"CrashApi is null, not init .");
            } else {
                mCrashApi.generateCustomLog(info);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        isDebug = true;
        isEncrypt = false;
        isZip = true;
        enableNativeLog = true;
        enableANRLog = true;
        enableUnexpLog = false;
        isIntl = false;
        crashSdkVersion = "1.2.0";
        pageArrayLock = new Object();
        mArrayList = new ArrayList(10);
        isPA = false;
    }

    private static class CrashClientImpl
    implements ICrashClient {
        private CrashClientImpl() {
        }

        public void onLogGenerated(File file, String s) {
        }

        public void onClientProcessLogGenerated(String s, File file, String s1) {
        }

        public File onBeforeUploadLog(File file) {
            return file;
        }

        public void onCrashRestarting(boolean b) {
        }

        public void onAddCrashStats(String s, int i, int i1) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String onGetCallbackInfo(String category, boolean b) {
            if (UMCrash.KEY_CALLBACK_PAGE_ACTION.equals(category)) {
                String result = null;
                try {
                    Object object = pageArrayLock;
                    synchronized (object) {
                        if (mArrayList != null && mArrayList.size() > 0) {
                            JSONObject jsonSec = new JSONObject();
                            jsonSec.put("source", 0);
                            jsonSec.put("action_name", (Object)"page_view");
                            JSONArray jsonParameter = new JSONArray();
                            for (int i = 0; i < mArrayList.size(); ++i) {
                                String item = (String)mArrayList.get(i);
                                if (item == null) continue;
                                JSONObject jsonitem = new JSONObject();
                                jsonitem.put("name", (Object)item);
                                jsonParameter.put((Object)jsonitem);
                            }
                            jsonSec.put("action_parameter", (Object)jsonParameter);
                            result = jsonSec.toString();
                            if (isDebug) {
                                Log.i((String)TAG, (String)("page json is " + result));
                            }
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return result;
            }
            if (UMCrash.KEY_CALLBACK_UMID.equals(category)) {
                return UMCrash.getUMID(mContext);
            }
            if (UMCrash.KEY_CALLBACK_USER_STRING.equals(category)) {
                if (mUMCrashCallback != null) {
                    String callbackString = mUMCrashCallback.onCallback();
                    if (callbackString == null) {
                        return null;
                    }
                    int len = callbackString.trim().getBytes().length;
                    if (len > 256) {
                        callbackString = UMCrashUtils.splitByByte(callbackString, 256);
                    }
                    return callbackString;
                }
                return null;
            }
            return null;
        }
    }
}

