/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.umcrash;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Build;
import android.telephony.TelephonyManager;
import com.uc.crashsdk.export.CrashApi;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class UMCrashUtils {
    public static final String UNKNOW = "";

    public static String[] getActiveUser(Context context) {
        if (context == null) {
            return null;
        }
        String[] activeUser = null;
        Class<?> mClass = null;
        try {
            mClass = Class.forName("com.umeng.commonsdk.utils.UMUtils");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (mClass != null) {
            Method umConfigMethed = null;
            try {
                umConfigMethed = mClass.getMethod("getActiveUser", Context.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (umConfigMethed != null) {
                try {
                    Object o = umConfigMethed.invoke(null, context);
                    if (o != null) {
                        activeUser = (String[])o;
                    }
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (InvocationTargetException invocationTargetException) {
                    // empty catch block
                }
            }
        }
        return activeUser;
    }

    public static void setPuidAndProvider(String puid, String provider) {
        if (CrashApi.getInstance() != null) {
            CrashApi.getInstance().addHeaderInfo("um_app_puid", puid);
            CrashApi.getInstance().addHeaderInfo("um_app_provider", provider);
        }
    }

    public static String getNetworkOperatorName(Context context) {
        if (context == null) {
            return UNKNOW;
        }
        try {
            TelephonyManager tm = (TelephonyManager)context.getSystemService("phone");
            if (UMCrashUtils.checkPermission(context, "android.permission.READ_PHONE_STATE") && tm != null) {
                return tm.getNetworkOperatorName();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return UNKNOW;
    }

    public static boolean checkPermission(Context context, String permission2) {
        boolean result;
        block7: {
            result = false;
            if (context == null) {
                return result;
            }
            if (Build.VERSION.SDK_INT >= 23) {
                try {
                    Class<?> clazz = Class.forName("android.content.Context");
                    Method method = clazz.getMethod("checkSelfPermission", String.class);
                    int rest = (Integer)method.invoke((Object)context, permission2);
                    if (rest == 0) {
                        result = true;
                        break block7;
                    }
                    result = false;
                }
                catch (Throwable e) {
                    result = false;
                }
            } else {
                PackageManager pm = context.getPackageManager();
                if (pm.checkPermission(permission2, context.getPackageName()) == 0) {
                    result = true;
                }
            }
        }
        return result;
    }

    public static String splitByByte(String srcStr, int length) {
        StringBuffer sb = new StringBuffer(length);
        try {
            String tempStr;
            byte[] b;
            int srcLength = srcStr.length();
            int tempLength = 0;
            for (int i = 0; i < srcLength && length >= (tempLength += (b = (tempStr = String.valueOf(srcStr.charAt(i))).getBytes()).length); ++i) {
                sb.append(tempStr);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return sb.toString();
    }
}

