package com.unity3d.ads.core.domain

import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.GAME_ID
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.INIT_GAME_ID_CHANGED
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.INIT_GAME_ID_SAME
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.INIT_TEST_MODE_CHANGED
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.INIT_TEST_MODE_SAME
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.PREVIOUS_GAME_ID
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.PREVIOUS_TEST_MODE
import com.unity3d.ads.core.domain.SendDiagnosticEvent.Companion.TEST_MODE
import com.unity3d.services.core.configuration.InitializeEventsMetricSender
import com.unity3d.services.core.properties.ClientProperties
import com.unity3d.services.core.properties.SdkProperties
import com.unity3d.services.core.request.metrics.Metric

class CommonCheckForGameIdAndTestModeChanges(
    private val getGameId: GetGameId,
    private val sendDiagnosticEvent: SendDiagnosticEvent
) : CheckForGameIdAndTestModeChanges {
    override fun invoke(legacy: Boolean) {

        val gameId = getGameId() ?: "null"

        val previousGameId = ClientProperties.getPreviousGameId() ?: "null"
        val gameIdMap = mapOf(PREVIOUS_GAME_ID to previousGameId, GAME_ID to gameId)

        if (previousGameId != "null") {
            if (gameId != previousGameId) {
                sendDiagnostic(event = INIT_GAME_ID_CHANGED, tags = gameIdMap, legacy)
            } else {
                sendDiagnostic(event = INIT_GAME_ID_SAME, tags = gameIdMap, legacy)
            }
            val testMode = SdkProperties.isTestMode()
            val previousTestMode = SdkProperties.getPreviousTestMode()
            val testModeMap = mapOf(
                PREVIOUS_TEST_MODE to previousTestMode.toString(),
                TEST_MODE to testMode.toString()
            )

            if (testMode != previousTestMode) {
                sendDiagnostic(event = INIT_TEST_MODE_CHANGED, tags = testModeMap, legacy)
            } else {
                sendDiagnostic(event = INIT_TEST_MODE_SAME, tags = testModeMap, legacy)
            }
        }
    }

    private fun sendDiagnostic(event: String, tags: Map<String, String>, isLegacy: Boolean) {
        if (isLegacy) {
            InitializeEventsMetricSender.getInstance().sendMetric(Metric(event, tags))
        } else {
            sendDiagnosticEvent(event = event, tags = tags)
        }
    }
}