package com.unity3d.ads.core.data.manager

import com.unity3d.ads.core.data.model.exception.LoadException
import com.unity3d.ads.core.domain.offerwall.OfferwallEventData
import com.unity3d.services.ads.offerwall.OfferwallAdapterBridge
import com.unity3d.services.ads.offerwall.OfferwallEvent
import com.unity3d.services.core.log.DeviceLog
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.first
import kotlinx.coroutines.flow.onSubscription
import kotlinx.coroutines.flow.transformWhile

class AndroidOfferwallManager(
    private val offerwallBridge: OfferwallAdapterBridge
) : OfferwallManager {

    override suspend fun getVersion() = offerwallBridge.getVersion()

    override suspend fun isConnected() = offerwallBridge.isConnected()

    override suspend fun isAdReady(placementName: String) = offerwallBridge.isAdReady(placementName)

    override suspend fun loadAd(placementName: String) {
        DeviceLog.debug("Offerwall Manager - loadAd: $placementName")
        offerwallBridge.offerwallEventFlow
            .onSubscription {
                offerwallBridge.loadAd(placementName)
            }.first {
                it.offerwallEvent in listOf(
                    OfferwallEvent.REQUEST_SUCCESS,
                    OfferwallEvent.REQUEST_FAILED
                ) && it.placementName == placementName
            }.takeIf { it.offerwallEvent != OfferwallEvent.REQUEST_SUCCESS }?.run {
                throw LoadException(0, "Error loading offerwall ad: ${errorMessage ?: offerwallEvent}")
            }
    }

    override fun showAd(placementName: String): Flow<OfferwallEventData> {
        DeviceLog.debug("Offerwall Manager - showAd: $placementName")
        return offerwallBridge.offerwallEventFlow
            .onSubscription {
                offerwallBridge.showAd(placementName)
            }.transformWhile {
                emit(it)
                it.offerwallEvent !in arrayOf(OfferwallEvent.ON_CONTENT_DISMISS, OfferwallEvent.SHOW_FAILED)
            }
    }
}