package com.unity3d.ads.core.domain

import com.unity3d.ads.core.data.datasource.WebviewConfigurationDataSource
import com.unity3d.ads.core.data.model.WebViewConfiguration
import com.unity3d.ads.datastore.WebviewConfigurationStore


class GetLatestWebViewConfiguration(
    private val webviewConfigurationDataSource: WebviewConfigurationDataSource
) {
    suspend operator fun invoke(
        receivedEntryPoint: String? = null,
        receivedVersion: Int? = null,
        receivedAdditionalFiles: List<String>? = null,
        receivedType: String? = null,
    ): WebViewConfiguration {
        val currentWebViewConfiguration = webviewConfigurationDataSource.get().let {
            WebViewConfiguration(it.version, it.entryPoint, it.additionalFilesList, it.type)
        }

        if (receivedEntryPoint == null && receivedVersion == null && receivedAdditionalFiles == null && receivedType == null) {
            return currentWebViewConfiguration
        }

        val result = WebViewConfiguration(
            version = receivedVersion ?: currentWebViewConfiguration.version,
            entryPoint = receivedEntryPoint ?: currentWebViewConfiguration.entryPoint,
            additionalFiles = receivedAdditionalFiles ?: currentWebViewConfiguration.additionalFiles,
            type = receivedType ?: currentWebViewConfiguration.type,
        )

        if (result != currentWebViewConfiguration) {
            webviewConfigurationDataSource.set(
                WebviewConfigurationStore.WebViewConfigurationStore.newBuilder().apply {
                    version = result.version
                    entryPoint = result.entryPoint
                    addAllAdditionalFiles(result.additionalFiles)
                    type = result.type
                }.build()
            )
        }

        return result
    }
}