package com.unity3d.services.store.core

import com.unity3d.services.ads.gmascar.handlers.WebViewErrorHandler
import com.unity3d.services.store.StoreError
import com.unity3d.services.store.StoreEvent
import org.json.JSONException
import java.lang.reflect.InvocationTargetException

class WebViewStoreExceptionHandler(private val _webViewErrorHandler: WebViewErrorHandler) : StoreExceptionHandler {
    override fun handleStoreException(storeEvent: StoreEvent, operationId: Int, exception: Exception) {
        sendErrorToWebView(storeEvent, getStoreError(exception), operationId, exception)
    }

    private fun sendErrorToWebView(
        storeEvent: StoreEvent,
        storeError: StoreError,
        operationId: Int,
        exception: Exception
    ) {
        _webViewErrorHandler.handleError(
            StoreWebViewError(
                storeEvent,
                exception.message,
                operationId,
                storeError,
                exception.message
            )
        )
    }

    private fun getStoreError(exception: Exception): StoreError {
        return when (exception) {
            is NoSuchMethodException -> StoreError.NO_SUCH_METHOD
            is IllegalAccessException -> StoreError.ILLEGAL_ACCESS
            is JSONException -> StoreError.JSON_ERROR
            is InvocationTargetException -> StoreError.INVOCATION_TARGET
            is ClassNotFoundException -> StoreError.CLASS_NOT_FOUND
            else -> StoreError.UNKNOWN_ERROR
        }
    }
}
