package com.unity3d.ads.beta

import android.content.Context
import com.unity3d.services.core.log.DeviceLog

// Should it be called init options?
internal class InitializationConfiguration(
    val context: Context,
    val gameID: String,
    val isTestModeEnabled: Boolean,
    val logLevel: DeviceLog.UnityAdsLogLevel = DeviceLog.UnityAdsLogLevel.INFO,
    val extras: Map<String, String> = emptyMap(),
    val mediationInfo: MediationInfo? = null,
) {
    class Builder(private val context: Context, private val gameID: String, private val isTestModeEnabled: Boolean) {
        private var logLevel: DeviceLog.UnityAdsLogLevel = DeviceLog.UnityAdsLogLevel.INFO
        private var mediationInfo: MediationInfo? = null
        private var extras: Map<String, String> = emptyMap()

        fun withLogLevel(logLevel: DeviceLog.UnityAdsLogLevel): Builder {
            this.logLevel = logLevel
            return this
        }

        fun withMediationInfo(mediationInfo: MediationInfo?): Builder {
            this.mediationInfo = mediationInfo
            return this
        }

        fun withExtras(extras: Map<String, String>): Builder {
            this.extras = extras
            return this
        }

        fun build(): InitializationConfiguration {
            return InitializationConfiguration(
                context,
                gameID,
                isTestModeEnabled,
                logLevel,
                extras,
                mediationInfo
            )
        }
    }
}