package com.unity3d.ads.core.data.model

import androidx.datastore.core.CorruptionException
import androidx.datastore.core.Serializer
import com.google.protobuf.InvalidProtocolBufferException
import com.unity3d.ads.datastore.UniversalRequestStoreOuterClass.UniversalRequestStore
import java.io.InputStream
import java.io.OutputStream

class UniversalRequestStoreSerializer : Serializer<UniversalRequestStore> {

    override val defaultValue: UniversalRequestStore = UniversalRequestStore.getDefaultInstance()

    override suspend fun readFrom(input: InputStream): UniversalRequestStore {
        try {
            return UniversalRequestStore.parseFrom(input)
        } catch (exception: InvalidProtocolBufferException) {
            throw CorruptionException("Cannot read proto.", exception)
        } catch (exception: Throwable) {
            throw CorruptionException("Error while reading proto file.", exception)
        }
    }

    override suspend fun writeTo(t: UniversalRequestStore, output: OutputStream) = t.writeTo(output)
}