package com.unity3d.ads.core.domain

import com.unity3d.ads.core.data.manager.SDKPropertiesManager
import com.unity3d.ads.core.data.model.InitializationState
import com.unity3d.ads.core.data.model.toBold
import com.unity3d.ads.core.data.repository.SessionRepository


class CommonGetInitializationState(
    private val sessionRepository: SessionRepository,
    private val sdkPropertiesManager: SDKPropertiesManager
) : GetInitializationState {
    override fun invoke(legacy: Boolean): InitializationState {
        return if (legacy) {
            sdkPropertiesManager.getCurrentInitializationState().toBold()
        } else {
            sessionRepository.initializationState
        }
    }
}