package com.unity3d.ads.core.domain.om

import android.webkit.WebView
import com.unity3d.ads.core.data.model.AdObject
import com.unity3d.ads.core.data.model.OmidOptions
import org.json.JSONObject

interface OmInteraction {
    suspend operator fun invoke(adObject: AdObject, options: JSONObject)

    fun getWebview(adObject: AdObject): WebView?
    fun getOMidOptions(options: JSONObject): OmidOptions

    companion object {
        const val OMID_IMPRESSION_TYPE = "impressionType"
        const val OMID_CREATIVE_TYPE = "creativeType"
        const val OMID_CUSTOM_REFERENCE_DATA = "customReferenceData"
        const val OMID_VIDEO_EVENTS_OWNER = "videoEventsOwner"
        const val OMID_MEDIA_EVENTS_OWNER = "mediaEventsOwner"
        const val OMID_IMPRESSION_OWNER = "impressionOwner"
        const val OMID_ISOLATE_VERIFICATION_SCRIPTS = "isolateVerificationScripts"
    }
}