/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.auth;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import com.vk.api.sdk.VK;
import com.vk.api.sdk.VKKeyValueStorage;
import com.vk.api.sdk.auth.VKAccessToken;
import com.vk.api.sdk.auth.VKAuthCallback;
import com.vk.api.sdk.auth.VKAuthParams;
import com.vk.api.sdk.auth.VKAuthResult;
import com.vk.api.sdk.auth.VKScope;
import com.vk.api.sdk.ui.VKWebViewAuthActivity;
import com.vk.api.sdk.utils.VKUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000  2\u00020\u0001:\u0001 B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ(\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u0016H\u0002J\u0018\u0010\u001c\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0018\u0010\u001f\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/vk/api/sdk/auth/VKAuthManager;", "", "keyValueStorage", "Lcom/vk/api/sdk/VKKeyValueStorage;", "(Lcom/vk/api/sdk/VKKeyValueStorage;)V", "clearAccessToken", "", "getCurrentToken", "Lcom/vk/api/sdk/auth/VKAccessToken;", "isLoggedIn", "", "login", "activity", "Landroid/app/Activity;", "scopes", "", "Lcom/vk/api/sdk/auth/VKScope;", "onActivityResult", "requestCode", "", "resultCode", "data", "Landroid/content/Intent;", "callback", "Lcom/vk/api/sdk/auth/VKAuthCallback;", "processResult", "Lcom/vk/api/sdk/auth/VKAuthResult;", "result", "startAuthActivity", "params", "Lcom/vk/api/sdk/auth/VKAuthParams;", "startInternalAuthActivity", "Companion", "libapi-sdk-core_release"})
public final class VKAuthManager {
    private final VKKeyValueStorage keyValueStorage;
    @NotNull
    public static final String VK_APP_PACKAGE_ID = "com.vkontakte.android";
    private static final String VK_APP_AUTH_ACTION = "com.vkontakte.android.action.SDK_AUTH";
    @NotNull
    public static final String VK_EXTRA_TOKEN_DATA = "extra-token-data";
    @NotNull
    public static final String VK_AUTH_ERROR = "error";
    private static final int VK_APP_AUTH_CODE = 282;
    public static final Companion Companion = new Companion(null);

    public final void login(@NotNull Activity activity, @NotNull Collection<? extends VKScope> scopes) {
        Intrinsics.checkParameterIsNotNull((Object)activity, (String)"activity");
        Intrinsics.checkParameterIsNotNull(scopes, (String)"scopes");
        VKAuthParams params = new VKAuthParams(VK.getAppId((Context)activity), null, scopes, 2, null);
        if (VKUtils.isAppInstalled((Context)activity, VK_APP_PACKAGE_ID) && VKUtils.isIntentAvailable((Context)activity, VK_APP_AUTH_ACTION)) {
            this.startAuthActivity(activity, params);
        } else {
            this.startInternalAuthActivity(activity, params);
        }
    }

    private final void startAuthActivity(Activity activity, VKAuthParams params) {
        Intent intent = new Intent(VK_APP_AUTH_ACTION, null);
        boolean bl = false;
        boolean bl2 = false;
        Intent $this$apply = intent;
        boolean bl3 = false;
        $this$apply.setPackage(VK_APP_PACKAGE_ID);
        $this$apply.putExtras(params.toExtraBundle());
        Intent intent2 = intent;
        activity.startActivityForResult(intent2, 282);
    }

    private final void startInternalAuthActivity(Activity activity, VKAuthParams params) {
        VKWebViewAuthActivity.Companion.startForAuth(activity, params, 282);
    }

    public final boolean onActivityResult(int requestCode, int resultCode, @Nullable Intent data, @NotNull VKAuthCallback callback) {
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        if (requestCode != 282) {
            return false;
        }
        if (data == null) {
            callback.onLoginFailed(1);
            return true;
        }
        VKAuthResult result = this.processResult(data);
        if (resultCode != -1 || result == null || result.isError()) {
            callback.onLoginFailed(1);
        } else {
            VKAccessToken vKAccessToken = result.getAccessToken();
            if (vKAccessToken == null) {
                Intrinsics.throwNpe();
            }
            vKAccessToken.save(this.keyValueStorage);
            VK.INSTANCE.getApiManager$libapi_sdk_core_release().setCredentials(result.getAccessToken().getAccessToken(), result.getAccessToken().getSecret());
            callback.onLogin(result.getAccessToken());
        }
        return true;
    }

    private final VKAuthResult processResult(Intent result) {
        VKAuthResult vKAuthResult;
        Map tokenParams = null;
        if (result.hasExtra(VK_EXTRA_TOKEN_DATA)) {
            String tokenInfo = result.getStringExtra(VK_EXTRA_TOKEN_DATA);
            tokenParams = VKUtils.explodeQueryString(tokenInfo);
        } else if (result.getExtras() != null) {
            tokenParams = new HashMap();
            Bundle bundle = result.getExtras();
            if (bundle == null) {
                Intrinsics.throwNpe();
            }
            Iterator iterator = bundle.keySet().iterator();
            while (iterator.hasNext()) {
                String key;
                String string2 = key = (String)iterator.next();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"key");
                Bundle bundle2 = result.getExtras();
                if (bundle2 == null) {
                    Intrinsics.throwNpe();
                }
                tokenParams.put(string2, String.valueOf(bundle2.get(key)));
            }
        } else {
            return null;
        }
        if (tokenParams != null && tokenParams.get(VK_AUTH_ERROR) == null) {
            VKAuthResult vKAuthResult2;
            try {
                vKAuthResult2 = new VKAuthResult(new VKAccessToken(tokenParams), 0, 2, null);
            }
            catch (Exception e) {
                Log.e((String)VKAuthManager.class.getSimpleName(), (String)"Failed to get VK token", (Throwable)e);
                vKAuthResult2 = null;
            }
            vKAuthResult = vKAuthResult2;
        } else {
            vKAuthResult = null;
        }
        return vKAuthResult;
    }

    public final boolean isLoggedIn() {
        VKAccessToken token = this.getCurrentToken();
        return token != null && token.isValid();
    }

    @Nullable
    public final VKAccessToken getCurrentToken() {
        return VKAccessToken.Companion.restore(this.keyValueStorage);
    }

    public final void clearAccessToken() {
        VKAccessToken.Companion.remove(this.keyValueStorage);
    }

    public VKAuthManager(@NotNull VKKeyValueStorage keyValueStorage) {
        Intrinsics.checkParameterIsNotNull((Object)keyValueStorage, (String)"keyValueStorage");
        this.keyValueStorage = keyValueStorage;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/vk/api/sdk/auth/VKAuthManager$Companion;", "", "()V", "VK_APP_AUTH_ACTION", "", "VK_APP_AUTH_CODE", "", "VK_APP_PACKAGE_ID", "VK_AUTH_ERROR", "VK_EXTRA_TOKEN_DATA", "libapi-sdk-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

