/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.chain;

import com.vk.api.sdk.VKApiManager;
import com.vk.api.sdk.chain.ChainArgs;
import com.vk.api.sdk.chain.ChainCall;
import com.vk.api.sdk.chain.RetryChainCall;
import com.vk.api.sdk.exceptions.VKApiException;
import com.vk.api.sdk.exceptions.VKApiExecutionException;
import com.vk.api.sdk.utils.ExponentialBackoff;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u0010B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\u0002\u0010\tJ\u0017\u0010\f\u001a\u0004\u0018\u00018\u00002\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcom/vk/api/sdk/chain/TooManyRequestRetryChainCall;", "T", "Lcom/vk/api/sdk/chain/RetryChainCall;", "manager", "Lcom/vk/api/sdk/VKApiManager;", "retryLimit", "", "chain", "Lcom/vk/api/sdk/chain/ChainCall;", "(Lcom/vk/api/sdk/VKApiManager;ILcom/vk/api/sdk/chain/ChainCall;)V", "getChain", "()Lcom/vk/api/sdk/chain/ChainCall;", "call", "args", "Lcom/vk/api/sdk/chain/ChainArgs;", "(Lcom/vk/api/sdk/chain/ChainArgs;)Ljava/lang/Object;", "Backoff", "libapi-sdk-core_release"})
public final class TooManyRequestRetryChainCall<T>
extends RetryChainCall<T> {
    @NotNull
    private final ChainCall<T> chain;

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public T call(@NotNull ChainArgs args) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
        int n = 0;
        int n2 = this.getRetryLimit();
        if (n <= n2) {
            while (true) {
                if (Backoff.INSTANCE.shouldWait()) {
                    Thread.sleep(Backoff.INSTANCE.delayTime());
                }
                try {
                    T result = this.chain.call(args);
                    Backoff.INSTANCE.reset();
                    return result;
                }
                catch (VKApiExecutionException ex) {
                    void i;
                    if (!ex.isTooManyRequestsError()) {
                        throw (Throwable)ex;
                    }
                    this.logDebug("Too many requests", ex);
                    Backoff.INSTANCE.backoff();
                    if (i == n2) break;
                    ++i;
                    continue;
                }
                break;
            }
        }
        throw (Throwable)new VKApiException("Can't handle too many requests due to retry limit! (retryLimit=" + this.getRetryLimit() + ')');
    }

    @NotNull
    public final ChainCall<T> getChain() {
        return this.chain;
    }

    public TooManyRequestRetryChainCall(@NotNull VKApiManager manager, int retryLimit, @NotNull ChainCall<? extends T> chain) {
        Intrinsics.checkParameterIsNotNull((Object)manager, (String)"manager");
        Intrinsics.checkParameterIsNotNull(chain, (String)"chain");
        super(manager, retryLimit);
        this.chain = chain;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010\t\u001a\u00020\u0004J\u0006\u0010\n\u001a\u00020\bJ\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/vk/api/sdk/chain/TooManyRequestRetryChainCall$Backoff;", "", "()V", "TIMEOUT", "", "bf", "Lcom/vk/api/sdk/utils/ExponentialBackoff;", "backoff", "", "delayTime", "reset", "shouldWait", "", "libapi-sdk-core_release"})
    private static final class Backoff {
        public static final long TIMEOUT = 1000L;
        private static final ExponentialBackoff bf;
        public static final Backoff INSTANCE;

        public final synchronized boolean shouldWait() {
            return bf.shouldWait();
        }

        public final synchronized void backoff() {
            bf.onError();
        }

        public final synchronized void reset() {
            bf.reset();
        }

        public final synchronized long delayTime() {
            return bf.getDelayMs();
        }

        private Backoff() {
        }

        static {
            Backoff backoff;
            INSTANCE = backoff = new Backoff();
            bf = new ExponentialBackoff(1000L, 8000L, 1.2f, 0.0f, 8, null);
        }
    }
}

