/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.okhttp;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.net.Uri;
import com.vk.api.sdk.exceptions.VKLocalIOException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLConnection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/vk/api/sdk/okhttp/FileFullRequestBody;", "Lokhttp3/RequestBody;", "context", "Landroid/content/Context;", "fileUri", "Landroid/net/Uri;", "(Landroid/content/Context;Landroid/net/Uri;)V", "contentLength", "", "contentType", "Lokhttp3/MediaType;", "writeTo", "", "sink", "Lokio/BufferedSink;", "Companion", "libapi-sdk-core_release"})
public final class FileFullRequestBody
extends RequestBody {
    private final Context context;
    private final Uri fileUri;
    private static final int CHUNK = 8192;
    public static final Companion Companion = new Companion(null);

    @Nullable
    public MediaType contentType() {
        String mimeType;
        String string2;
        String fileName;
        Uri uri = this.fileUri;
        String string3 = fileName = uri != null ? uri.getLastPathSegment() : null;
        if (fileName == null) {
            string2 = null;
        } else {
            String string4;
            try {
                string4 = URLConnection.guessContentTypeFromName(fileName);
            }
            catch (Exception ex) {
                string4 = null;
            }
            string2 = mimeType = string4;
        }
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        return MediaType.parse((String)mimeType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long contentLength() throws IOException {
        long l;
        AssetFileDescriptor fd = null;
        try {
            Context context = this.context;
            AssetFileDescriptor assetFileDescriptor = fd = context != null && (context = context.getContentResolver()) != null ? context.openAssetFileDescriptor(this.fileUri, "r") : null;
            if (assetFileDescriptor == null) throw (Throwable)new FileNotFoundException("Cannot open uri: " + this.fileUri);
            l = assetFileDescriptor.getLength();
        }
        catch (FileNotFoundException ex) {
            try {
                throw (Throwable)new VKLocalIOException(ex);
            }
            catch (Throwable throwable) {
                if (fd == null) throw throwable;
                try {
                    fd.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            fd.close();
            return l;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void writeTo(@NotNull BufferedSink sink) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        AssetFileDescriptor fileDescriptor = null;
        OutputStream os = sink.outputStream();
        try {
            FileInputStream inputStream = null;
            try {
                Context context = this.context;
                AssetFileDescriptor assetFileDescriptor = context != null && (context = context.getContentResolver()) != null ? context.openAssetFileDescriptor(this.fileUri, "r") : (fileDescriptor = null);
                if (fileDescriptor == null) {
                    throw (Throwable)new FileNotFoundException("Cannot open uri: " + this.fileUri);
                }
                FileInputStream fileInputStream = fileDescriptor.createInputStream();
                Intrinsics.checkExpressionValueIsNotNull((Object)fileInputStream, (String)"fileDescriptor.createInputStream()");
                inputStream = fileInputStream;
            }
            catch (IOException ex) {
                throw (Throwable)new VKLocalIOException(ex);
            }
            byte[] buffer = new byte[8192];
            int readCount = 0;
            while (inputStream.available() > 0) {
                try {
                    readCount = inputStream.read(buffer);
                }
                catch (IOException ex) {
                    throw (Throwable)new VKLocalIOException(ex);
                }
                if (readCount != -1) {
                    os.write(buffer, 0, readCount);
                    os.flush();
                    continue;
                }
                break;
            }
        }
        catch (Throwable throwable) {
            if (fileDescriptor == null) throw throwable;
            try {
                fileDescriptor.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            fileDescriptor.close();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public FileFullRequestBody(@Nullable Context context, @NotNull Uri fileUri) {
        Intrinsics.checkParameterIsNotNull((Object)fileUri, (String)"fileUri");
        this.context = context;
        this.fileUri = fileUri;
        Context context2 = this.context;
        boolean bl = false;
        boolean bl2 = false;
        if (context2 == null) {
            boolean bl3 = false;
            String string2 = "context is null";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        if (this.fileUri == null) {
            throw (Throwable)new IllegalArgumentException("fileUri is null");
        }
        if (!new File(this.fileUri.getPath()).exists()) {
            throw (Throwable)new IllegalArgumentException("file is not exist");
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/vk/api/sdk/okhttp/FileFullRequestBody$Companion;", "", "()V", "CHUNK", "", "libapi-sdk-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

