/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.okhttp;

import android.content.Context;
import android.net.Uri;
import android.os.Looper;
import androidx.collection.LongSparseArray;
import com.vk.api.sdk.VKApiProgressListener;
import com.vk.api.sdk.VKOkHttpProvider;
import com.vk.api.sdk.exceptions.VKApiException;
import com.vk.api.sdk.exceptions.VKApiExecutionException;
import com.vk.api.sdk.exceptions.VKInternalServerErrorException;
import com.vk.api.sdk.exceptions.VKLargeEntityException;
import com.vk.api.sdk.internal.HttpMultipartEntry;
import com.vk.api.sdk.internal.QueryStringGenerator;
import com.vk.api.sdk.internal.Validation;
import com.vk.api.sdk.okhttp.FileFullRequestBody;
import com.vk.api.sdk.okhttp.LoggingInterceptor;
import com.vk.api.sdk.okhttp.OkHttpExecutorConfig;
import com.vk.api.sdk.okhttp.OkHttpMethodCall;
import com.vk.api.sdk.okhttp.OkHttpPostCall;
import com.vk.api.sdk.okhttp.ProgressRequestBody;
import com.vk.api.sdk.okhttp.RequestTag;
import com.vk.api.sdk.utils.ApiExtKt;
import com.vk.api.sdk.utils.log.Logger;
import java.io.Closeable;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import okhttp3.CacheControl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 J2\u00020\u0001:\u0001JB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\u00062\u0006\u0010*\u001a\u00020\u0006H\u0002J\u0010\u0010+\u001a\u00020\r2\u0006\u0010'\u001a\u00020(H\u0002J\u0012\u0010,\u001a\u0004\u0018\u00010\u00062\u0006\u0010-\u001a\u00020.H\u0016J\u001a\u0010,\u001a\u0004\u0018\u00010\u00062\u0006\u0010-\u001a\u00020/2\b\u00100\u001a\u0004\u0018\u000101J\u0010\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0004J\u0018\u00102\u001a\u0002032\u0006\u00104\u001a\u0002052\u0006\u0010'\u001a\u00020(H\u0004J\u0012\u00106\u001a\u0004\u0018\u00010\u00062\u0006\u0010-\u001a\u00020.H\u0014J\u0012\u00107\u001a\u0004\u0018\u00010\u00062\u0006\u0010-\u001a\u00020.H\u0014J\u0012\u00108\u001a\u0004\u0018\u00010\r2\u0006\u0010'\u001a\u00020(H\u0002J\b\u00109\u001a\u00020\rH\u0002J\u0018\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\r2\u0006\u0010=\u001a\u00020\rH\u0002J\u0012\u0010>\u001a\u0004\u0018\u00010\u00062\u0006\u0010?\u001a\u000203H\u0004J\u0018\u0010@\u001a\u00020%2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u001d\u001a\u0004\u0018\u00010\u0006J\u0010\u0010A\u001a\u00020%2\u0006\u0010B\u001a\u00020\u0018H\u0002J\u0018\u0010C\u001a\u00020\u00062\u0006\u0010-\u001a\u00020.2\u0006\u0010D\u001a\u00020\u0006H\u0004J \u0010E\u001a\u00020F*\u00020F2\u0012\u0010G\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020I0HH\u0002R\u001a\u0010\u0005\u001a\u00020\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\bR\u000e\u0010\u0016\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0017\u001a\u00020\u00188BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u0006X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\b\"\u0004\b\u001f\u0010\nR\u0014\u0010 \u001a\u00020!X\u0084D\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#\u00a8\u0006K"}, d2={"Lcom/vk/api/sdk/okhttp/OkHttpExecutor;", "", "config", "Lcom/vk/api/sdk/okhttp/OkHttpExecutorConfig;", "(Lcom/vk/api/sdk/okhttp/OkHttpExecutorConfig;)V", "accessToken", "", "getAccessToken", "()Ljava/lang/String;", "setAccessToken", "(Ljava/lang/String;)V", "clientsByTimeouts", "Landroidx/collection/LongSparseArray;", "Lokhttp3/OkHttpClient;", "getConfig", "()Lcom/vk/api/sdk/okhttp/OkHttpExecutorConfig;", "context", "Landroid/content/Context;", "getContext", "()Landroid/content/Context;", "host", "getHost", "lock", "okHttpProvider", "Lcom/vk/api/sdk/VKOkHttpProvider;", "getOkHttpProvider", "()Lcom/vk/api/sdk/VKOkHttpProvider;", "okHttpProvider$delegate", "Lkotlin/Lazy;", "secret", "getSecret", "setSecret", "timeoutDelay", "", "getTimeoutDelay", "()I", "clearClients", "", "clientWithTimeOut", "timeoutMs", "", "convertFileNameToSafeValue", "fileName", "createClient", "execute", "call", "Lcom/vk/api/sdk/okhttp/OkHttpMethodCall;", "Lcom/vk/api/sdk/okhttp/OkHttpPostCall;", "progressListener", "Lcom/vk/api/sdk/VKApiProgressListener;", "executeRequest", "Lokhttp3/Response;", "request", "Lokhttp3/Request;", "getActualAccessToken", "getActualSecret", "getClient", "getDefaultClient", "isSame", "", "c1", "c2", "readResponse", "response", "setCredentials", "updateClient", "provider", "validateQueryString", "paramsString", "updateWith", "Lokhttp3/MultipartBody$Builder;", "parts", "", "Lcom/vk/api/sdk/internal/HttpMultipartEntry;", "Companion", "libapi-sdk-core_release"})
public class OkHttpExecutor {
    private final int timeoutDelay = 500;
    @NotNull
    private final Context context;
    private final Object lock;
    private final Lazy okHttpProvider$delegate;
    @NotNull
    private final String host;
    @NotNull
    private volatile String accessToken;
    @Nullable
    private volatile String secret;
    private final LongSparseArray<OkHttpClient> clientsByTimeouts;
    @NotNull
    private final OkHttpExecutorConfig config;
    @NotNull
    public static final String MIME_APPLICATION = "application/x-www-form-urlencoded; charset=utf-8";
    private static final String UTF_8 = "UTF-8";
    public static final Companion Companion = new Companion(null);

    protected final int getTimeoutDelay() {
        return this.timeoutDelay;
    }

    @NotNull
    protected final Context getContext() {
        return this.context;
    }

    private final VKOkHttpProvider getOkHttpProvider() {
        Lazy lazy = this.okHttpProvider$delegate;
        OkHttpExecutor okHttpExecutor = this;
        Object var3_3 = null;
        boolean bl = false;
        return (VKOkHttpProvider)lazy.getValue();
    }

    @NotNull
    public final String getHost() {
        return this.host;
    }

    @NotNull
    protected final String getAccessToken() {
        return this.accessToken;
    }

    protected final void setAccessToken(@NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"<set-?>");
        this.accessToken = string2;
    }

    @Nullable
    protected final String getSecret() {
        return this.secret;
    }

    protected final void setSecret(@Nullable String string2) {
        this.secret = string2;
    }

    public final void setCredentials(@NotNull String accessToken, @Nullable String secret) {
        Intrinsics.checkParameterIsNotNull((Object)accessToken, (String)"accessToken");
        Validation.INSTANCE.assertAccessTokenValid(accessToken);
        this.accessToken = accessToken;
        this.secret = secret;
    }

    @Nullable
    public String execute(@NotNull OkHttpMethodCall call) throws InterruptedException, IOException, VKApiException {
        Request request;
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        String actualAccessToken = this.getActualAccessToken(call);
        String actualSecret = this.getActualSecret(call);
        String queryString = QueryStringGenerator.INSTANCE.buildQueryString(actualAccessToken, actualSecret, this.config.getAppId(), call);
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)MIME_APPLICATION), (String)this.validateQueryString(call, queryString));
        RequestTag requestTag = call.getTag();
        Request request2 = request = new Request.Builder().post(requestBody).url("https://" + this.host + "/method/" + call.getMethod()).cacheControl(CacheControl.FORCE_NETWORK).tag(Map.class, requestTag != null ? requestTag.toMap() : null).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)request2, (String)"request");
        return this.readResponse(this.executeRequest(request2));
    }

    @Nullable
    public final String execute(@NotNull OkHttpPostCall call, @Nullable VKApiProgressListener progressListener) throws InterruptedException, IOException, VKApiException {
        Request request;
        MultipartBody body;
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        MultipartBody.Builder builder2 = new MultipartBody.Builder().setType(MultipartBody.FORM);
        Intrinsics.checkExpressionValueIsNotNull((Object)builder2, (String)"MultipartBody.Builder()\n\u2026tType(MultipartBody.FORM)");
        MultipartBody multipartBody = body = this.updateWith(builder2, call.getParts()).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)multipartBody, (String)"body");
        ProgressRequestBody requestBody = new ProgressRequestBody((RequestBody)multipartBody, progressListener);
        long timeout = call.getTimeoutMs() > 0L ? call.getTimeoutMs() : this.config.getPostRequestsTimeout();
        Request request2 = request = new Request.Builder().post((RequestBody)requestBody).url(call.getUrl()).cacheControl(CacheControl.FORCE_NETWORK).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)request2, (String)"request");
        return this.readResponse(this.executeRequest(request2, timeout));
    }

    @NotNull
    protected final String validateQueryString(@NotNull OkHttpMethodCall call, @NotNull String paramsString) throws VKApiException {
        Uri uri;
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        Intrinsics.checkParameterIsNotNull((Object)paramsString, (String)"paramsString");
        if (StringsKt.startsWith$default((String)call.getMethod(), (String)"execute.", (boolean)false, (int)2, null) && (uri = Uri.parse((String)("https://vk.com/?" + paramsString))).getQueryParameters("method").contains("execute")) {
            Collection collection = uri.getQueryParameters("code");
            boolean bl = false;
            boolean bl2 = false;
            if (!(collection == null || collection.isEmpty())) {
                throw (Throwable)new VKApiExecutionException(15, call.getMethod(), false, "Hey dude don't execute your hacky code ;)", null, null, null, 112, null);
            }
        }
        return paramsString;
    }

    @NotNull
    protected final Response executeRequest(@NotNull Request request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        return this.executeRequest(request, this.config.getDefaultTimeoutMs());
    }

    @NotNull
    protected final Response executeRequest(@NotNull Request request, long timeoutMs) throws InterruptedException, IOException {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        Response response = this.clientWithTimeOut(timeoutMs).newCall(request).execute();
        Intrinsics.checkExpressionValueIsNotNull((Object)response, (String)"clientWithTimeOut(timeou\u2026ewCall(request).execute()");
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected final String readResponse(@NotNull Response response) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)response, (String)"response");
        if (response.code() == 413) {
            String string3 = response.message();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"response.message()");
            throw (Throwable)new VKLargeEntityException(string3);
        }
        ResponseBody responseBody = response.body();
        if (responseBody != null) {
            Closeable closeable = (Closeable)responseBody;
            boolean bl = false;
            Throwable throwable = null;
            try {
                ResponseBody it = (ResponseBody)closeable;
                boolean bl2 = false;
                String string4 = it.string();
                string2 = string4;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        } else {
            string2 = null;
        }
        String body = string2;
        int n = response.code();
        if (500 <= n && 599 >= n) {
            int n2 = response.code();
            String string5 = body;
            if (string5 == null) {
                string5 = "null";
            }
            throw (Throwable)new VKInternalServerErrorException(n2, string5);
        }
        return body;
    }

    @Nullable
    protected String getActualAccessToken(@NotNull OkHttpMethodCall call) {
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        return this.accessToken;
    }

    @Nullable
    protected String getActualSecret(@NotNull OkHttpMethodCall call) {
        Intrinsics.checkParameterIsNotNull((Object)call, (String)"call");
        return this.secret;
    }

    /*
     * WARNING - void declaration
     */
    private final MultipartBody.Builder updateWith(@NotNull MultipartBody.Builder $this$updateWith, Map<String, ? extends HttpMultipartEntry> parts) {
        Object object = parts;
        boolean bl = false;
        Iterator<Map.Entry<String, ? extends HttpMultipartEntry>> iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void key;
            Map.Entry<String, ? extends HttpMultipartEntry> entry;
            Map.Entry<String, ? extends HttpMultipartEntry> entry2 = entry = iterator.next();
            boolean bl2 = false;
            object = entry2.getKey();
            entry2 = entry;
            bl2 = false;
            HttpMultipartEntry entry3 = entry2.getValue();
            if (entry3 instanceof HttpMultipartEntry.Text) {
                $this$updateWith.addFormDataPart((String)key, ((HttpMultipartEntry.Text)entry3).getTextValue());
                continue;
            }
            if (!(entry3 instanceof HttpMultipartEntry.File)) continue;
            FileFullRequestBody partBody = new FileFullRequestBody(this.context, ((HttpMultipartEntry.File)entry3).getFileUri());
            String string2 = ((HttpMultipartEntry.File)entry3).getFileName();
            if (string2 == null) {
                string2 = "";
            }
            $this$updateWith.addFormDataPart((String)key, this.convertFileNameToSafeValue(string2), (RequestBody)partBody);
        }
        return $this$updateWith;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final OkHttpClient clientWithTimeOut(long timeoutMs) {
        Object object = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (object) {
            long fixedTimeoutMs;
            OkHttpClient okHttpClient;
            boolean bl3 = false;
            OkHttpClient baseClient = this.getOkHttpProvider().getClient();
            OkHttpClient defaultClient = this.getDefaultClient();
            if (!this.isSame(baseClient, defaultClient)) {
                this.clearClients();
            }
            if ((okHttpClient = this.getClient(fixedTimeoutMs = timeoutMs + (long)this.timeoutDelay)) == null) {
                okHttpClient = this.createClient(fixedTimeoutMs);
            }
            OkHttpClient okHttpClient2 = okHttpClient;
            return okHttpClient2;
        }
    }

    private final OkHttpClient getDefaultClient() {
        long timeoutMs = this.config.getDefaultTimeoutMs();
        OkHttpClient okHttpClient = this.getClient(timeoutMs);
        if (okHttpClient == null) {
            okHttpClient = this.createClient(timeoutMs);
        }
        return okHttpClient;
    }

    private final OkHttpClient getClient(long timeoutMs) {
        return (OkHttpClient)this.clientsByTimeouts.get(timeoutMs);
    }

    private final OkHttpClient createClient(long timeoutMs) {
        OkHttpClient client;
        OkHttpClient okHttpClient = client = this.getOkHttpProvider().getClient().newBuilder().readTimeout(timeoutMs, TimeUnit.MILLISECONDS).connectTimeout(timeoutMs, TimeUnit.MILLISECONDS).build();
        Intrinsics.checkExpressionValueIsNotNull((Object)okHttpClient, (String)"client");
        ApiExtKt.set(this.clientsByTimeouts, timeoutMs, okHttpClient);
        return client;
    }

    private final void clearClients() {
        this.clientsByTimeouts.clear();
    }

    private final boolean isSame(OkHttpClient c1, OkHttpClient c2) {
        return c1.connectTimeoutMillis() == c2.connectTimeoutMillis() && c1.readTimeoutMillis() == c2.readTimeoutMillis() && c1.writeTimeoutMillis() == c2.writeTimeoutMillis() && c1.pingIntervalMillis() == c2.pingIntervalMillis() && Intrinsics.areEqual((Object)c1.proxy(), (Object)c2.proxy()) && Intrinsics.areEqual((Object)c1.proxySelector(), (Object)c2.proxySelector()) && Intrinsics.areEqual((Object)c1.cookieJar(), (Object)c2.cookieJar()) && Intrinsics.areEqual((Object)c1.cache(), (Object)c2.cache()) && Intrinsics.areEqual((Object)c1.dns(), (Object)c2.dns()) && Intrinsics.areEqual((Object)c1.socketFactory(), (Object)c2.socketFactory()) && Intrinsics.areEqual((Object)c1.sslSocketFactory(), (Object)c2.sslSocketFactory()) && Intrinsics.areEqual((Object)c1.sslSocketFactory(), (Object)c2.sslSocketFactory()) && Intrinsics.areEqual((Object)c1.hostnameVerifier(), (Object)c2.hostnameVerifier()) && Intrinsics.areEqual((Object)c1.certificatePinner(), (Object)c2.certificatePinner()) && Intrinsics.areEqual((Object)c1.authenticator(), (Object)c2.authenticator()) && Intrinsics.areEqual((Object)c1.proxyAuthenticator(), (Object)c2.proxyAuthenticator()) && Intrinsics.areEqual((Object)c1.connectionPool(), (Object)c2.connectionPool()) && c1.followSslRedirects() == c2.followSslRedirects() && c1.followRedirects() == c2.followRedirects() && c1.retryOnConnectionFailure() == c2.retryOnConnectionFailure() && Intrinsics.areEqual((Object)c1.dispatcher(), (Object)c2.dispatcher()) && Intrinsics.areEqual((Object)c1.protocols(), (Object)c2.protocols()) && Intrinsics.areEqual((Object)c1.connectionSpecs(), (Object)c2.connectionSpecs()) && Intrinsics.areEqual((Object)c1.interceptors(), (Object)c2.interceptors()) && Intrinsics.areEqual((Object)c1.networkInterceptors(), (Object)c2.networkInterceptors());
    }

    private final void updateClient(VKOkHttpProvider provider) {
        provider.updateClient(new VKOkHttpProvider.BuilderUpdateFunction(this){
            final /* synthetic */ OkHttpExecutor this$0;

            @NotNull
            public OkHttpClient.Builder update(@NotNull OkHttpClient.Builder builder2) {
                Intrinsics.checkParameterIsNotNull((Object)builder2, (String)"builder");
                if (Logger.LogLevel.NONE != (Logger.LogLevel)((Object)this.this$0.getConfig().getLogger().getLogLevel().getValue())) {
                    builder2.addInterceptor((Interceptor)new LoggingInterceptor(this.this$0.getConfig().getLogFilterCredentials(), this.this$0.getConfig().getLogger()));
                }
                return builder2;
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    private final String convertFileNameToSafeValue(String fileName) {
        String string2 = URLEncoder.encode(StringsKt.replace$default((String)fileName, (String)"\"", (String)"\\\"", (boolean)false, (int)4, null), UTF_8);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"URLEncoder.encode(fileNa\u2026ace(\"\\\"\", \"\\\\\\\"\"), UTF_8)");
        return string2;
    }

    @NotNull
    protected final OkHttpExecutorConfig getConfig() {
        return this.config;
    }

    public OkHttpExecutor(@NotNull OkHttpExecutorConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.config = config;
        this.timeoutDelay = 500;
        this.context = this.config.getContext();
        this.lock = new Object();
        this.okHttpProvider$delegate = LazyKt.lazy((Function0)((Function0)new Function0<VKOkHttpProvider>(this){
            final /* synthetic */ OkHttpExecutor this$0;

            @NotNull
            public final VKOkHttpProvider invoke() {
                if (Intrinsics.areEqual((Object)Looper.getMainLooper(), (Object)Looper.myLooper())) {
                    throw (Throwable)new IllegalStateException("UI thread");
                }
                OkHttpExecutor.access$updateClient(this.this$0, this.this$0.getConfig().getOkHttpProvider());
                return this.this$0.getConfig().getOkHttpProvider();
            }
            {
                this.this$0 = okHttpExecutor;
                super(0);
            }
        }));
        this.host = this.config.getHost();
        this.accessToken = this.config.getAccessToken();
        this.secret = this.config.getSecret();
        this.clientsByTimeouts = new LongSparseArray();
    }

    public static final /* synthetic */ void access$updateClient(OkHttpExecutor $this, VKOkHttpProvider provider) {
        $this.updateClient(provider);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/vk/api/sdk/okhttp/OkHttpExecutor$Companion;", "", "()V", "MIME_APPLICATION", "", "UTF_8", "libapi-sdk-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

