/*
 * Decompiled with CFR 0.152.
 */
package com.vk.api.sdk.okhttp;

import com.vk.api.sdk.VKApiProgressListener;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.ForwardingSink;
import okio.Okio;
import okio.Sink;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\u0007H\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/vk/api/sdk/okhttp/ProgressRequestBody;", "Lokhttp3/RequestBody;", "requestBody", "progressListener", "Lcom/vk/api/sdk/VKApiProgressListener;", "(Lokhttp3/RequestBody;Lcom/vk/api/sdk/VKApiProgressListener;)V", "lastNotifyTime", "", "contentLength", "contentType", "Lokhttp3/MediaType;", "notifyProgressSend", "", "progress", "maxValue", "writeTo", "sink", "Lokio/BufferedSink;", "Companion", "CountingSink", "libapi-sdk-core_release"})
public final class ProgressRequestBody
extends RequestBody {
    private long lastNotifyTime;
    private final RequestBody requestBody;
    private final VKApiProgressListener progressListener;
    private static final long NOTIFY_INTERVAL;
    public static final Companion Companion;

    @Nullable
    public MediaType contentType() {
        return this.requestBody.contentType();
    }

    public long contentLength() throws IOException {
        return this.requestBody.contentLength();
    }

    public void writeTo(@NotNull BufferedSink sink) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)sink, (String)"sink");
        BufferedSink bufferedSink = Okio.buffer((Sink)((Sink)new CountingSink((Sink)sink)));
        this.requestBody.writeTo(bufferedSink);
        bufferedSink.flush();
    }

    private final void notifyProgressSend(long progress, long maxValue) {
        if (this.progressListener == null) {
            return;
        }
        long now = System.currentTimeMillis();
        long diff = now - this.lastNotifyTime;
        if (diff >= NOTIFY_INTERVAL) {
            float scale = 1000.0f / (float)maxValue;
            int progressValue = (int)((float)progress * scale);
            int progressMaxValue = (int)((float)maxValue * scale);
            this.progressListener.onProgress(progressValue, progressMaxValue);
            this.lastNotifyTime = System.currentTimeMillis();
        }
    }

    public ProgressRequestBody(@NotNull RequestBody requestBody, @Nullable VKApiProgressListener progressListener) {
        Intrinsics.checkParameterIsNotNull((Object)requestBody, (String)"requestBody");
        this.requestBody = requestBody;
        this.progressListener = progressListener;
    }

    static {
        Companion = new Companion(null);
        NOTIFY_INTERVAL = TimeUnit.MILLISECONDS.toMillis(160L);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/vk/api/sdk/okhttp/ProgressRequestBody$CountingSink;", "Lokio/ForwardingSink;", "delegate", "Lokio/Sink;", "(Lcom/vk/api/sdk/okhttp/ProgressRequestBody;Lokio/Sink;)V", "bytesWritten", "", "contentLength", "write", "", "source", "Lokio/Buffer;", "byteCount", "libapi-sdk-core_release"})
    private final class CountingSink
    extends ForwardingSink {
        private long bytesWritten;
        private long contentLength;

        public void write(@NotNull Buffer source, long byteCount) throws IOException {
            Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
            super.write(source, byteCount);
            this.bytesWritten += byteCount;
            if (this.contentLength < 0L) {
                this.contentLength = ProgressRequestBody.this.contentLength();
            }
            if (this.contentLength < 0L) {
                ProgressRequestBody.this.notifyProgressSend(0L, 1L);
            } else {
                ProgressRequestBody.this.notifyProgressSend(this.bytesWritten, this.contentLength);
            }
        }

        public CountingSink(Sink delegate2) {
            Intrinsics.checkParameterIsNotNull((Object)delegate2, (String)"delegate");
            super(delegate2);
            this.contentLength = -1L;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/vk/api/sdk/okhttp/ProgressRequestBody$Companion;", "", "()V", "NOTIFY_INTERVAL", "", "libapi-sdk-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

