/*
 * Decompiled with CFR 0.152.
 */
package com.vungle.warren;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Log;
import android.util.Pair;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.vungle.warren.AdRequest;
import com.vungle.warren.PresentationFactory;
import com.vungle.warren.ServiceLocator;
import com.vungle.warren.VungleLogger;
import com.vungle.warren.VungleStaticApi;
import com.vungle.warren.error.VungleException;
import com.vungle.warren.ui.CloseDelegate;
import com.vungle.warren.ui.OrientationDelegate;
import com.vungle.warren.ui.VungleActivity;
import com.vungle.warren.ui.contract.AdContract;
import com.vungle.warren.ui.state.BundleOptionsState;
import com.vungle.warren.ui.state.OptionsState;
import com.vungle.warren.ui.view.FullAdWidget;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class AdActivity
extends Activity {
    private static final String REQUEST_KEY_EXTRA = "request";
    private static final String TAG = "VungleActivity";
    public static final String PRESENTER_STATE = "presenter_state";
    private static AdContract.AdvertisementPresenter.EventListener bus;
    @Nullable
    private AdContract.AdvertisementPresenter presenter;
    private BroadcastReceiver broadcastReceiver;
    private AdRequest request;
    private PresentationFactory presenterFactory;
    private OptionsState state;
    private AtomicBoolean pendingStart = new AtomicBoolean(false);
    private boolean started = false;
    private boolean resumed = false;
    private PresentationFactory.FullScreenCallback fullscreenCallback = new PresentationFactory.FullScreenCallback(){

        @Override
        public void onResult(@NonNull Pair<AdContract.AdView, AdContract.AdvertisementPresenter> result, @Nullable VungleException error) {
            if (error != null) {
                AdActivity.this.presenterFactory = null;
                AdActivity.this.deliverError(error.getExceptionCode(), AdActivity.this.request);
                AdActivity.this.finish();
                return;
            }
            AdActivity.this.presenter = (AdContract.AdvertisementPresenter)result.second;
            AdActivity.this.presenter.setEventListener(bus);
            AdContract.AdView adView = (AdContract.AdView)result.first;
            AdActivity.this.presenter.attach(adView, AdActivity.this.state);
            if (AdActivity.this.pendingStart.getAndSet(false)) {
                AdActivity.this.start();
            }
        }
    };

    public static void setEventListener(AdContract.AdvertisementPresenter.EventListener listener) {
        bus = listener;
    }

    @VisibleForTesting
    protected static AdContract.AdvertisementPresenter.EventListener getEventListener() {
        return bus;
    }

    @NonNull
    public static Intent createIntent(Context context, AdRequest request) {
        Intent intent = new Intent(context, VungleActivity.class);
        intent.addFlags(0x10000000);
        Bundle bundle = new Bundle();
        bundle.putSerializable(REQUEST_KEY_EXTRA, (Serializable)request);
        intent.putExtras(bundle);
        return intent;
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        FullAdWidget fullAdWidget;
        super.onCreate(savedInstanceState);
        this.requestWindowFeature(1);
        this.getWindow().setFlags(0x1000000, 0x1000000);
        this.request = AdActivity.getRequest(this.getIntent());
        ServiceLocator serviceLocator = ServiceLocator.getInstance((Context)this);
        VungleStaticApi vungleStaticApi = serviceLocator.getService(VungleStaticApi.class);
        if (!vungleStaticApi.isInitialized() || bus == null || this.request == null || TextUtils.isEmpty((CharSequence)this.request.getPlacementId())) {
            this.finish();
            return;
        }
        long adStartTime = System.currentTimeMillis();
        VungleLogger.verbose(true, TAG, "ttDownloadContext", String.format("Creating ad, request = %1$s, at: %2$d", this.request, adStartTime));
        try {
            fullAdWidget = new FullAdWidget((Context)this, this.getWindow());
        }
        catch (InstantiationException e2) {
            this.deliverError(10, this.request);
            this.finish();
            return;
        }
        this.presenterFactory = serviceLocator.getService(PresentationFactory.class);
        this.state = savedInstanceState == null ? null : (OptionsState)savedInstanceState.getParcelable(PRESENTER_STATE);
        this.presenterFactory.getFullScreenPresentation((Context)this, this.request, fullAdWidget, this.state, new CloseDelegate(){

            @Override
            public void close() {
                AdActivity.this.finish();
            }
        }, new OrientationDelegate(){

            @Override
            public void setOrientation(int orientation) {
                AdActivity.this.setRequestedOrientation(orientation);
            }
        }, savedInstanceState, this.fullscreenCallback);
        this.setContentView((View)fullAdWidget, fullAdWidget.getLayoutParams());
        this.connectBroadcastReceiver();
        VungleLogger.verbose(true, TAG, "ttDownloadContext", String.format("Ad created, request = %1$s, elapsed time: %2$dms", this.request, System.currentTimeMillis() - adStartTime));
    }

    @VisibleForTesting
    @Nullable
    static AdRequest getRequest(@NonNull Intent intent) {
        Bundle bundle = intent.getExtras();
        if (bundle != null) {
            return (AdRequest)bundle.getSerializable(REQUEST_KEY_EXTRA);
        }
        return null;
    }

    protected void onNewIntent(Intent intent) {
        String newPlacement;
        super.onNewIntent(intent);
        AdRequest oldRequest = AdActivity.getRequest(this.getIntent());
        AdRequest newRequest = AdActivity.getRequest(intent);
        String oldPlacement = oldRequest != null ? oldRequest.getPlacementId() : null;
        String string = newPlacement = newRequest != null ? newRequest.getPlacementId() : null;
        if (oldPlacement != null && newPlacement != null && !oldPlacement.equals(newPlacement)) {
            Log.d((String)TAG, (String)("Tried to play another placement " + newPlacement + " while playing " + oldPlacement));
            this.deliverError(15, newRequest);
            VungleLogger.warn(AdActivity.class.getSimpleName() + "#onNewIntent", String.format("Tried to play another placement %1$s while playing %2$s", newPlacement, oldPlacement));
        }
    }

    private void deliverError(int code, AdRequest request) {
        VungleException exception = new VungleException(code);
        if (bus != null) {
            bus.onError(exception, request.getPlacementId());
        }
        VungleLogger.error(AdActivity.class.getSimpleName() + "#deliverError", exception.getLocalizedMessage());
    }

    private void connectBroadcastReceiver() {
        this.broadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String command;
                switch (command = intent.getStringExtra("command")) {
                    case "stopAll": {
                        AdActivity.this.finish();
                        break;
                    }
                    default: {
                        VungleLogger.warn(AdActivity.class.getSimpleName() + "#connectBroadcastReceiver", String.format("Receiving Invalid Broadcast: %1$s", command));
                    }
                }
            }
        };
        LocalBroadcastManager.getInstance((Context)this.getApplicationContext()).registerReceiver(this.broadcastReceiver, new IntentFilter("AdvertisementBus"));
    }

    public void onWindowFocusChanged(boolean hasFocus) {
        super.onWindowFocusChanged(hasFocus);
        if (hasFocus) {
            this.start();
        } else {
            this.stop();
        }
    }

    private void start() {
        if (this.presenter == null) {
            this.pendingStart.set(true);
        } else if (!this.started && this.resumed && this.hasWindowFocus()) {
            this.presenter.start();
            this.started = true;
        }
    }

    private void stop() {
        if (this.presenter != null && this.started) {
            int flag = (this.isChangingConfigurations() ? 1 : 0) | (this.isFinishing() ? 2 : 0);
            this.presenter.stop(flag);
            this.started = false;
        }
        this.pendingStart.set(false);
    }

    protected void onResume() {
        super.onResume();
        this.resumed = true;
        this.start();
    }

    protected void onPause() {
        super.onPause();
        this.resumed = false;
        this.stop();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (newConfig.orientation == 2) {
            Log.d((String)TAG, (String)"landscape");
        } else if (newConfig.orientation == 1) {
            Log.d((String)TAG, (String)"portrait");
        }
        if (this.presenter != null) {
            this.presenter.onViewConfigurationChanged();
        }
    }

    @SuppressLint(value={"ResourceType"})
    public void onBackPressed() {
        if (this.presenter != null) {
            this.presenter.handleExit();
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        Log.d((String)TAG, (String)"onSaveInstanceState");
        BundleOptionsState optionsState = new BundleOptionsState();
        if (this.presenter != null) {
            this.presenter.generateSaveState(optionsState);
            outState.putParcelable(PRESENTER_STATE, (Parcelable)optionsState);
        }
        if (this.presenterFactory != null) {
            this.presenterFactory.saveState(outState);
        }
        super.onSaveInstanceState(outState);
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        Log.d((String)TAG, (String)("onRestoreInstanceState(" + savedInstanceState + ")"));
        if (savedInstanceState != null && this.presenter != null) {
            this.presenter.restoreFromSave((OptionsState)savedInstanceState.getParcelable(PRESENTER_STATE));
        }
    }

    public void setRequestedOrientation(int requestedOrientation) {
        if (this.canRotate()) {
            super.setRequestedOrientation(requestedOrientation);
        }
    }

    protected abstract boolean canRotate();

    protected void onDestroy() {
        LocalBroadcastManager.getInstance((Context)this.getApplicationContext()).unregisterReceiver(this.broadcastReceiver);
        if (this.presenter != null) {
            this.presenter.detach((this.isChangingConfigurations() ? 1 : 0) | 2);
        } else if (this.presenterFactory != null) {
            this.presenterFactory.destroy();
            this.presenterFactory = null;
            this.deliverError(25, this.request);
        }
        super.onDestroy();
    }
}

